/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.aries.blueprint.ExtendedBeanMetadata;
import org.apache.aries.blueprint.ext.AbstractPropertyPlaceholder;
import org.apache.aries.blueprint.ext.PropertyPlaceholder;
import org.apache.camel.component.properties.DefaultPropertiesParser;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.util.ObjectHelper;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.reflect.ComponentMetadata;

public class BlueprintPropertiesParser
extends DefaultPropertiesParser {
    private final PropertiesComponent propertiesComponent;
    private final BlueprintContainer container;
    private final PropertiesParser delegate;
    private final Set<PropertyPlaceholderWrapper> placeholders = new LinkedHashSet<PropertyPlaceholderWrapper>();
    private Method method;
    private Method oldMethod;

    public BlueprintPropertiesParser(PropertiesComponent propertiesComponent, BlueprintContainer container, PropertiesParser delegate) {
        super(propertiesComponent);
        this.propertiesComponent = propertiesComponent;
        this.container = container;
        this.delegate = delegate;
    }

    public String[] lookupPropertyPlaceholderIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (Object componentId : this.container.getComponentIds()) {
            Class clazz;
            String id = (String)componentId;
            ComponentMetadata meta = this.container.getComponentMetadata(id);
            if (!(meta instanceof ExtendedBeanMetadata) || (clazz = ((ExtendedBeanMetadata)meta).getRuntimeClass()) == null || !AbstractPropertyPlaceholder.class.isAssignableFrom(clazz) && this.newPlaceholderClass(clazz) == null) continue;
            ids.add(id);
        }
        return ids.toArray(new String[ids.size()]);
    }

    private Class<?> newPlaceholderClass(Class<?> clazz) {
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            if (!"org.apache.aries.blueprint.ext.AbstractPropertyPlaceholderExt".equals(c.getName())) continue;
            return c;
        }
        return null;
    }

    public void addPropertyPlaceholder(String id) {
        Class<?> clazz;
        Object component = this.container.getComponentInstance(id);
        if (component != null && (clazz = this.newPlaceholderClass(component.getClass())) != null) {
            this.log.debug("Adding Blueprint PropertyPlaceholder: {}", (Object)id);
            if (this.method == null) {
                try {
                    this.method = clazz.getDeclaredMethod("retrieveValue", String.class);
                    this.method.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("Cannot add blueprint property placeholder: " + id + " as the method retrieveValue is not accessible", e);
                }
            }
            this.placeholders.add(new PropertyPlaceholderWrapper(component, this.method));
        }
        if (component instanceof AbstractPropertyPlaceholder) {
            AbstractPropertyPlaceholder placeholder = (AbstractPropertyPlaceholder)component;
            this.log.debug("Adding Blueprint PropertyPlaceholder: {}", (Object)id);
            if (this.oldMethod == null) {
                try {
                    this.oldMethod = AbstractPropertyPlaceholder.class.getDeclaredMethod("retrieveValue", String.class);
                    this.oldMethod.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("Cannot add blueprint property placeholder: " + id + " as the method retrieveValue is not accessible", e);
                }
            }
            this.placeholders.add(new PropertyPlaceholderWrapper(placeholder, this.oldMethod));
        }
    }

    public String parseProperty(String key, String value, Properties properties) {
        String delegateAnswer;
        this.log.trace("Parsing property key: {} with value: {}", (Object)key, (Object)value);
        String answer = null;
        if (key != null && this.propertiesComponent.getOverrideProperties() != null) {
            answer = (String)this.propertiesComponent.getOverrideProperties().get(key);
        }
        if (answer == null && key != null) {
            for (PropertyPlaceholderWrapper placeholder : this.placeholders) {
                boolean isDefault = false;
                if (this.placeholders.size() > 1) {
                    Map map = placeholder.getDefaultProperties();
                    isDefault = map != null && map.containsKey(key);
                    this.log.trace("Blueprint property key: {} is part of default properties: {}", (Object)key, (Object)isDefault);
                }
                try {
                    String candidate = placeholder.retrieveValue(key);
                    if (candidate == null || answer != null && isDefault) continue;
                    this.log.trace("Blueprint parsed candidate property key: {} as value: {}", (Object)key, (Object)answer);
                    answer = candidate;
                }
                catch (Exception exception) {}
            }
            this.log.debug("Blueprint parsed property key: {} as value: {}", (Object)key, (Object)answer);
        }
        if (this.delegate != null && (delegateAnswer = this.delegate.parseProperty(key, answer != null ? answer : value, properties)) != null) {
            answer = delegateAnswer;
            this.log.debug("Delegate property parser parsed the property key: {} as value: {}", (Object)key, (Object)answer);
        }
        this.log.trace("Returning parsed property key: {} as value: {}", (Object)key, (Object)answer);
        return answer;
    }

    private class PropertyPlaceholderWrapper {
        private Object delegate;
        private Method method;

        public PropertyPlaceholderWrapper(Object delegate, Method method) {
            this.delegate = delegate;
            this.method = method;
        }

        public String retrieveValue(String key) {
            Object v = ObjectHelper.invokeMethod((Method)this.method, (Object)this.delegate, (Object[])new Object[]{key});
            return v == null ? null : v.toString();
        }

        public Map getDefaultProperties() {
            if (this.delegate instanceof PropertyPlaceholder) {
                return ((PropertyPlaceholder)this.delegate).getDefaultProperties();
            }
            try {
                Method getDefaultProperties = this.delegate.getClass().getMethod("getDefaultProperties", new Class[0]);
                return getDefaultProperties == null ? null : (Map)getDefaultProperties.invoke(this.delegate, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return null;
            }
        }
    }
}

