/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.factory.initializable;

import org.apache.uima.UimaContext;
import org.apache.uima.fit.factory.initializable.Initializable;
import org.apache.uima.fit.internal.ClassLoaderUtils;
import org.apache.uima.resource.ResourceInitializationException;

public final class InitializableFactory {
    private InitializableFactory() {
    }

    public static <T> T create(UimaContext context, String className, Class<T> superClass) throws ResourceInitializationException {
        Class<T> cls;
        try {
            ClassLoader cl = ClassLoaderUtils.findClassloader(context);
            cls = Class.forName(className, true, cl).asSubclass(superClass);
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)new IllegalStateException("classname = " + className + " superClass = " + superClass.getName(), e));
        }
        return InitializableFactory.create(context, cls);
    }

    public static <T> Class<? extends T> getClass(String className, Class<T> superClass) throws ResourceInitializationException {
        try {
            ClassLoader cl = ClassLoaderUtils.findClassloader();
            return Class.forName(className, true, cl).asSubclass(superClass);
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)new IllegalStateException("classname = " + className + " superClass = " + superClass.getName(), e));
        }
    }

    public static <T> T create(UimaContext context, Class<? extends T> cls) throws ResourceInitializationException {
        T instance;
        try {
            instance = cls.newInstance();
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        InitializableFactory.initialize(instance, context);
        return instance;
    }

    public static void initialize(Object object, UimaContext context) throws ResourceInitializationException {
        if (object instanceof Initializable) {
            ((Initializable)object).initialize(context);
        }
    }
}

