/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.tools;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.uima.UIMAException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CasConsumer;
import org.apache.uima.collection.CasInitializer;
import org.apache.uima.collection.CollectionProcessingEngine;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.collection.metadata.CpeDescription;
import org.apache.uima.internal.util.I18nUtil;
import org.apache.uima.pear.tools.InstallationController;
import org.apache.uima.pear.tools.PackageBrowser;
import org.apache.uima.pear.util.UIMAUtil;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;

public class InstallationTester {
    private String uimaCategory = null;
    private PackageBrowser pkgBrowser = null;
    private Properties systemProps = null;
    private static final String PEAR_MESSAGE_RESOURCE_BUNDLE = "org.apache.uima.pear.pear_messages";

    public InstallationTester(PackageBrowser pkgBrowser) throws IOException, InvalidXMLException, ResourceInitializationException, UIMAException, UIMARuntimeException {
        Exception err;
        this.pkgBrowser = pkgBrowser;
        this.systemProps = System.getProperties();
        File compDescFile = new File(this.pkgBrowser.getInstallationDescriptor().getMainComponentDesc());
        this.uimaCategory = UIMAUtil.identifyUimaComponentCategory(compDescFile);
        if (this.uimaCategory == null && (err = UIMAUtil.getLastErrorForXmlDesc(compDescFile)) != null) {
            if (err instanceof UIMAException) {
                throw (UIMAException)err;
            }
            if (err instanceof UIMARuntimeException) {
                throw (UIMARuntimeException)err;
            }
            throw new RuntimeException(err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstallationController.TestStatus doTest() throws IOException, InvalidXMLException, ResourceInitializationException {
        if (this.uimaCategory.equals("TS")) {
            return this.testTypeSystem();
        }
        List<String> kinds = Arrays.asList("AE", "CC", "CI", "CR", "CPE");
        if (!kinds.contains(this.uimaCategory)) {
            InstallationController.TestStatus status = new InstallationController.TestStatus();
            status.setMessage(I18nUtil.localizeMessage(PEAR_MESSAGE_RESOURCE_BUNDLE, "installation_verification_type_not_detected", new Object[]{this.pkgBrowser.getInstallationDescriptor().getMainComponentId()}, null));
            return status;
        }
        InstallationTester.setSystemProperties(this.pkgBrowser);
        XMLInputSource xmlIn = null;
        ResourceManager resource_manager = null;
        try {
            xmlIn = new XMLInputSource(this.pkgBrowser.getInstallationDescriptor().getMainComponentDesc());
            ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(xmlIn);
            resource_manager = InstallationTester.getResourceManager(this.pkgBrowser);
            InstallationController.TestStatus status = new InstallationController.TestStatus();
            if (this.uimaCategory.equals("AE")) {
                this.testAnalysisEngine(specifier, resource_manager, status);
            } else if (this.uimaCategory.equals("CC")) {
                this.testCasConsumer(specifier, resource_manager, status);
            } else if (this.uimaCategory.equals("CI")) {
                this.testCasInitializer(specifier, resource_manager, status);
            } else if (this.uimaCategory.equals("CR")) {
                this.testCollectionReader(specifier, resource_manager, status);
            } else if (this.uimaCategory.equals("CPE")) {
                this.testCpeCongifuration(specifier, resource_manager, status);
            }
            this.resetSystemProperties();
            InstallationController.TestStatus testStatus = status;
            return testStatus;
        }
        finally {
            if (xmlIn != null) {
                xmlIn.close();
            }
            if (resource_manager != null) {
                resource_manager.destroy();
            }
        }
    }

    private static ResourceManager getResourceManager(PackageBrowser pkgBrowser) throws IOException {
        ResourceManager resourceMgr = UIMAFramework.newDefaultResourceManager();
        if (pkgBrowser.getComponentDataPath() != null) {
            resourceMgr.setDataPath(pkgBrowser.getComponentDataPath());
        }
        if (pkgBrowser.buildComponentClassPath() != null) {
            resourceMgr.setExtensionClassPath(pkgBrowser.buildComponentClassPath(), true);
        }
        return resourceMgr;
    }

    private static void setSystemProperties(PackageBrowser pkgBrowser) throws IOException {
        Properties props = pkgBrowser.getComponentEnvVars();
        for (String string : props.keySet()) {
            String value = (String)props.get(string);
            System.setProperty(string, value);
        }
    }

    private void resetSystemProperties() {
        System.setProperties(this.systemProps);
    }

    private void testAnalysisEngine(ResourceSpecifier specifier, ResourceManager resource_manager, InstallationController.TestStatus status) throws IOException, InvalidXMLException, ResourceInitializationException {
        AnalysisEngine ae = UIMAFramework.produceAnalysisEngine(specifier, resource_manager, null);
        CAS cas = null;
        if (ae != null) {
            cas = ae.newCAS();
        }
        if (ae != null && cas != null) {
            status.setRetCode(0);
        } else {
            status.setRetCode(-1);
            status.setMessage(I18nUtil.localizeMessage(PEAR_MESSAGE_RESOURCE_BUNDLE, "installation_verification_ae_not_created", new Object[]{this.pkgBrowser.getInstallationDescriptor().getMainComponentId()}, null));
        }
    }

    private void testCasConsumer(ResourceSpecifier specifier, ResourceManager resource_manager, InstallationController.TestStatus status) throws IOException, InvalidXMLException, ResourceInitializationException {
        CasConsumer cc = UIMAFramework.produceCasConsumer(specifier, resource_manager, null);
        if (cc != null) {
            status.setRetCode(0);
        } else {
            status.setRetCode(-1);
            status.setMessage(I18nUtil.localizeMessage(PEAR_MESSAGE_RESOURCE_BUNDLE, "installation_verification_cc_not_created", new Object[]{this.pkgBrowser.getInstallationDescriptor().getMainComponentId()}, null));
        }
    }

    private void testCasInitializer(ResourceSpecifier specifier, ResourceManager resource_manager, InstallationController.TestStatus status) throws IOException, InvalidXMLException, ResourceInitializationException {
        CasInitializer ci = UIMAFramework.produceCasInitializer(specifier, resource_manager, null);
        if (ci != null) {
            status.setRetCode(0);
        } else {
            status.setRetCode(-1);
            status.setMessage(I18nUtil.localizeMessage(PEAR_MESSAGE_RESOURCE_BUNDLE, "installation_verification_ci_not_created", new Object[]{this.pkgBrowser.getInstallationDescriptor().getMainComponentId()}, null));
        }
    }

    private void testCollectionReader(ResourceSpecifier specifier, ResourceManager resource_manager, InstallationController.TestStatus status) throws IOException, InvalidXMLException, ResourceInitializationException {
        CollectionReader cr = UIMAFramework.produceCollectionReader(specifier, resource_manager, null);
        if (cr != null) {
            status.setRetCode(0);
        } else {
            status.setRetCode(-1);
            status.setMessage(I18nUtil.localizeMessage(PEAR_MESSAGE_RESOURCE_BUNDLE, "installation_verification_cr_not_created", new Object[]{this.pkgBrowser.getInstallationDescriptor().getMainComponentId()}, null));
        }
    }

    private void testCpeCongifuration(ResourceSpecifier specifier, ResourceManager resource_manager, InstallationController.TestStatus status) throws IOException, InvalidXMLException, ResourceInitializationException {
        CollectionProcessingEngine cpe = UIMAFramework.produceCollectionProcessingEngine((CpeDescription)((Object)specifier), resource_manager, null);
        if (cpe != null) {
            status.setRetCode(0);
        } else {
            status.setRetCode(-1);
            status.setMessage(I18nUtil.localizeMessage(PEAR_MESSAGE_RESOURCE_BUNDLE, "installation_verification_cpe_not_created", new Object[]{this.pkgBrowser.getInstallationDescriptor().getMainComponentId()}, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstallationController.TestStatus testTypeSystem() throws IOException, InvalidXMLException, ResourceInitializationException {
        InstallationTester.setSystemProperties(this.pkgBrowser);
        try (XMLInputSource xmlIn = null;){
            xmlIn = new XMLInputSource(this.pkgBrowser.getInstallationDescriptor().getMainComponentDesc());
            TypeSystemDescription tsDescription = UIMAFramework.getXMLParser().parseTypeSystemDescription(xmlIn);
            TypePriorities tPriorities = UIMAFramework.getResourceSpecifierFactory().createTypePriorities();
            FsIndexDescription[] fsIndexes = new FsIndexDescription[]{};
            CAS cas = CasCreationUtils.createCas(tsDescription, tPriorities, fsIndexes);
            InstallationController.TestStatus status = new InstallationController.TestStatus();
            if (cas != null) {
                status.setRetCode(0);
            } else {
                status.setRetCode(-1);
                status.setMessage(I18nUtil.localizeMessage(PEAR_MESSAGE_RESOURCE_BUNDLE, "installation_verification_cas_not_created", new Object[]{this.pkgBrowser.getInstallationDescriptor().getMainComponentId()}, null));
            }
            this.resetSystemProperties();
            InstallationController.TestStatus testStatus = status;
            return testStatus;
        }
    }
}

