/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cvd.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFileChooser;
import org.apache.uima.internal.util.Timer;
import org.apache.uima.tools.cvd.MainFrame;

public class FileOpenEventHandler
implements ActionListener {
    private final MainFrame main;

    public FileOpenEventHandler(MainFrame frame) {
        this.main = frame;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        int rc;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Open text file");
        fileChooser.setFileSelectionMode(0);
        if (this.main.getFileOpenDir() != null) {
            fileChooser.setCurrentDirectory(this.main.getFileOpenDir());
        }
        if ((rc = fileChooser.showOpenDialog(this.main)) == 0) {
            this.main.setTextFile(fileChooser.getSelectedFile());
            if (this.main.getTextFile().exists() && this.main.getTextFile().isFile()) {
                this.main.setFileOpenDir(this.main.getTextFile().getParentFile());
            }
            Timer time = new Timer();
            time.start();
            this.main.loadFile();
            time.stop();
            this.main.resetTrees();
            this.main.setSaveTextFileEnable(true);
            this.main.getUndoMgr().discardAllEdits();
            this.main.setFileStatusMessage();
            this.main.setStatusbarMessage("Done loading text file " + this.main.getTextFile().getName() + " in " + String.valueOf(time.getTimeSpan()) + ".");
        }
    }
}

