/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.caseditor.view.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.caseditor.editor.AnnotationEditor;
import org.apache.uima.caseditor.editor.AnnotationStyle;
import org.apache.uima.caseditor.editor.AnnotationStyleChangeListener;
import org.apache.uima.caseditor.editor.IAnnotationEditorModifyListener;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.apache.uima.caseditor.editor.ICasDocumentListener;
import org.apache.uima.ruta.caseditor.RutaCasEditorPlugin;
import org.apache.uima.ruta.caseditor.view.tree.AnnotationTreeContentProvider;
import org.apache.uima.ruta.caseditor.view.tree.AnnotationTreeLabelProvider;
import org.apache.uima.ruta.caseditor.view.tree.AnnotationTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.AnnotationTreeViewDragListener;
import org.apache.uima.ruta.caseditor.view.tree.IRootTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.ITreeNode;
import org.apache.uima.ruta.caseditor.view.tree.ToolTipListener;
import org.apache.uima.ruta.caseditor.view.tree.TypeOrderedRootTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.TypeTreeNode;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationTreeViewPage
extends Page
implements MouseListener,
IDoubleClickListener,
Listener,
ISelectionListener,
ICheckStateListener,
IAnnotationEditorModifyListener {
    private CheckboxTreeViewer treeView;
    private AnnotationTreeLabelProvider lableProvider;
    protected Text filterTypeTextField;
    private Map<Type, Image> icons = new HashMap<Type, Image>();
    private Composite overlay;
    protected AnnotationEditor editor;
    protected ICasDocument document;
    private boolean useSelection;
    private Text filterCoveredTextTextField;
    private int offset = -1;
    private TreeViewAnnotationStyleChangeListener styleListener;

    public AnnotationTreeViewPage(boolean useSelection, AnnotationEditor editor) {
        this.useSelection = useSelection;
        this.editor = editor;
        this.document = editor.getDocument();
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
    }

    public void createControl(Composite parent) {
        this.overlay = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.overlay.setLayout((Layout)layout);
        this.filterTypeTextField = new Text(this.overlay, 2052);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 1;
        this.filterTypeTextField.setLayoutData((Object)gd);
        this.filterTypeTextField.setToolTipText("Retain types that contain...");
        this.filterTypeTextField.addListener(2, (Listener)this);
        this.filterTypeTextField.addListener(4, (Listener)this);
        this.filterTypeTextField.addListener(24, (Listener)this);
        this.filterTypeTextField.setMessage("Only types with...");
        this.filterCoveredTextTextField = new Text(this.overlay, 2052);
        GridData gd2 = new GridData();
        gd2.grabExcessHorizontalSpace = true;
        gd2.horizontalAlignment = 4;
        gd2.horizontalSpan = 1;
        this.filterCoveredTextTextField.setLayoutData((Object)gd2);
        this.filterCoveredTextTextField.setToolTipText("Only annotation with...");
        this.filterCoveredTextTextField.addListener(2, (Listener)this);
        this.filterCoveredTextTextField.addListener(4, (Listener)this);
        this.filterCoveredTextTextField.addListener(24, (Listener)this);
        this.filterCoveredTextTextField.setMessage("Only annotations with...");
        this.treeView = new CheckboxTreeViewer(this.overlay, 770);
        gd = new GridData(1808);
        this.treeView.getTree().setLayoutData((Object)gd);
        AnnotationTreeContentProvider provider = new AnnotationTreeContentProvider(this.editor, this);
        this.treeView.setContentProvider((IContentProvider)provider);
        this.document.addChangeListener((ICasDocumentListener)provider);
        this.lableProvider = new AnnotationTreeLabelProvider(this);
        this.treeView.setLabelProvider((IBaseLabelProvider)this.lableProvider);
        this.treeView.addCheckStateListener((ICheckStateListener)this);
        this.treeView.addDoubleClickListener((IDoubleClickListener)this);
        this.treeView.getTree().addMouseListener((MouseListener)this);
        ToolTipListener tl = new ToolTipListener(this.treeView.getTree());
        this.treeView.getTree().addListener(12, (Listener)tl);
        this.treeView.getTree().addListener(1, (Listener)tl);
        this.treeView.getTree().addListener(5, (Listener)tl);
        this.treeView.getTree().addListener(32, (Listener)tl);
        int ops = 3;
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
        this.treeView.addDragSupport(ops, transfers, (DragSourceListener)new AnnotationTreeViewDragListener((StructuredViewer)this.treeView));
        this.getTreeViewer().getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int keyCode = e.keyCode;
                if (keyCode == 8 || keyCode == 127) {
                    AnnotationTreeViewPage.this.deleteSelectedAnnotations();
                }
            }
        });
        this.styleListener = new TreeViewAnnotationStyleChangeListener();
        this.editor.getCasDocumentProvider().getTypeSystemPreferenceStore((Object)this.editor.getEditorInput()).addPropertyChangeListener((IPropertyChangeListener)this.styleListener);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeView);
        this.editor.addAnnotationListener((IAnnotationEditorModifyListener)this);
        if (!this.useSelection) {
            this.reloadTree();
        }
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.editor.removeAnnotationListener((IAnnotationEditorModifyListener)this);
        this.editor.getCasDocumentProvider().getTypeSystemPreferenceStore((Object)this.editor.getEditorInput()).removePropertyChangeListener((IPropertyChangeListener)this.styleListener);
        this.overlay.dispose();
        Collection<Image> values = this.icons.values();
        for (Image image : values) {
            image.dispose();
        }
    }

    public Control getControl() {
        return this.overlay;
    }

    public CheckboxTreeViewer getTreeViewer() {
        return this.treeView;
    }

    public void setFocus() {
        this.overlay.setFocus();
    }

    public void doubleClick(DoubleClickEvent event) {
        Object treeNode;
        if (event.getSelection() == null || !(event.getSelection() instanceof ITreeSelection) || (treeNode = ((ITreeSelection)event.getSelection()).getFirstElement()) instanceof AnnotationTreeNode) {
            // empty if block
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void deleteSelectedAnnotations() {
        if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Confirm Delete", (String)"Are you sure you want to delete these items?")) {
            TreeItem[] items = this.treeView.getTree().getSelection();
            HashSet<AnnotationFS> annots = new HashSet<AnnotationFS>();
            for (TreeItem it : items) {
                if (it.getData() instanceof AnnotationTreeNode) {
                    AnnotationTreeNode annot = (AnnotationTreeNode)it.getData();
                    annots.add(annot.getAnnotation());
                    continue;
                }
                if (!(it.getData() instanceof TypeTreeNode)) continue;
                TypeTreeNode type = (TypeTreeNode)it.getData();
                for (ITreeNode child : type.getChildren()) {
                    if (!(child instanceof AnnotationTreeNode)) continue;
                    AnnotationTreeNode annot = (AnnotationTreeNode)child;
                    annots.add(annot.getAnnotation());
                }
            }
            this.editor.getDocument().removeFeatureStructures(annots);
        }
    }

    public void mouseDown(MouseEvent mouseEvent) {
    }

    public void mouseUp(MouseEvent e) {
    }

    public Image getIcon(Type type) {
        if (this.icons.containsKey(type)) {
            return this.icons.get(type);
        }
        Image image = this.updateIcon(type);
        return image;
    }

    private void updateIcon(String typeName) {
        Set<Type> keySet = this.icons.keySet();
        for (Type type : keySet) {
            String name = type.getName();
            if (!name.equals(typeName)) continue;
            this.updateIcon(type);
            return;
        }
    }

    private Image updateIcon(Type type) {
        AnnotationStyle style = this.editor.getAnnotationStyle(type);
        Color fg = new Color((Device)Display.getCurrent(), 0, 0, 0);
        Color bg = new Color((Device)Display.getCurrent(), style.getColor().getRed(), style.getColor().getGreen(), style.getColor().getBlue());
        PaletteData paletteData = new PaletteData(new RGB[]{bg.getRGB(), fg.getRGB()});
        ImageData imageData = new ImageData(40, 40, 1, paletteData);
        Image image = new Image((Device)Display.getCurrent(), imageData);
        GC gc = new GC((Drawable)image);
        String styleString = style.getStyle().name().substring(0, 2);
        Point p = gc.stringExtent(styleString);
        gc.dispose();
        image.dispose();
        imageData = new ImageData(p.x + 4, p.y, 1, paletteData);
        image = new Image((Device)Display.getCurrent(), imageData);
        gc = new GC((Drawable)image);
        gc.setBackground(bg);
        gc.setForeground(fg);
        gc.setTextAntialias(1);
        gc.drawString(styleString, 2, 0);
        gc.dispose();
        Image oldImage = this.icons.get(type);
        if (oldImage != null) {
            oldImage.dispose();
        }
        this.icons.put(type, image);
        return image;
    }

    public IRootTreeNode getTypeOrderedTree(int pos, String manualTypeFilter, String manualTextFilter) {
        TypeOrderedRootTreeNode root = new TypeOrderedRootTreeNode();
        IPreferenceStore preferenceStore = RutaCasEditorPlugin.getDefault().getPreferenceStore();
        boolean withParents = preferenceStore.getBoolean("showParentTypes");
        AnnotationIndex annotationIndex = this.document.getCAS().getAnnotationIndex();
        for (AnnotationFS annotationFS : annotationIndex) {
            boolean textConstraint;
            boolean offsetConstraint = pos == -1 || annotationFS.getBegin() <= pos && annotationFS.getEnd() >= pos;
            boolean typeConstraint = StringUtils.isEmpty((CharSequence)manualTypeFilter) || annotationFS.getType().getName().indexOf(manualTypeFilter) != -1;
            boolean bl = textConstraint = StringUtils.isEmpty((CharSequence)manualTextFilter) || annotationFS.getCoveredText().indexOf(manualTextFilter) != -1;
            if (!offsetConstraint || !typeConstraint || !textConstraint) continue;
            root.insertFS((FeatureStructure)annotationFS, withParents);
        }
        root.sort();
        return root;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.useSelection) {
            return;
        }
        if (selection instanceof StructuredSelection && part instanceof AnnotationEditor) {
            this.offset = this.editor.getCaretOffset();
            this.reloadTree();
        }
    }

    public void handleEvent(Event event) {
        if ((event.widget == this.filterTypeTextField || event.widget == this.filterCoveredTextTextField) && event.type == 24) {
            this.reloadTree();
        }
    }

    public void reloadTree() {
        String typeText = this.filterTypeTextField.getText();
        String coveredTextText = this.filterCoveredTextTextField.getText();
        IRootTreeNode tree = this.getTypeOrderedTree(this.offset, typeText, coveredTextText);
        this.getTreeViewer().setInput((Object)tree);
        Collection shownAnnotationTypes = this.editor.getShownAnnotationTypes();
        List<TypeTreeNode> nodes = this.toNodes(shownAnnotationTypes);
        this.getTreeViewer().setCheckedElements(nodes.toArray());
        this.getTreeViewer().setGrayed((Object)new TypeTreeNode(this.editor.getAnnotationMode()), true);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object element = event.getElement();
        boolean checked = event.getChecked();
        Type type = null;
        if (element instanceof TypeTreeNode) {
            type = ((TypeTreeNode)element).getType();
        } else if (element instanceof AnnotationTreeNode) {
            type = ((AnnotationTreeNode)element).getType();
        }
        if (type != null && !this.editor.getAnnotationMode().equals(type)) {
            this.editor.setShownAnnotationType(type, checked);
        }
    }

    public void annotationModeChanged(Type newMode) {
        this.getTreeViewer().setGrayed((Object)new TypeTreeNode(newMode), true);
    }

    public void showAnnotationsChanged(Collection<Type> shownAnnotationTypes) {
        List<TypeTreeNode> nodes = this.toNodes(shownAnnotationTypes);
        this.getTreeViewer().setCheckedElements(nodes.toArray());
    }

    private List<TypeTreeNode> toNodes(Collection<Type> shownAnnotationTypes) {
        ArrayList<TypeTreeNode> nodes = new ArrayList<TypeTreeNode>();
        for (Type type : shownAnnotationTypes) {
            nodes.add(new TypeTreeNode(type));
        }
        return nodes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TreeViewAnnotationStyleChangeListener
    extends AnnotationStyleChangeListener {
        public void annotationStylesChanged(Collection<AnnotationStyle> styles) {
            for (AnnotationStyle annotationStyle : styles) {
                String annotation = annotationStyle.getAnnotation();
                AnnotationTreeViewPage.this.updateIcon(annotation);
            }
            if (!AnnotationTreeViewPage.this.treeView.isBusy()) {
                AnnotationTreeViewPage.this.treeView.refresh();
            }
        }
    }
}

