/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.network.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.AddressAndPort;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.AddressAndPortExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.semconv.SemanticAttributes;

public final class InternalServerAttributesExtractor<REQUEST> {
    private final AddressAndPortExtractor<REQUEST> addressAndPortExtractor;
    private final boolean emitStableUrlAttributes;
    private final boolean emitOldHttpAttributes;
    private final Mode oldSemconvMode;

    public InternalServerAttributesExtractor(AddressAndPortExtractor<REQUEST> addressAndPortExtractor, boolean emitStableUrlAttributes, boolean emitOldHttpAttributes, Mode oldSemconvMode) {
        this.addressAndPortExtractor = addressAndPortExtractor;
        this.emitStableUrlAttributes = emitStableUrlAttributes;
        this.emitOldHttpAttributes = emitOldHttpAttributes;
        this.oldSemconvMode = oldSemconvMode;
    }

    public void onStart(AttributesBuilder attributes, REQUEST request) {
        AddressAndPort serverAddressAndPort = this.addressAndPortExtractor.extract(request);
        if (serverAddressAndPort.address != null) {
            if (this.emitStableUrlAttributes) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.SERVER_ADDRESS, (Object)serverAddressAndPort.address);
            }
            if (this.emitOldHttpAttributes) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, this.oldSemconvMode.address, (Object)serverAddressAndPort.address);
            }
            if (serverAddressAndPort.port != null && serverAddressAndPort.port > 0) {
                if (this.emitStableUrlAttributes) {
                    AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.SERVER_PORT, (Object)serverAddressAndPort.port);
                }
                if (this.emitOldHttpAttributes) {
                    AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, this.oldSemconvMode.port, (Object)serverAddressAndPort.port);
                }
            }
        }
    }

    public static enum Mode {
        PEER((AttributeKey<String>)SemanticAttributes.NET_PEER_NAME, (AttributeKey<Long>)SemanticAttributes.NET_PEER_PORT),
        HOST((AttributeKey<String>)SemanticAttributes.NET_HOST_NAME, (AttributeKey<Long>)SemanticAttributes.NET_HOST_PORT);

        final AttributeKey<String> address;
        final AttributeKey<Long> port;

        private Mode(AttributeKey<String> address, AttributeKey<Long> port) {
            this.address = address;
            this.port = port;
        }
    }
}

