/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.openapi;

import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.stream.Stream;
import org.apache.tomee.microprofile.openapi.MicroProfileOpenApiRegistration;
import org.eclipse.microprofile.openapi.models.OpenAPI;

@WebServlet(name="openapi-servlet", urlPatterns={"/openapi/*"})
public class MicroProfileOpenApiEndpoint
extends HttpServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletContext servletContext = request.getServletContext();
        OpenAPI openAPI = MicroProfileOpenApiRegistration.getOpenApi(servletContext);
        String format = request.getParameter("format");
        Format formatOpenApi = this.getOpenApiFormat(request, format);
        response.setContentType(formatOpenApi.getMimeType());
        if (openAPI == null) {
            response.sendError(404, "No OpenAPI model available");
        } else {
            response.getOutputStream().write(OpenApiSerializer.serialize((OpenAPI)openAPI, (Format)formatOpenApi).getBytes(StandardCharsets.UTF_8));
        }
    }

    private Format getOpenApiFormat(HttpServletRequest request, String format) {
        return Stream.of(Format.values()).filter(f -> format != null && f.name().compareToIgnoreCase(format) == 0).findFirst().orElse(request.getHeader("Accept").toLowerCase(Locale.ENGLISH).contains("application/json") ? Format.JSON : Format.YAML);
    }
}

