/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.metadata.AffiliationDescriptor;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;

public class BasicDynamicTrustedNamesStrategy
implements Function<XMLObject, Set<String>> {
    @Override
    @Nonnull
    public Set<String> apply(@Nullable XMLObject input) {
        if (input == null) {
            return CollectionSupport.emptySet();
        }
        Set<String> rawResult = null;
        if (input instanceof EntityDescriptor) {
            EntityDescriptor entity = (EntityDescriptor)input;
            String entityID = entity.getEntityID();
            if (entityID != null) {
                rawResult = CollectionSupport.singleton((Object)entityID);
            }
        } else if (input instanceof EntitiesDescriptor) {
            EntitiesDescriptor entities = (EntitiesDescriptor)input;
            String name = entities.getName();
            if (name != null) {
                rawResult = CollectionSupport.singleton((Object)name);
            }
        } else if (input instanceof RoleDescriptor) {
            EntityDescriptor entity;
            String entityID;
            XMLObject parent = input.getParent();
            if (parent instanceof EntityDescriptor && (entityID = (entity = (EntityDescriptor)parent).getEntityID()) != null) {
                rawResult = CollectionSupport.singleton((Object)entityID);
            }
        } else if (input instanceof AffiliationDescriptor) {
            EntityDescriptor entity;
            String entityID;
            XMLObject parent;
            AffiliationDescriptor affil = (AffiliationDescriptor)input;
            rawResult = new HashSet<String>();
            String owner = affil.getOwnerID();
            if (owner != null) {
                rawResult.add(owner);
            }
            if ((parent = input.getParent()) instanceof EntityDescriptor && (entityID = (entity = (EntityDescriptor)parent).getEntityID()) != null) {
                rawResult.add(entityID);
            }
        }
        if (rawResult != null) {
            return CollectionSupport.copyToSet((Collection)StringSupport.normalizeStringCollection((Collection)rawResult));
        }
        return CollectionSupport.emptySet();
    }
}

