/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Localized;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.InternationalString;

public final class Warnings
implements Localized,
Serializable {
    private static final long serialVersionUID = -1825161781642905329L;
    private final Locale errorLocale;
    private final boolean isParsing;
    private String root;
    private final ArrayList<Object> messages;
    private final LinkedHashMap<Exception, String[]> exceptionSources;
    private Map<String, List<String>> ignoredElements;
    private boolean published;

    Warnings(Locale locale, boolean isParsing, Map<String, List<String>> ignoredElements) {
        this.errorLocale = locale;
        this.isParsing = isParsing;
        this.ignoredElements = ignoredElements;
        this.exceptionSources = new LinkedHashMap(4);
        this.messages = new ArrayList();
    }

    final void setRoot(Object obj) {
        ReferenceIdentifier id;
        if (obj instanceof IdentifiedObject && (id = ((IdentifiedObject)obj).getName()) != null && (this.root = id.getCode()) != null) {
            return;
        }
        this.root = Classes.getShortClassName(obj);
    }

    final void add(InternationalString message, Exception cause, String[] source) {
        assert (message != null || cause != null);
        this.messages.add(message);
        this.messages.add(cause);
        if (cause != null) {
            this.exceptionSources.put(cause, source);
        }
    }

    final void publish() {
        if (!this.published) {
            this.ignoredElements = this.ignoredElements.isEmpty() ? Collections.emptyMap() : new LinkedHashMap<String, List<String>>(this.ignoredElements);
            this.published = true;
        }
    }

    @Override
    public Locale getLocale() {
        return this.errorLocale;
    }

    public String getRootElement() {
        return this.root;
    }

    public final int getNumMessages() {
        return this.messages != null ? this.messages.size() / 2 : 0;
    }

    public String getMessage(int index) {
        ArgumentChecks.ensureValidIndex(this.getNumMessages(), index);
        InternationalString i18n = (InternationalString)this.messages.get(index *= 2);
        if (i18n != null) {
            return i18n.toString(this.errorLocale);
        }
        Exception cause = (Exception)this.messages.get(index + 1);
        String[] sources = this.exceptionSources.get(cause);
        if (sources != null) {
            return Errors.getResources(this.errorLocale).getString((short)156, sources);
        }
        return cause.toString();
    }

    public Exception getException(int index) {
        ArgumentChecks.ensureValidIndex(this.getNumMessages(), index);
        return (Exception)this.messages.get(index * 2 + 1);
    }

    public Set<Exception> getExceptions() {
        return this.exceptionSources != null ? this.exceptionSources.keySet() : Collections.emptySet();
    }

    public String[] getExceptionSource(Exception ex) {
        return this.exceptionSources != null ? this.exceptionSources.get(ex) : null;
    }

    public Set<String> getUnknownElements() {
        return this.ignoredElements.keySet();
    }

    public Collection<String> getUnknownElementLocations(String element) {
        return this.ignoredElements.get(element);
    }

    public String toString() {
        return this.toString(this.errorLocale);
    }

    public String toString(Locale locale) {
        StringBuilder buffer = new StringBuilder(250);
        String lineSeparator = System.lineSeparator();
        Messages resources = Messages.getResources(locale);
        buffer.append(resources.getString(this.isParsing ? (short)22 : 26, this.root));
        if (this.messages != null) {
            Iterator<Object> it = this.messages.iterator();
            while (it.hasNext()) {
                String message;
                InternationalString i18n = (InternationalString)it.next();
                Exception cause = (Exception)it.next();
                if (i18n != null) {
                    message = i18n.toString(locale);
                } else {
                    String[] sources = this.exceptionSources.get(cause);
                    if (sources != null) {
                        message = Errors.getResources(locale).getString((short)156, sources);
                    } else {
                        message = cause.toString();
                        cause = null;
                    }
                }
                buffer.append(lineSeparator).append("\u00a0\u2022\u00a0").append(message);
                if (cause == null) continue;
                String details = Exceptions.getLocalizedMessage(cause, locale);
                if (details == null) {
                    details = cause.toString();
                }
                buffer.append(lineSeparator).append("\u00a0\u00a0\u00a0").append(details);
            }
        }
        if (!this.ignoredElements.isEmpty()) {
            Vocabulary vocabulary = Vocabulary.getResources(locale);
            buffer.append(lineSeparator).append("\u00a0\u2022\u00a0").append(resources.getString((short)29));
            for (Map.Entry<String, List<String>> entry : this.ignoredElements.entrySet()) {
                buffer.append(lineSeparator).append("\u00a0\u00a0\u00a0\u00a0\u2023\u00a0").append(vocabulary.getString((short)165, entry.getKey()));
                String separator = vocabulary.getString((short)105);
                for (String p : entry.getValue()) {
                    buffer.append(separator).append(p);
                    separator = ", ";
                }
                buffer.append('.');
            }
        }
        return buffer.toString();
    }
}

