/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.stream;

import java.io.EOFException;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Objects;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.io.stream.DataTransfer;
import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Errors;

final class MemoryDataTransfer
implements DataTransfer,
ReadableByteChannel {
    private final ChannelDataInput.ArrayReader reader;

    MemoryDataTransfer(String filename, Buffer data) throws IOException {
        ChannelDataInput input = new ChannelDataInput(filename, this, data instanceof ByteBuffer ? (ByteBuffer)data : null, true);
        if (data instanceof ByteBuffer) {
            ChannelDataInput channelDataInput = input;
            Objects.requireNonNull(channelDataInput);
            this.reader = channelDataInput.new ChannelDataInput.BytesReader(null);
        } else if (data instanceof ShortBuffer) {
            ChannelDataInput channelDataInput = input;
            Objects.requireNonNull(channelDataInput);
            this.reader = channelDataInput.new ChannelDataInput.ShortsReader((ShortBuffer)data);
        } else if (data instanceof IntBuffer) {
            ChannelDataInput channelDataInput = input;
            Objects.requireNonNull(channelDataInput);
            this.reader = channelDataInput.new ChannelDataInput.IntsReader((IntBuffer)data);
        } else if (data instanceof LongBuffer) {
            ChannelDataInput channelDataInput = input;
            Objects.requireNonNull(channelDataInput);
            this.reader = channelDataInput.new ChannelDataInput.LongsReader((LongBuffer)data);
        } else if (data instanceof FloatBuffer) {
            ChannelDataInput channelDataInput = input;
            Objects.requireNonNull(channelDataInput);
            this.reader = channelDataInput.new ChannelDataInput.FloatsReader((FloatBuffer)data);
        } else if (data instanceof DoubleBuffer) {
            ChannelDataInput channelDataInput = input;
            Objects.requireNonNull(channelDataInput);
            this.reader = channelDataInput.new ChannelDataInput.DoublesReader((DoubleBuffer)data);
        } else if (data instanceof CharBuffer) {
            ChannelDataInput channelDataInput = input;
            Objects.requireNonNull(channelDataInput);
            this.reader = channelDataInput.new ChannelDataInput.CharsReader((CharBuffer)data);
        } else {
            throw new IllegalArgumentException(Errors.format((short)149, Classes.getClass(data)));
        }
    }

    DataTransfer reader() {
        return this.view() instanceof ByteBuffer ? this.reader : this;
    }

    @Override
    public void seek(long position) throws IOException {
        int dataSizeShift = this.dataSizeShift();
        if (position < 0L || (position & (long)((1 << dataSizeShift) - 1)) != 0L) {
            throw new IOException(Errors.format((short)45, "position", position));
        }
        Buffer data = this.view();
        if ((position >>>= dataSizeShift) > (long)data.limit()) {
            throw new EOFException(Errors.format((short)137, this.filename()));
        }
        data.position((int)position);
    }

    @Override
    public String filename() {
        return this.reader.filename();
    }

    @Override
    public int dataSizeShift() {
        return this.reader.dataSizeShift();
    }

    @Override
    public Object dataArray() {
        return this.reader.dataArray();
    }

    @Override
    public Buffer dataArrayAsBuffer() {
        return this.reader.dataArrayAsBuffer();
    }

    @Override
    public Buffer view() {
        return this.reader.view();
    }

    @Override
    public Buffer createView() {
        return this.reader.createView();
    }

    @Override
    public void createDataArray(int length) {
        this.reader.createDataArray(length);
    }

    @Override
    public void setDest(Object array) {
        this.reader.setDest(array);
    }

    @Override
    public void readFully(Buffer view, int offset, int length) {
        this.reader.transfer(offset, length);
    }

    @Override
    public int read(ByteBuffer dst) {
        return -1;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }
}

