/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.dom.Document;
import org.apache.tapestry5.internal.services.PageMarkupRenderer;
import org.apache.tapestry5.internal.services.RequestPageCache;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.services.MarkupWriterFactory;
import org.apache.tapestry5.services.PageDocumentGenerator;

public class PageDocumentGeneratorImpl
implements PageDocumentGenerator {
    private final RequestPageCache pageCache;
    private final PageMarkupRenderer markupRenderer;
    private final MarkupWriterFactory markupWriterFactory;

    public PageDocumentGeneratorImpl(RequestPageCache pageCache, PageMarkupRenderer markupRenderer, MarkupWriterFactory markupWriterFactory) {
        this.markupRenderer = markupRenderer;
        this.markupWriterFactory = markupWriterFactory;
        this.pageCache = pageCache;
    }

    @Override
    public Document render(String logicalPageName) {
        Page page = this.pageCache.get(logicalPageName);
        MarkupWriter writer = this.markupWriterFactory.newMarkupWriter(logicalPageName);
        this.markupRenderer.renderPageMarkup(page, writer);
        return writer.getDocument();
    }
}

