/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.WriterMatrixMarket;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.runtime.util.HDFSTool;
import org.apache.sysds.utils.stats.InfrastructureAnalyzer;

public class WriterMatrixMarketParallel
extends WriterMatrixMarket {
    @Override
    protected void writeMatrixMarketMatrixToHDFS(Path path, JobConf job, FileSystem fs, MatrixBlock src) throws IOException {
        int rlen = src.getNumRows();
        int numPartFiles = (int)(OptimizerUtils.estimateSizeTextOutput(src.getNumRows(), src.getNumColumns(), src.getNonZeros(), Types.FileFormat.MM) / InfrastructureAnalyzer.getHDFSBlockSize());
        numPartFiles = Math.max(numPartFiles, 1);
        int numThreads = OptimizerUtils.getParallelTextWriteParallelism();
        numThreads = Math.min(numThreads, numPartFiles);
        if (!this._forcedParallel && numThreads <= 1) {
            super.writeMatrixMarketMatrixToHDFS(path, job, fs, src);
            return;
        }
        HDFSTool.createDirIfNotExistOnHDFS(path, "777");
        ExecutorService pool = CommonThreadPool.get(numThreads);
        try {
            ArrayList<WriteMMTask> tasks = new ArrayList<WriteMMTask>();
            int blklen = (int)Math.ceil((double)rlen / (double)numThreads);
            int i = 0;
            while (i < numThreads & i * blklen < rlen) {
                Path newPath = new Path(path, IOUtilFunctions.getPartFileName(i));
                tasks.add(new WriteMMTask(newPath, job, fs, src, i * blklen, Math.min((i + 1) * blklen, rlen)));
                ++i;
            }
            for (Future task : pool.invokeAll(tasks)) {
                task.get();
            }
            if (fs instanceof LocalFileSystem) {
                i = 0;
                while (i < numThreads & i * blklen < rlen) {
                    IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, new Path(path, IOUtilFunctions.getPartFileName(i)));
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new IOException("Failed parallel write of text output.", e);
        }
        finally {
            pool.shutdown();
        }
    }

    private class WriteMMTask
    implements Callable<Object> {
        private JobConf _job = null;
        private FileSystem _fs = null;
        private MatrixBlock _src = null;
        private Path _path = null;
        private int _rl = -1;
        private int _ru = -1;

        public WriteMMTask(Path path, JobConf job, FileSystem fs, MatrixBlock src, int rl, int ru) {
            this._path = path;
            this._job = job;
            this._fs = fs;
            this._src = src;
            this._rl = rl;
            this._ru = ru;
        }

        @Override
        public Object call() throws Exception {
            WriterMatrixMarket.writeMatrixMarketMatrixToFile(this._path, this._job, this._fs, this._src, this._rl, this._ru);
            return null;
        }
    }
}

