/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.io.FileFormatPropertiesHDF5;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.ReaderHDF5;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.runtime.util.HDFSTool;

public class ReaderHDF5Parallel
extends ReaderHDF5 {
    private final int _numThreads = OptimizerUtils.getParallelBinaryReadParallelism();
    protected JobConf _job;

    public ReaderHDF5Parallel(FileFormatPropertiesHDF5 props) {
        super(props);
    }

    @Override
    public MatrixBlock readMatrixFromHDFS(String fname, long rlen, long clen, int blen, long estnnz) throws IOException, DMLRuntimeException {
        this._job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)this._job);
        FileInputFormat.addInputPath((JobConf)this._job, (Path)path);
        TextInputFormat informat = new TextInputFormat();
        informat.configure(this._job);
        ReaderHDF5Parallel.checkValidInputFile(fs, path);
        ArrayList<Path> files = new ArrayList<Path>();
        files.add(path);
        MatrixBlock src = ReaderHDF5Parallel.computeHDF5Size(files, fs, this._props.getDatasetName(), estnnz);
        int numParts = Math.min(files.size(), this._numThreads);
        ExecutorService pool = CommonThreadPool.get(this._numThreads);
        try {
            int bufferSize = src.getNumColumns() * src.getNumRows() * 8 + 2048;
            ArrayList<ReadHDF5Task> tasks = new ArrayList<ReadHDF5Task>();
            rlen = src.getNumRows();
            int blklen = (int)Math.ceil((double)rlen / (double)numParts);
            int i = 0;
            while (i < this._numThreads & (long)(i * blklen) < rlen) {
                int rl = i * blklen;
                int ru = (int)Math.min((long)((i + 1) * blklen), rlen);
                Path newPath = HDFSTool.isDirectory(fs, path) ? new Path(path, IOUtilFunctions.getPartFileName(i)) : path;
                BufferedInputStream bis = new BufferedInputStream((InputStream)fs.open(newPath), bufferSize);
                tasks.add(new ReadHDF5Task(bis, this._props.getDatasetName(), src, rl, ru, clen, blklen));
                ++i;
            }
            long nnz = 0L;
            for (Future task : pool.invokeAll(tasks)) {
                nnz += ((Long)task.get()).longValue();
            }
            src.setNonZeros(nnz);
            MatrixBlock matrixBlock = src;
            return matrixBlock;
        }
        catch (Exception e) {
            throw new IOException("Failed parallel read of HDF5 input.", e);
        }
        finally {
            pool.shutdown();
        }
    }

    @Override
    public MatrixBlock readMatrixFromInputStream(InputStream is, long rlen, long clen, int blen, long estnnz) throws IOException, DMLRuntimeException {
        return new ReaderHDF5(this._props).readMatrixFromInputStream(is, rlen, clen, blen, estnnz);
    }

    private static class ReadHDF5Task
    implements Callable<Long> {
        private final BufferedInputStream _bis;
        private final String _datasetName;
        private final MatrixBlock _src;
        private final int _rl;
        private final int _ru;
        private final long _clen;
        private final int _blen;

        public ReadHDF5Task(BufferedInputStream bis, String datasetName, MatrixBlock src, int rl, int ru, long clen, int blen) {
            this._bis = bis;
            this._datasetName = datasetName;
            this._src = src;
            this._rl = rl;
            this._ru = ru;
            this._clen = clen;
            this._blen = blen;
        }

        @Override
        public Long call() throws IOException {
            return ReaderHDF5.readMatrixFromHDF5(this._bis, this._datasetName, this._src, this._rl, this._ru, this._clen, this._blen);
        }
    }
}

