/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public abstract class AbstractJcrResourceResolverTest {
    @Rule
    public SlingContext context = new SlingContext(this.getResourceResolverType());
    private static final String STRING_VALUE = "value1";
    private static final String[] STRING_ARRAY_VALUE = new String[]{"value1", "value2"};
    private static final int INTEGER_VALUE = 25;
    private static final double DOUBLE_VALUE = 3.555;
    private static final boolean BOOLEAN_VALUE = true;
    private static final Date DATE_VALUE = new Date(10000L);
    private static final Calendar CALENDAR_VALUE = Calendar.getInstance();
    private static final byte[] BINARY_VALUE = new byte[]{1, 2, 3, 4, 5, 6};
    private Session session;
    protected Node testRoot;

    protected abstract ResourceResolverType getResourceResolverType();

    @Before
    public final void setUp() throws RepositoryException {
        this.session = (Session)this.context.resourceResolver().adaptTo(Session.class);
        Node rootNode = this.getTestRootNode();
        Node node1 = rootNode.addNode("node1", "nt:unstructured");
        node1.setProperty("stringProp", STRING_VALUE);
        node1.setProperty("stringArrayProp", STRING_ARRAY_VALUE);
        node1.setProperty("integerProp", 25L);
        node1.setProperty("doubleProp", 3.555);
        node1.setProperty("booleanProp", true);
        node1.setProperty("dateProp", DateUtils.toCalendar((Date)DATE_VALUE));
        node1.setProperty("calendarProp", CALENDAR_VALUE);
        node1.setProperty("binaryProp", this.session.getValueFactory().createBinary((InputStream)new ByteArrayInputStream(BINARY_VALUE)));
        node1.addNode("node11", "nt:unstructured");
        node1.addNode("node12", "nt:unstructured");
        this.session.save();
    }

    @After
    public final void tearDown() {
        this.testRoot = null;
    }

    private Node getTestRootNode() throws RepositoryException {
        if (this.testRoot == null) {
            this.testRoot = (Node)this.context.resourceResolver().getResource(this.context.uniqueRoot().content()).adaptTo(Node.class);
        }
        return this.testRoot;
    }

    @Test
    public void testGetResourcesAndValues() throws IOException, RepositoryException {
        Resource resource1 = this.context.resourceResolver().getResource(this.getTestRootNode().getPath() + "/node1");
        Assert.assertNotNull((Object)resource1);
        Assert.assertEquals((Object)"node1", (Object)resource1.getName());
        ValueMap props = ResourceUtil.getValueMap((Resource)resource1);
        Assert.assertEquals((Object)STRING_VALUE, (Object)props.get("stringProp", String.class));
        Assert.assertArrayEquals((Object[])STRING_ARRAY_VALUE, (Object[])((Object[])props.get("stringArrayProp", String[].class)));
        Assert.assertEquals((Object)25, (Object)props.get("integerProp", Integer.class));
        Assert.assertEquals((double)3.555, (double)((Double)props.get("doubleProp", Double.class)), (double)1.0E-4);
        Assert.assertEquals((Object)true, (Object)props.get("booleanProp", Boolean.class));
        Assert.assertEquals((Object)DATE_VALUE, (Object)props.get("dateProp", Date.class));
        Assert.assertEquals((Object)CALENDAR_VALUE.getTime(), (Object)((Calendar)props.get("calendarProp", Calendar.class)).getTime());
        Resource binaryPropResource = resource1.getChild("binaryProp");
        InputStream is = (InputStream)binaryPropResource.adaptTo(InputStream.class);
        byte[] dataFromResource = IOUtils.toByteArray((InputStream)is);
        is.close();
        Assert.assertArrayEquals((byte[])BINARY_VALUE, (byte[])dataFromResource);
        InputStream is2 = (InputStream)binaryPropResource.adaptTo(InputStream.class);
        byte[] dataFromResource2 = IOUtils.toByteArray((InputStream)is2);
        is2.close();
        Assert.assertArrayEquals((byte[])BINARY_VALUE, (byte[])dataFromResource2);
        List children = IteratorUtils.toList((Iterator)resource1.listChildren());
        Assert.assertEquals((long)2L, (long)children.size());
        Assert.assertEquals((Object)"node11", (Object)((Resource)children.get(0)).getName());
        Assert.assertEquals((Object)"node12", (Object)((Resource)children.get(1)).getName());
    }

    @Test
    public void testCreateNodeWithPrimaryType() throws RepositoryException, PersistenceException {
        Resource parent = this.context.resourceResolver().getResource(this.getTestRootNode().getPath());
        Resource child = this.context.resourceResolver().create(parent, "nodeTypeResource", Map.of("sling:resourceType", "nt:unstructured"));
        Assert.assertNotNull((Object)child);
        Assert.assertEquals((Object)"nt:unstructured", (Object)child.getResourceType());
        Assert.assertEquals((Object)"nt:unstructured", (Object)((Node)child.adaptTo(Node.class)).getPrimaryNodeType().getName());
    }

    @Test
    public void testCreateNodeWithResourceType() throws RepositoryException, PersistenceException {
        Resource parent = this.context.resourceResolver().getResource(this.getTestRootNode().getPath());
        Resource child = ResourceUtil.getOrCreateResource((ResourceResolver)this.context.resourceResolver(), (String)(parent.getPath() + "/intermediate/child"), (String)"sling/resource/type", (String)"nt:unstructured", (boolean)true);
        Assert.assertNotNull((Object)child);
        Assert.assertEquals((Object)"sling:OrderedFolder", (Object)parent.getResourceType());
        Assert.assertEquals((Object)"sling/resource/type", (Object)child.getResourceType());
    }

    @Test
    public void testPendingChangesCommit() throws Exception {
        if (this.getResourceResolverType() == ResourceResolverType.JCR_MOCK) {
            return;
        }
        Resource testRootResource = this.context.resourceResolver().getResource(this.getTestRootNode().getPath());
        this.context.resourceResolver().delete(testRootResource);
        Assert.assertTrue((boolean)this.session.hasPendingChanges());
        this.context.resourceResolver().commit();
        Assert.assertFalse((boolean)this.session.hasPendingChanges());
    }
}

