/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.helper;

import java.util.Iterator;
import java.util.Set;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.resourceresolver.impl.helper.AbstractIterator;

public class UniqueResourceIterator
extends AbstractIterator<Resource> {
    private final Iterator<Resource> input;
    private final Set<String> visited;

    public UniqueResourceIterator(Set<String> visited, Iterator<Resource> input) {
        this.input = input;
        this.visited = visited;
    }

    @Override
    protected Resource seek() {
        while (this.input.hasNext()) {
            Resource next = this.input.next();
            String name = next.getName();
            if (this.visited.contains(name)) continue;
            this.visited.add(name);
            next.getResourceMetadata().setResolutionPath(next.getPath());
            return next;
        }
        return null;
    }
}

