/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl.resource;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jackrabbit.usermanager.resource.SystemUserManagerPaths;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAuthorizableValueMap
implements ValueMap {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected boolean fullyRead;
    protected final Map<String, Object> cache;
    protected Authorizable authorizable;
    protected final SystemUserManagerPaths systemUserManagerPaths;

    protected BaseAuthorizableValueMap(Authorizable authorizable, SystemUserManagerPaths systemUserManagerPaths) {
        this.authorizable = authorizable;
        this.cache = new LinkedHashMap<String, Object>();
        this.fullyRead = false;
        this.systemUserManagerPaths = systemUserManagerPaths;
    }

    public <T> T get(String name, Class<T> type) {
        if (type == null) {
            return (T)this.get(name);
        }
        return this.convertToType(name, type);
    }

    public <T> T get(String name, T defaultValue) {
        if (defaultValue == null) {
            return (T)this.get(name);
        }
        Class<?> type = this.normalizeClass(defaultValue.getClass());
        Class<Object> value = this.get(name, (T)type);
        if (value == null) {
            value = defaultValue;
        }
        return (T)value;
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public boolean containsValue(Object value) {
        this.readFully();
        return this.cache.containsValue(value);
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        this.readFully();
        return this.cache.entrySet();
    }

    public Object get(Object key) {
        Object value = this.cache.get(key);
        if (value == null) {
            value = this.read((String)key);
        }
        return value;
    }

    public Set<String> keySet() {
        this.readFully();
        return this.cache.keySet();
    }

    public int size() {
        this.readFully();
        return this.cache.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Collection<Object> values() {
        this.readFully();
        return this.cache.values();
    }

    protected abstract Object read(String var1);

    protected Object readPropertyAndCache(String key, String relPath) throws RepositoryException {
        Value[] property = this.authorizable.getProperty(relPath);
        Object value = this.valuesToJavaObject(property);
        this.cache.put(key, value);
        return value;
    }

    public static Object toJavaObject(Value value) throws RepositoryException {
        switch (value.getType()) {
            case 12: {
                return value.getDecimal();
            }
            case 2: {
                return new LazyInputStream(value);
            }
            case 6: {
                return value.getBoolean();
            }
            case 5: {
                return value.getDate();
            }
            case 4: {
                return value.getDouble();
            }
            case 3: {
                return value.getLong();
            }
        }
        return value.getString();
    }

    protected Object valuesToJavaObject(Value[] values) throws RepositoryException {
        if (values == null) {
            return null;
        }
        if (values.length == 1) {
            return BaseAuthorizableValueMap.toJavaObject(values[0]);
        }
        Object[] valuesObjs = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            valuesObjs[i] = BaseAuthorizableValueMap.toJavaObject(values[i]);
        }
        return valuesObjs;
    }

    protected abstract void readFully();

    public String toString() {
        this.readFully();
        return this.cache.toString();
    }

    public Object remove(Object arg0) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object put(String arg0, Object arg1) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map<? extends String, ? extends Object> arg0) {
        throw new UnsupportedOperationException();
    }

    protected <T> T convertToType(String name, Class<T> type) {
        Object result = null;
        try {
            if (this.authorizable.hasProperty(name)) {
                Value[] values = this.authorizable.getProperty(name);
                if (values == null) {
                    return null;
                }
                boolean multiValue = values.length > 1;
                boolean array = type.isArray();
                if (multiValue) {
                    if (array) {
                        result = this.convertToArray(values, type.getComponentType());
                    } else if (values.length > 0) {
                        result = this.convertToType(values[0], type);
                    }
                } else {
                    Value value = values[0];
                    result = array ? this.convertToArray(new Value[]{value}, type.getComponentType()) : this.convertToType(value, type);
                }
            } else {
                result = super.get(name, type);
            }
        }
        catch (ValueFormatException vfe) {
            this.log.info(String.format("convertToType: Cannot convert value of %s to %s", name, type), (Throwable)vfe);
        }
        catch (RepositoryException re) {
            this.log.info(String.format("convertToType: Cannot get value of %s", name), (Throwable)re);
        }
        return (T)result;
    }

    private <T> T[] convertToArray(Value[] jcrValues, Class<T> type) throws RepositoryException {
        ArrayList<T> values = null;
        for (int i = 0; i < jcrValues.length; ++i) {
            T value = this.convertToType(jcrValues[i], type);
            if (value == null) continue;
            if (values == null) {
                values = new ArrayList<T>();
            }
            values.add(value);
        }
        Object[] array = null;
        if (values != null) {
            Object[] result = (Object[])Array.newInstance(type, values.size());
            array = values.toArray(result);
        }
        return array;
    }

    private <T> T convertToType(Value jcrValue, Class<T> type) throws RepositoryException {
        if (String.class == type) {
            return (T)jcrValue.getString();
        }
        if (Byte.class == type) {
            return (T)Byte.valueOf((byte)jcrValue.getLong());
        }
        if (BigDecimal.class == type) {
            return (T)jcrValue.getDecimal();
        }
        if (Short.class == type) {
            return (T)Short.valueOf((short)jcrValue.getLong());
        }
        if (Integer.class == type) {
            return (T)Integer.valueOf((int)jcrValue.getLong());
        }
        if (Long.class == type) {
            return (T)Long.valueOf(jcrValue.getLong());
        }
        if (Float.class == type) {
            return (T)Float.valueOf((float)jcrValue.getDouble());
        }
        if (Double.class == type) {
            return (T)Double.valueOf(jcrValue.getDouble());
        }
        if (Boolean.class == type) {
            return (T)Boolean.valueOf(jcrValue.getBoolean());
        }
        if (Date.class == type) {
            return (T)jcrValue.getDate().getTime();
        }
        if (Calendar.class == type) {
            return (T)jcrValue.getDate();
        }
        if (Binary.class == type) {
            return (T)jcrValue.getBinary();
        }
        if (InputStream.class == type) {
            return (T)jcrValue.getBinary().getStream();
        }
        if (Value.class == type) {
            return (T)jcrValue;
        }
        return null;
    }

    private Class<?> normalizeClass(Class<?> type) {
        if (Calendar.class.isAssignableFrom(type)) {
            type = Calendar.class;
        } else if (Date.class.isAssignableFrom(type)) {
            type = Date.class;
        } else if (Value.class.isAssignableFrom(type)) {
            type = Value.class;
        } else if (InputStream.class.isAssignableFrom(type)) {
            type = InputStream.class;
        } else if (Binary.class.isAssignableFrom(type)) {
            type = Binary.class;
        }
        return type;
    }

    public static class LazyInputStream
    extends InputStream {
        private final Value value;
        private InputStream delegatee;

        public LazyInputStream(@NotNull Value value) {
            this.value = value;
        }

        @Override
        public void close() throws IOException {
            if (this.delegatee != null) {
                this.delegatee.close();
            }
        }

        @Override
        public int available() throws IOException {
            return this.getStream().available();
        }

        @Override
        public int read() throws IOException {
            return this.getStream().read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.getStream().read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.getStream().read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.getStream().skip(n);
        }

        @Override
        public boolean markSupported() {
            try {
                return this.getStream().markSupported();
            }
            catch (IOException iOException) {
                return false;
            }
        }

        @Override
        public synchronized void mark(int readlimit) {
            try {
                this.getStream().mark(readlimit);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public synchronized void reset() throws IOException {
            this.getStream().reset();
        }

        private InputStream getStream() throws IOException {
            if (this.delegatee == null) {
                try {
                    this.delegatee = this.value.getBinary().getStream();
                }
                catch (RepositoryException re) {
                    throw (IOException)new IOException(re.getMessage()).initCause(re);
                }
            }
            return this.delegatee;
        }
    }
}

