/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.PackageInfo;

public class CheckUnusedBundles
implements AnalyserTask {
    @Override
    public String getName() {
        return "Unused Bundle Check";
    }

    @Override
    public String getId() {
        return "check-unused-bundles";
    }

    @Override
    public void execute(AnalyserTaskContext ctx) throws IOException {
        for (BundleDescriptor info : ctx.getFeatureDescriptor().getBundleDescriptors()) {
            if (info.getExportedPackages().isEmpty()) continue;
            HashSet<PackageInfo> exports = new HashSet<PackageInfo>(info.getExportedPackages());
            HashSet<String> optionalImports = new HashSet<String>();
            for (BundleDescriptor inner : ctx.getFeatureDescriptor().getBundleDescriptors()) {
                if (inner == info) continue;
                Iterator iter = exports.iterator();
                while (iter.hasNext()) {
                    PackageInfo expPck = (PackageInfo)iter.next();
                    boolean found = false;
                    for (PackageInfo impPck : inner.getImportedPackages()) {
                        if (!expPck.getName().equals(impPck.getName()) || impPck.getVersion() != null && !impPck.getPackageVersionRange().includes(expPck.getPackageVersion())) continue;
                        if (impPck.isOptional()) {
                            optionalImports.add(impPck.getName());
                            break;
                        }
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    iter.remove();
                }
                if (!exports.isEmpty()) continue;
                break;
            }
            if (exports.size() != info.getExportedPackages().size()) continue;
            if (!optionalImports.isEmpty()) {
                ctx.reportArtifactWarning(info.getArtifact().getId(), "Exports from bundle are only imported optionally by other bundles.");
                continue;
            }
            ctx.reportArtifactWarning(info.getArtifact().getId(), "Exports from bundle are not imported by any other bundle.");
        }
    }
}

