/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Configurations;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.util.converter.Converters;

public class CheckServiceUserMapping
implements AnalyserTask {
    static final String SERVICE_USER_MAPPING_PID = "org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl";
    static final String FACTORY_PID = "org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl.amended";
    static final String USER_MAPPING = "user.mapping";
    static final String CFG_WARN_ONLY_FOR_DEPRECATED_MAPPINGS = "warnOnlyForDeprecatedMappings";
    static final String CFG_WARN_ONLY_FOR_DEPRECATED_MAPPINGS_DEFAULT = Boolean.FALSE.toString();

    @Override
    public String getName() {
        return "Service User Mapping Check";
    }

    @Override
    public String getId() {
        return "serviceusermapping";
    }

    @Override
    public void execute(AnalyserTaskContext ctx) {
        boolean warnOnlyForDeprecation = Boolean.parseBoolean(ctx.getConfiguration().getOrDefault(CFG_WARN_ONLY_FOR_DEPRECATED_MAPPINGS, CFG_WARN_ONLY_FOR_DEPRECATED_MAPPINGS_DEFAULT));
        Configurations configurations = ctx.getFeature().getConfigurations();
        Configuration cfg = configurations.getConfiguration(SERVICE_USER_MAPPING_PID);
        if (cfg != null) {
            CheckServiceUserMapping.check(ctx, cfg, warnOnlyForDeprecation);
        }
        for (Configuration c : configurations.getFactoryConfigurations(FACTORY_PID)) {
            CheckServiceUserMapping.check(ctx, c, warnOnlyForDeprecation);
        }
    }

    private static void check(AnalyserTaskContext ctx, Configuration cfg, boolean warnOnlyForDeprecation) {
        Object val = cfg.getConfigurationProperties().get(USER_MAPPING);
        if (val != null) {
            String[] mappings;
            for (String spec : mappings = (String[])Converters.standardConverter().convert(val).to(String[].class)) {
                CheckServiceUserMapping.check(ctx, cfg, spec, warnOnlyForDeprecation);
            }
        }
    }

    private static void check(@NotNull AnalyserTaskContext ctx, @NotNull Configuration cfg, @Nullable String spec, boolean warnOnlyForDeprecation) {
        String id = cfg.getPid();
        if (spec == null || spec.trim().isEmpty()) {
            ctx.reportConfigurationWarning(cfg, "Ignoring empty mapping in " + id);
            return;
        }
        Mapping mapping = Mapping.parse(spec, ctx, cfg);
        if (mapping == null) {
            ctx.reportConfigurationError(cfg, String.format("Invalid service user mapping '%s' from %s", spec, id));
        } else if (mapping.isDeprecated()) {
            String msg = String.format("Deprecated service user mapping '%s' from %s", spec, id);
            if (warnOnlyForDeprecation) {
                ctx.reportConfigurationWarning(cfg, msg);
            } else {
                ctx.reportConfigurationError(cfg, msg);
            }
        }
    }

    private static class Mapping {
        private final boolean isDeprecated;

        @Nullable
        private static Mapping parse(@NotNull String spec, @NotNull AnalyserTaskContext ctx, @NotNull Configuration cfg) {
            int colon = spec.indexOf(58);
            int equals = spec.indexOf(61);
            if (colon == 0 || equals <= 0) {
                ctx.reportConfigurationWarning(cfg, "Invalid service user mapping: serviceName is required");
                return null;
            }
            if (equals == spec.length() - 1) {
                ctx.reportConfigurationWarning(cfg, "Invalid service user mapping: userName or principalNames is required");
                return null;
            }
            if (colon + 1 == equals) {
                ctx.reportConfigurationWarning(cfg, "Invalid service user mapping: serviceInfo must not be empty");
                return null;
            }
            String s = spec.substring(equals + 1);
            String userName = s.charAt(0) == '[' && s.charAt(s.length() - 1) == ']' ? null : s;
            return new Mapping(userName != null);
        }

        private Mapping(boolean isDeprecated) {
            this.isDeprecated = isDeprecated;
        }

        private boolean isDeprecated() {
            return this.isDeprecated;
        }
    }
}

