# OpenOffice add-in build instructions

All `XFoo` Java interfaces are generated from IDL files with the same name.
As long as `XFoo` Java/IDL interfaces are not modified, there is no need for the OpenOffice SDK.
But if any `XFoo` interface is modified, then the steps documented below must be done.
The last step shall be executed on the client machine
(users can also use the _"Tools / Package manager"_ menu from OpenOffice GUI).

Replace _ooo-path_ by the path to the OpenOffice installation directory.
That directory should contain the `program` sub-directories.
The OpenOffice SDK shall be installed as a sub-directory of the OpenOffice root directory.
If the name of that SDK directory is different than `OpenOffice_SDK`,
then modify the `OO_SDK_HOME` value below accordingly.

```
export OFFICE_BASE_HOME=ooo-path
export OO_SDK_HOME=$OFFICE_BASE_HOME/OpenOffice_SDK
export PATH=$OFFICE_BASE_HOME/program:$OO_SDK_HOME/bin:$PATH
```


## Compiles the UNO `*.urd` binary file

The following command generates `*.urd` files (to be deleted later).
The `-C` option is for including additional service information,
the `-cid` option is for checking if identifiers fulfill the UNO naming requirements, and
the `-w` option is for displaying warning messages.

```
cd endorsed/src/org.apache.sis.openoffice/main
idlc -C -cid -w -I $OO_SDK_HOME/idl org/apache/sis/openoffice/*.idl
```


### MacOS troubleshooting

if the above command fails with a message like “`dyld: Library not loaded: @executable_path/libreg.dylib.3`
(…) `Reason: image not found`”, try adding the following environment variable:

```
export DYLD_FALLBACK_LIBRARY_PATH=$OFFICE_BASE_HOME/program
```


## Compiles the UNO `*.rdb` registry file and the `*.class` file

The `*.rdb` and `*.class` files generated by the following commands
will need to be committed in the source code repository.
Committing compilation results is usually not recommended, but in this particular case
most users will not have the necessary installation for producing those files themselves
(including the `*.class` files, which is not the usual `javac` output).

```
regmerge ../bundle/sis.rdb /UCR org/apache/sis/openoffice/*.urd
rm org/apache/sis/openoffice/*.urd
cd ../bundle
javamaker -BUCR sis.rdb $OFFICE_BASE_HOME/program/types.rdb -Torg.apache.sis.openoffice.XReferencing
```


## Derives a `*.java` source from the `*.class` file

Following command can be skipped if the API defined by `*.idl` files did not changed.
If this command is executed, the result will be sent to the console.
Developer need to bring any changes to the Java interface manually.

```
javap org.apache.sis.openoffice.XReferencing
```


## Build

```
cd ../../..
gradle test
```


## Test in Apache OpenOffice

Launch:

```
cd target
unopkg add apache-sis-1.6.oxt --log-file log.txt
scalc -env:RTL_LOGFILE=log.txt
```

If not already done, configure Java runtime with
_Tools_ → _Options…_ → _Advanced_ → _Java options_ → _Parameters_
and specify the following parameters:

```
-agentlib:jdwp=transport=dt_socket,server=y,address=8000,suspend=n
```

It allows to attach the IDE debugger to the Java virtual machine running in LibreOffice.
For example, with NetBeans, use _Debug_ → _Attach debugger…_,
select "Socket attach" as the transport and 8000 as the port number.
