/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.base;

import java.awt.Color;
import java.awt.image.DataBuffer;
import java.util.List;
import java.util.function.Function;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.BufferedGridCoverage;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.ImageRenderer;

final class Raster
extends BufferedGridCoverage {
    private final int pixelStride;
    private final int[] bandOffsets;
    private final int visibleBand;
    private final Function<Category, Color[]> colors;

    Raster(GridGeometry domain, List<SampleDimension> range, DataBuffer data, int pixelStride, int[] bandOffsets, int visibleBand, Function<Category, Color[]> colors) {
        super(domain, range, data);
        this.colors = colors;
        this.pixelStride = pixelStride;
        this.bandOffsets = bandOffsets;
        this.visibleBand = visibleBand;
    }

    protected void configure(ImageRenderer renderer) {
        if (this.bandOffsets != null) {
            renderer.setInterleavedPixelOffsets(this.pixelStride, this.bandOffsets);
        }
        if (this.colors != null) {
            renderer.setCategoryColors(this.colors);
        }
        renderer.setVisibleBand(this.visibleBand);
    }
}

