/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.Objects;
import java.util.Optional;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class DomainDefinition {
    private Envelope limits;
    private GeneralEnvelope intersection;
    private ToDomain stepToDomain;

    public void estimate(MathTransform evaluated) throws TransformException {
        Envelope domain;
        if (evaluated instanceof AbstractMathTransform && (domain = (Envelope)((AbstractMathTransform)evaluated).getDomain(this).orElse(null)) != null) {
            if (this.stepToDomain != null) {
                domain = Envelopes.transform(this.stepToDomain.concatenation(), domain);
            }
            this.intersect(domain);
        }
    }

    final void estimateOnInverse(MathTransform inverse) throws TransformException {
        if (inverse instanceof ConcatenatedTransform) {
            ConcatenatedTransform ct = (ConcatenatedTransform)inverse;
            this.estimateOnInverse(ct.transform2);
            this.estimateOnInverse(ct.transform1, ct.transform2);
        } else {
            MathTransform forward = inverse.inverse();
            if (forward instanceof ConcatenatedTransform) {
                ConcatenatedTransform ct = (ConcatenatedTransform)forward;
                MathTransform transform1 = ct.transform2.inverse();
                MathTransform transform2 = ct.transform1.inverse();
                this.estimateOnInverse(transform2);
                this.estimateOnInverse(transform1, transform2);
            } else {
                this.estimate(forward);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void estimateOnInverse(MathTransform inverse, MathTransform tail) throws TransformException {
        ToDomain previous = this.stepToDomain;
        try {
            this.stepToDomain = new ToDomain(tail, this.stepToDomain);
            this.estimateOnInverse(inverse);
        }
        finally {
            this.stepToDomain = previous;
        }
    }

    public void intersect(Envelope domain) {
        Objects.requireNonNull(domain);
        if (this.limits == null) {
            this.limits = domain;
        } else {
            if (this.intersection == null) {
                this.intersection = new GeneralEnvelope(this.limits);
                this.limits = this.intersection;
            }
            this.intersection.intersect(domain);
        }
    }

    final Envelope intersectOrTransform(Envelope domain, MathTransform prefix) throws TransformException {
        if (domain != null) {
            if (this.stepToDomain != null) {
                prefix = MathTransforms.concatenate(prefix, this.stepToDomain.concatenation());
                domain = Envelopes.transform(prefix, domain);
                this.intersect(domain);
                return null;
            }
            domain = Envelopes.transform(prefix, domain);
        }
        return domain;
    }

    public Optional<Envelope> result() {
        return Optional.ofNullable(this.limits);
    }

    public String toString() {
        return this.limits != null ? this.limits.toString() : "empty";
    }

    private static final class ToDomain {
        private final MathTransform step;
        private final ToDomain next;
        private MathTransform concatenation;

        ToDomain(MathTransform step, ToDomain next) {
            this.step = step;
            this.next = next;
        }

        MathTransform concatenation() {
            if (this.concatenation == null) {
                this.concatenation = this.next == null ? this.step : MathTransforms.concatenate(this.step, this.next.concatenation());
            }
            return this.concatenation;
        }
    }
}

