/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.openprotocol.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class OpenProtocolMessageParameterSetIdUploadReplyRev3
    extends OpenProtocolMessageParameterSetIdUploadReply implements Message {

  // Accessors for discriminator values.
  public Integer getRevision() {
    return (int) 3;
  }

  // Properties.
  protected final List<Integer> parameters;
  protected final List<Integer> numberOfCycles;
  protected final List<Long> typeOfProgram;

  public OpenProtocolMessageParameterSetIdUploadReplyRev3(
      Integer midRevision,
      Short noAckFlag,
      Integer targetStationId,
      Integer targetSpindleId,
      Integer sequenceNumber,
      Short numberOfMessageParts,
      Short messagePartNumber,
      List<Integer> parameters,
      List<Integer> numberOfCycles,
      List<Long> typeOfProgram) {
    super(
        midRevision,
        noAckFlag,
        targetStationId,
        targetSpindleId,
        sequenceNumber,
        numberOfMessageParts,
        messagePartNumber);
    this.parameters = parameters;
    this.numberOfCycles = numberOfCycles;
    this.typeOfProgram = typeOfProgram;
  }

  public List<Integer> getParameters() {
    return parameters;
  }

  public List<Integer> getNumberOfCycles() {
    return numberOfCycles;
  }

  public List<Long> getTypeOfProgram() {
    return typeOfProgram;
  }

  @Override
  protected void serializeOpenProtocolMessageParameterSetIdUploadReplyChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("OpenProtocolMessageParameterSetIdUploadReplyRev3");

    // Implicit Field (numParameters) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int numParameters = (int) (COUNT(getParameters()));
    writeImplicitField(
        "numParameters",
        numParameters,
        writeUnsignedInt(writeBuffer, 24),
        WithOption.WithEncoding("ASCII"));

    // Array Field (parameters)
    writeSimpleTypeArrayField(
        "parameters",
        parameters,
        writeUnsignedInt(writeBuffer, 24),
        WithOption.WithEncoding("ASCII"));

    // Array Field (numberOfCycles)
    writeSimpleTypeArrayField(
        "numberOfCycles",
        numberOfCycles,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithEncoding("ASCII"));

    // Array Field (typeOfProgram)
    writeSimpleTypeArrayField(
        "typeOfProgram",
        typeOfProgram,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithEncoding("ASCII"));

    writeBuffer.popContext("OpenProtocolMessageParameterSetIdUploadReplyRev3");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    OpenProtocolMessageParameterSetIdUploadReplyRev3 _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Implicit Field (numParameters)
    lengthInBits += 24;

    // Array field
    if (parameters != null) {
      lengthInBits += 24 * parameters.size();
    }

    // Array field
    if (numberOfCycles != null) {
      lengthInBits += 16 * numberOfCycles.size();
    }

    // Array field
    if (typeOfProgram != null) {
      lengthInBits += 32 * typeOfProgram.size();
    }

    return lengthInBits;
  }

  public static OpenProtocolMessageParameterSetIdUploadReplyBuilder
      staticParseOpenProtocolMessageParameterSetIdUploadReplyBuilder(
          ReadBuffer readBuffer, Integer revision) throws ParseException {
    readBuffer.pullContext("OpenProtocolMessageParameterSetIdUploadReplyRev3");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int numParameters =
        readImplicitField(
            "numParameters", readUnsignedInt(readBuffer, 24), WithOption.WithEncoding("ASCII"));

    List<Integer> parameters =
        readCountArrayField(
            "parameters",
            readUnsignedInt(readBuffer, 24),
            numParameters,
            WithOption.WithEncoding("ASCII"));

    List<Integer> numberOfCycles =
        readCountArrayField(
            "numberOfCycles",
            readUnsignedInt(readBuffer, 16),
            numParameters,
            WithOption.WithEncoding("ASCII"));

    List<Long> typeOfProgram =
        readCountArrayField(
            "typeOfProgram",
            readUnsignedLong(readBuffer, 32),
            numParameters,
            WithOption.WithEncoding("ASCII"));

    readBuffer.closeContext("OpenProtocolMessageParameterSetIdUploadReplyRev3");
    // Create the instance
    return new OpenProtocolMessageParameterSetIdUploadReplyRev3BuilderImpl(
        parameters, numberOfCycles, typeOfProgram);
  }

  public static class OpenProtocolMessageParameterSetIdUploadReplyRev3BuilderImpl
      implements OpenProtocolMessageParameterSetIdUploadReply
          .OpenProtocolMessageParameterSetIdUploadReplyBuilder {
    private final List<Integer> parameters;
    private final List<Integer> numberOfCycles;
    private final List<Long> typeOfProgram;

    public OpenProtocolMessageParameterSetIdUploadReplyRev3BuilderImpl(
        List<Integer> parameters, List<Integer> numberOfCycles, List<Long> typeOfProgram) {
      this.parameters = parameters;
      this.numberOfCycles = numberOfCycles;
      this.typeOfProgram = typeOfProgram;
    }

    public OpenProtocolMessageParameterSetIdUploadReplyRev3 build(
        Integer midRevision,
        Short noAckFlag,
        Integer targetStationId,
        Integer targetSpindleId,
        Integer sequenceNumber,
        Short numberOfMessageParts,
        Short messagePartNumber) {
      OpenProtocolMessageParameterSetIdUploadReplyRev3
          openProtocolMessageParameterSetIdUploadReplyRev3 =
              new OpenProtocolMessageParameterSetIdUploadReplyRev3(
                  midRevision,
                  noAckFlag,
                  targetStationId,
                  targetSpindleId,
                  sequenceNumber,
                  numberOfMessageParts,
                  messagePartNumber,
                  parameters,
                  numberOfCycles,
                  typeOfProgram);
      return openProtocolMessageParameterSetIdUploadReplyRev3;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof OpenProtocolMessageParameterSetIdUploadReplyRev3)) {
      return false;
    }
    OpenProtocolMessageParameterSetIdUploadReplyRev3 that =
        (OpenProtocolMessageParameterSetIdUploadReplyRev3) o;
    return (getParameters() == that.getParameters())
        && (getNumberOfCycles() == that.getNumberOfCycles())
        && (getTypeOfProgram() == that.getTypeOfProgram())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getParameters(), getNumberOfCycles(), getTypeOfProgram());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
