/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.retry;

import com.hazelcast.jet.retry.IntervalFunction;
import com.hazelcast.jet.retry.RetryStrategy;
import com.hazelcast.jet.retry.impl.RetryStrategyImpl;
import java.util.concurrent.TimeUnit;

public final class RetryStrategies {
    private static final int DEFAULT_MAX_ATTEMPTS = -1;
    private static final long DEFAULT_WAIT_DURATION_MS = TimeUnit.SECONDS.toMillis(5L);
    private static final IntervalFunction DEFAULT_INTERVAL_FUNCTION = IntervalFunction.constant(DEFAULT_WAIT_DURATION_MS);

    private RetryStrategies() {
    }

    public static RetryStrategy never() {
        return new Builder().maxAttempts(0).build();
    }

    public static RetryStrategy indefinitely(long intervalMillis) {
        return new Builder().intervalFunction(IntervalFunction.constant(intervalMillis)).build();
    }

    public static Builder custom() {
        return new Builder();
    }

    public static final class Builder {
        private int maxAttempts = -1;
        private IntervalFunction intervalFunction = DEFAULT_INTERVAL_FUNCTION;

        private Builder() {
        }

        public Builder maxAttempts(int maxRetryAttempts) {
            this.maxAttempts = maxRetryAttempts;
            return this;
        }

        public Builder intervalFunction(IntervalFunction f) {
            this.intervalFunction = f;
            return this;
        }

        public RetryStrategy build() {
            return new RetryStrategyImpl(this.maxAttempts, this.intervalFunction);
        }
    }
}

