/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.client.impl.client.DistributedObjectInfo;
import com.hazelcast.client.impl.clientside.HazelcastClientInstance;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientGetDistributedObjectsCodec;
import com.hazelcast.client.impl.protocol.codec.JetExistsDistributedObjectCodec;
import com.hazelcast.client.impl.protocol.codec.JetGetJobAndSqlSummaryListCodec;
import com.hazelcast.client.impl.protocol.codec.JetGetJobIdsCodec;
import com.hazelcast.client.impl.protocol.codec.JetGetJobSummaryListCodec;
import com.hazelcast.client.impl.protocol.codec.JetUploadJobMetaDataCodec;
import com.hazelcast.client.impl.protocol.codec.JetUploadJobMultipartCodec;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.Sha256Util;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.impl.AbstractJetInstance;
import com.hazelcast.jet.impl.ClientJobProxy;
import com.hazelcast.jet.impl.JobAndSqlSummary;
import com.hazelcast.jet.impl.JobSummary;
import com.hazelcast.jet.impl.SubmitJobParameters;
import com.hazelcast.jet.impl.operation.GetJobIdsOperation;
import com.hazelcast.jet.impl.submitjob.clientside.execute.JobExecuteCall;
import com.hazelcast.jet.impl.submitjob.clientside.upload.JobUploadCall;
import com.hazelcast.jet.impl.submitjob.clientside.validator.SubmitJobParametersValidator;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;

public class JetClientInstanceImpl
extends AbstractJetInstance<UUID> {
    private final HazelcastClientInstanceImpl client;
    private final SerializationService serializationService;

    public JetClientInstanceImpl(HazelcastClientInstanceImpl hazelcastInstance) {
        super(hazelcastInstance);
        this.client = hazelcastInstance;
        this.serializationService = this.client.getSerializationService();
        ExceptionUtil.registerJetExceptions(hazelcastInstance.getClientExceptionFactory());
    }

    @Override
    public UUID getMasterId() {
        return this.client.getClientClusterService().getMasterMember().getUuid();
    }

    @Override
    public Map<UUID, GetJobIdsOperation.GetJobIdsResult> getJobsInt(String onlyName, Long onlyJobId) {
        return (Map)this.invokeRequestOnAnyMemberAndDecodeResponse(JetGetJobIdsCodec.encodeRequest(onlyName, onlyJobId == null ? Long.MIN_VALUE : onlyJobId), resp -> {
            Data responseSerialized = JetGetJobIdsCodec.decodeResponse((ClientMessage)resp).response;
            return this.serializationService.toObject(responseSerialized);
        });
    }

    @Override
    @Nonnull
    public JetConfig getConfig() {
        throw new UnsupportedOperationException("Jet Configuration is not available on the client");
    }

    @Nonnull
    @Deprecated
    public List<JobSummary> getJobSummaryList() {
        return (List)this.invokeRequestOnMasterAndDecodeResponse(JetGetJobSummaryListCodec.encodeRequest(), JetGetJobSummaryListCodec::decodeResponse);
    }

    @Nonnull
    public List<JobAndSqlSummary> getJobAndSqlSummaryList() {
        return (List)this.invokeRequestOnMasterAndDecodeResponse(JetGetJobAndSqlSummaryListCodec.encodeRequest(), JetGetJobAndSqlSummaryListCodec::decodeResponse);
    }

    @Nonnull
    public HazelcastClientInstanceImpl getHazelcastClient() {
        return this.client;
    }

    @Override
    public boolean existsDistributedObject(@Nonnull String serviceName, @Nonnull String objectName) {
        return (Boolean)this.invokeRequestOnAnyMemberAndDecodeResponse(JetExistsDistributedObjectCodec.encodeRequest(serviceName, objectName), JetExistsDistributedObjectCodec::decodeResponse);
    }

    public List<DistributedObjectInfo> getDistributedObjects() {
        return (List)this.invokeRequestOnAnyMemberAndDecodeResponse(ClientGetDistributedObjectsCodec.encodeRequest(), ClientGetDistributedObjectsCodec::decodeResponse);
    }

    @Override
    public Job newJobProxy(long jobId, UUID lightJobCoordinator) {
        return new ClientJobProxy(this.client, jobId, lightJobCoordinator);
    }

    @Override
    public Job newJobProxy(long jobId, boolean isLightJob, @Nonnull Object jobDefinition, @Nonnull JobConfig config, @Nullable Subject subject) {
        if (subject != null) {
            throw new UnsupportedOperationException("Submitting a job with subject is not allowed for client");
        }
        return new ClientJobProxy(this.client, jobId, isLightJob, jobDefinition, config);
    }

    public void submitJobFromJar(@Nonnull SubmitJobParameters submitJobParameters) {
        if (submitJobParameters.isJarOnMember()) {
            this.executeJobFromJar(submitJobParameters);
        } else {
            this.uploadJobFromJar(submitJobParameters);
        }
    }

    private void executeJobFromJar(@Nonnull SubmitJobParameters submitJobParameters) {
        try {
            SubmitJobParametersValidator.validateJarOnMember(submitJobParameters);
            Path jarPath = submitJobParameters.getJarPath();
            JobExecuteCall jobExecuteCall = this.initializeJobExecuteCall(submitJobParameters.getJarPath());
            this.getLogger().fine("Submitting JobMetaData for jarPath: %s", jarPath);
            this.sendJobMetaDataForExecute(jobExecuteCall, submitJobParameters);
            this.getLogger().fine("Job execution from jar '%s' finished successfully", jarPath);
        }
        catch (Exception exception) {
            com.hazelcast.internal.util.ExceptionUtil.sneakyThrow(exception);
        }
    }

    private void uploadJobFromJar(@Nonnull SubmitJobParameters submitJobParameters) {
        try {
            SubmitJobParametersValidator.validateJarOnClient(submitJobParameters);
            Path jarPath = submitJobParameters.getJarPath();
            JobUploadCall jobUploadCall = this.initializeJobUploadCall(submitJobParameters.getJarPath());
            this.getLogger().fine("Submitting JobMetaData for jarPath: %s", jarPath);
            this.sendJobMetaDataForUpload(jobUploadCall, submitJobParameters);
            this.sendJobMultipart(jobUploadCall, jarPath);
            this.getLogger().fine("Job upload from jar '%s' finished successfully", jarPath);
        }
        catch (IOException | NoSuchAlgorithmException exception) {
            com.hazelcast.internal.util.ExceptionUtil.sneakyThrow(exception);
        }
    }

    public JobUploadCall initializeJobUploadCall(Path jarPath) throws IOException, NoSuchAlgorithmException {
        JobUploadCall jobUploadCall = new JobUploadCall();
        jobUploadCall.initializeJobUploadCall(this.client, jarPath);
        return jobUploadCall;
    }

    public JobExecuteCall initializeJobExecuteCall(Path jarPath) {
        JobExecuteCall jobExecuteCall = new JobExecuteCall();
        jobExecuteCall.initializeJobExecuteCall(this.client, jarPath);
        return jobExecuteCall;
    }

    private void sendJobMetaDataForUpload(JobUploadCall jobUploadCall, SubmitJobParameters submitJobParameters) {
        ClientMessage jobMetaDataRequest = JetUploadJobMetaDataCodec.encodeRequest(jobUploadCall.getSessionId(), submitJobParameters.isJarOnMember(), jobUploadCall.getFileNameWithoutExtension(), jobUploadCall.getSha256HexOfJar(), submitJobParameters.getSnapshotName(), submitJobParameters.getJobName(), submitJobParameters.getMainClass(), submitJobParameters.getJobParameters());
        this.invokeRequestNoRetryOnRandom(jobUploadCall.getMemberUuid(), jobMetaDataRequest);
    }

    private void sendJobMetaDataForExecute(JobExecuteCall jobExecuteCall, SubmitJobParameters submitJobParameters) {
        ClientMessage jobMetaDataRequest = JetUploadJobMetaDataCodec.encodeRequest(jobExecuteCall.getSessionId(), submitJobParameters.isJarOnMember(), jobExecuteCall.getJarPath(), jobExecuteCall.getSha256HexOfJar(), submitJobParameters.getSnapshotName(), submitJobParameters.getJobName(), submitJobParameters.getMainClass(), submitJobParameters.getJobParameters());
        this.invokeRequestNoRetryOnRandom(jobExecuteCall.getMemberUuid(), jobMetaDataRequest);
    }

    private void sendJobMultipart(JobUploadCall jobUploadCall, Path jarPath) throws IOException, NoSuchAlgorithmException {
        File file = jarPath.toFile();
        byte[] partBuffer = jobUploadCall.allocatePartBuffer();
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            for (int currentPartNumber = 1; currentPartNumber <= jobUploadCall.getTotalParts(); ++currentPartNumber) {
                int bytesRead = fileInputStream.read(partBuffer);
                byte[] dataToSend = jobUploadCall.getDataToSend(partBuffer, bytesRead);
                String sha256Hex = Sha256Util.calculateSha256Hex(dataToSend);
                ClientMessage jobMultipartRequest = JetUploadJobMultipartCodec.encodeRequest(jobUploadCall.getSessionId(), currentPartNumber, jobUploadCall.getTotalParts(), dataToSend, bytesRead, sha256Hex);
                this.getLogger().fine("Submitting Job Part for jarPath: %s PartNumber %d/%d", jarPath, currentPartNumber, jobUploadCall.getTotalParts());
                this.invokeRequestNoRetryOnRandom(jobUploadCall.getMemberUuid(), jobMultipartRequest);
            }
        }
    }

    @Override
    public ILogger getLogger() {
        return this.client.getLoggingService().getLogger(this.getClass());
    }

    private <S> S invokeRequestOnMasterAndDecodeResponse(ClientMessage request, Function<ClientMessage, Object> decoder) {
        return this.invokeRequestAndDecodeResponse(this.getMasterId(), request, decoder);
    }

    private <S> S invokeRequestOnAnyMemberAndDecodeResponse(ClientMessage request, Function<ClientMessage, Object> decoder) {
        return this.invokeRequestAndDecodeResponse(null, request, decoder);
    }

    private void invokeRequestNoRetryOnRandom(UUID uuid, ClientMessage request) {
        ClientInvocation invocation = new ClientInvocation((HazelcastClientInstance)this.client, request, null, uuid);
        invocation.disallowRetryOnRandom();
        this.invoke(invocation);
    }

    private <S> S invokeRequestAndDecodeResponse(UUID uuid, ClientMessage request, Function<ClientMessage, Object> decoder) {
        ClientInvocation invocation = new ClientInvocation((HazelcastClientInstance)this.client, request, null, uuid);
        return this.invoke(decoder, invocation);
    }

    private <S> S invoke(Function<ClientMessage, Object> decoder, ClientInvocation invocation) {
        try {
            ClientMessage response = (ClientMessage)invocation.invoke().get();
            return (S)this.serializationService.toObject(decoder.apply(response));
        }
        catch (Exception exception) {
            throw ExceptionUtil.rethrow(exception);
        }
    }

    private void invoke(ClientInvocation invocation) {
        try {
            invocation.invoke().get();
        }
        catch (Exception exception) {
            throw ExceptionUtil.rethrow(exception);
        }
    }
}

