/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.cdx;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Objects;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.URIs;
import org.netpreserve.jwarc.WarcCaptureRecord;
import org.netpreserve.jwarc.WarcDigest;
import org.netpreserve.jwarc.WarcResponse;
import org.netpreserve.jwarc.WarcRevisit;
import org.netpreserve.jwarc.cdx.CdxFields;
import org.netpreserve.jwarc.cdx.CdxRecord;

public class CdxFormat {
    public static final String CDX9_LEGEND = "N b a m s k r V g";
    public static final String CDX10_LEGEND = "N b a m s k r M V g";
    public static final String CDX11_LEGEND = "N b a m s k r M S V g";
    public static final CdxFormat CDX9 = new CdxFormat("N b a m s k r V g");
    public static final CdxFormat CDX10 = new CdxFormat("N b a m s k r M V g");
    public static final CdxFormat CDX11 = new CdxFormat("N b a m s k r M S V g");
    public static final String PYWB_REVISIT_MIMETYPE = "warc/revisit";
    private final byte[] fieldNames;
    private final byte[] fieldIndices;
    private final boolean digestUnchanged;

    public CdxFormat(String legend) {
        this(legend, false);
    }

    private CdxFormat(String legend, boolean digestUnchanged) {
        this.digestUnchanged = digestUnchanged;
        String[] fields = legend.replaceFirst("^ ?CDX ", "").split(" ");
        this.fieldNames = new byte[fields.length];
        this.fieldIndices = new byte[128];
        Arrays.fill(this.fieldIndices, (byte)-1);
        for (int i = 0; i < fields.length; i = (int)((byte)(i + 1))) {
            byte fieldName;
            if (fields[i].length() != 1) {
                throw new IllegalArgumentException("CDX field names must be a single ASCII character");
            }
            this.fieldNames[i] = fieldName = (byte)fields[i].charAt(0);
            this.fieldIndices[fieldName] = i;
        }
    }

    int indexOf(int field) {
        if (field > this.fieldIndices.length) {
            return -1;
        }
        return this.fieldIndices[field];
    }

    public String legend() {
        StringBuilder builder = new StringBuilder();
        for (byte fieldName : this.fieldNames) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append((char)fieldName);
        }
        return builder.toString();
    }

    public String toString() {
        return "CdxFormat(\"" + this.legend() + "\")";
    }

    public CdxRecord parse(String line) {
        try {
            return new CdxRecord(line, this);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String format(WarcCaptureRecord record, String filename, long position, long size) {
        return this.format(record, filename, position, size, null);
    }

    public String format(WarcCaptureRecord record, String filename, long position, long size, String urlkey) {
        StringBuilder builder = new StringBuilder();
        for (byte fieldName : this.fieldNames) {
            String value;
            if (builder.length() > 0) {
                builder.append(' ');
            }
            try {
                value = this.formatField(fieldName, record, filename, position, size, urlkey);
            }
            catch (Exception e) {
                value = "-";
            }
            builder.append(value);
        }
        return builder.toString();
    }

    String formatField(byte fieldName, WarcCaptureRecord record, String filename, long position, long size, String urlkey) throws IOException {
        switch (fieldName) {
            case 107: {
                return record.payloadDigest().map(this.digestUnchanged ? WarcDigest::raw : WarcDigest::base32).map(CdxFormat::escape).orElse("-");
            }
            case 86: {
                return position < 0L ? "-" : String.valueOf(position);
            }
            case 83: {
                return size < 0L ? "-" : String.valueOf(size);
            }
            case 98: {
                return CdxFields.DATE_FORMAT.format(record.date());
            }
            case 103: {
                return filename == null ? "-" : CdxFormat.escape(filename);
            }
            case 109: {
                if (record instanceof WarcRevisit) {
                    return PYWB_REVISIT_MIMETYPE;
                }
                return CdxFormat.escape(record.payload().map(p -> p.type().base()).orElse(MediaType.OCTET_STREAM).toString());
            }
            case 78: {
                if (urlkey != null) {
                    return CdxFormat.escape(urlkey);
                }
                return CdxFormat.escape(URIs.toNormalizedSurt(record.target()));
            }
            case 97: {
                return CdxFormat.escape(record.target());
            }
            case 114: {
                if (record instanceof WarcResponse) {
                    return ((WarcResponse)record).http().headers().first("Location").map(CdxFormat::escape).orElse("-");
                }
                return "-";
            }
            case 115: {
                if (record instanceof WarcResponse || record instanceof WarcRevisit) {
                    if (record instanceof WarcRevisit) {
                        return Integer.toString(((WarcRevisit)record).http().status());
                    }
                    if (record.contentType().base().equals(MediaType.HTTP)) {
                        return Integer.toString(((WarcResponse)record).http().status());
                    }
                    if (record.contentType().base().equals(MediaType.GEMINI)) {
                        return String.format("%02d", ((WarcResponse)record).gemini().statusHttpEquivalent());
                    }
                }
                return "200";
            }
        }
        throw new IllegalArgumentException("Unknown CDX field: " + (char)fieldName);
    }

    private static String escape(String str) {
        if (str == null) {
            return null;
        }
        return str.replace(" ", "%20").replace("\n", "%0A").replace("\u0000", "%00");
    }

    public static class Builder {
        private String legend = "N b a m s k r M S V g";
        private boolean digestUnchanged = false;

        public Builder legend(String legend) {
            this.legend = Objects.requireNonNull(legend);
            return this;
        }

        public Builder digestUnchanged() {
            this.digestUnchanged = true;
            return this;
        }

        public CdxFormat build() {
            return new CdxFormat(this.legend, this.digestUnchanged);
        }
    }
}

