/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.controller.AbstractControllerBrokerRequestBatch$;
import kafka.controller.ControllerChannelContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.controller.StateChangeLogger;
import kafka.server.KafkaConfig;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.StopReplicaRequestData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tmh!\u0002\u0017.\u0003\u0003\u0011\u0004\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u0011\u0019\u0003!\u0011!Q\u0001\n\u001dC\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\t9\u0002\u0011\t\u0011)A\u0005;\"A\u0001\r\u0001B\u0001B\u0003%\u0011\rC\u0003e\u0001\u0011\u0005Q\rC\u0004m\u0001\t\u0007I\u0011A7\t\rE\u0004\u0001\u0015!\u0003o\u0011\u001d\u0011\bA1A\u0005\u0002MDq!!\r\u0001A\u0003%A\u000fC\u0005\u00024\u0001\u0011\r\u0011\"\u0001\u00026!A\u0011\u0011\n\u0001!\u0002\u0013\t9\u0004C\u0005\u0002L\u0001\u0011\r\u0011\"\u0001\u0002N!A\u0011Q\u000b\u0001!\u0002\u0013\ty\u0005C\u0005\u0002X\u0001\u0011\r\u0011\"\u0001\u0002Z!A\u00111\u000e\u0001!\u0002\u0013\tY\u0006C\u0005\u0002n\u0001\u0001\r\u0011\"\u0003\u0002p!I\u0011Q\u0011\u0001A\u0002\u0013%\u0011q\u0011\u0005\t\u0003'\u0003\u0001\u0015)\u0003\u0002r!Y\u0011Q\u0013\u0001A\u0002\u0003\u0007I\u0011BAL\u0011-\tI\n\u0001a\u0001\u0002\u0004%I!a'\t\u0015\u0005}\u0005\u00011A\u0001B\u0003&!\nC\u0004\u0002\"\u00021\t!a)\t\u0013\u0005m\u0007!%A\u0005\u0002\u0005u\u0007bBAz\u0001\u0011\u0005\u0011Q\u001f\u0005\b\u0003o\u0004A\u0011AA}\u0011\u001d\ti\u0010\u0001C\u0001\u0003kDq!a@\u0001\t\u0003\u0011\t\u0001C\u0004\u0003,\u0001!\tA!\f\t\u000f\t]\u0002\u0001\"\u0001\u0003:!9!q\u0007\u0001\u0005\u0002\t\u0015\u0003b\u0002B\u001c\u0001\u0011\u0005!\u0011\n\u0005\b\u0005\u007f\u0002A\u0011\u0002BA\u0011\u001d\u0011I\t\u0001D\u0001\u0005\u0017CqAa'\u0001\t\u0013\u0011i\nC\u0004\u0003$\u00021\tA!*\t\u000f\tE\u0006\u0001\"\u0003\u00034\"9!\u0011\u0018\u0001\u0007\u0002\tm\u0006b\u0002Bt\u0001\u0011\u0005!\u0011^\u0004\n\u0005[l\u0013\u0011!E\u0001\u0005_4\u0001\u0002L\u0017\u0002\u0002#\u0005!\u0011\u001f\u0005\u0007I&\"\tAa=\t\u0013\tU\u0018&%A\u0005\u0002\t](\u0001J!cgR\u0014\u0018m\u0019;D_:$(o\u001c7mKJ\u0014%o\\6feJ+\u0017/^3ti\n\u000bGo\u00195\u000b\u00059z\u0013AC2p]R\u0014x\u000e\u001c7fe*\t\u0001'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001\u0019\u0014\b\u0005\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATG\u0001\u0004B]f\u0014VM\u001a\t\u0003uuj\u0011a\u000f\u0006\u0003y=\nQ!\u001e;jYNL!AP\u001e\u0003\u000f1{wmZ5oO\u000611m\u001c8gS\u001e\u0004\"!\u0011#\u000e\u0003\tS!aQ\u0018\u0002\rM,'O^3s\u0013\t)%IA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001E7fi\u0006$\u0017\r^1Qe>4\u0018\u000eZ3s!\r!\u0004JS\u0005\u0003\u0013V\u0012\u0011BR;oGRLwN\u001c\u0019\u0011\u0005-cU\"A\u0017\n\u00055k#\u0001G\"p]R\u0014x\u000e\u001c7fe\u000eC\u0017M\u001c8fY\u000e{g\u000e^3yi\u00069R.\u001a;bI\u0006$\u0018MV3sg&|g\u000e\u0015:pm&$WM\u001d\t\u0004i!\u0003\u0006CA)[\u001b\u0005\u0011&BA*U\u0003\u0019\u0019w.\\7p]*\u00111)\u0016\u0006\u0003aYS!a\u0016-\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0016aA8sO&\u00111L\u0015\u0002\u0010\u001b\u0016$\u0018\rZ1uCZ+'o]5p]\u0006\t2\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\u0011\u0005-s\u0016BA0.\u0005E\u0019F/\u0019;f\u0007\"\fgnZ3M_\u001e<WM]\u0001\u0010WJ\fg\r^\"p]R\u0014x\u000e\u001c7feB\u0011AGY\u0005\u0003GV\u0012qAQ8pY\u0016\fg.\u0001\u0004=S:LGO\u0010\u000b\u0007M\u001eD\u0017N[6\u0011\u0005-\u0003\u0001\"B \u0007\u0001\u0004\u0001\u0005\"\u0002$\u0007\u0001\u00049\u0005\"\u0002(\u0007\u0001\u0004y\u0005\"\u0002/\u0007\u0001\u0004i\u0006b\u00021\u0007!\u0003\u0005\r!Y\u0001\rG>tGO]8mY\u0016\u0014\u0018\nZ\u000b\u0002]B\u0011Ag\\\u0005\u0003aV\u00121!\u00138u\u00035\u0019wN\u001c;s_2dWM]%eA\u00051B.Z1eKJ\fe\u000eZ%teJ+\u0017/^3ti6\u000b\u0007/F\u0001u!\u0011)(P\u001c?\u000e\u0003YT!a\u001e=\u0002\u000f5,H/\u00192mK*\u0011\u00110N\u0001\u000bG>dG.Z2uS>t\u0017BA>w\u0005\ri\u0015\r\u001d\t\u0006kjl\u0018Q\u0001\t\u0004}\u0006\u0005Q\"A@\u000b\u0005M+\u0016bAA\u0002\u007f\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0003BA\u0004\u0003WqA!!\u0003\u0002&9!\u00111BA\u0011\u001d\u0011\ti!a\b\u000f\t\u0005=\u0011Q\u0004\b\u0005\u0003#\tYB\u0004\u0003\u0002\u0014\u0005eQBAA\u000b\u0015\r\t9\"M\u0001\u0007yI|w\u000e\u001e \n\u0003eK!a\u0016-\n\u0005A2\u0016BA*V\u0013\r\t\u0019c`\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\t9#!\u000b\u0002/1+\u0017\rZ3s\u0003:$\u0017j\u001d:SKF,Xm\u001d;ECR\f'bAA\u0012\u007f&!\u0011QFA\u0018\u0005iaU-\u00193fe\u0006sG-S:s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0015\u0011\t9#!\u000b\u0002/1,\u0017\rZ3s\u0003:$\u0017j\u001d:SKF,Xm\u001d;NCB\u0004\u0013!F:u_B\u0014V\r\u001d7jG\u0006\u0014V-];fgRl\u0015\r]\u000b\u0003\u0003o\u0001R!\u001e>o\u0003s\u0001R!\u001e>~\u0003w\u0001B!!\u0010\u0002D9!\u0011\u0011BA \u0013\u0011\t\t%!\u000b\u0002-M#x\u000e\u001d*fa2L7-\u0019*fcV,7\u000f\u001e#bi\u0006LA!!\u0012\u0002H\tI2\u000b^8q%\u0016\u0004H.[2b!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0015\u0011\t\t%!\u000b\u0002-M$x\u000e\u001d*fa2L7-\u0019*fcV,7\u000f^'ba\u0002\na$\u001e9eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cHO\u0011:pW\u0016\u00148+\u001a;\u0016\u0005\u0005=\u0003\u0003B;\u0002R9L1!a\u0015w\u0005\r\u0019V\r^\u0001 kB$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u\u0005J|7.\u001a:TKR\u0004\u0013!J;qI\u0006$X-T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e)beRLG/[8o\u0013:4w.T1q+\t\tY\u0006E\u0003vuv\fi\u0006\u0005\u0003\u0002`\u0005\u0015d\u0002BA\u0005\u0003CJA!a\u0019\u0002*\u0005IR\u000b\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$H)\u0019;b\u0013\u0011\t9'!\u001b\u00039U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCB\u000b'\u000f^5uS>t7\u000b^1uK*!\u00111MA\u0015\u0003\u0019*\b\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgR\u0004\u0016M\u001d;ji&|g.\u00138g_6\u000b\u0007\u000fI\u0001\u000bkB$\u0017\r^3UsB,WCAA9!\u0011\t\u0019(a \u000f\t\u0005U\u00141P\u0007\u0003\u0003oR1!!\u001f\u0000\u0003!\u0011X-];fgR\u001c\u0018\u0002BA?\u0003o\na#\u00112tiJ\f7\r^\"p]R\u0014x\u000e\u001c*fcV,7\u000f^\u0005\u0005\u0003\u0003\u000b\u0019I\u0001\u0003UsB,'\u0002BA?\u0003o\na\"\u001e9eCR,G+\u001f9f?\u0012*\u0017\u000f\u0006\u0003\u0002\n\u0006=\u0005c\u0001\u001b\u0002\f&\u0019\u0011QR\u001b\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003#\u0013\u0012\u0011!a\u0001\u0003c\n1\u0001\u001f\u00132\u0003-)\b\u000fZ1uKRK\b/\u001a\u0011\u0002!5,G/\u00193bi\u0006Len\u001d;b]\u000e,W#\u0001&\u0002)5,G/\u00193bi\u0006Len\u001d;b]\u000e,w\fJ3r)\u0011\tI)!(\t\u0011\u0005EU#!AA\u0002)\u000b\u0011#\\3uC\u0012\fG/Y%ogR\fgnY3!\u0003-\u0019XM\u001c3SKF,Xm\u001d;\u0015\u0011\u0005%\u0015QUAU\u0003\u0017Da!a*\u0018\u0001\u0004q\u0017\u0001\u00032s_.,'/\u00133\t\u000f\u0005-v\u00031\u0001\u0002.\u00069!/Z9vKN$\b\u0007BAX\u0003s\u0003b!a\u001d\u00022\u0006U\u0016\u0002BAZ\u0003\u0007\u0013qAQ;jY\u0012,'\u000f\u0005\u0003\u00028\u0006eF\u0002\u0001\u0003\r\u0003w\u000bI+!A\u0001\u0002\u000b\u0005\u0011Q\u0018\u0002\u0004?\u0012\"\u0014\u0003BA`\u0003\u000b\u00042\u0001NAa\u0013\r\t\u0019-\u000e\u0002\b\u001d>$\b.\u001b8h!\u0011\t)(a2\n\t\u0005%\u0017q\u000f\u0002\u0017\u0003\n\u001cHO]1di\u000e{g\u000e\u001e:pYJ+\u0017/^3ti\"I\u0011QZ\f\u0011\u0002\u0003\u0007\u0011qZ\u0001\tG\u0006dGNY1dWB9A'!5\u0002V\u0006%\u0015bAAjk\tIa)\u001e8di&|g.\r\t\u0005\u0003k\n9.\u0003\u0003\u0002Z\u0006]$\u0001E!cgR\u0014\u0018m\u0019;SKN\u0004xN\\:f\u0003U\u0019XM\u001c3SKF,Xm\u001d;%I\u00164\u0017-\u001e7uIM*\"!a8+\t\u0005=\u0017\u0011]\u0016\u0003\u0003G\u0004B!!:\u0002p6\u0011\u0011q\u001d\u0006\u0005\u0003S\fY/A\u0005v]\u000eDWmY6fI*\u0019\u0011Q^\u001b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002r\u0006\u001d(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Aa.Z<CCR\u001c\u0007\u000e\u0006\u0002\u0002\n\u0006i1/\u001a;Va\u0012\fG/\u001a+za\u0016$B!!#\u0002|\"9\u0011Q\u000e\u000eA\u0002\u0005E\u0014!B2mK\u0006\u0014\u0018\u0001I1eI2+\u0017\rZ3s\u0003:$\u0017j\u001d:SKF,Xm\u001d;G_J\u0014%o\\6feN$B\"!#\u0003\u0004\t=!1\u0003B\u000f\u0005OAqA!\u0002\u001d\u0001\u0004\u00119!A\u0005ce>\\WM]%egB)!\u0011\u0002B\u0006]6\t\u00010C\u0002\u0003\u000ea\u00141aU3r\u0011\u0019\u0011\t\u0002\ba\u0001{\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007b\u0002B\u000b9\u0001\u0007!qC\u0001\u001cY\u0016\fG-\u001a:JgJ\fe\u000eZ\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\u0011\u0007-\u0013I\"C\u0002\u0003\u001c5\u00121\u0004T3bI\u0016\u0014\u0018j\u001d:B]\u0012\u001cuN\u001c;s_2dWM]#q_\u000eD\u0007b\u0002B\u00109\u0001\u0007!\u0011E\u0001\u0012e\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\bcA&\u0003$%\u0019!QE\u0017\u0003#I+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG\u000f\u0003\u0004\u0003*q\u0001\r!Y\u0001\u0006SNtUm^\u0001 C\u0012$7\u000b^8q%\u0016\u0004H.[2b%\u0016\fX/Z:u\r>\u0014(I]8lKJ\u001cH\u0003CAE\u0005_\u0011\tDa\r\t\u000f\t\u0015Q\u00041\u0001\u0003\b!1!\u0011C\u000fA\u0002uDaA!\u000e\u001e\u0001\u0004\t\u0017a\u00043fY\u0016$X\rU1si&$\u0018n\u001c8\u0002E\u0005$G-\u00169eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cHOR8s\u0005J|7.\u001a:t)\u0019\tIIa\u000f\u0003>!9!Q\u0001\u0010A\u0002\t\u001d\u0001b\u0002B =\u0001\u0007!\u0011I\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\b#\u0002B\u0005\u0005\u0007j\u0018bAA*qR!\u0011\u0011\u0012B$\u0011\u001d\u0011)a\ba\u0001\u0005\u000f!B#!#\u0003L\t5#\u0011\u000bB+\u00053\u0012iF!\u0019\u0003x\tm\u0004b\u0002B\u0003A\u0001\u0007!q\u0001\u0005\u0007\u0005\u001f\u0002\u0003\u0019\u00018\u0002\u001f\r|g\u000e\u001e:pY2,'/\u00129pG\"DaAa\u0015!\u0001\u0004i\u0018!\u00039beRLG/[8o\u0011\u0019\u00119\u0006\ta\u0001]\u00061A.Z1eKJDaAa\u0017!\u0001\u0004q\u0017a\u00037fC\u0012,'/\u00129pG\"DaAa\u0018!\u0001\u0004q\u0017A\u00049beRLG/[8o\u000bB|7\r\u001b\u0005\b\u0005G\u0002\u0003\u0019\u0001B3\u0003\u0011I7O]:\u0011\u000b\t\u001d$\u0011\u000f8\u000f\t\t%$Q\u000e\b\u0005\u0003'\u0011Y'C\u00017\u0013\r\u0011y'N\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\u0019H!\u001e\u0003\t1K7\u000f\u001e\u0006\u0004\u0005_*\u0004b\u0002B=A\u0001\u0007!qA\u0001\te\u0016\u0004H.[2bg\"9!Q\u0010\u0011A\u0002\t\u001d\u0011aD8gM2Lg.\u001a*fa2L7-Y:\u0002/M,g\u000e\u001a'fC\u0012,'/\u00118e\u0013N\u0014(+Z9vKN$HCBAE\u0005\u0007\u0013)\t\u0003\u0004\u0003P\u0005\u0002\rA\u001c\u0005\u0007\u0005\u000f\u000b\u0003\u0019A/\u0002\u001dM$\u0018\r^3DQ\u0006tw-\u001a'pO\u0006Q\u0002.\u00198eY\u0016dU-\u00193fe\u0006sG-S:s%\u0016\u001c\bo\u001c8tKR1\u0011\u0011\u0012BG\u0005/CqAa$#\u0001\u0004\u0011\t*\u0001\u0005sKN\u0004xN\\:f!\u0011\t)Ha%\n\t\tU\u0015q\u000f\u0002\u0015\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d*fgB|gn]3\t\r\te%\u00051\u0001o\u0003\u0019\u0011'o\\6fe\u0006Q2/\u001a8e+B$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:ugR1\u0011\u0011\u0012BP\u0005CCaAa\u0014$\u0001\u0004q\u0007B\u0002BDG\u0001\u0007Q,\u0001\u000fiC:$G.Z+qI\u0006$X-T3uC\u0012\fG/\u0019*fgB|gn]3\u0015\r\u0005%%q\u0015BX\u0011\u001d\u0011y\t\na\u0001\u0005S\u0003B!!\u001e\u0003,&!!QVA<\u0005Y)\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0014Vm\u001d9p]N,\u0007B\u0002BMI\u0001\u0007a.A\ftK:$7\u000b^8q%\u0016\u0004H.[2b%\u0016\fX/Z:ugR1\u0011\u0011\u0012B[\u0005oCaAa\u0014&\u0001\u0004q\u0007B\u0002BDK\u0001\u0007Q,A\riC:$G.Z*u_B\u0014V\r\u001d7jG\u0006\u0014Vm\u001d9p]N,G\u0003CAE\u0005{\u00139M!3\t\u000f\t}f\u00051\u0001\u0003B\u0006\u00192\u000f^8q%\u0016\u0004H.[2b%\u0016\u001c\bo\u001c8tKB!\u0011Q\u000fBb\u0013\u0011\u0011)-a\u001e\u0003'M#x\u000e\u001d*fa2L7-\u0019*fgB|gn]3\t\r\u0005\u001df\u00051\u0001o\u0011\u001d\u0011YM\na\u0001\u0005\u001b\f\u0001\u0005]1si&$\u0018n\u001c8FeJ|'o\u001d$pe\u0012+G.\u001a;j]\u001e$v\u000e]5dgB9!q\u001aBl{\nmg\u0002\u0002Bi\u0005'\u00042!a\u00056\u0013\r\u0011).N\u0001\u0007!J,G-\u001a4\n\u0007m\u0014INC\u0002\u0003VV\u0002BA!8\u0003d6\u0011!q\u001c\u0006\u0004\u0005C|\u0018\u0001\u00039s_R|7m\u001c7\n\t\t\u0015(q\u001c\u0002\u0007\u000bJ\u0014xN]:\u0002+M,g\u000e\u001a*fcV,7\u000f^:U_\n\u0013xn[3sgR!\u0011\u0011\u0012Bv\u0011\u0019\u0011ye\na\u0001]\u0006!\u0013IY:ue\u0006\u001cGoQ8oiJ|G\u000e\\3s\u0005J|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007\u000e\u0005\u0002LSM\u0011\u0011f\r\u000b\u0003\u0005_\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*TC\u0001B}U\r\t\u0017\u0011\u001d")
public abstract class AbstractControllerBrokerRequestBatch
implements Logging {
    private final KafkaConfig config;
    private final Function0<ControllerChannelContext> metadataProvider;
    private final Function0<MetadataVersion> metadataVersionProvider;
    private final StateChangeLogger stateChangeLogger;
    private final boolean kraftController;
    private final int controllerId;
    private final scala.collection.mutable.Map<Object, scala.collection.mutable.Map<TopicPartition, LeaderAndIsrRequestData.LeaderAndIsrPartitionState>> leaderAndIsrRequestMap;
    private final scala.collection.mutable.Map<Object, scala.collection.mutable.Map<TopicPartition, StopReplicaRequestData.StopReplicaPartitionState>> stopReplicaRequestMap;
    private final scala.collection.mutable.Set<Object> updateMetadataRequestBrokerSet;
    private final scala.collection.mutable.Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> updateMetadataRequestPartitionInfoMap;
    private AbstractControlRequest.Type updateType;
    private ControllerChannelContext metadataInstance;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$5() {
        return AbstractControllerBrokerRequestBatch$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int controllerId() {
        return this.controllerId;
    }

    public scala.collection.mutable.Map<Object, scala.collection.mutable.Map<TopicPartition, LeaderAndIsrRequestData.LeaderAndIsrPartitionState>> leaderAndIsrRequestMap() {
        return this.leaderAndIsrRequestMap;
    }

    public scala.collection.mutable.Map<Object, scala.collection.mutable.Map<TopicPartition, StopReplicaRequestData.StopReplicaPartitionState>> stopReplicaRequestMap() {
        return this.stopReplicaRequestMap;
    }

    public scala.collection.mutable.Set<Object> updateMetadataRequestBrokerSet() {
        return this.updateMetadataRequestBrokerSet;
    }

    public scala.collection.mutable.Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> updateMetadataRequestPartitionInfoMap() {
        return this.updateMetadataRequestPartitionInfoMap;
    }

    private AbstractControlRequest.Type updateType() {
        return this.updateType;
    }

    private void updateType_$eq(AbstractControlRequest.Type x$1) {
        this.updateType = x$1;
    }

    private ControllerChannelContext metadataInstance() {
        return this.metadataInstance;
    }

    private void metadataInstance_$eq(ControllerChannelContext x$1) {
        this.metadataInstance = x$1;
    }

    public abstract void sendRequest(int var1, AbstractControlRequest.Builder<? extends AbstractControlRequest> var2, Function1<AbstractResponse, BoxedUnit> var3);

    public Function1<AbstractResponse, BoxedUnit> sendRequest$default$3() {
        return null;
    }

    public void newBatch() {
        if (this.leaderAndIsrRequestMap().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(135).append("Controller to broker state change requests batch is not empty while creating ").append("a new one. Some LeaderAndIsr state changes ").append(this.leaderAndIsrRequestMap()).append(" might be lost ").toString());
        }
        if (this.stopReplicaRequestMap().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(134).append("Controller to broker state change requests batch is not empty while creating a ").append("new one. Some StopReplica state changes ").append(this.stopReplicaRequestMap()).append(" might be lost ").toString());
        }
        if (this.updateMetadataRequestBrokerSet().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(169).append("Controller to broker state change requests batch is not empty while creating a ").append("new one. Some UpdateMetadata state changes to brokers ").append(this.updateMetadataRequestBrokerSet()).append(" with partition info ").append(this.updateMetadataRequestPartitionInfoMap()).append(" might be lost ").toString());
        }
        this.metadataInstance_$eq((ControllerChannelContext)this.metadataProvider.apply());
    }

    public void setUpdateType(AbstractControlRequest.Type updateType) {
        this.updateType_$eq(updateType);
    }

    public void clear() {
        this.leaderAndIsrRequestMap().clear();
        this.stopReplicaRequestMap().clear();
        this.updateMetadataRequestBrokerSet().clear();
        this.updateMetadataRequestPartitionInfoMap().clear();
        this.metadataInstance_$eq(null);
        this.updateType_$eq(AbstractControlRequest.Type.UNKNOWN);
    }

    public void addLeaderAndIsrRequestForBrokers(Seq<Object> brokerIds, TopicPartition topicPartition, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, ReplicaAssignment replicaAssignment, boolean isNew) {
        ((IterableLike)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 >= 0)).foreach((Function1 & Serializable & scala.Serializable)brokerId -> AbstractControllerBrokerRequestBatch.$anonfun$addLeaderAndIsrRequestForBrokers$2(this, topicPartition, leaderIsrAndControllerEpoch, replicaAssignment, isNew, BoxesRunTime.unboxToInt((Object)brokerId)));
        this.addUpdateMetadataRequestForBrokers((Seq<Object>)this.metadataInstance().liveOrShuttingDownBrokerIds().toSeq(), (Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
    }

    public void addStopReplicaRequestForBrokers(Seq<Object> brokerIds, TopicPartition topicPartition, boolean deletePartition) {
        int leaderEpoch = this.metadataInstance().leaderEpoch(topicPartition);
        ((IterableLike)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$6 -> x$6 >= 0)).foreach((Function1 & Serializable & scala.Serializable)brokerId -> AbstractControllerBrokerRequestBatch.$anonfun$addStopReplicaRequestForBrokers$2(this, topicPartition, leaderEpoch, deletePartition, BoxesRunTime.unboxToInt((Object)brokerId)));
    }

    public void addUpdateMetadataRequestForBrokers(Seq<Object> brokerIds, Set<TopicPartition> partitions) {
        this.updateMetadataRequestBrokerSet().$plus$plus$eq((TraversableOnce)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$8 -> x$8 >= 0));
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            AbstractControllerBrokerRequestBatch.$anonfun$addUpdateMetadataRequestForBrokers$2(this, brokerIds, partition);
            return BoxedUnit.UNIT;
        });
    }

    public void addUpdateMetadataRequestForBrokers(Seq<Object> brokerIds) {
        this.updateMetadataRequestBrokerSet().$plus$plus$eq((TraversableOnce)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$10 -> x$10 >= 0));
    }

    public void addUpdateMetadataRequestForBrokers(Seq<Object> brokerIds, int controllerEpoch, TopicPartition partition, int leader, int leaderEpoch, int partitionEpoch, List<Object> isrs, Seq<Object> replicas, Seq<Object> offlineReplicas) {
        this.updateMetadataRequestBrokerSet().$plus$plus$eq((TraversableOnce)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$11 -> x$11 >= 0));
        UpdateMetadataRequestData.UpdateMetadataPartitionState partitionStateInfo = new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(partition.topic()).setPartitionIndex(partition.partition()).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)isrs.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), List$.MODULE$.canBuildFrom())).asJava()).setZkVersion(partitionEpoch).setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setOfflineReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)offlineReplicas.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava());
        this.updateMetadataRequestPartitionInfoMap().put((Object)partition, (Object)partitionStateInfo);
    }

    /*
     * WARNING - void declaration
     */
    private void sendLeaderAndIsrRequest(int controllerEpoch, StateChangeLogger stateChangeLog) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        MetadataVersion metadataVersion = (MetadataVersion)this.metadataVersionProvider.apply();
        int leaderAndIsrRequestVersion = metadataVersion.isAtLeast(MetadataVersion.IBP_3_4_IV0) ? 7 : (metadataVersion.isAtLeast(MetadataVersion.IBP_3_2_IV0) ? 6 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_8_IV1) ? 5 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_4_IV1) ? 4 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_4_IV0) ? 3 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_2_IV0) ? 2 : (metadataVersion.isAtLeast(MetadataVersion.IBP_1_0_IV0) ? 1 : 0))))));
        Function2 & Serializable & scala.Serializable intersect = (arg_0, arg_1) -> AbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$1$adapted(this, stateChangeLog, (short)leaderAndIsrRequestVersion, controllerEpoch, arg_0, arg_1);
        Map<Object, scala.collection.mutable.Map<TopicPartition, LeaderAndIsrRequestData.LeaderAndIsrPartitionState>> map = Implicits$.MODULE$.MapExtensionMethods(this.leaderAndIsrRequestMap());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        this.leaderAndIsrRequestMap().clear();
    }

    public abstract void handleLeaderAndIsrResponse(LeaderAndIsrResponse var1, int var2);

    private void sendUpdateMetadataRequests(int controllerEpoch, StateChangeLogger stateChangeLog) {
        stateChangeLog.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Sending UpdateMetadata request to brokers ").append(this.updateMetadataRequestBrokerSet()).append(" ").append("for ").append(this.updateMetadataRequestPartitionInfoMap().size()).append(" partitions").toString());
        Buffer partitionStates = this.updateMetadataRequestPartitionInfoMap().values().toBuffer();
        MetadataVersion metadataVersion = (MetadataVersion)this.metadataVersionProvider.apply();
        int updateMetadataRequestVersion = metadataVersion.isAtLeast(MetadataVersion.IBP_3_4_IV0) ? 8 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_8_IV1) ? 7 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_4_IV1) ? 6 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_2_IV0) ? 5 : (metadataVersion.isAtLeast(MetadataVersion.IBP_1_0_IV0) ? 4 : (metadataVersion.isAtLeast(MetadataVersion.IBP_0_10_2_IV0) ? 3 : (metadataVersion.isAtLeast(MetadataVersion.IBP_0_10_0_IV1) ? 2 : (metadataVersion.isAtLeast(MetadataVersion.IBP_0_9_0) ? 1 : 0)))))));
        Buffer liveBrokers = this.metadataInstance().liveOrShuttingDownBrokers().iterator().map(arg_0 -> AbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$2((short)updateMetadataRequestVersion, arg_0)).toBuffer();
        ((IterableLike)this.updateMetadataRequestBrokerSet().intersect(this.metadataInstance().liveOrShuttingDownBrokerIds())).foreach((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> AbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$4(this, partitionStates, (short)updateMetadataRequestVersion, controllerEpoch, liveBrokers, arg_0)));
        this.updateMetadataRequestBrokerSet().clear();
        this.updateMetadataRequestPartitionInfoMap().clear();
    }

    public abstract void handleUpdateMetadataResponse(UpdateMetadataResponse var1, int var2);

    /*
     * WARNING - void declaration
     */
    private void sendStopReplicaRequests(int controllerEpoch, StateChangeLogger stateChangeLog) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        boolean traceEnabled = stateChangeLog.isTraceEnabled();
        MetadataVersion metadataVersion = (MetadataVersion)this.metadataVersionProvider.apply();
        short stopReplicaRequestVersion = metadataVersion.isAtLeast(MetadataVersion.IBP_3_4_IV0) ? (short)4 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_6_IV0) ? (short)3 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_4_IV1) ? (short)2 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_2_IV0) ? (short)1 : 0)));
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(brokerId, partitionStates) -> {
            AbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$2(this, traceEnabled, stateChangeLog, stopReplicaRequestVersion, controllerEpoch, BoxesRunTime.unboxToInt((Object)brokerId), partitionStates);
            return BoxedUnit.UNIT;
        };
        Map<Object, scala.collection.mutable.Map<TopicPartition, StopReplicaRequestData.StopReplicaPartitionState>> map = Implicits$.MODULE$.MapExtensionMethods(this.stopReplicaRequestMap());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        this.stopReplicaRequestMap().clear();
    }

    public abstract void handleStopReplicaResponse(StopReplicaResponse var1, int var2, scala.collection.immutable.Map<TopicPartition, Errors> var3);

    public void sendRequestsToBrokers(int controllerEpoch) {
        try {
            StateChangeLogger stateChangeLog = this.stateChangeLogger.withControllerEpoch(controllerEpoch);
            this.sendLeaderAndIsrRequest(controllerEpoch, stateChangeLog);
            this.sendUpdateMetadataRequests(controllerEpoch, stateChangeLog);
            this.sendStopReplicaRequests(controllerEpoch, stateChangeLog);
            this.updateType_$eq(AbstractControlRequest.Type.UNKNOWN);
            return;
        }
        catch (Throwable e) {
            if (this.leaderAndIsrRequestMap().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(100).append("Haven't been able to send leader and isr requests, current state of ").append("the map is ").append(this.leaderAndIsrRequestMap()).append(". Exception message: ").append(e).toString());
            }
            if (this.updateMetadataRequestBrokerSet().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(124).append("Haven't been able to send metadata update requests to brokers ").append(this.updateMetadataRequestBrokerSet()).append(", ").append("current state of the partition info is ").append(this.updateMetadataRequestPartitionInfoMap()).append(". Exception message: ").append(e).toString());
            }
            if (this.stopReplicaRequestMap().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(98).append("Haven't been able to send stop replica requests, current state of ").append("the map is ").append(this.stopReplicaRequestMap()).append(". Exception message: ").append(e).toString());
            }
            throw new IllegalStateException(e);
        }
    }

    public static final /* synthetic */ Option $anonfun$addLeaderAndIsrRequestForBrokers$2(AbstractControllerBrokerRequestBatch $this, TopicPartition topicPartition$1, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1, ReplicaAssignment replicaAssignment$1, boolean isNew$1, int brokerId) {
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)$this.leaderAndIsrRequestMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable & scala.Serializable)() -> Map$.MODULE$.empty());
        boolean alreadyNew = result.get((Object)topicPartition$1).exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isNew()));
        LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch$1.leaderAndIsr();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(topicPartition$1.topic()).setPartitionIndex(topicPartition$1.partition()).setControllerEpoch(leaderIsrAndControllerEpoch$1.controllerEpoch()).setLeader(leaderAndIsr.leader()).setLeaderEpoch(leaderAndIsr.leaderEpoch()).setIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)leaderAndIsr.isr().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), List$.MODULE$.canBuildFrom())).asJava()).setPartitionEpoch(leaderAndIsr.partitionEpoch()).setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaAssignment$1.replicas().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setAddingReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaAssignment$1.addingReplicas().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setRemovingReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaAssignment$1.removingReplicas().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setIsNew(isNew$1 || alreadyNew);
        if (((MetadataVersion)$this.metadataVersionProvider.apply()).isAtLeast(MetadataVersion.IBP_3_2_IV0)) {
            partitionState.setLeaderRecoveryState(leaderAndIsr.leaderRecoveryState().value());
        }
        return result.put((Object)topicPartition$1, (Object)partitionState);
    }

    public static final /* synthetic */ Option $anonfun$addStopReplicaRequestForBrokers$2(AbstractControllerBrokerRequestBatch $this, TopicPartition topicPartition$2, int leaderEpoch$1, boolean deletePartition$1, int brokerId) {
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)$this.stopReplicaRequestMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable & scala.Serializable)() -> Map$.MODULE$.empty());
        boolean alreadyDelete = result.get((Object)topicPartition$2).exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.deletePartition()));
        return result.put((Object)topicPartition$2, (Object)new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex(topicPartition$2.partition()).setLeaderEpoch(leaderEpoch$1).setDeletePartition(alreadyDelete || deletePartition$1));
    }

    public static final /* synthetic */ void $anonfun$addUpdateMetadataRequestForBrokers$2(AbstractControllerBrokerRequestBatch $this, Seq brokerIds$1, TopicPartition partition) {
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch;
        boolean beingDeleted = $this.metadataInstance().isTopicQueuedUpForDeletion(partition.topic());
        Option<LeaderIsrAndControllerEpoch> option = $this.metadataInstance().partitionLeadershipInfo(partition);
        if (option instanceof Some && (leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value()) != null) {
            LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch.leaderAndIsr();
            int controllerEpoch = leaderIsrAndControllerEpoch.controllerEpoch();
            Seq<Object> replicas = $this.metadataInstance().partitionReplicaAssignment(partition);
            Seq offlineReplicas = (Seq)replicas.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$9 -> !$this.metadataInstance().isReplicaOnline(x$9, partition));
            LeaderAndIsr updatedLeaderAndIsr = beingDeleted ? LeaderAndIsr$.MODULE$.duringDelete(leaderAndIsr.isr()) : leaderAndIsr;
            $this.addUpdateMetadataRequestForBrokers((Seq<Object>)brokerIds$1, controllerEpoch, partition, updatedLeaderAndIsr.leader(), updatedLeaderAndIsr.leaderEpoch(), updatedLeaderAndIsr.partitionEpoch(), updatedLeaderAndIsr.isr(), replicas, (Seq<Object>)offlineReplicas);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Leader not yet assigned for partition ").append(partition).append(". Skip sending UpdateMetadataRequest.").toString());
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ void $anonfun$sendLeaderAndIsrRequest$2(scala.collection.mutable.Set leaderIds$1, int broker$2, IntRef numBecomeLeaders$1, StateChangeLogger stateChangeLog$1, TopicPartition topicPartition, LeaderAndIsrRequestData.LeaderAndIsrPartitionState state) {
        String typeOfRequest;
        String string;
        leaderIds$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)state.leader()));
        if (broker$2 == state.leader()) {
            ++numBecomeLeaders$1.elem;
            string = "become-leader";
        } else {
            string = typeOfRequest = "become-follower";
        }
        if (stateChangeLog$1.isTraceEnabled()) {
            stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Sending ").append(typeOfRequest).append(" LeaderAndIsr request ").append(state).append(" to broker ").append(broker$2).append(" for partition ").append(topicPartition).toString());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$sendLeaderAndIsrRequest$10(AbstractControllerBrokerRequestBatch $this, int broker$2, AbstractResponse r) {
        LeaderAndIsrResponse leaderAndIsrResponse = (LeaderAndIsrResponse)r;
        $this.handleLeaderAndIsrResponse(leaderAndIsrResponse, broker$2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$sendLeaderAndIsrRequest$1(AbstractControllerBrokerRequestBatch $this, StateChangeLogger stateChangeLog$1, short leaderAndIsrRequestVersion$1, int controllerEpoch$1, int broker, scala.collection.mutable.Map leaderAndIsrPartitionStates) {
        if ($this.metadataInstance().liveOrShuttingDownBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)broker))) {
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            scala.collection.mutable.Set leaderIds = scala.collection.mutable.Set$.MODULE$.empty();
            IntRef numBecomeLeaders = IntRef.create((int)0);
            Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, state) -> {
                AbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$2(leaderIds, broker, numBecomeLeaders, stateChangeLog$1, topicPartition, state);
                return BoxedUnit.UNIT;
            };
            Map map = Implicits$.MODULE$.MapExtensionMethods(leaderAndIsrPartitionStates);
            if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
            stateChangeLog$1.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(91).append("Sending LeaderAndIsr request to broker ").append(broker).append(" with ").append(numBecomeLeaders$1.elem).append(" become-leader ").append("and ").append(leaderAndIsrPartitionStates.size() - numBecomeLeaders$1.elem).append(" become-follower partitions").toString());
            Set leaders = (Set)((SetLike)$this.metadataInstance().liveOrShuttingDownBrokers().filter((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)leaderIds.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))))).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.node($this.config.interBrokerListenerName()), Set$.MODULE$.canBuildFrom());
            long brokerEpoch = BoxesRunTime.unboxToLong((Object)$this.metadataInstance().liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)broker)));
            scala.collection.immutable.Map topicIds = ((TraversableOnce)((TraversableOnce)leaderAndIsrPartitionStates.keys().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.topic(), Iterable$.MODULE$.canBuildFrom())).toSet().map((Function1 & Serializable & scala.Serializable)topic -> new Tuple2(topic, $this.metadataInstance().topicIds().getOrElse(topic, (Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID)), scala.collection.immutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            LeaderAndIsrRequest.Builder leaderAndIsrRequestBuilder = new LeaderAndIsrRequest.Builder(leaderAndIsrRequestVersion$1, $this.controllerId(), controllerEpoch$1, brokerEpoch, (java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(leaderAndIsrPartitionStates.values().toBuffer()).asJava(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)topicIds).asJava(), (Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter(leaders).asJava(), $this.kraftController, $this.updateType());
            $this.sendRequest(broker, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)leaderAndIsrRequestBuilder, (Function1<AbstractResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)r -> {
                AbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$10($this, broker, r);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$sendUpdateMetadataRequests$2(short updateMetadataRequestVersion$1, Broker broker) {
        Seq seq;
        if (updateMetadataRequestVersion$1 == 0) {
            SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
            ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
            Node node = broker.node(listenerName);
            seq = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(node.host()).setPort(node.port()).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$);
        } else {
            seq = (Seq)broker.endPoints().map((Function1 & Serializable & scala.Serializable)endpoint -> new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(endpoint.host()).setPort(endpoint.port()).setSecurityProtocol(endpoint.securityProtocol().id).setListener(endpoint.listenerName().value()), Seq$.MODULE$.canBuildFrom());
        }
        Seq endpoints = seq;
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(broker.id()).setEndpoints((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(endpoints).asJava()).setRack((String)broker.rack().orNull(Predef$.MODULE$.$conforms()));
    }

    public static final /* synthetic */ void $anonfun$sendUpdateMetadataRequests$8(AbstractControllerBrokerRequestBatch $this, int broker$3, AbstractResponse r) {
        UpdateMetadataResponse updateMetadataResponse = (UpdateMetadataResponse)r;
        $this.handleUpdateMetadataResponse(updateMetadataResponse, broker$3);
    }

    public static final /* synthetic */ void $anonfun$sendUpdateMetadataRequests$4(AbstractControllerBrokerRequestBatch $this, Buffer partitionStates$1, short updateMetadataRequestVersion$1, int controllerEpoch$2, Buffer liveBrokers$1, int broker) {
        long brokerEpoch = BoxesRunTime.unboxToLong((Object)$this.metadataInstance().liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)broker)));
        scala.collection.immutable.Map topicIds = ((TraversableOnce)((TraversableLike)((TraversableLike)((SeqLike)partitionStates$1.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.topicName(), Buffer$.MODULE$.canBuildFrom())).distinct()).filter(arg_0 -> AbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$6$adapted($this.metadataInstance().topicIds(), arg_0))).map((Function1 & Serializable & scala.Serializable)topic -> new Tuple2(topic, $this.metadataInstance().topicIds().apply(topic)), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        UpdateMetadataRequest.Builder updateMetadataRequestBuilder = new UpdateMetadataRequest.Builder(updateMetadataRequestVersion$1, $this.controllerId(), controllerEpoch$2, brokerEpoch, (java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(partitionStates$1).asJava(), (java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(liveBrokers$1).asJava(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)topicIds).asJava(), $this.kraftController, $this.updateType());
        $this.sendRequest(broker, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)updateMetadataRequestBuilder, (Function1<AbstractResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)r -> {
            AbstractControllerBrokerRequestBatch.$anonfun$sendUpdateMetadataRequests$8($this, broker, r);
            return BoxedUnit.UNIT;
        });
    }

    private final void responseCallback$1(int brokerId, Function1 isPartitionDeleted, AbstractResponse response) {
        StopReplicaResponse stopReplicaResponse = (StopReplicaResponse)response;
        scala.collection.mutable.Map partitionErrorsForDeletingTopics = Map$.MODULE$.empty();
        stopReplicaResponse.partitionErrors().forEach(pe -> {
            TopicPartition tp = new TopicPartition(pe.topicName(), pe.partitionIndex());
            if (this.metadataInstance().isTopicDeletionInProgress(pe.topicName()) && BoxesRunTime.unboxToBoolean((Object)intersect2.apply((Object)tp))) {
                responseCallback$1_partitionErrorsForDeletingTopics.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Errors.forCode((short)pe.errorCode())));
                return;
            }
        });
        if (partitionErrorsForDeletingTopics.nonEmpty()) {
            this.handleStopReplicaResponse(stopReplicaResponse, brokerId, (scala.collection.immutable.Map<TopicPartition, Errors>)partitionErrorsForDeletingTopics.toMap(Predef$.MODULE$.$conforms()));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$sendStopReplicaRequests$5(scala.collection.mutable.Map stopReplicaTopicState$1, TopicPartition topicPartition, StopReplicaRequestData.StopReplicaPartitionState partitionState) {
        return ((StopReplicaRequestData.StopReplicaTopicState)stopReplicaTopicState$1.getOrElseUpdate((Object)topicPartition.topic(), (Function0 & Serializable & scala.Serializable)() -> new StopReplicaRequestData.StopReplicaTopicState().setTopicName(topicPartition.topic()))).partitionStates().add(partitionState);
    }

    public static final /* synthetic */ boolean $anonfun$sendStopReplicaRequests$8(scala.collection.mutable.Map partitionStates$2, TopicPartition tp) {
        return partitionStates$2.get((Object)tp).exists((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)x$15.deletePartition()));
    }

    public static final /* synthetic */ void $anonfun$sendStopReplicaRequests$10(AbstractControllerBrokerRequestBatch $this, int brokerId$2, Function1 eta$0$1$2, AbstractResponse response) {
        StopReplicaResponse responseCallback$1_stopReplicaResponse = (StopReplicaResponse)response;
        scala.collection.mutable.Map responseCallback$1_partitionErrorsForDeletingTopics = Map$.MODULE$.empty();
        responseCallback$1_stopReplicaResponse.partitionErrors().forEach(pe -> {
            TopicPartition tp = new TopicPartition(pe.topicName(), pe.partitionIndex());
            if (this.metadataInstance().isTopicDeletionInProgress(pe.topicName()) && BoxesRunTime.unboxToBoolean((Object)intersect2.apply((Object)tp))) {
                responseCallback$1_partitionErrorsForDeletingTopics.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Errors.forCode((short)pe.errorCode())));
                return;
            }
        });
        if (responseCallback$1_partitionErrorsForDeletingTopics.nonEmpty()) {
            $this.handleStopReplicaResponse(responseCallback$1_stopReplicaResponse, brokerId$2, (scala.collection.immutable.Map<TopicPartition, Errors>)responseCallback$1_partitionErrorsForDeletingTopics.toMap(Predef$.MODULE$.$conforms()));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$sendStopReplicaRequests$11(IntRef numPartitionStateWithDelete$1, scala.collection.mutable.Map topicStatesWithDelete$1, IntRef numPartitionStateWithoutDelete$1, scala.collection.mutable.Map topicStatesWithoutDelete$1, TopicPartition topicPartition, StopReplicaRequestData.StopReplicaPartitionState partitionState) {
        scala.collection.mutable.Map map;
        if (partitionState.deletePartition()) {
            ++numPartitionStateWithDelete$1.elem;
            map = topicStatesWithDelete$1;
        } else {
            ++numPartitionStateWithoutDelete$1.elem;
            map = topicStatesWithoutDelete$1;
        }
        return ((StopReplicaRequestData.StopReplicaTopicState)map.getOrElseUpdate((Object)topicPartition.topic(), (Function0 & Serializable & scala.Serializable)() -> new StopReplicaRequestData.StopReplicaTopicState().setTopicName(topicPartition.topic()))).partitionStates().add(partitionState);
    }

    public static final /* synthetic */ boolean $anonfun$sendStopReplicaRequests$14(TopicPartition x$16) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$sendStopReplicaRequests$15(AbstractControllerBrokerRequestBatch $this, int brokerId$2, Function1 eta$0$2$1, AbstractResponse response) {
        StopReplicaResponse responseCallback$1_stopReplicaResponse = (StopReplicaResponse)response;
        scala.collection.mutable.Map responseCallback$1_partitionErrorsForDeletingTopics = Map$.MODULE$.empty();
        responseCallback$1_stopReplicaResponse.partitionErrors().forEach(pe -> {
            TopicPartition tp = new TopicPartition(pe.topicName(), pe.partitionIndex());
            if (this.metadataInstance().isTopicDeletionInProgress(pe.topicName()) && BoxesRunTime.unboxToBoolean((Object)intersect2.apply((Object)tp))) {
                responseCallback$1_partitionErrorsForDeletingTopics.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Errors.forCode((short)pe.errorCode())));
                return;
            }
        });
        if (responseCallback$1_partitionErrorsForDeletingTopics.nonEmpty()) {
            $this.handleStopReplicaResponse(responseCallback$1_stopReplicaResponse, brokerId$2, (scala.collection.immutable.Map<TopicPartition, Errors>)responseCallback$1_partitionErrorsForDeletingTopics.toMap(Predef$.MODULE$.$conforms()));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$sendStopReplicaRequests$2(AbstractControllerBrokerRequestBatch $this, boolean traceEnabled$1, StateChangeLogger stateChangeLog$2, short stopReplicaRequestVersion$1, int controllerEpoch$3, int brokerId, scala.collection.mutable.Map partitionStates) {
        if ($this.metadataInstance().liveOrShuttingDownBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)brokerId))) {
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            if (traceEnabled$1) {
                void forKeyValue$extension_f2;
                void forKeyValue$extension_$this2;
                Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, partitionState) -> {
                    stateChangeLog$2.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Sending StopReplica request ").append(partitionState).append(" to ").append("broker ").append(brokerId$2).append(" for partition ").append(topicPartition).toString());
                    return BoxedUnit.UNIT;
                };
                Map map = Implicits$.MODULE$.MapExtensionMethods(partitionStates);
                if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                    throw null;
                }
                MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this2), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f2, arg_0, arg_1));
            }
            long brokerEpoch = BoxesRunTime.unboxToLong((Object)$this.metadataInstance().liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)brokerId)));
            if (stopReplicaRequestVersion$1 >= 3) {
                void forKeyValue$extension_f3;
                void forKeyValue$extension_$this3;
                scala.collection.mutable.Map stopReplicaTopicState = Map$.MODULE$.empty();
                Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, partitionState) -> BoxesRunTime.boxToBoolean((boolean)AbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$5(stopReplicaTopicState, topicPartition, partitionState));
                Map map = Implicits$.MODULE$.MapExtensionMethods(partitionStates);
                if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                    throw null;
                }
                MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this3), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f3, arg_0, arg_1));
                stateChangeLog$2.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Sending StopReplica request for ").append(partitionStates.size()).append(" ").append("replicas to broker ").append(brokerId).toString());
                StopReplicaRequest.Builder stopReplicaRequestBuilder = new StopReplicaRequest.Builder(stopReplicaRequestVersion$1, $this.controllerId(), controllerEpoch$3, brokerEpoch, false, (java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(stopReplicaTopicState.values().toBuffer()).asJava(), $this.kraftController);
                Function1 & Serializable & scala.Serializable intersect2 = (Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)AbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$8(partitionStates, tp));
                $this.sendRequest(brokerId, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)stopReplicaRequestBuilder, (Function1<AbstractResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                    StopReplicaResponse $anonfun$sendStopReplicaRequests$10_responseCallback$1_stopReplicaResponse = (StopReplicaResponse)response;
                    scala.collection.mutable.Map $anonfun$sendStopReplicaRequests$10_responseCallback$1_partitionErrorsForDeletingTopics = Map$.MODULE$.empty();
                    $anonfun$sendStopReplicaRequests$10_responseCallback$1_stopReplicaResponse.partitionErrors().forEach(pe -> {
                        TopicPartition tp = new TopicPartition(pe.topicName(), pe.partitionIndex());
                        if (this.metadataInstance().isTopicDeletionInProgress(pe.topicName()) && BoxesRunTime.unboxToBoolean((Object)intersect2.apply((Object)tp))) {
                            responseCallback$1_partitionErrorsForDeletingTopics.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Errors.forCode((short)pe.errorCode())));
                            return;
                        }
                    });
                    if ($anonfun$sendStopReplicaRequests$10_responseCallback$1_partitionErrorsForDeletingTopics.nonEmpty()) {
                        $this.handleStopReplicaResponse($anonfun$sendStopReplicaRequests$10_responseCallback$1_stopReplicaResponse, brokerId, (scala.collection.immutable.Map<TopicPartition, Errors>)$anonfun$sendStopReplicaRequests$10_responseCallback$1_partitionErrorsForDeletingTopics.toMap(Predef$.MODULE$.$conforms()));
                    }
                    return BoxedUnit.UNIT;
                });
                return;
            }
            IntRef numPartitionStateWithDelete = IntRef.create((int)0);
            IntRef numPartitionStateWithoutDelete = IntRef.create((int)0);
            scala.collection.mutable.Map topicStatesWithDelete = Map$.MODULE$.empty();
            scala.collection.mutable.Map topicStatesWithoutDelete = Map$.MODULE$.empty();
            Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, partitionState) -> BoxesRunTime.boxToBoolean((boolean)AbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$11(numPartitionStateWithDelete, topicStatesWithDelete, numPartitionStateWithoutDelete, topicStatesWithoutDelete, topicPartition, partitionState));
            Map map = Implicits$.MODULE$.MapExtensionMethods(partitionStates);
            if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
            if (topicStatesWithDelete.nonEmpty()) {
                stateChangeLog$2.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Sending StopReplica request (delete = true) for ").append(numPartitionStateWithDelete$1.elem).append(" replicas to broker ").append(brokerId).toString());
                StopReplicaRequest.Builder stopReplicaRequestBuilder = new StopReplicaRequest.Builder(stopReplicaRequestVersion$1, $this.controllerId(), controllerEpoch$3, brokerEpoch, true, (java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(topicStatesWithDelete.values().toBuffer()).asJava(), $this.kraftController);
                Function1 & Serializable & scala.Serializable intersect3 = (Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)AbstractControllerBrokerRequestBatch.$anonfun$sendStopReplicaRequests$14(x$16));
                $this.sendRequest(brokerId, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)stopReplicaRequestBuilder, (Function1<AbstractResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                    StopReplicaResponse $anonfun$sendStopReplicaRequests$15_responseCallback$1_stopReplicaResponse = (StopReplicaResponse)response;
                    scala.collection.mutable.Map $anonfun$sendStopReplicaRequests$15_responseCallback$1_partitionErrorsForDeletingTopics = Map$.MODULE$.empty();
                    $anonfun$sendStopReplicaRequests$15_responseCallback$1_stopReplicaResponse.partitionErrors().forEach(pe -> {
                        TopicPartition tp = new TopicPartition(pe.topicName(), pe.partitionIndex());
                        if (this.metadataInstance().isTopicDeletionInProgress(pe.topicName()) && BoxesRunTime.unboxToBoolean((Object)intersect2.apply((Object)tp))) {
                            responseCallback$1_partitionErrorsForDeletingTopics.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Errors.forCode((short)pe.errorCode())));
                            return;
                        }
                    });
                    if ($anonfun$sendStopReplicaRequests$15_responseCallback$1_partitionErrorsForDeletingTopics.nonEmpty()) {
                        $this.handleStopReplicaResponse($anonfun$sendStopReplicaRequests$15_responseCallback$1_stopReplicaResponse, brokerId, (scala.collection.immutable.Map<TopicPartition, Errors>)$anonfun$sendStopReplicaRequests$15_responseCallback$1_partitionErrorsForDeletingTopics.toMap(Predef$.MODULE$.$conforms()));
                    }
                    return BoxedUnit.UNIT;
                });
            }
            if (topicStatesWithoutDelete.nonEmpty()) {
                stateChangeLog$2.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Sending StopReplica request (delete = false) for ").append(numPartitionStateWithoutDelete$1.elem).append(" replicas to broker ").append(brokerId).toString());
                StopReplicaRequest.Builder stopReplicaRequestBuilder = new StopReplicaRequest.Builder(stopReplicaRequestVersion$1, $this.controllerId(), controllerEpoch$3, brokerEpoch, false, (java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(topicStatesWithoutDelete.values().toBuffer()).asJava(), $this.kraftController);
                $this.sendRequest(brokerId, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)stopReplicaRequestBuilder, $this.sendRequest$default$3());
                return;
            }
            return;
        }
    }

    public AbstractControllerBrokerRequestBatch(KafkaConfig config, Function0<ControllerChannelContext> metadataProvider, Function0<MetadataVersion> metadataVersionProvider, StateChangeLogger stateChangeLogger, boolean kraftController) {
        this.config = config;
        this.metadataProvider = metadataProvider;
        this.metadataVersionProvider = metadataVersionProvider;
        this.stateChangeLogger = stateChangeLogger;
        this.kraftController = kraftController;
        Logging.$init$(this);
        this.controllerId = config.brokerId();
        this.leaderAndIsrRequestMap = Map$.MODULE$.empty();
        this.stopReplicaRequestMap = Map$.MODULE$.empty();
        this.updateMetadataRequestBrokerSet = scala.collection.mutable.Set$.MODULE$.empty();
        this.updateMetadataRequestPartitionInfoMap = Map$.MODULE$.empty();
        this.updateType = AbstractControlRequest.Type.UNKNOWN;
    }

    public static final /* synthetic */ Object $anonfun$sendLeaderAndIsrRequest$1$adapted(AbstractControllerBrokerRequestBatch $this, StateChangeLogger stateChangeLog$1, short leaderAndIsrRequestVersion$1, int controllerEpoch$1, Object broker, scala.collection.mutable.Map leaderAndIsrPartitionStates) {
        AbstractControllerBrokerRequestBatch.$anonfun$sendLeaderAndIsrRequest$1($this, stateChangeLog$1, leaderAndIsrRequestVersion$1, controllerEpoch$1, BoxesRunTime.unboxToInt((Object)broker), leaderAndIsrPartitionStates);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$sendUpdateMetadataRequests$6$adapted(Map eta$0$1$1, String key) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.contains((Object)key));
    }
}

