/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.parse.zip;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.metadata.Metadata;
import org.apache.nutch.parse.Outlink;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.parse.ParseData;
import org.apache.nutch.parse.ParseImpl;
import org.apache.nutch.parse.ParseResult;
import org.apache.nutch.parse.ParseStatus;
import org.apache.nutch.parse.Parser;
import org.apache.nutch.parse.zip.ZipTextExtractor;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.util.NutchConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipParser
implements Parser {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Configuration conf;

    public ParseResult getParse(Content content) {
        String resultText = null;
        String resultTitle = null;
        Outlink[] outlinks = null;
        ArrayList<Outlink> outLinksList = new ArrayList<Outlink>();
        try {
            String contentLen = content.getMetadata().get("Content-Length");
            int len = Integer.parseInt(contentLen);
            LOG.debug("ziplen: {}", (Object)len);
            byte[] contentInBytes = content.getContent();
            if (contentLen != null && contentInBytes.length != len) {
                return new ParseStatus(2, 202, "Content truncated at " + contentInBytes.length + " bytes. Parser can't handle incomplete zip file.").getEmptyParseResult(content.getUrl(), this.getConf());
            }
            ZipTextExtractor extractor = new ZipTextExtractor(this.getConf());
            resultText = extractor.extractText(new ByteArrayInputStream(contentInBytes), content.getUrl(), outLinksList);
        }
        catch (Exception e) {
            return new ParseStatus(2, "Can't be handled as Zip document. " + String.valueOf(e)).getEmptyParseResult(content.getUrl(), this.getConf());
        }
        if (resultText == null) {
            resultText = "";
        }
        if (resultTitle == null) {
            resultTitle = "";
        }
        outlinks = outLinksList.toArray(new Outlink[0]);
        ParseData parseData = new ParseData(ParseStatus.STATUS_SUCCESS, resultTitle, outlinks, content.getMetadata());
        LOG.trace("Zip file parsed sucessfully.");
        return ParseResult.createParseResult((String)content.getUrl(), (Parse)new ParseImpl(resultText, parseData));
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("ZipParser <zip_file>");
            System.exit(1);
        }
        File file = new File(args[0]);
        String url = "file:" + file.getCanonicalPath();
        FileInputStream in = new FileInputStream(file);
        byte[] bytes = new byte[in.available()];
        in.read(bytes);
        in.close();
        Configuration conf = NutchConfiguration.create();
        ZipParser parser = new ZipParser();
        parser.setConf(conf);
        Metadata meta = new Metadata();
        meta.add("Content-Length", "" + file.length());
        ParseResult parseResult = parser.getParse(new Content(url, url, bytes, "application/zip", meta, conf));
        Parse p = parseResult.get(url);
        System.out.println(parseResult.size());
        System.out.println("Parse Text:");
        System.out.println(p.getText());
        System.out.println("Parse Data:");
        System.out.println(p.getData());
    }
}

