/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.krb;

import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.login.AppConfigurationEntry;

public interface KerberosUser {
    public void login();

    public void logout();

    public <T> T doAs(PrivilegedAction<T> var1) throws IllegalStateException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T doAs(PrivilegedAction<T> action, ClassLoader contextClassLoader) throws IllegalStateException {
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(contextClassLoader);
        try {
            T t = this.doAs(action);
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
    }

    public <T> T doAs(PrivilegedExceptionAction<T> var1) throws IllegalStateException, PrivilegedActionException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T doAs(PrivilegedExceptionAction<T> action, ClassLoader contextClassLoader) throws IllegalStateException, PrivilegedActionException {
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(contextClassLoader);
        try {
            T t = this.doAs(action);
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
    }

    public boolean checkTGTAndRelogin();

    public boolean isLoggedIn();

    public String getPrincipal();

    public AppConfigurationEntry getConfigurationEntry();
}

