/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javac.api;

import java.util.HashMap;
import jpt.sun.source.doctree.EntityTree;
import jpt.sun.tools.javac.util.StringUtils;

class Entity {
    private static final HashMap<String, String> entities = new HashMap();

    Entity() {
    }

    private static void put(String name, char c) {
        entities.put(name, String.valueOf(c));
    }

    private static void put(String name, char c1, char c2) {
        entities.put(name, String.valueOf(new char[]{c1, c2}));
    }

    static String getCharacters(EntityTree tree) {
        String name = tree.getName().toString();
        if (name.startsWith("#")) {
            try {
                int v;
                int n = v = StringUtils.toLowerCase(name).startsWith("#x") ? Integer.parseInt(name.substring(2), 16) : Integer.parseInt(name.substring(1), 10);
                if (!(!Character.isDefined(v) || Character.isISOControl(v) && !Character.isSpaceChar(v) || v >= 55296 && v <= 57343)) {
                    return String.valueOf((char)v);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return null;
        }
        return entities.get(name);
    }

    static {
        Entity.put("Aacute", '\u00c1');
        Entity.put("aacute", '\u00e1');
        Entity.put("Abreve", '\u0102');
        Entity.put("abreve", '\u0103');
        Entity.put("ac", '\u223e');
        Entity.put("acd", '\u223f');
        Entity.put("acE", '\u223e', '\u0333');
        Entity.put("Acirc", '\u00c2');
        Entity.put("acirc", '\u00e2');
        Entity.put("acute", '\u00b4');
        Entity.put("Acy", '\u0410');
        Entity.put("acy", '\u0430');
        Entity.put("AElig", '\u00c6');
        Entity.put("aelig", '\u00e6');
        Entity.put("af", '\u2061');
        Entity.put("Afr", '\ud835', '\udd04');
        Entity.put("afr", '\ud835', '\udd1e');
        Entity.put("Agrave", '\u00c0');
        Entity.put("agrave", '\u00e0');
        Entity.put("alefsym", '\u2135');
        Entity.put("aleph", '\u2135');
        Entity.put("Alpha", '\u0391');
        Entity.put("alpha", '\u03b1');
        Entity.put("Amacr", '\u0100');
        Entity.put("amacr", '\u0101');
        Entity.put("amalg", '\u2a3f');
        Entity.put("amp", '&');
        Entity.put("AMP", '&');
        Entity.put("andand", '\u2a55');
        Entity.put("And", '\u2a53');
        Entity.put("and", '\u2227');
        Entity.put("andd", '\u2a5c');
        Entity.put("andslope", '\u2a58');
        Entity.put("andv", '\u2a5a');
        Entity.put("ang", '\u2220');
        Entity.put("ange", '\u29a4');
        Entity.put("angle", '\u2220');
        Entity.put("angmsdaa", '\u29a8');
        Entity.put("angmsdab", '\u29a9');
        Entity.put("angmsdac", '\u29aa');
        Entity.put("angmsdad", '\u29ab');
        Entity.put("angmsdae", '\u29ac');
        Entity.put("angmsdaf", '\u29ad');
        Entity.put("angmsdag", '\u29ae');
        Entity.put("angmsdah", '\u29af');
        Entity.put("angmsd", '\u2221');
        Entity.put("angrt", '\u221f');
        Entity.put("angrtvb", '\u22be');
        Entity.put("angrtvbd", '\u299d');
        Entity.put("angsph", '\u2222');
        Entity.put("angst", '\u00c5');
        Entity.put("angzarr", '\u237c');
        Entity.put("Aogon", '\u0104');
        Entity.put("aogon", '\u0105');
        Entity.put("Aopf", '\ud835', '\udd38');
        Entity.put("aopf", '\ud835', '\udd52');
        Entity.put("apacir", '\u2a6f');
        Entity.put("ap", '\u2248');
        Entity.put("apE", '\u2a70');
        Entity.put("ape", '\u224a');
        Entity.put("apid", '\u224b');
        Entity.put("apos", '\'');
        Entity.put("ApplyFunction", '\u2061');
        Entity.put("approx", '\u2248');
        Entity.put("approxeq", '\u224a');
        Entity.put("Aring", '\u00c5');
        Entity.put("aring", '\u00e5');
        Entity.put("Ascr", '\ud835', '\udc9c');
        Entity.put("ascr", '\ud835', '\udcb6');
        Entity.put("Assign", '\u2254');
        Entity.put("ast", '*');
        Entity.put("asymp", '\u2248');
        Entity.put("asympeq", '\u224d');
        Entity.put("Atilde", '\u00c3');
        Entity.put("atilde", '\u00e3');
        Entity.put("Auml", '\u00c4');
        Entity.put("auml", '\u00e4');
        Entity.put("awconint", '\u2233');
        Entity.put("awint", '\u2a11');
        Entity.put("backcong", '\u224c');
        Entity.put("backepsilon", '\u03f6');
        Entity.put("backprime", '\u2035');
        Entity.put("backsim", '\u223d');
        Entity.put("backsimeq", '\u22cd');
        Entity.put("Backslash", '\u2216');
        Entity.put("Barv", '\u2ae7');
        Entity.put("barvee", '\u22bd');
        Entity.put("barwed", '\u2305');
        Entity.put("Barwed", '\u2306');
        Entity.put("barwedge", '\u2305');
        Entity.put("bbrk", '\u23b5');
        Entity.put("bbrktbrk", '\u23b6');
        Entity.put("bcong", '\u224c');
        Entity.put("Bcy", '\u0411');
        Entity.put("bcy", '\u0431');
        Entity.put("bdquo", '\u201e');
        Entity.put("becaus", '\u2235');
        Entity.put("because", '\u2235');
        Entity.put("Because", '\u2235');
        Entity.put("bemptyv", '\u29b0');
        Entity.put("bepsi", '\u03f6');
        Entity.put("bernou", '\u212c');
        Entity.put("Bernoullis", '\u212c');
        Entity.put("Beta", '\u0392');
        Entity.put("beta", '\u03b2');
        Entity.put("beth", '\u2136');
        Entity.put("between", '\u226c');
        Entity.put("Bfr", '\ud835', '\udd05');
        Entity.put("bfr", '\ud835', '\udd1f');
        Entity.put("bigcap", '\u22c2');
        Entity.put("bigcirc", '\u25ef');
        Entity.put("bigcup", '\u22c3');
        Entity.put("bigodot", '\u2a00');
        Entity.put("bigoplus", '\u2a01');
        Entity.put("bigotimes", '\u2a02');
        Entity.put("bigsqcup", '\u2a06');
        Entity.put("bigstar", '\u2605');
        Entity.put("bigtriangledown", '\u25bd');
        Entity.put("bigtriangleup", '\u25b3');
        Entity.put("biguplus", '\u2a04');
        Entity.put("bigvee", '\u22c1');
        Entity.put("bigwedge", '\u22c0');
        Entity.put("bkarow", '\u290d');
        Entity.put("blacklozenge", '\u29eb');
        Entity.put("blacksquare", '\u25aa');
        Entity.put("blacktriangle", '\u25b4');
        Entity.put("blacktriangledown", '\u25be');
        Entity.put("blacktriangleleft", '\u25c2');
        Entity.put("blacktriangleright", '\u25b8');
        Entity.put("blank", '\u2423');
        Entity.put("blk12", '\u2592');
        Entity.put("blk14", '\u2591');
        Entity.put("blk34", '\u2593');
        Entity.put("block", '\u2588');
        Entity.put("bne", '=', '\u20e5');
        Entity.put("bnequiv", '\u2261', '\u20e5');
        Entity.put("bNot", '\u2aed');
        Entity.put("bnot", '\u2310');
        Entity.put("Bopf", '\ud835', '\udd39');
        Entity.put("bopf", '\ud835', '\udd53');
        Entity.put("bot", '\u22a5');
        Entity.put("bottom", '\u22a5');
        Entity.put("bowtie", '\u22c8');
        Entity.put("boxbox", '\u29c9');
        Entity.put("boxdl", '\u2510');
        Entity.put("boxdL", '\u2555');
        Entity.put("boxDl", '\u2556');
        Entity.put("boxDL", '\u2557');
        Entity.put("boxdr", '\u250c');
        Entity.put("boxdR", '\u2552');
        Entity.put("boxDr", '\u2553');
        Entity.put("boxDR", '\u2554');
        Entity.put("boxh", '\u2500');
        Entity.put("boxH", '\u2550');
        Entity.put("boxhd", '\u252c');
        Entity.put("boxHd", '\u2564');
        Entity.put("boxhD", '\u2565');
        Entity.put("boxHD", '\u2566');
        Entity.put("boxhu", '\u2534');
        Entity.put("boxHu", '\u2567');
        Entity.put("boxhU", '\u2568');
        Entity.put("boxHU", '\u2569');
        Entity.put("boxminus", '\u229f');
        Entity.put("boxplus", '\u229e');
        Entity.put("boxtimes", '\u22a0');
        Entity.put("boxul", '\u2518');
        Entity.put("boxuL", '\u255b');
        Entity.put("boxUl", '\u255c');
        Entity.put("boxUL", '\u255d');
        Entity.put("boxur", '\u2514');
        Entity.put("boxuR", '\u2558');
        Entity.put("boxUr", '\u2559');
        Entity.put("boxUR", '\u255a');
        Entity.put("boxv", '\u2502');
        Entity.put("boxV", '\u2551');
        Entity.put("boxvh", '\u253c');
        Entity.put("boxvH", '\u256a');
        Entity.put("boxVh", '\u256b');
        Entity.put("boxVH", '\u256c');
        Entity.put("boxvl", '\u2524');
        Entity.put("boxvL", '\u2561');
        Entity.put("boxVl", '\u2562');
        Entity.put("boxVL", '\u2563');
        Entity.put("boxvr", '\u251c');
        Entity.put("boxvR", '\u255e');
        Entity.put("boxVr", '\u255f');
        Entity.put("boxVR", '\u2560');
        Entity.put("bprime", '\u2035');
        Entity.put("breve", '\u02d8');
        Entity.put("Breve", '\u02d8');
        Entity.put("brvbar", '\u00a6');
        Entity.put("bscr", '\ud835', '\udcb7');
        Entity.put("Bscr", '\u212c');
        Entity.put("bsemi", '\u204f');
        Entity.put("bsim", '\u223d');
        Entity.put("bsime", '\u22cd');
        Entity.put("bsolb", '\u29c5');
        Entity.put("bsol", '\\');
        Entity.put("bsolhsub", '\u27c8');
        Entity.put("bull", '\u2022');
        Entity.put("bullet", '\u2022');
        Entity.put("bump", '\u224e');
        Entity.put("bumpE", '\u2aae');
        Entity.put("bumpe", '\u224f');
        Entity.put("Bumpeq", '\u224e');
        Entity.put("bumpeq", '\u224f');
        Entity.put("Cacute", '\u0106');
        Entity.put("cacute", '\u0107');
        Entity.put("capand", '\u2a44');
        Entity.put("capbrcup", '\u2a49');
        Entity.put("capcap", '\u2a4b');
        Entity.put("cap", '\u2229');
        Entity.put("Cap", '\u22d2');
        Entity.put("capcup", '\u2a47');
        Entity.put("capdot", '\u2a40');
        Entity.put("CapitalDifferentialD", '\u2145');
        Entity.put("caps", '\u2229', '\ufe00');
        Entity.put("caret", '\u2041');
        Entity.put("caron", '\u02c7');
        Entity.put("Cayleys", '\u212d');
        Entity.put("ccaps", '\u2a4d');
        Entity.put("Ccaron", '\u010c');
        Entity.put("ccaron", '\u010d');
        Entity.put("Ccedil", '\u00c7');
        Entity.put("ccedil", '\u00e7');
        Entity.put("Ccirc", '\u0108');
        Entity.put("ccirc", '\u0109');
        Entity.put("Cconint", '\u2230');
        Entity.put("ccups", '\u2a4c');
        Entity.put("ccupssm", '\u2a50');
        Entity.put("Cdot", '\u010a');
        Entity.put("cdot", '\u010b');
        Entity.put("cedil", '\u00b8');
        Entity.put("Cedilla", '\u00b8');
        Entity.put("cemptyv", '\u29b2');
        Entity.put("cent", '\u00a2');
        Entity.put("centerdot", '\u00b7');
        Entity.put("CenterDot", '\u00b7');
        Entity.put("cfr", '\ud835', '\udd20');
        Entity.put("Cfr", '\u212d');
        Entity.put("CHcy", '\u0427');
        Entity.put("chcy", '\u0447');
        Entity.put("check", '\u2713');
        Entity.put("checkmark", '\u2713');
        Entity.put("Chi", '\u03a7');
        Entity.put("chi", '\u03c7');
        Entity.put("circ", '\u02c6');
        Entity.put("circeq", '\u2257');
        Entity.put("circlearrowleft", '\u21ba');
        Entity.put("circlearrowright", '\u21bb');
        Entity.put("circledast", '\u229b');
        Entity.put("circledcirc", '\u229a');
        Entity.put("circleddash", '\u229d');
        Entity.put("CircleDot", '\u2299');
        Entity.put("circledR", '\u00ae');
        Entity.put("circledS", '\u24c8');
        Entity.put("CircleMinus", '\u2296');
        Entity.put("CirclePlus", '\u2295');
        Entity.put("CircleTimes", '\u2297');
        Entity.put("cir", '\u25cb');
        Entity.put("cirE", '\u29c3');
        Entity.put("cire", '\u2257');
        Entity.put("cirfnint", '\u2a10');
        Entity.put("cirmid", '\u2aef');
        Entity.put("cirscir", '\u29c2');
        Entity.put("ClockwiseContourIntegral", '\u2232');
        Entity.put("CloseCurlyDoubleQuote", '\u201d');
        Entity.put("CloseCurlyQuote", '\u2019');
        Entity.put("clubs", '\u2663');
        Entity.put("clubsuit", '\u2663');
        Entity.put("colon", ':');
        Entity.put("Colon", '\u2237');
        Entity.put("Colone", '\u2a74');
        Entity.put("colone", '\u2254');
        Entity.put("coloneq", '\u2254');
        Entity.put("comma", ',');
        Entity.put("commat", '@');
        Entity.put("comp", '\u2201');
        Entity.put("compfn", '\u2218');
        Entity.put("complement", '\u2201');
        Entity.put("complexes", '\u2102');
        Entity.put("cong", '\u2245');
        Entity.put("congdot", '\u2a6d');
        Entity.put("Congruent", '\u2261');
        Entity.put("conint", '\u222e');
        Entity.put("Conint", '\u222f');
        Entity.put("ContourIntegral", '\u222e');
        Entity.put("copf", '\ud835', '\udd54');
        Entity.put("Copf", '\u2102');
        Entity.put("coprod", '\u2210');
        Entity.put("Coproduct", '\u2210');
        Entity.put("copy", '\u00a9');
        Entity.put("COPY", '\u00a9');
        Entity.put("copysr", '\u2117');
        Entity.put("CounterClockwiseContourIntegral", '\u2233');
        Entity.put("crarr", '\u21b5');
        Entity.put("cross", '\u2717');
        Entity.put("Cross", '\u2a2f');
        Entity.put("Cscr", '\ud835', '\udc9e');
        Entity.put("cscr", '\ud835', '\udcb8');
        Entity.put("csub", '\u2acf');
        Entity.put("csube", '\u2ad1');
        Entity.put("csup", '\u2ad0');
        Entity.put("csupe", '\u2ad2');
        Entity.put("ctdot", '\u22ef');
        Entity.put("cudarrl", '\u2938');
        Entity.put("cudarrr", '\u2935');
        Entity.put("cuepr", '\u22de');
        Entity.put("cuesc", '\u22df');
        Entity.put("cularr", '\u21b6');
        Entity.put("cularrp", '\u293d');
        Entity.put("cupbrcap", '\u2a48');
        Entity.put("cupcap", '\u2a46');
        Entity.put("CupCap", '\u224d');
        Entity.put("cup", '\u222a');
        Entity.put("Cup", '\u22d3');
        Entity.put("cupcup", '\u2a4a');
        Entity.put("cupdot", '\u228d');
        Entity.put("cupor", '\u2a45');
        Entity.put("cups", '\u222a', '\ufe00');
        Entity.put("curarr", '\u21b7');
        Entity.put("curarrm", '\u293c');
        Entity.put("curlyeqprec", '\u22de');
        Entity.put("curlyeqsucc", '\u22df');
        Entity.put("curlyvee", '\u22ce');
        Entity.put("curlywedge", '\u22cf');
        Entity.put("curren", '\u00a4');
        Entity.put("curvearrowleft", '\u21b6');
        Entity.put("curvearrowright", '\u21b7');
        Entity.put("cuvee", '\u22ce');
        Entity.put("cuwed", '\u22cf');
        Entity.put("cwconint", '\u2232');
        Entity.put("cwint", '\u2231');
        Entity.put("cylcty", '\u232d');
        Entity.put("dagger", '\u2020');
        Entity.put("Dagger", '\u2021');
        Entity.put("daleth", '\u2138');
        Entity.put("darr", '\u2193');
        Entity.put("Darr", '\u21a1');
        Entity.put("dArr", '\u21d3');
        Entity.put("dash", '\u2010');
        Entity.put("Dashv", '\u2ae4');
        Entity.put("dashv", '\u22a3');
        Entity.put("dbkarow", '\u290f');
        Entity.put("dblac", '\u02dd');
        Entity.put("Dcaron", '\u010e');
        Entity.put("dcaron", '\u010f');
        Entity.put("Dcy", '\u0414');
        Entity.put("dcy", '\u0434');
        Entity.put("ddagger", '\u2021');
        Entity.put("ddarr", '\u21ca');
        Entity.put("DD", '\u2145');
        Entity.put("dd", '\u2146');
        Entity.put("DDotrahd", '\u2911');
        Entity.put("ddotseq", '\u2a77');
        Entity.put("deg", '\u00b0');
        Entity.put("Del", '\u2207');
        Entity.put("Delta", '\u0394');
        Entity.put("delta", '\u03b4');
        Entity.put("demptyv", '\u29b1');
        Entity.put("dfisht", '\u297f');
        Entity.put("Dfr", '\ud835', '\udd07');
        Entity.put("dfr", '\ud835', '\udd21');
        Entity.put("dHar", '\u2965');
        Entity.put("dharl", '\u21c3');
        Entity.put("dharr", '\u21c2');
        Entity.put("DiacriticalAcute", '\u00b4');
        Entity.put("DiacriticalDot", '\u02d9');
        Entity.put("DiacriticalDoubleAcute", '\u02dd');
        Entity.put("DiacriticalGrave", '`');
        Entity.put("DiacriticalTilde", '\u02dc');
        Entity.put("diam", '\u22c4');
        Entity.put("diamond", '\u22c4');
        Entity.put("Diamond", '\u22c4');
        Entity.put("diamondsuit", '\u2666');
        Entity.put("diams", '\u2666');
        Entity.put("die", '\u00a8');
        Entity.put("DifferentialD", '\u2146');
        Entity.put("digamma", '\u03dd');
        Entity.put("disin", '\u22f2');
        Entity.put("div", '\u00f7');
        Entity.put("divide", '\u00f7');
        Entity.put("divideontimes", '\u22c7');
        Entity.put("divonx", '\u22c7');
        Entity.put("DJcy", '\u0402');
        Entity.put("djcy", '\u0452');
        Entity.put("dlcorn", '\u231e');
        Entity.put("dlcrop", '\u230d');
        Entity.put("dollar", '$');
        Entity.put("Dopf", '\ud835', '\udd3b');
        Entity.put("dopf", '\ud835', '\udd55');
        Entity.put("Dot", '\u00a8');
        Entity.put("dot", '\u02d9');
        Entity.put("DotDot", '\u20dc');
        Entity.put("doteq", '\u2250');
        Entity.put("doteqdot", '\u2251');
        Entity.put("DotEqual", '\u2250');
        Entity.put("dotminus", '\u2238');
        Entity.put("dotplus", '\u2214');
        Entity.put("dotsquare", '\u22a1');
        Entity.put("doublebarwedge", '\u2306');
        Entity.put("DoubleContourIntegral", '\u222f');
        Entity.put("DoubleDot", '\u00a8');
        Entity.put("DoubleDownArrow", '\u21d3');
        Entity.put("DoubleLeftArrow", '\u21d0');
        Entity.put("DoubleLeftRightArrow", '\u21d4');
        Entity.put("DoubleLeftTee", '\u2ae4');
        Entity.put("DoubleLongLeftArrow", '\u27f8');
        Entity.put("DoubleLongLeftRightArrow", '\u27fa');
        Entity.put("DoubleLongRightArrow", '\u27f9');
        Entity.put("DoubleRightArrow", '\u21d2');
        Entity.put("DoubleRightTee", '\u22a8');
        Entity.put("DoubleUpArrow", '\u21d1');
        Entity.put("DoubleUpDownArrow", '\u21d5');
        Entity.put("DoubleVerticalBar", '\u2225');
        Entity.put("DownArrowBar", '\u2913');
        Entity.put("downarrow", '\u2193');
        Entity.put("DownArrow", '\u2193');
        Entity.put("Downarrow", '\u21d3');
        Entity.put("DownArrowUpArrow", '\u21f5');
        Entity.put("DownBreve", '\u0311');
        Entity.put("downdownarrows", '\u21ca');
        Entity.put("downharpoonleft", '\u21c3');
        Entity.put("downharpoonright", '\u21c2');
        Entity.put("DownLeftRightVector", '\u2950');
        Entity.put("DownLeftTeeVector", '\u295e');
        Entity.put("DownLeftVectorBar", '\u2956');
        Entity.put("DownLeftVector", '\u21bd');
        Entity.put("DownRightTeeVector", '\u295f');
        Entity.put("DownRightVectorBar", '\u2957');
        Entity.put("DownRightVector", '\u21c1');
        Entity.put("DownTeeArrow", '\u21a7');
        Entity.put("DownTee", '\u22a4');
        Entity.put("drbkarow", '\u2910');
        Entity.put("drcorn", '\u231f');
        Entity.put("drcrop", '\u230c');
        Entity.put("Dscr", '\ud835', '\udc9f');
        Entity.put("dscr", '\ud835', '\udcb9');
        Entity.put("DScy", '\u0405');
        Entity.put("dscy", '\u0455');
        Entity.put("dsol", '\u29f6');
        Entity.put("Dstrok", '\u0110');
        Entity.put("dstrok", '\u0111');
        Entity.put("dtdot", '\u22f1');
        Entity.put("dtri", '\u25bf');
        Entity.put("dtrif", '\u25be');
        Entity.put("duarr", '\u21f5');
        Entity.put("duhar", '\u296f');
        Entity.put("dwangle", '\u29a6');
        Entity.put("DZcy", '\u040f');
        Entity.put("dzcy", '\u045f');
        Entity.put("dzigrarr", '\u27ff');
        Entity.put("Eacute", '\u00c9');
        Entity.put("eacute", '\u00e9');
        Entity.put("easter", '\u2a6e');
        Entity.put("Ecaron", '\u011a');
        Entity.put("ecaron", '\u011b');
        Entity.put("Ecirc", '\u00ca');
        Entity.put("ecirc", '\u00ea');
        Entity.put("ecir", '\u2256');
        Entity.put("ecolon", '\u2255');
        Entity.put("Ecy", '\u042d');
        Entity.put("ecy", '\u044d');
        Entity.put("eDDot", '\u2a77');
        Entity.put("Edot", '\u0116');
        Entity.put("edot", '\u0117');
        Entity.put("eDot", '\u2251');
        Entity.put("ee", '\u2147');
        Entity.put("efDot", '\u2252');
        Entity.put("Efr", '\ud835', '\udd08');
        Entity.put("efr", '\ud835', '\udd22');
        Entity.put("eg", '\u2a9a');
        Entity.put("Egrave", '\u00c8');
        Entity.put("egrave", '\u00e8');
        Entity.put("egs", '\u2a96');
        Entity.put("egsdot", '\u2a98');
        Entity.put("el", '\u2a99');
        Entity.put("Element", '\u2208');
        Entity.put("elinters", '\u23e7');
        Entity.put("ell", '\u2113');
        Entity.put("els", '\u2a95');
        Entity.put("elsdot", '\u2a97');
        Entity.put("Emacr", '\u0112');
        Entity.put("emacr", '\u0113');
        Entity.put("empty", '\u2205');
        Entity.put("emptyset", '\u2205');
        Entity.put("EmptySmallSquare", '\u25fb');
        Entity.put("emptyv", '\u2205');
        Entity.put("EmptyVerySmallSquare", '\u25ab');
        Entity.put("emsp13", '\u2004');
        Entity.put("emsp14", '\u2005');
        Entity.put("emsp", '\u2003');
        Entity.put("ENG", '\u014a');
        Entity.put("eng", '\u014b');
        Entity.put("ensp", '\u2002');
        Entity.put("Eogon", '\u0118');
        Entity.put("eogon", '\u0119');
        Entity.put("Eopf", '\ud835', '\udd3c');
        Entity.put("eopf", '\ud835', '\udd56');
        Entity.put("epar", '\u22d5');
        Entity.put("eparsl", '\u29e3');
        Entity.put("eplus", '\u2a71');
        Entity.put("epsi", '\u03b5');
        Entity.put("Epsilon", '\u0395');
        Entity.put("epsilon", '\u03b5');
        Entity.put("epsiv", '\u03f5');
        Entity.put("eqcirc", '\u2256');
        Entity.put("eqcolon", '\u2255');
        Entity.put("eqsim", '\u2242');
        Entity.put("eqslantgtr", '\u2a96');
        Entity.put("eqslantless", '\u2a95');
        Entity.put("Equal", '\u2a75');
        Entity.put("equals", '=');
        Entity.put("EqualTilde", '\u2242');
        Entity.put("equest", '\u225f');
        Entity.put("Equilibrium", '\u21cc');
        Entity.put("equiv", '\u2261');
        Entity.put("equivDD", '\u2a78');
        Entity.put("eqvparsl", '\u29e5');
        Entity.put("erarr", '\u2971');
        Entity.put("erDot", '\u2253');
        Entity.put("escr", '\u212f');
        Entity.put("Escr", '\u2130');
        Entity.put("esdot", '\u2250');
        Entity.put("Esim", '\u2a73');
        Entity.put("esim", '\u2242');
        Entity.put("Eta", '\u0397');
        Entity.put("eta", '\u03b7');
        Entity.put("ETH", '\u00d0');
        Entity.put("eth", '\u00f0');
        Entity.put("Euml", '\u00cb');
        Entity.put("euml", '\u00eb');
        Entity.put("euro", '\u20ac');
        Entity.put("excl", '!');
        Entity.put("exist", '\u2203');
        Entity.put("Exists", '\u2203');
        Entity.put("expectation", '\u2130');
        Entity.put("exponentiale", '\u2147');
        Entity.put("ExponentialE", '\u2147');
        Entity.put("fallingdotseq", '\u2252');
        Entity.put("Fcy", '\u0424');
        Entity.put("fcy", '\u0444');
        Entity.put("female", '\u2640');
        Entity.put("ffilig", '\ufb03');
        Entity.put("fflig", '\ufb00');
        Entity.put("ffllig", '\ufb04');
        Entity.put("Ffr", '\ud835', '\udd09');
        Entity.put("ffr", '\ud835', '\udd23');
        Entity.put("filig", '\ufb01');
        Entity.put("FilledSmallSquare", '\u25fc');
        Entity.put("FilledVerySmallSquare", '\u25aa');
        Entity.put("fjlig", 'f', 'j');
        Entity.put("flat", '\u266d');
        Entity.put("fllig", '\ufb02');
        Entity.put("fltns", '\u25b1');
        Entity.put("fnof", '\u0192');
        Entity.put("Fopf", '\ud835', '\udd3d');
        Entity.put("fopf", '\ud835', '\udd57');
        Entity.put("forall", '\u2200');
        Entity.put("ForAll", '\u2200');
        Entity.put("fork", '\u22d4');
        Entity.put("forkv", '\u2ad9');
        Entity.put("Fouriertrf", '\u2131');
        Entity.put("fpartint", '\u2a0d');
        Entity.put("frac12", '\u00bd');
        Entity.put("frac13", '\u2153');
        Entity.put("frac14", '\u00bc');
        Entity.put("frac15", '\u2155');
        Entity.put("frac16", '\u2159');
        Entity.put("frac18", '\u215b');
        Entity.put("frac23", '\u2154');
        Entity.put("frac25", '\u2156');
        Entity.put("frac34", '\u00be');
        Entity.put("frac35", '\u2157');
        Entity.put("frac38", '\u215c');
        Entity.put("frac45", '\u2158');
        Entity.put("frac56", '\u215a');
        Entity.put("frac58", '\u215d');
        Entity.put("frac78", '\u215e');
        Entity.put("frasl", '\u2044');
        Entity.put("frown", '\u2322');
        Entity.put("fscr", '\ud835', '\udcbb');
        Entity.put("Fscr", '\u2131');
        Entity.put("gacute", '\u01f5');
        Entity.put("Gamma", '\u0393');
        Entity.put("gamma", '\u03b3');
        Entity.put("Gammad", '\u03dc');
        Entity.put("gammad", '\u03dd');
        Entity.put("gap", '\u2a86');
        Entity.put("Gbreve", '\u011e');
        Entity.put("gbreve", '\u011f');
        Entity.put("Gcedil", '\u0122');
        Entity.put("Gcirc", '\u011c');
        Entity.put("gcirc", '\u011d');
        Entity.put("Gcy", '\u0413');
        Entity.put("gcy", '\u0433');
        Entity.put("Gdot", '\u0120');
        Entity.put("gdot", '\u0121');
        Entity.put("ge", '\u2265');
        Entity.put("gE", '\u2267');
        Entity.put("gEl", '\u2a8c');
        Entity.put("gel", '\u22db');
        Entity.put("geq", '\u2265');
        Entity.put("geqq", '\u2267');
        Entity.put("geqslant", '\u2a7e');
        Entity.put("gescc", '\u2aa9');
        Entity.put("ges", '\u2a7e');
        Entity.put("gesdot", '\u2a80');
        Entity.put("gesdoto", '\u2a82');
        Entity.put("gesdotol", '\u2a84');
        Entity.put("gesl", '\u22db', '\ufe00');
        Entity.put("gesles", '\u2a94');
        Entity.put("Gfr", '\ud835', '\udd0a');
        Entity.put("gfr", '\ud835', '\udd24');
        Entity.put("gg", '\u226b');
        Entity.put("Gg", '\u22d9');
        Entity.put("ggg", '\u22d9');
        Entity.put("gimel", '\u2137');
        Entity.put("GJcy", '\u0403');
        Entity.put("gjcy", '\u0453');
        Entity.put("gla", '\u2aa5');
        Entity.put("gl", '\u2277');
        Entity.put("glE", '\u2a92');
        Entity.put("glj", '\u2aa4');
        Entity.put("gnap", '\u2a8a');
        Entity.put("gnapprox", '\u2a8a');
        Entity.put("gne", '\u2a88');
        Entity.put("gnE", '\u2269');
        Entity.put("gneq", '\u2a88');
        Entity.put("gneqq", '\u2269');
        Entity.put("gnsim", '\u22e7');
        Entity.put("Gopf", '\ud835', '\udd3e');
        Entity.put("gopf", '\ud835', '\udd58');
        Entity.put("grave", '`');
        Entity.put("GreaterEqual", '\u2265');
        Entity.put("GreaterEqualLess", '\u22db');
        Entity.put("GreaterFullEqual", '\u2267');
        Entity.put("GreaterGreater", '\u2aa2');
        Entity.put("GreaterLess", '\u2277');
        Entity.put("GreaterSlantEqual", '\u2a7e');
        Entity.put("GreaterTilde", '\u2273');
        Entity.put("Gscr", '\ud835', '\udca2');
        Entity.put("gscr", '\u210a');
        Entity.put("gsim", '\u2273');
        Entity.put("gsime", '\u2a8e');
        Entity.put("gsiml", '\u2a90');
        Entity.put("gtcc", '\u2aa7');
        Entity.put("gtcir", '\u2a7a');
        Entity.put("gt", '>');
        Entity.put("GT", '>');
        Entity.put("Gt", '\u226b');
        Entity.put("gtdot", '\u22d7');
        Entity.put("gtlPar", '\u2995');
        Entity.put("gtquest", '\u2a7c');
        Entity.put("gtrapprox", '\u2a86');
        Entity.put("gtrarr", '\u2978');
        Entity.put("gtrdot", '\u22d7');
        Entity.put("gtreqless", '\u22db');
        Entity.put("gtreqqless", '\u2a8c');
        Entity.put("gtrless", '\u2277');
        Entity.put("gtrsim", '\u2273');
        Entity.put("gvertneqq", '\u2269', '\ufe00');
        Entity.put("gvnE", '\u2269', '\ufe00');
        Entity.put("Hacek", '\u02c7');
        Entity.put("hairsp", '\u200a');
        Entity.put("half", '\u00bd');
        Entity.put("hamilt", '\u210b');
        Entity.put("HARDcy", '\u042a');
        Entity.put("hardcy", '\u044a');
        Entity.put("harrcir", '\u2948');
        Entity.put("harr", '\u2194');
        Entity.put("hArr", '\u21d4');
        Entity.put("harrw", '\u21ad');
        Entity.put("Hat", '^');
        Entity.put("hbar", '\u210f');
        Entity.put("Hcirc", '\u0124');
        Entity.put("hcirc", '\u0125');
        Entity.put("hearts", '\u2665');
        Entity.put("heartsuit", '\u2665');
        Entity.put("hellip", '\u2026');
        Entity.put("hercon", '\u22b9');
        Entity.put("hfr", '\ud835', '\udd25');
        Entity.put("Hfr", '\u210c');
        Entity.put("HilbertSpace", '\u210b');
        Entity.put("hksearow", '\u2925');
        Entity.put("hkswarow", '\u2926');
        Entity.put("hoarr", '\u21ff');
        Entity.put("homtht", '\u223b');
        Entity.put("hookleftarrow", '\u21a9');
        Entity.put("hookrightarrow", '\u21aa');
        Entity.put("hopf", '\ud835', '\udd59');
        Entity.put("Hopf", '\u210d');
        Entity.put("horbar", '\u2015');
        Entity.put("HorizontalLine", '\u2500');
        Entity.put("hscr", '\ud835', '\udcbd');
        Entity.put("Hscr", '\u210b');
        Entity.put("hslash", '\u210f');
        Entity.put("Hstrok", '\u0126');
        Entity.put("hstrok", '\u0127');
        Entity.put("HumpDownHump", '\u224e');
        Entity.put("HumpEqual", '\u224f');
        Entity.put("hybull", '\u2043');
        Entity.put("hyphen", '\u2010');
        Entity.put("Iacute", '\u00cd');
        Entity.put("iacute", '\u00ed');
        Entity.put("ic", '\u2063');
        Entity.put("Icirc", '\u00ce');
        Entity.put("icirc", '\u00ee');
        Entity.put("Icy", '\u0418');
        Entity.put("icy", '\u0438');
        Entity.put("Idot", '\u0130');
        Entity.put("IEcy", '\u0415');
        Entity.put("iecy", '\u0435');
        Entity.put("iexcl", '\u00a1');
        Entity.put("iff", '\u21d4');
        Entity.put("ifr", '\ud835', '\udd26');
        Entity.put("Ifr", '\u2111');
        Entity.put("Igrave", '\u00cc');
        Entity.put("igrave", '\u00ec');
        Entity.put("ii", '\u2148');
        Entity.put("iiiint", '\u2a0c');
        Entity.put("iiint", '\u222d');
        Entity.put("iinfin", '\u29dc');
        Entity.put("iiota", '\u2129');
        Entity.put("IJlig", '\u0132');
        Entity.put("ijlig", '\u0133');
        Entity.put("Imacr", '\u012a');
        Entity.put("imacr", '\u012b');
        Entity.put("image", '\u2111');
        Entity.put("ImaginaryI", '\u2148');
        Entity.put("imagline", '\u2110');
        Entity.put("imagpart", '\u2111');
        Entity.put("imath", '\u0131');
        Entity.put("Im", '\u2111');
        Entity.put("imof", '\u22b7');
        Entity.put("imped", '\u01b5');
        Entity.put("Implies", '\u21d2');
        Entity.put("incare", '\u2105');
        Entity.put("in", '\u2208');
        Entity.put("infin", '\u221e');
        Entity.put("infintie", '\u29dd');
        Entity.put("inodot", '\u0131');
        Entity.put("intcal", '\u22ba');
        Entity.put("int", '\u222b');
        Entity.put("Int", '\u222c');
        Entity.put("integers", '\u2124');
        Entity.put("Integral", '\u222b');
        Entity.put("intercal", '\u22ba');
        Entity.put("Intersection", '\u22c2');
        Entity.put("intlarhk", '\u2a17');
        Entity.put("intprod", '\u2a3c');
        Entity.put("InvisibleComma", '\u2063');
        Entity.put("InvisibleTimes", '\u2062');
        Entity.put("IOcy", '\u0401');
        Entity.put("iocy", '\u0451');
        Entity.put("Iogon", '\u012e');
        Entity.put("iogon", '\u012f');
        Entity.put("Iopf", '\ud835', '\udd40');
        Entity.put("iopf", '\ud835', '\udd5a');
        Entity.put("Iota", '\u0399');
        Entity.put("iota", '\u03b9');
        Entity.put("iprod", '\u2a3c');
        Entity.put("iquest", '\u00bf');
        Entity.put("iscr", '\ud835', '\udcbe');
        Entity.put("Iscr", '\u2110');
        Entity.put("isin", '\u2208');
        Entity.put("isindot", '\u22f5');
        Entity.put("isinE", '\u22f9');
        Entity.put("isins", '\u22f4');
        Entity.put("isinsv", '\u22f3');
        Entity.put("isinv", '\u2208');
        Entity.put("it", '\u2062');
        Entity.put("Itilde", '\u0128');
        Entity.put("itilde", '\u0129');
        Entity.put("Iukcy", '\u0406');
        Entity.put("iukcy", '\u0456');
        Entity.put("Iuml", '\u00cf');
        Entity.put("iuml", '\u00ef');
        Entity.put("Jcirc", '\u0134');
        Entity.put("jcirc", '\u0135');
        Entity.put("Jcy", '\u0419');
        Entity.put("jcy", '\u0439');
        Entity.put("Jfr", '\ud835', '\udd0d');
        Entity.put("jfr", '\ud835', '\udd27');
        Entity.put("jmath", '\u0237');
        Entity.put("Jopf", '\ud835', '\udd41');
        Entity.put("jopf", '\ud835', '\udd5b');
        Entity.put("Jscr", '\ud835', '\udca5');
        Entity.put("jscr", '\ud835', '\udcbf');
        Entity.put("Jsercy", '\u0408');
        Entity.put("jsercy", '\u0458');
        Entity.put("Jukcy", '\u0404');
        Entity.put("jukcy", '\u0454');
        Entity.put("Kappa", '\u039a');
        Entity.put("kappa", '\u03ba');
        Entity.put("kappav", '\u03f0');
        Entity.put("Kcedil", '\u0136');
        Entity.put("kcedil", '\u0137');
        Entity.put("Kcy", '\u041a');
        Entity.put("kcy", '\u043a');
        Entity.put("Kfr", '\ud835', '\udd0e');
        Entity.put("kfr", '\ud835', '\udd28');
        Entity.put("kgreen", '\u0138');
        Entity.put("KHcy", '\u0425');
        Entity.put("khcy", '\u0445');
        Entity.put("KJcy", '\u040c');
        Entity.put("kjcy", '\u045c');
        Entity.put("Kopf", '\ud835', '\udd42');
        Entity.put("kopf", '\ud835', '\udd5c');
        Entity.put("Kscr", '\ud835', '\udca6');
        Entity.put("kscr", '\ud835', '\udcc0');
        Entity.put("lAarr", '\u21da');
        Entity.put("Lacute", '\u0139');
        Entity.put("lacute", '\u013a');
        Entity.put("laemptyv", '\u29b4');
        Entity.put("lagran", '\u2112');
        Entity.put("Lambda", '\u039b');
        Entity.put("lambda", '\u03bb');
        Entity.put("lang", '\u27e8');
        Entity.put("Lang", '\u27ea');
        Entity.put("langd", '\u2991');
        Entity.put("langle", '\u27e8');
        Entity.put("lap", '\u2a85');
        Entity.put("Laplacetrf", '\u2112');
        Entity.put("laquo", '\u00ab');
        Entity.put("larrb", '\u21e4');
        Entity.put("larrbfs", '\u291f');
        Entity.put("larr", '\u2190');
        Entity.put("Larr", '\u219e');
        Entity.put("lArr", '\u21d0');
        Entity.put("larrfs", '\u291d');
        Entity.put("larrhk", '\u21a9');
        Entity.put("larrlp", '\u21ab');
        Entity.put("larrpl", '\u2939');
        Entity.put("larrsim", '\u2973');
        Entity.put("larrtl", '\u21a2');
        Entity.put("latail", '\u2919');
        Entity.put("lAtail", '\u291b');
        Entity.put("lat", '\u2aab');
        Entity.put("late", '\u2aad');
        Entity.put("lates", '\u2aad', '\ufe00');
        Entity.put("lbarr", '\u290c');
        Entity.put("lBarr", '\u290e');
        Entity.put("lbbrk", '\u2772');
        Entity.put("lbrace", '{');
        Entity.put("lbrack", '[');
        Entity.put("lbrke", '\u298b');
        Entity.put("lbrksld", '\u298f');
        Entity.put("lbrkslu", '\u298d');
        Entity.put("Lcaron", '\u013d');
        Entity.put("lcaron", '\u013e');
        Entity.put("Lcedil", '\u013b');
        Entity.put("lcedil", '\u013c');
        Entity.put("lceil", '\u2308');
        Entity.put("lcub", '{');
        Entity.put("Lcy", '\u041b');
        Entity.put("lcy", '\u043b');
        Entity.put("ldca", '\u2936');
        Entity.put("ldquo", '\u201c');
        Entity.put("ldquor", '\u201e');
        Entity.put("ldrdhar", '\u2967');
        Entity.put("ldrushar", '\u294b');
        Entity.put("ldsh", '\u21b2');
        Entity.put("le", '\u2264');
        Entity.put("lE", '\u2266');
        Entity.put("LeftAngleBracket", '\u27e8');
        Entity.put("LeftArrowBar", '\u21e4');
        Entity.put("leftarrow", '\u2190');
        Entity.put("LeftArrow", '\u2190');
        Entity.put("Leftarrow", '\u21d0');
        Entity.put("LeftArrowRightArrow", '\u21c6');
        Entity.put("leftarrowtail", '\u21a2');
        Entity.put("LeftCeiling", '\u2308');
        Entity.put("LeftDoubleBracket", '\u27e6');
        Entity.put("LeftDownTeeVector", '\u2961');
        Entity.put("LeftDownVectorBar", '\u2959');
        Entity.put("LeftDownVector", '\u21c3');
        Entity.put("LeftFloor", '\u230a');
        Entity.put("leftharpoondown", '\u21bd');
        Entity.put("leftharpoonup", '\u21bc');
        Entity.put("leftleftarrows", '\u21c7');
        Entity.put("leftrightarrow", '\u2194');
        Entity.put("LeftRightArrow", '\u2194');
        Entity.put("Leftrightarrow", '\u21d4');
        Entity.put("leftrightarrows", '\u21c6');
        Entity.put("leftrightharpoons", '\u21cb');
        Entity.put("leftrightsquigarrow", '\u21ad');
        Entity.put("LeftRightVector", '\u294e');
        Entity.put("LeftTeeArrow", '\u21a4');
        Entity.put("LeftTee", '\u22a3');
        Entity.put("LeftTeeVector", '\u295a');
        Entity.put("leftthreetimes", '\u22cb');
        Entity.put("LeftTriangleBar", '\u29cf');
        Entity.put("LeftTriangle", '\u22b2');
        Entity.put("LeftTriangleEqual", '\u22b4');
        Entity.put("LeftUpDownVector", '\u2951');
        Entity.put("LeftUpTeeVector", '\u2960');
        Entity.put("LeftUpVectorBar", '\u2958');
        Entity.put("LeftUpVector", '\u21bf');
        Entity.put("LeftVectorBar", '\u2952');
        Entity.put("LeftVector", '\u21bc');
        Entity.put("lEg", '\u2a8b');
        Entity.put("leg", '\u22da');
        Entity.put("leq", '\u2264');
        Entity.put("leqq", '\u2266');
        Entity.put("leqslant", '\u2a7d');
        Entity.put("lescc", '\u2aa8');
        Entity.put("les", '\u2a7d');
        Entity.put("lesdot", '\u2a7f');
        Entity.put("lesdoto", '\u2a81');
        Entity.put("lesdotor", '\u2a83');
        Entity.put("lesg", '\u22da', '\ufe00');
        Entity.put("lesges", '\u2a93');
        Entity.put("lessapprox", '\u2a85');
        Entity.put("lessdot", '\u22d6');
        Entity.put("lesseqgtr", '\u22da');
        Entity.put("lesseqqgtr", '\u2a8b');
        Entity.put("LessEqualGreater", '\u22da');
        Entity.put("LessFullEqual", '\u2266');
        Entity.put("LessGreater", '\u2276');
        Entity.put("lessgtr", '\u2276');
        Entity.put("LessLess", '\u2aa1');
        Entity.put("lesssim", '\u2272');
        Entity.put("LessSlantEqual", '\u2a7d');
        Entity.put("LessTilde", '\u2272');
        Entity.put("lfisht", '\u297c');
        Entity.put("lfloor", '\u230a');
        Entity.put("Lfr", '\ud835', '\udd0f');
        Entity.put("lfr", '\ud835', '\udd29');
        Entity.put("lg", '\u2276');
        Entity.put("lgE", '\u2a91');
        Entity.put("lHar", '\u2962');
        Entity.put("lhard", '\u21bd');
        Entity.put("lharu", '\u21bc');
        Entity.put("lharul", '\u296a');
        Entity.put("lhblk", '\u2584');
        Entity.put("LJcy", '\u0409');
        Entity.put("ljcy", '\u0459');
        Entity.put("llarr", '\u21c7');
        Entity.put("ll", '\u226a');
        Entity.put("Ll", '\u22d8');
        Entity.put("llcorner", '\u231e');
        Entity.put("Lleftarrow", '\u21da');
        Entity.put("llhard", '\u296b');
        Entity.put("lltri", '\u25fa');
        Entity.put("Lmidot", '\u013f');
        Entity.put("lmidot", '\u0140');
        Entity.put("lmoustache", '\u23b0');
        Entity.put("lmoust", '\u23b0');
        Entity.put("lnap", '\u2a89');
        Entity.put("lnapprox", '\u2a89');
        Entity.put("lne", '\u2a87');
        Entity.put("lnE", '\u2268');
        Entity.put("lneq", '\u2a87');
        Entity.put("lneqq", '\u2268');
        Entity.put("lnsim", '\u22e6');
        Entity.put("loang", '\u27ec');
        Entity.put("loarr", '\u21fd');
        Entity.put("lobrk", '\u27e6');
        Entity.put("longleftarrow", '\u27f5');
        Entity.put("LongLeftArrow", '\u27f5');
        Entity.put("Longleftarrow", '\u27f8');
        Entity.put("longleftrightarrow", '\u27f7');
        Entity.put("LongLeftRightArrow", '\u27f7');
        Entity.put("Longleftrightarrow", '\u27fa');
        Entity.put("longmapsto", '\u27fc');
        Entity.put("longrightarrow", '\u27f6');
        Entity.put("LongRightArrow", '\u27f6');
        Entity.put("Longrightarrow", '\u27f9');
        Entity.put("looparrowleft", '\u21ab');
        Entity.put("looparrowright", '\u21ac');
        Entity.put("lopar", '\u2985');
        Entity.put("Lopf", '\ud835', '\udd43');
        Entity.put("lopf", '\ud835', '\udd5d');
        Entity.put("loplus", '\u2a2d');
        Entity.put("lotimes", '\u2a34');
        Entity.put("lowast", '\u2217');
        Entity.put("lowbar", '_');
        Entity.put("LowerLeftArrow", '\u2199');
        Entity.put("LowerRightArrow", '\u2198');
        Entity.put("loz", '\u25ca');
        Entity.put("lozenge", '\u25ca');
        Entity.put("lozf", '\u29eb');
        Entity.put("lpar", '(');
        Entity.put("lparlt", '\u2993');
        Entity.put("lrarr", '\u21c6');
        Entity.put("lrcorner", '\u231f');
        Entity.put("lrhar", '\u21cb');
        Entity.put("lrhard", '\u296d');
        Entity.put("lrm", '\u200e');
        Entity.put("lrtri", '\u22bf');
        Entity.put("lsaquo", '\u2039');
        Entity.put("lscr", '\ud835', '\udcc1');
        Entity.put("Lscr", '\u2112');
        Entity.put("lsh", '\u21b0');
        Entity.put("Lsh", '\u21b0');
        Entity.put("lsim", '\u2272');
        Entity.put("lsime", '\u2a8d');
        Entity.put("lsimg", '\u2a8f');
        Entity.put("lsqb", '[');
        Entity.put("lsquo", '\u2018');
        Entity.put("lsquor", '\u201a');
        Entity.put("Lstrok", '\u0141');
        Entity.put("lstrok", '\u0142');
        Entity.put("ltcc", '\u2aa6');
        Entity.put("ltcir", '\u2a79');
        Entity.put("lt", '<');
        Entity.put("LT", '<');
        Entity.put("Lt", '\u226a');
        Entity.put("ltdot", '\u22d6');
        Entity.put("lthree", '\u22cb');
        Entity.put("ltimes", '\u22c9');
        Entity.put("ltlarr", '\u2976');
        Entity.put("ltquest", '\u2a7b');
        Entity.put("ltri", '\u25c3');
        Entity.put("ltrie", '\u22b4');
        Entity.put("ltrif", '\u25c2');
        Entity.put("ltrPar", '\u2996');
        Entity.put("lurdshar", '\u294a');
        Entity.put("luruhar", '\u2966');
        Entity.put("lvertneqq", '\u2268', '\ufe00');
        Entity.put("lvnE", '\u2268', '\ufe00');
        Entity.put("macr", '\u00af');
        Entity.put("male", '\u2642');
        Entity.put("malt", '\u2720');
        Entity.put("maltese", '\u2720');
        Entity.put("Map", '\u2905');
        Entity.put("map", '\u21a6');
        Entity.put("mapsto", '\u21a6');
        Entity.put("mapstodown", '\u21a7');
        Entity.put("mapstoleft", '\u21a4');
        Entity.put("mapstoup", '\u21a5');
        Entity.put("marker", '\u25ae');
        Entity.put("mcomma", '\u2a29');
        Entity.put("Mcy", '\u041c');
        Entity.put("mcy", '\u043c');
        Entity.put("mdash", '\u2014');
        Entity.put("mDDot", '\u223a');
        Entity.put("measuredangle", '\u2221');
        Entity.put("MediumSpace", '\u205f');
        Entity.put("Mellintrf", '\u2133');
        Entity.put("Mfr", '\ud835', '\udd10');
        Entity.put("mfr", '\ud835', '\udd2a');
        Entity.put("mho", '\u2127');
        Entity.put("micro", '\u00b5');
        Entity.put("midast", '*');
        Entity.put("midcir", '\u2af0');
        Entity.put("mid", '\u2223');
        Entity.put("middot", '\u00b7');
        Entity.put("minusb", '\u229f');
        Entity.put("minus", '\u2212');
        Entity.put("minusd", '\u2238');
        Entity.put("minusdu", '\u2a2a');
        Entity.put("MinusPlus", '\u2213');
        Entity.put("mlcp", '\u2adb');
        Entity.put("mldr", '\u2026');
        Entity.put("mnplus", '\u2213');
        Entity.put("models", '\u22a7');
        Entity.put("Mopf", '\ud835', '\udd44');
        Entity.put("mopf", '\ud835', '\udd5e');
        Entity.put("mp", '\u2213');
        Entity.put("mscr", '\ud835', '\udcc2');
        Entity.put("Mscr", '\u2133');
        Entity.put("mstpos", '\u223e');
        Entity.put("Mu", '\u039c');
        Entity.put("mu", '\u03bc');
        Entity.put("multimap", '\u22b8');
        Entity.put("mumap", '\u22b8');
        Entity.put("nabla", '\u2207');
        Entity.put("Nacute", '\u0143');
        Entity.put("nacute", '\u0144');
        Entity.put("nang", '\u2220', '\u20d2');
        Entity.put("nap", '\u2249');
        Entity.put("napE", '\u2a70', '\u0338');
        Entity.put("napid", '\u224b', '\u0338');
        Entity.put("napos", '\u0149');
        Entity.put("napprox", '\u2249');
        Entity.put("natural", '\u266e');
        Entity.put("naturals", '\u2115');
        Entity.put("natur", '\u266e');
        Entity.put("nbsp", '\u00a0');
        Entity.put("nbump", '\u224e', '\u0338');
        Entity.put("nbumpe", '\u224f', '\u0338');
        Entity.put("ncap", '\u2a43');
        Entity.put("Ncaron", '\u0147');
        Entity.put("ncaron", '\u0148');
        Entity.put("Ncedil", '\u0145');
        Entity.put("ncedil", '\u0146');
        Entity.put("ncong", '\u2247');
        Entity.put("ncongdot", '\u2a6d', '\u0338');
        Entity.put("ncup", '\u2a42');
        Entity.put("Ncy", '\u041d');
        Entity.put("ncy", '\u043d');
        Entity.put("ndash", '\u2013');
        Entity.put("nearhk", '\u2924');
        Entity.put("nearr", '\u2197');
        Entity.put("neArr", '\u21d7');
        Entity.put("nearrow", '\u2197');
        Entity.put("ne", '\u2260');
        Entity.put("nedot", '\u2250', '\u0338');
        Entity.put("NegativeMediumSpace", '\u200b');
        Entity.put("NegativeThickSpace", '\u200b');
        Entity.put("NegativeThinSpace", '\u200b');
        Entity.put("NegativeVeryThinSpace", '\u200b');
        Entity.put("nequiv", '\u2262');
        Entity.put("nesear", '\u2928');
        Entity.put("nesim", '\u2242', '\u0338');
        Entity.put("NestedGreaterGreater", '\u226b');
        Entity.put("NestedLessLess", '\u226a');
        Entity.put("NewLine", '\n');
        Entity.put("nexist", '\u2204');
        Entity.put("nexists", '\u2204');
        Entity.put("Nfr", '\ud835', '\udd11');
        Entity.put("nfr", '\ud835', '\udd2b');
        Entity.put("ngE", '\u2267', '\u0338');
        Entity.put("nge", '\u2271');
        Entity.put("ngeq", '\u2271');
        Entity.put("ngeqq", '\u2267', '\u0338');
        Entity.put("ngeqslant", '\u2a7e', '\u0338');
        Entity.put("nges", '\u2a7e', '\u0338');
        Entity.put("nGg", '\u22d9', '\u0338');
        Entity.put("ngsim", '\u2275');
        Entity.put("nGt", '\u226b', '\u20d2');
        Entity.put("ngt", '\u226f');
        Entity.put("ngtr", '\u226f');
        Entity.put("nGtv", '\u226b', '\u0338');
        Entity.put("nharr", '\u21ae');
        Entity.put("nhArr", '\u21ce');
        Entity.put("nhpar", '\u2af2');
        Entity.put("ni", '\u220b');
        Entity.put("nis", '\u22fc');
        Entity.put("nisd", '\u22fa');
        Entity.put("niv", '\u220b');
        Entity.put("NJcy", '\u040a');
        Entity.put("njcy", '\u045a');
        Entity.put("nlarr", '\u219a');
        Entity.put("nlArr", '\u21cd');
        Entity.put("nldr", '\u2025');
        Entity.put("nlE", '\u2266', '\u0338');
        Entity.put("nle", '\u2270');
        Entity.put("nleftarrow", '\u219a');
        Entity.put("nLeftarrow", '\u21cd');
        Entity.put("nleftrightarrow", '\u21ae');
        Entity.put("nLeftrightarrow", '\u21ce');
        Entity.put("nleq", '\u2270');
        Entity.put("nleqq", '\u2266', '\u0338');
        Entity.put("nleqslant", '\u2a7d', '\u0338');
        Entity.put("nles", '\u2a7d', '\u0338');
        Entity.put("nless", '\u226e');
        Entity.put("nLl", '\u22d8', '\u0338');
        Entity.put("nlsim", '\u2274');
        Entity.put("nLt", '\u226a', '\u20d2');
        Entity.put("nlt", '\u226e');
        Entity.put("nltri", '\u22ea');
        Entity.put("nltrie", '\u22ec');
        Entity.put("nLtv", '\u226a', '\u0338');
        Entity.put("nmid", '\u2224');
        Entity.put("NoBreak", '\u2060');
        Entity.put("NonBreakingSpace", '\u00a0');
        Entity.put("nopf", '\ud835', '\udd5f');
        Entity.put("Nopf", '\u2115');
        Entity.put("Not", '\u2aec');
        Entity.put("not", '\u00ac');
        Entity.put("NotCongruent", '\u2262');
        Entity.put("NotCupCap", '\u226d');
        Entity.put("NotDoubleVerticalBar", '\u2226');
        Entity.put("NotElement", '\u2209');
        Entity.put("NotEqual", '\u2260');
        Entity.put("NotEqualTilde", '\u2242', '\u0338');
        Entity.put("NotExists", '\u2204');
        Entity.put("NotGreater", '\u226f');
        Entity.put("NotGreaterEqual", '\u2271');
        Entity.put("NotGreaterFullEqual", '\u2267', '\u0338');
        Entity.put("NotGreaterGreater", '\u226b', '\u0338');
        Entity.put("NotGreaterLess", '\u2279');
        Entity.put("NotGreaterSlantEqual", '\u2a7e', '\u0338');
        Entity.put("NotGreaterTilde", '\u2275');
        Entity.put("NotHumpDownHump", '\u224e', '\u0338');
        Entity.put("NotHumpEqual", '\u224f', '\u0338');
        Entity.put("notin", '\u2209');
        Entity.put("notindot", '\u22f5', '\u0338');
        Entity.put("notinE", '\u22f9', '\u0338');
        Entity.put("notinva", '\u2209');
        Entity.put("notinvb", '\u22f7');
        Entity.put("notinvc", '\u22f6');
        Entity.put("NotLeftTriangleBar", '\u29cf', '\u0338');
        Entity.put("NotLeftTriangle", '\u22ea');
        Entity.put("NotLeftTriangleEqual", '\u22ec');
        Entity.put("NotLess", '\u226e');
        Entity.put("NotLessEqual", '\u2270');
        Entity.put("NotLessGreater", '\u2278');
        Entity.put("NotLessLess", '\u226a', '\u0338');
        Entity.put("NotLessSlantEqual", '\u2a7d', '\u0338');
        Entity.put("NotLessTilde", '\u2274');
        Entity.put("NotNestedGreaterGreater", '\u2aa2', '\u0338');
        Entity.put("NotNestedLessLess", '\u2aa1', '\u0338');
        Entity.put("notni", '\u220c');
        Entity.put("notniva", '\u220c');
        Entity.put("notnivb", '\u22fe');
        Entity.put("notnivc", '\u22fd');
        Entity.put("NotPrecedes", '\u2280');
        Entity.put("NotPrecedesEqual", '\u2aaf', '\u0338');
        Entity.put("NotPrecedesSlantEqual", '\u22e0');
        Entity.put("NotReverseElement", '\u220c');
        Entity.put("NotRightTriangleBar", '\u29d0', '\u0338');
        Entity.put("NotRightTriangle", '\u22eb');
        Entity.put("NotRightTriangleEqual", '\u22ed');
        Entity.put("NotSquareSubset", '\u228f', '\u0338');
        Entity.put("NotSquareSubsetEqual", '\u22e2');
        Entity.put("NotSquareSuperset", '\u2290', '\u0338');
        Entity.put("NotSquareSupersetEqual", '\u22e3');
        Entity.put("NotSubset", '\u2282', '\u20d2');
        Entity.put("NotSubsetEqual", '\u2288');
        Entity.put("NotSucceeds", '\u2281');
        Entity.put("NotSucceedsEqual", '\u2ab0', '\u0338');
        Entity.put("NotSucceedsSlantEqual", '\u22e1');
        Entity.put("NotSucceedsTilde", '\u227f', '\u0338');
        Entity.put("NotSuperset", '\u2283', '\u20d2');
        Entity.put("NotSupersetEqual", '\u2289');
        Entity.put("NotTilde", '\u2241');
        Entity.put("NotTildeEqual", '\u2244');
        Entity.put("NotTildeFullEqual", '\u2247');
        Entity.put("NotTildeTilde", '\u2249');
        Entity.put("NotVerticalBar", '\u2224');
        Entity.put("nparallel", '\u2226');
        Entity.put("npar", '\u2226');
        Entity.put("nparsl", '\u2afd', '\u20e5');
        Entity.put("npart", '\u2202', '\u0338');
        Entity.put("npolint", '\u2a14');
        Entity.put("npr", '\u2280');
        Entity.put("nprcue", '\u22e0');
        Entity.put("nprec", '\u2280');
        Entity.put("npreceq", '\u2aaf', '\u0338');
        Entity.put("npre", '\u2aaf', '\u0338');
        Entity.put("nrarrc", '\u2933', '\u0338');
        Entity.put("nrarr", '\u219b');
        Entity.put("nrArr", '\u21cf');
        Entity.put("nrarrw", '\u219d', '\u0338');
        Entity.put("nrightarrow", '\u219b');
        Entity.put("nRightarrow", '\u21cf');
        Entity.put("nrtri", '\u22eb');
        Entity.put("nrtrie", '\u22ed');
        Entity.put("nsc", '\u2281');
        Entity.put("nsccue", '\u22e1');
        Entity.put("nsce", '\u2ab0', '\u0338');
        Entity.put("Nscr", '\ud835', '\udca9');
        Entity.put("nscr", '\ud835', '\udcc3');
        Entity.put("nshortmid", '\u2224');
        Entity.put("nshortparallel", '\u2226');
        Entity.put("nsim", '\u2241');
        Entity.put("nsime", '\u2244');
        Entity.put("nsimeq", '\u2244');
        Entity.put("nsmid", '\u2224');
        Entity.put("nspar", '\u2226');
        Entity.put("nsqsube", '\u22e2');
        Entity.put("nsqsupe", '\u22e3');
        Entity.put("nsub", '\u2284');
        Entity.put("nsubE", '\u2ac5', '\u0338');
        Entity.put("nsube", '\u2288');
        Entity.put("nsubset", '\u2282', '\u20d2');
        Entity.put("nsubseteq", '\u2288');
        Entity.put("nsubseteqq", '\u2ac5', '\u0338');
        Entity.put("nsucc", '\u2281');
        Entity.put("nsucceq", '\u2ab0', '\u0338');
        Entity.put("nsup", '\u2285');
        Entity.put("nsupE", '\u2ac6', '\u0338');
        Entity.put("nsupe", '\u2289');
        Entity.put("nsupset", '\u2283', '\u20d2');
        Entity.put("nsupseteq", '\u2289');
        Entity.put("nsupseteqq", '\u2ac6', '\u0338');
        Entity.put("ntgl", '\u2279');
        Entity.put("Ntilde", '\u00d1');
        Entity.put("ntilde", '\u00f1');
        Entity.put("ntlg", '\u2278');
        Entity.put("ntriangleleft", '\u22ea');
        Entity.put("ntrianglelefteq", '\u22ec');
        Entity.put("ntriangleright", '\u22eb');
        Entity.put("ntrianglerighteq", '\u22ed');
        Entity.put("Nu", '\u039d');
        Entity.put("nu", '\u03bd');
        Entity.put("num", '#');
        Entity.put("numero", '\u2116');
        Entity.put("numsp", '\u2007');
        Entity.put("nvap", '\u224d', '\u20d2');
        Entity.put("nvdash", '\u22ac');
        Entity.put("nvDash", '\u22ad');
        Entity.put("nVdash", '\u22ae');
        Entity.put("nVDash", '\u22af');
        Entity.put("nvge", '\u2265', '\u20d2');
        Entity.put("nvgt", '>', '\u20d2');
        Entity.put("nvHarr", '\u2904');
        Entity.put("nvinfin", '\u29de');
        Entity.put("nvlArr", '\u2902');
        Entity.put("nvle", '\u2264', '\u20d2');
        Entity.put("nvlt", '<', '\u20d2');
        Entity.put("nvltrie", '\u22b4', '\u20d2');
        Entity.put("nvrArr", '\u2903');
        Entity.put("nvrtrie", '\u22b5', '\u20d2');
        Entity.put("nvsim", '\u223c', '\u20d2');
        Entity.put("nwarhk", '\u2923');
        Entity.put("nwarr", '\u2196');
        Entity.put("nwArr", '\u21d6');
        Entity.put("nwarrow", '\u2196');
        Entity.put("nwnear", '\u2927');
        Entity.put("Oacute", '\u00d3');
        Entity.put("oacute", '\u00f3');
        Entity.put("oast", '\u229b');
        Entity.put("Ocirc", '\u00d4');
        Entity.put("ocirc", '\u00f4');
        Entity.put("ocir", '\u229a');
        Entity.put("Ocy", '\u041e');
        Entity.put("ocy", '\u043e');
        Entity.put("odash", '\u229d');
        Entity.put("Odblac", '\u0150');
        Entity.put("odblac", '\u0151');
        Entity.put("odiv", '\u2a38');
        Entity.put("odot", '\u2299');
        Entity.put("odsold", '\u29bc');
        Entity.put("OElig", '\u0152');
        Entity.put("oelig", '\u0153');
        Entity.put("ofcir", '\u29bf');
        Entity.put("Ofr", '\ud835', '\udd12');
        Entity.put("ofr", '\ud835', '\udd2c');
        Entity.put("ogon", '\u02db');
        Entity.put("Ograve", '\u00d2');
        Entity.put("ograve", '\u00f2');
        Entity.put("ogt", '\u29c1');
        Entity.put("ohbar", '\u29b5');
        Entity.put("ohm", '\u03a9');
        Entity.put("oint", '\u222e');
        Entity.put("olarr", '\u21ba');
        Entity.put("olcir", '\u29be');
        Entity.put("olcross", '\u29bb');
        Entity.put("oline", '\u203e');
        Entity.put("olt", '\u29c0');
        Entity.put("Omacr", '\u014c');
        Entity.put("omacr", '\u014d');
        Entity.put("Omega", '\u03a9');
        Entity.put("omega", '\u03c9');
        Entity.put("Omicron", '\u039f');
        Entity.put("omicron", '\u03bf');
        Entity.put("omid", '\u29b6');
        Entity.put("ominus", '\u2296');
        Entity.put("Oopf", '\ud835', '\udd46');
        Entity.put("oopf", '\ud835', '\udd60');
        Entity.put("opar", '\u29b7');
        Entity.put("OpenCurlyDoubleQuote", '\u201c');
        Entity.put("OpenCurlyQuote", '\u2018');
        Entity.put("operp", '\u29b9');
        Entity.put("oplus", '\u2295');
        Entity.put("orarr", '\u21bb');
        Entity.put("Or", '\u2a54');
        Entity.put("or", '\u2228');
        Entity.put("ord", '\u2a5d');
        Entity.put("order", '\u2134');
        Entity.put("orderof", '\u2134');
        Entity.put("ordf", '\u00aa');
        Entity.put("ordm", '\u00ba');
        Entity.put("origof", '\u22b6');
        Entity.put("oror", '\u2a56');
        Entity.put("orslope", '\u2a57');
        Entity.put("orv", '\u2a5b');
        Entity.put("oS", '\u24c8');
        Entity.put("Oscr", '\ud835', '\udcaa');
        Entity.put("oscr", '\u2134');
        Entity.put("Oslash", '\u00d8');
        Entity.put("oslash", '\u00f8');
        Entity.put("osol", '\u2298');
        Entity.put("Otilde", '\u00d5');
        Entity.put("otilde", '\u00f5');
        Entity.put("otimesas", '\u2a36');
        Entity.put("Otimes", '\u2a37');
        Entity.put("otimes", '\u2297');
        Entity.put("Ouml", '\u00d6');
        Entity.put("ouml", '\u00f6');
        Entity.put("ovbar", '\u233d');
        Entity.put("OverBar", '\u203e');
        Entity.put("OverBrace", '\u23de');
        Entity.put("OverBracket", '\u23b4');
        Entity.put("OverParenthesis", '\u23dc');
        Entity.put("para", '\u00b6');
        Entity.put("parallel", '\u2225');
        Entity.put("par", '\u2225');
        Entity.put("parsim", '\u2af3');
        Entity.put("parsl", '\u2afd');
        Entity.put("part", '\u2202');
        Entity.put("PartialD", '\u2202');
        Entity.put("Pcy", '\u041f');
        Entity.put("pcy", '\u043f');
        Entity.put("percnt", '%');
        Entity.put("period", '.');
        Entity.put("permil", '\u2030');
        Entity.put("perp", '\u22a5');
        Entity.put("pertenk", '\u2031');
        Entity.put("Pfr", '\ud835', '\udd13');
        Entity.put("pfr", '\ud835', '\udd2d');
        Entity.put("Phi", '\u03a6');
        Entity.put("phi", '\u03c6');
        Entity.put("phiv", '\u03d5');
        Entity.put("phmmat", '\u2133');
        Entity.put("phone", '\u260e');
        Entity.put("Pi", '\u03a0');
        Entity.put("pi", '\u03c0');
        Entity.put("pitchfork", '\u22d4');
        Entity.put("piv", '\u03d6');
        Entity.put("planck", '\u210f');
        Entity.put("planckh", '\u210e');
        Entity.put("plankv", '\u210f');
        Entity.put("plusacir", '\u2a23');
        Entity.put("plusb", '\u229e');
        Entity.put("pluscir", '\u2a22');
        Entity.put("plus", '+');
        Entity.put("plusdo", '\u2214');
        Entity.put("plusdu", '\u2a25');
        Entity.put("pluse", '\u2a72');
        Entity.put("PlusMinus", '\u00b1');
        Entity.put("plusmn", '\u00b1');
        Entity.put("plussim", '\u2a26');
        Entity.put("plustwo", '\u2a27');
        Entity.put("pm", '\u00b1');
        Entity.put("Poincareplane", '\u210c');
        Entity.put("pointint", '\u2a15');
        Entity.put("popf", '\ud835', '\udd61');
        Entity.put("Popf", '\u2119');
        Entity.put("pound", '\u00a3');
        Entity.put("prap", '\u2ab7');
        Entity.put("Pr", '\u2abb');
        Entity.put("pr", '\u227a');
        Entity.put("prcue", '\u227c');
        Entity.put("precapprox", '\u2ab7');
        Entity.put("prec", '\u227a');
        Entity.put("preccurlyeq", '\u227c');
        Entity.put("Precedes", '\u227a');
        Entity.put("PrecedesEqual", '\u2aaf');
        Entity.put("PrecedesSlantEqual", '\u227c');
        Entity.put("PrecedesTilde", '\u227e');
        Entity.put("preceq", '\u2aaf');
        Entity.put("precnapprox", '\u2ab9');
        Entity.put("precneqq", '\u2ab5');
        Entity.put("precnsim", '\u22e8');
        Entity.put("pre", '\u2aaf');
        Entity.put("prE", '\u2ab3');
        Entity.put("precsim", '\u227e');
        Entity.put("prime", '\u2032');
        Entity.put("Prime", '\u2033');
        Entity.put("primes", '\u2119');
        Entity.put("prnap", '\u2ab9');
        Entity.put("prnE", '\u2ab5');
        Entity.put("prnsim", '\u22e8');
        Entity.put("prod", '\u220f');
        Entity.put("Product", '\u220f');
        Entity.put("profalar", '\u232e');
        Entity.put("profline", '\u2312');
        Entity.put("profsurf", '\u2313');
        Entity.put("prop", '\u221d');
        Entity.put("Proportional", '\u221d');
        Entity.put("Proportion", '\u2237');
        Entity.put("propto", '\u221d');
        Entity.put("prsim", '\u227e');
        Entity.put("prurel", '\u22b0');
        Entity.put("Pscr", '\ud835', '\udcab');
        Entity.put("pscr", '\ud835', '\udcc5');
        Entity.put("Psi", '\u03a8');
        Entity.put("psi", '\u03c8');
        Entity.put("puncsp", '\u2008');
        Entity.put("Qfr", '\ud835', '\udd14');
        Entity.put("qfr", '\ud835', '\udd2e');
        Entity.put("qint", '\u2a0c');
        Entity.put("qopf", '\ud835', '\udd62');
        Entity.put("Qopf", '\u211a');
        Entity.put("qprime", '\u2057');
        Entity.put("Qscr", '\ud835', '\udcac');
        Entity.put("qscr", '\ud835', '\udcc6');
        Entity.put("quaternions", '\u210d');
        Entity.put("quatint", '\u2a16');
        Entity.put("quest", '?');
        Entity.put("questeq", '\u225f');
        Entity.put("quot", '\"');
        Entity.put("QUOT", '\"');
        Entity.put("rAarr", '\u21db');
        Entity.put("race", '\u223d', '\u0331');
        Entity.put("Racute", '\u0154');
        Entity.put("racute", '\u0155');
        Entity.put("radic", '\u221a');
        Entity.put("raemptyv", '\u29b3');
        Entity.put("rang", '\u27e9');
        Entity.put("Rang", '\u27eb');
        Entity.put("rangd", '\u2992');
        Entity.put("range", '\u29a5');
        Entity.put("rangle", '\u27e9');
        Entity.put("raquo", '\u00bb');
        Entity.put("rarrap", '\u2975');
        Entity.put("rarrb", '\u21e5');
        Entity.put("rarrbfs", '\u2920');
        Entity.put("rarrc", '\u2933');
        Entity.put("rarr", '\u2192');
        Entity.put("Rarr", '\u21a0');
        Entity.put("rArr", '\u21d2');
        Entity.put("rarrfs", '\u291e');
        Entity.put("rarrhk", '\u21aa');
        Entity.put("rarrlp", '\u21ac');
        Entity.put("rarrpl", '\u2945');
        Entity.put("rarrsim", '\u2974');
        Entity.put("Rarrtl", '\u2916');
        Entity.put("rarrtl", '\u21a3');
        Entity.put("rarrw", '\u219d');
        Entity.put("ratail", '\u291a');
        Entity.put("rAtail", '\u291c');
        Entity.put("ratio", '\u2236');
        Entity.put("rationals", '\u211a');
        Entity.put("rbarr", '\u290d');
        Entity.put("rBarr", '\u290f');
        Entity.put("RBarr", '\u2910');
        Entity.put("rbbrk", '\u2773');
        Entity.put("rbrace", '}');
        Entity.put("rbrack", ']');
        Entity.put("rbrke", '\u298c');
        Entity.put("rbrksld", '\u298e');
        Entity.put("rbrkslu", '\u2990');
        Entity.put("Rcaron", '\u0158');
        Entity.put("rcaron", '\u0159');
        Entity.put("Rcedil", '\u0156');
        Entity.put("rcedil", '\u0157');
        Entity.put("rceil", '\u2309');
        Entity.put("rcub", '}');
        Entity.put("Rcy", '\u0420');
        Entity.put("rcy", '\u0440');
        Entity.put("rdca", '\u2937');
        Entity.put("rdldhar", '\u2969');
        Entity.put("rdquo", '\u201d');
        Entity.put("rdquor", '\u201d');
        Entity.put("rdsh", '\u21b3');
        Entity.put("real", '\u211c');
        Entity.put("realine", '\u211b');
        Entity.put("realpart", '\u211c');
        Entity.put("reals", '\u211d');
        Entity.put("Re", '\u211c');
        Entity.put("rect", '\u25ad');
        Entity.put("reg", '\u00ae');
        Entity.put("REG", '\u00ae');
        Entity.put("ReverseElement", '\u220b');
        Entity.put("ReverseEquilibrium", '\u21cb');
        Entity.put("ReverseUpEquilibrium", '\u296f');
        Entity.put("rfisht", '\u297d');
        Entity.put("rfloor", '\u230b');
        Entity.put("rfr", '\ud835', '\udd2f');
        Entity.put("Rfr", '\u211c');
        Entity.put("rHar", '\u2964');
        Entity.put("rhard", '\u21c1');
        Entity.put("rharu", '\u21c0');
        Entity.put("rharul", '\u296c');
        Entity.put("Rho", '\u03a1');
        Entity.put("rho", '\u03c1');
        Entity.put("rhov", '\u03f1');
        Entity.put("RightAngleBracket", '\u27e9');
        Entity.put("RightArrowBar", '\u21e5');
        Entity.put("rightarrow", '\u2192');
        Entity.put("RightArrow", '\u2192');
        Entity.put("Rightarrow", '\u21d2');
        Entity.put("RightArrowLeftArrow", '\u21c4');
        Entity.put("rightarrowtail", '\u21a3');
        Entity.put("RightCeiling", '\u2309');
        Entity.put("RightDoubleBracket", '\u27e7');
        Entity.put("RightDownTeeVector", '\u295d');
        Entity.put("RightDownVectorBar", '\u2955');
        Entity.put("RightDownVector", '\u21c2');
        Entity.put("RightFloor", '\u230b');
        Entity.put("rightharpoondown", '\u21c1');
        Entity.put("rightharpoonup", '\u21c0');
        Entity.put("rightleftarrows", '\u21c4');
        Entity.put("rightleftharpoons", '\u21cc');
        Entity.put("rightrightarrows", '\u21c9');
        Entity.put("rightsquigarrow", '\u219d');
        Entity.put("RightTeeArrow", '\u21a6');
        Entity.put("RightTee", '\u22a2');
        Entity.put("RightTeeVector", '\u295b');
        Entity.put("rightthreetimes", '\u22cc');
        Entity.put("RightTriangleBar", '\u29d0');
        Entity.put("RightTriangle", '\u22b3');
        Entity.put("RightTriangleEqual", '\u22b5');
        Entity.put("RightUpDownVector", '\u294f');
        Entity.put("RightUpTeeVector", '\u295c');
        Entity.put("RightUpVectorBar", '\u2954');
        Entity.put("RightUpVector", '\u21be');
        Entity.put("RightVectorBar", '\u2953');
        Entity.put("RightVector", '\u21c0');
        Entity.put("ring", '\u02da');
        Entity.put("risingdotseq", '\u2253');
        Entity.put("rlarr", '\u21c4');
        Entity.put("rlhar", '\u21cc');
        Entity.put("rlm", '\u200f');
        Entity.put("rmoustache", '\u23b1');
        Entity.put("rmoust", '\u23b1');
        Entity.put("rnmid", '\u2aee');
        Entity.put("roang", '\u27ed');
        Entity.put("roarr", '\u21fe');
        Entity.put("robrk", '\u27e7');
        Entity.put("ropar", '\u2986');
        Entity.put("ropf", '\ud835', '\udd63');
        Entity.put("Ropf", '\u211d');
        Entity.put("roplus", '\u2a2e');
        Entity.put("rotimes", '\u2a35');
        Entity.put("RoundImplies", '\u2970');
        Entity.put("rpar", ')');
        Entity.put("rpargt", '\u2994');
        Entity.put("rppolint", '\u2a12');
        Entity.put("rrarr", '\u21c9');
        Entity.put("Rrightarrow", '\u21db');
        Entity.put("rsaquo", '\u203a');
        Entity.put("rscr", '\ud835', '\udcc7');
        Entity.put("Rscr", '\u211b');
        Entity.put("rsh", '\u21b1');
        Entity.put("Rsh", '\u21b1');
        Entity.put("rsqb", ']');
        Entity.put("rsquo", '\u2019');
        Entity.put("rsquor", '\u2019');
        Entity.put("rthree", '\u22cc');
        Entity.put("rtimes", '\u22ca');
        Entity.put("rtri", '\u25b9');
        Entity.put("rtrie", '\u22b5');
        Entity.put("rtrif", '\u25b8');
        Entity.put("rtriltri", '\u29ce');
        Entity.put("RuleDelayed", '\u29f4');
        Entity.put("ruluhar", '\u2968');
        Entity.put("rx", '\u211e');
        Entity.put("Sacute", '\u015a');
        Entity.put("sacute", '\u015b');
        Entity.put("sbquo", '\u201a');
        Entity.put("scap", '\u2ab8');
        Entity.put("Scaron", '\u0160');
        Entity.put("scaron", '\u0161');
        Entity.put("Sc", '\u2abc');
        Entity.put("sc", '\u227b');
        Entity.put("sccue", '\u227d');
        Entity.put("sce", '\u2ab0');
        Entity.put("scE", '\u2ab4');
        Entity.put("Scedil", '\u015e');
        Entity.put("scedil", '\u015f');
        Entity.put("Scirc", '\u015c');
        Entity.put("scirc", '\u015d');
        Entity.put("scnap", '\u2aba');
        Entity.put("scnE", '\u2ab6');
        Entity.put("scnsim", '\u22e9');
        Entity.put("scpolint", '\u2a13');
        Entity.put("scsim", '\u227f');
        Entity.put("Scy", '\u0421');
        Entity.put("scy", '\u0441');
        Entity.put("sdotb", '\u22a1');
        Entity.put("sdot", '\u22c5');
        Entity.put("sdote", '\u2a66');
        Entity.put("searhk", '\u2925');
        Entity.put("searr", '\u2198');
        Entity.put("seArr", '\u21d8');
        Entity.put("searrow", '\u2198');
        Entity.put("sect", '\u00a7');
        Entity.put("semi", ';');
        Entity.put("seswar", '\u2929');
        Entity.put("setminus", '\u2216');
        Entity.put("setmn", '\u2216');
        Entity.put("sext", '\u2736');
        Entity.put("Sfr", '\ud835', '\udd16');
        Entity.put("sfr", '\ud835', '\udd30');
        Entity.put("sfrown", '\u2322');
        Entity.put("sharp", '\u266f');
        Entity.put("SHCHcy", '\u0429');
        Entity.put("shchcy", '\u0449');
        Entity.put("SHcy", '\u0428');
        Entity.put("shcy", '\u0448');
        Entity.put("ShortDownArrow", '\u2193');
        Entity.put("ShortLeftArrow", '\u2190');
        Entity.put("shortmid", '\u2223');
        Entity.put("shortparallel", '\u2225');
        Entity.put("ShortRightArrow", '\u2192');
        Entity.put("ShortUpArrow", '\u2191');
        Entity.put("shy", '\u00ad');
        Entity.put("Sigma", '\u03a3');
        Entity.put("sigma", '\u03c3');
        Entity.put("sigmaf", '\u03c2');
        Entity.put("sigmav", '\u03c2');
        Entity.put("sim", '\u223c');
        Entity.put("simdot", '\u2a6a');
        Entity.put("sime", '\u2243');
        Entity.put("simeq", '\u2243');
        Entity.put("simg", '\u2a9e');
        Entity.put("simgE", '\u2aa0');
        Entity.put("siml", '\u2a9d');
        Entity.put("simlE", '\u2a9f');
        Entity.put("simne", '\u2246');
        Entity.put("simplus", '\u2a24');
        Entity.put("simrarr", '\u2972');
        Entity.put("slarr", '\u2190');
        Entity.put("SmallCircle", '\u2218');
        Entity.put("smallsetminus", '\u2216');
        Entity.put("smashp", '\u2a33');
        Entity.put("smeparsl", '\u29e4');
        Entity.put("smid", '\u2223');
        Entity.put("smile", '\u2323');
        Entity.put("smt", '\u2aaa');
        Entity.put("smte", '\u2aac');
        Entity.put("smtes", '\u2aac', '\ufe00');
        Entity.put("SOFTcy", '\u042c');
        Entity.put("softcy", '\u044c');
        Entity.put("solbar", '\u233f');
        Entity.put("solb", '\u29c4');
        Entity.put("sol", '/');
        Entity.put("Sopf", '\ud835', '\udd4a');
        Entity.put("sopf", '\ud835', '\udd64');
        Entity.put("spades", '\u2660');
        Entity.put("spadesuit", '\u2660');
        Entity.put("spar", '\u2225');
        Entity.put("sqcap", '\u2293');
        Entity.put("sqcaps", '\u2293', '\ufe00');
        Entity.put("sqcup", '\u2294');
        Entity.put("sqcups", '\u2294', '\ufe00');
        Entity.put("Sqrt", '\u221a');
        Entity.put("sqsub", '\u228f');
        Entity.put("sqsube", '\u2291');
        Entity.put("sqsubset", '\u228f');
        Entity.put("sqsubseteq", '\u2291');
        Entity.put("sqsup", '\u2290');
        Entity.put("sqsupe", '\u2292');
        Entity.put("sqsupset", '\u2290');
        Entity.put("sqsupseteq", '\u2292');
        Entity.put("square", '\u25a1');
        Entity.put("Square", '\u25a1');
        Entity.put("SquareIntersection", '\u2293');
        Entity.put("SquareSubset", '\u228f');
        Entity.put("SquareSubsetEqual", '\u2291');
        Entity.put("SquareSuperset", '\u2290');
        Entity.put("SquareSupersetEqual", '\u2292');
        Entity.put("SquareUnion", '\u2294');
        Entity.put("squarf", '\u25aa');
        Entity.put("squ", '\u25a1');
        Entity.put("squf", '\u25aa');
        Entity.put("srarr", '\u2192');
        Entity.put("Sscr", '\ud835', '\udcae');
        Entity.put("sscr", '\ud835', '\udcc8');
        Entity.put("ssetmn", '\u2216');
        Entity.put("ssmile", '\u2323');
        Entity.put("sstarf", '\u22c6');
        Entity.put("Star", '\u22c6');
        Entity.put("star", '\u2606');
        Entity.put("starf", '\u2605');
        Entity.put("straightepsilon", '\u03f5');
        Entity.put("straightphi", '\u03d5');
        Entity.put("strns", '\u00af');
        Entity.put("sub", '\u2282');
        Entity.put("Sub", '\u22d0');
        Entity.put("subdot", '\u2abd');
        Entity.put("subE", '\u2ac5');
        Entity.put("sube", '\u2286');
        Entity.put("subedot", '\u2ac3');
        Entity.put("submult", '\u2ac1');
        Entity.put("subnE", '\u2acb');
        Entity.put("subne", '\u228a');
        Entity.put("subplus", '\u2abf');
        Entity.put("subrarr", '\u2979');
        Entity.put("subset", '\u2282');
        Entity.put("Subset", '\u22d0');
        Entity.put("subseteq", '\u2286');
        Entity.put("subseteqq", '\u2ac5');
        Entity.put("SubsetEqual", '\u2286');
        Entity.put("subsetneq", '\u228a');
        Entity.put("subsetneqq", '\u2acb');
        Entity.put("subsim", '\u2ac7');
        Entity.put("subsub", '\u2ad5');
        Entity.put("subsup", '\u2ad3');
        Entity.put("succapprox", '\u2ab8');
        Entity.put("succ", '\u227b');
        Entity.put("succcurlyeq", '\u227d');
        Entity.put("Succeeds", '\u227b');
        Entity.put("SucceedsEqual", '\u2ab0');
        Entity.put("SucceedsSlantEqual", '\u227d');
        Entity.put("SucceedsTilde", '\u227f');
        Entity.put("succeq", '\u2ab0');
        Entity.put("succnapprox", '\u2aba');
        Entity.put("succneqq", '\u2ab6');
        Entity.put("succnsim", '\u22e9');
        Entity.put("succsim", '\u227f');
        Entity.put("SuchThat", '\u220b');
        Entity.put("sum", '\u2211');
        Entity.put("Sum", '\u2211');
        Entity.put("sung", '\u266a');
        Entity.put("sup1", '\u00b9');
        Entity.put("sup2", '\u00b2');
        Entity.put("sup3", '\u00b3');
        Entity.put("sup", '\u2283');
        Entity.put("Sup", '\u22d1');
        Entity.put("supdot", '\u2abe');
        Entity.put("supdsub", '\u2ad8');
        Entity.put("supE", '\u2ac6');
        Entity.put("supe", '\u2287');
        Entity.put("supedot", '\u2ac4');
        Entity.put("Superset", '\u2283');
        Entity.put("SupersetEqual", '\u2287');
        Entity.put("suphsol", '\u27c9');
        Entity.put("suphsub", '\u2ad7');
        Entity.put("suplarr", '\u297b');
        Entity.put("supmult", '\u2ac2');
        Entity.put("supnE", '\u2acc');
        Entity.put("supne", '\u228b');
        Entity.put("supplus", '\u2ac0');
        Entity.put("supset", '\u2283');
        Entity.put("Supset", '\u22d1');
        Entity.put("supseteq", '\u2287');
        Entity.put("supseteqq", '\u2ac6');
        Entity.put("supsetneq", '\u228b');
        Entity.put("supsetneqq", '\u2acc');
        Entity.put("supsim", '\u2ac8');
        Entity.put("supsub", '\u2ad4');
        Entity.put("supsup", '\u2ad6');
        Entity.put("swarhk", '\u2926');
        Entity.put("swarr", '\u2199');
        Entity.put("swArr", '\u21d9');
        Entity.put("swarrow", '\u2199');
        Entity.put("swnwar", '\u292a');
        Entity.put("szlig", '\u00df');
        Entity.put("Tab", '\t');
        Entity.put("target", '\u2316');
        Entity.put("Tau", '\u03a4');
        Entity.put("tau", '\u03c4');
        Entity.put("tbrk", '\u23b4');
        Entity.put("Tcaron", '\u0164');
        Entity.put("tcaron", '\u0165');
        Entity.put("Tcedil", '\u0162');
        Entity.put("tcedil", '\u0163');
        Entity.put("Tcy", '\u0422');
        Entity.put("tcy", '\u0442');
        Entity.put("tdot", '\u20db');
        Entity.put("telrec", '\u2315');
        Entity.put("Tfr", '\ud835', '\udd17');
        Entity.put("tfr", '\ud835', '\udd31');
        Entity.put("there4", '\u2234');
        Entity.put("therefore", '\u2234');
        Entity.put("Therefore", '\u2234');
        Entity.put("Theta", '\u0398');
        Entity.put("theta", '\u03b8');
        Entity.put("thetasym", '\u03d1');
        Entity.put("thetav", '\u03d1');
        Entity.put("thickapprox", '\u2248');
        Entity.put("thicksim", '\u223c');
        Entity.put("ThickSpace", '\u205f', '\u200a');
        Entity.put("ThinSpace", '\u2009');
        Entity.put("thinsp", '\u2009');
        Entity.put("thkap", '\u2248');
        Entity.put("thksim", '\u223c');
        Entity.put("THORN", '\u00de');
        Entity.put("thorn", '\u00fe');
        Entity.put("tilde", '\u02dc');
        Entity.put("Tilde", '\u223c');
        Entity.put("TildeEqual", '\u2243');
        Entity.put("TildeFullEqual", '\u2245');
        Entity.put("TildeTilde", '\u2248');
        Entity.put("timesbar", '\u2a31');
        Entity.put("timesb", '\u22a0');
        Entity.put("times", '\u00d7');
        Entity.put("timesd", '\u2a30');
        Entity.put("tint", '\u222d');
        Entity.put("toea", '\u2928');
        Entity.put("topbot", '\u2336');
        Entity.put("topcir", '\u2af1');
        Entity.put("top", '\u22a4');
        Entity.put("Topf", '\ud835', '\udd4b');
        Entity.put("topf", '\ud835', '\udd65');
        Entity.put("topfork", '\u2ada');
        Entity.put("tosa", '\u2929');
        Entity.put("tprime", '\u2034');
        Entity.put("trade", '\u2122');
        Entity.put("TRADE", '\u2122');
        Entity.put("triangle", '\u25b5');
        Entity.put("triangledown", '\u25bf');
        Entity.put("triangleleft", '\u25c3');
        Entity.put("trianglelefteq", '\u22b4');
        Entity.put("triangleq", '\u225c');
        Entity.put("triangleright", '\u25b9');
        Entity.put("trianglerighteq", '\u22b5');
        Entity.put("tridot", '\u25ec');
        Entity.put("trie", '\u225c');
        Entity.put("triminus", '\u2a3a');
        Entity.put("TripleDot", '\u20db');
        Entity.put("triplus", '\u2a39');
        Entity.put("trisb", '\u29cd');
        Entity.put("tritime", '\u2a3b');
        Entity.put("trpezium", '\u23e2');
        Entity.put("Tscr", '\ud835', '\udcaf');
        Entity.put("tscr", '\ud835', '\udcc9');
        Entity.put("TScy", '\u0426');
        Entity.put("tscy", '\u0446');
        Entity.put("TSHcy", '\u040b');
        Entity.put("tshcy", '\u045b');
        Entity.put("Tstrok", '\u0166');
        Entity.put("tstrok", '\u0167');
        Entity.put("twixt", '\u226c');
        Entity.put("twoheadleftarrow", '\u219e');
        Entity.put("twoheadrightarrow", '\u21a0');
        Entity.put("Uacute", '\u00da');
        Entity.put("uacute", '\u00fa');
        Entity.put("uarr", '\u2191');
        Entity.put("Uarr", '\u219f');
        Entity.put("uArr", '\u21d1');
        Entity.put("Uarrocir", '\u2949');
        Entity.put("Ubrcy", '\u040e');
        Entity.put("ubrcy", '\u045e');
        Entity.put("Ubreve", '\u016c');
        Entity.put("ubreve", '\u016d');
        Entity.put("Ucirc", '\u00db');
        Entity.put("ucirc", '\u00fb');
        Entity.put("Ucy", '\u0423');
        Entity.put("ucy", '\u0443');
        Entity.put("udarr", '\u21c5');
        Entity.put("Udblac", '\u0170');
        Entity.put("udblac", '\u0171');
        Entity.put("udhar", '\u296e');
        Entity.put("ufisht", '\u297e');
        Entity.put("Ufr", '\ud835', '\udd18');
        Entity.put("ufr", '\ud835', '\udd32');
        Entity.put("Ugrave", '\u00d9');
        Entity.put("ugrave", '\u00f9');
        Entity.put("uHar", '\u2963');
        Entity.put("uharl", '\u21bf');
        Entity.put("uharr", '\u21be');
        Entity.put("uhblk", '\u2580');
        Entity.put("ulcorn", '\u231c');
        Entity.put("ulcorner", '\u231c');
        Entity.put("ulcrop", '\u230f');
        Entity.put("ultri", '\u25f8');
        Entity.put("Umacr", '\u016a');
        Entity.put("umacr", '\u016b');
        Entity.put("uml", '\u00a8');
        Entity.put("UnderBar", '_');
        Entity.put("UnderBrace", '\u23df');
        Entity.put("UnderBracket", '\u23b5');
        Entity.put("UnderParenthesis", '\u23dd');
        Entity.put("Union", '\u22c3');
        Entity.put("UnionPlus", '\u228e');
        Entity.put("Uogon", '\u0172');
        Entity.put("uogon", '\u0173');
        Entity.put("Uopf", '\ud835', '\udd4c');
        Entity.put("uopf", '\ud835', '\udd66');
        Entity.put("UpArrowBar", '\u2912');
        Entity.put("uparrow", '\u2191');
        Entity.put("UpArrow", '\u2191');
        Entity.put("Uparrow", '\u21d1');
        Entity.put("UpArrowDownArrow", '\u21c5');
        Entity.put("updownarrow", '\u2195');
        Entity.put("UpDownArrow", '\u2195');
        Entity.put("Updownarrow", '\u21d5');
        Entity.put("UpEquilibrium", '\u296e');
        Entity.put("upharpoonleft", '\u21bf');
        Entity.put("upharpoonright", '\u21be');
        Entity.put("uplus", '\u228e');
        Entity.put("UpperLeftArrow", '\u2196');
        Entity.put("UpperRightArrow", '\u2197');
        Entity.put("upsi", '\u03c5');
        Entity.put("Upsi", '\u03d2');
        Entity.put("upsih", '\u03d2');
        Entity.put("Upsilon", '\u03a5');
        Entity.put("upsilon", '\u03c5');
        Entity.put("UpTeeArrow", '\u21a5');
        Entity.put("UpTee", '\u22a5');
        Entity.put("upuparrows", '\u21c8');
        Entity.put("urcorn", '\u231d');
        Entity.put("urcorner", '\u231d');
        Entity.put("urcrop", '\u230e');
        Entity.put("Uring", '\u016e');
        Entity.put("uring", '\u016f');
        Entity.put("urtri", '\u25f9');
        Entity.put("Uscr", '\ud835', '\udcb0');
        Entity.put("uscr", '\ud835', '\udcca');
        Entity.put("utdot", '\u22f0');
        Entity.put("Utilde", '\u0168');
        Entity.put("utilde", '\u0169');
        Entity.put("utri", '\u25b5');
        Entity.put("utrif", '\u25b4');
        Entity.put("uuarr", '\u21c8');
        Entity.put("Uuml", '\u00dc');
        Entity.put("uuml", '\u00fc');
        Entity.put("uwangle", '\u29a7');
        Entity.put("vangrt", '\u299c');
        Entity.put("varepsilon", '\u03f5');
        Entity.put("varkappa", '\u03f0');
        Entity.put("varnothing", '\u2205');
        Entity.put("varphi", '\u03d5');
        Entity.put("varpi", '\u03d6');
        Entity.put("varpropto", '\u221d');
        Entity.put("varr", '\u2195');
        Entity.put("vArr", '\u21d5');
        Entity.put("varrho", '\u03f1');
        Entity.put("varsigma", '\u03c2');
        Entity.put("varsubsetneq", '\u228a', '\ufe00');
        Entity.put("varsubsetneqq", '\u2acb', '\ufe00');
        Entity.put("varsupsetneq", '\u228b', '\ufe00');
        Entity.put("varsupsetneqq", '\u2acc', '\ufe00');
        Entity.put("vartheta", '\u03d1');
        Entity.put("vartriangleleft", '\u22b2');
        Entity.put("vartriangleright", '\u22b3');
        Entity.put("vBar", '\u2ae8');
        Entity.put("Vbar", '\u2aeb');
        Entity.put("vBarv", '\u2ae9');
        Entity.put("Vcy", '\u0412');
        Entity.put("vcy", '\u0432');
        Entity.put("vdash", '\u22a2');
        Entity.put("vDash", '\u22a8');
        Entity.put("Vdash", '\u22a9');
        Entity.put("VDash", '\u22ab');
        Entity.put("Vdashl", '\u2ae6');
        Entity.put("veebar", '\u22bb');
        Entity.put("vee", '\u2228');
        Entity.put("Vee", '\u22c1');
        Entity.put("veeeq", '\u225a');
        Entity.put("vellip", '\u22ee');
        Entity.put("verbar", '|');
        Entity.put("Verbar", '\u2016');
        Entity.put("vert", '|');
        Entity.put("Vert", '\u2016');
        Entity.put("VerticalBar", '\u2223');
        Entity.put("VerticalLine", '|');
        Entity.put("VerticalSeparator", '\u2758');
        Entity.put("VerticalTilde", '\u2240');
        Entity.put("VeryThinSpace", '\u200a');
        Entity.put("Vfr", '\ud835', '\udd19');
        Entity.put("vfr", '\ud835', '\udd33');
        Entity.put("vltri", '\u22b2');
        Entity.put("vnsub", '\u2282', '\u20d2');
        Entity.put("vnsup", '\u2283', '\u20d2');
        Entity.put("Vopf", '\ud835', '\udd4d');
        Entity.put("vopf", '\ud835', '\udd67');
        Entity.put("vprop", '\u221d');
        Entity.put("vrtri", '\u22b3');
        Entity.put("Vscr", '\ud835', '\udcb1');
        Entity.put("vscr", '\ud835', '\udccb');
        Entity.put("vsubnE", '\u2acb', '\ufe00');
        Entity.put("vsubne", '\u228a', '\ufe00');
        Entity.put("vsupnE", '\u2acc', '\ufe00');
        Entity.put("vsupne", '\u228b', '\ufe00');
        Entity.put("Vvdash", '\u22aa');
        Entity.put("vzigzag", '\u299a');
        Entity.put("Wcirc", '\u0174');
        Entity.put("wcirc", '\u0175');
        Entity.put("wedbar", '\u2a5f');
        Entity.put("wedge", '\u2227');
        Entity.put("Wedge", '\u22c0');
        Entity.put("wedgeq", '\u2259');
        Entity.put("weierp", '\u2118');
        Entity.put("Wfr", '\ud835', '\udd1a');
        Entity.put("wfr", '\ud835', '\udd34');
        Entity.put("Wopf", '\ud835', '\udd4e');
        Entity.put("wopf", '\ud835', '\udd68');
        Entity.put("wp", '\u2118');
        Entity.put("wr", '\u2240');
        Entity.put("wreath", '\u2240');
        Entity.put("Wscr", '\ud835', '\udcb2');
        Entity.put("wscr", '\ud835', '\udccc');
        Entity.put("xcap", '\u22c2');
        Entity.put("xcirc", '\u25ef');
        Entity.put("xcup", '\u22c3');
        Entity.put("xdtri", '\u25bd');
        Entity.put("Xfr", '\ud835', '\udd1b');
        Entity.put("xfr", '\ud835', '\udd35');
        Entity.put("xharr", '\u27f7');
        Entity.put("xhArr", '\u27fa');
        Entity.put("Xi", '\u039e');
        Entity.put("xi", '\u03be');
        Entity.put("xlarr", '\u27f5');
        Entity.put("xlArr", '\u27f8');
        Entity.put("xmap", '\u27fc');
        Entity.put("xnis", '\u22fb');
        Entity.put("xodot", '\u2a00');
        Entity.put("Xopf", '\ud835', '\udd4f');
        Entity.put("xopf", '\ud835', '\udd69');
        Entity.put("xoplus", '\u2a01');
        Entity.put("xotime", '\u2a02');
        Entity.put("xrarr", '\u27f6');
        Entity.put("xrArr", '\u27f9');
        Entity.put("Xscr", '\ud835', '\udcb3');
        Entity.put("xscr", '\ud835', '\udccd');
        Entity.put("xsqcup", '\u2a06');
        Entity.put("xuplus", '\u2a04');
        Entity.put("xutri", '\u25b3');
        Entity.put("xvee", '\u22c1');
        Entity.put("xwedge", '\u22c0');
        Entity.put("Yacute", '\u00dd');
        Entity.put("yacute", '\u00fd');
        Entity.put("YAcy", '\u042f');
        Entity.put("yacy", '\u044f');
        Entity.put("Ycirc", '\u0176');
        Entity.put("ycirc", '\u0177');
        Entity.put("Ycy", '\u042b');
        Entity.put("ycy", '\u044b');
        Entity.put("yen", '\u00a5');
        Entity.put("Yfr", '\ud835', '\udd1c');
        Entity.put("yfr", '\ud835', '\udd36');
        Entity.put("YIcy", '\u0407');
        Entity.put("yicy", '\u0457');
        Entity.put("Yopf", '\ud835', '\udd50');
        Entity.put("yopf", '\ud835', '\udd6a');
        Entity.put("Yscr", '\ud835', '\udcb4');
        Entity.put("yscr", '\ud835', '\udcce');
        Entity.put("YUcy", '\u042e');
        Entity.put("yucy", '\u044e');
        Entity.put("yuml", '\u00ff');
        Entity.put("Yuml", '\u0178');
        Entity.put("Zacute", '\u0179');
        Entity.put("zacute", '\u017a');
        Entity.put("Zcaron", '\u017d');
        Entity.put("zcaron", '\u017e');
        Entity.put("Zcy", '\u0417');
        Entity.put("zcy", '\u0437');
        Entity.put("Zdot", '\u017b');
        Entity.put("zdot", '\u017c');
        Entity.put("zeetrf", '\u2128');
        Entity.put("ZeroWidthSpace", '\u200b');
        Entity.put("Zeta", '\u0396');
        Entity.put("zeta", '\u03b6');
        Entity.put("zfr", '\ud835', '\udd37');
        Entity.put("Zfr", '\u2128');
        Entity.put("ZHcy", '\u0416');
        Entity.put("zhcy", '\u0436');
        Entity.put("zigrarr", '\u21dd');
        Entity.put("zopf", '\ud835', '\udd6b');
        Entity.put("Zopf", '\u2124');
        Entity.put("Zscr", '\ud835', '\udcb5');
        Entity.put("zscr", '\ud835', '\udccf');
        Entity.put("zwj", '\u200d');
        Entity.put("zwnj", '\u200c');
    }
}

