/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import jakarta.el.ELResolver;
import jakarta.faces.FacesException;
import jakarta.faces.FacesWrapper;
import jakarta.faces.FactoryFinder;
import jakarta.faces.application.Application;
import jakarta.faces.application.ApplicationFactory;
import jakarta.faces.application.ConfigurableNavigationHandler;
import jakarta.faces.application.NavigationHandler;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.application.ResourceHandler;
import jakarta.faces.application.StateManager;
import jakarta.faces.application.ViewHandler;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.search.SearchExpressionHandler;
import jakarta.faces.component.search.SearchKeywordResolver;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ActionListener;
import jakarta.faces.event.PhaseListener;
import jakarta.faces.event.PostConstructApplicationEvent;
import jakarta.faces.event.PostConstructViewMapEvent;
import jakarta.faces.event.PreDestroyViewMapEvent;
import jakarta.faces.event.SystemEvent;
import jakarta.faces.flow.Flow;
import jakarta.faces.flow.FlowCallNode;
import jakarta.faces.flow.FlowHandler;
import jakarta.faces.flow.FlowHandlerFactory;
import jakarta.faces.flow.MethodCallNode;
import jakarta.faces.flow.ReturnNode;
import jakarta.faces.flow.SwitchNode;
import jakarta.faces.flow.ViewNode;
import jakarta.faces.lifecycle.Lifecycle;
import jakarta.faces.lifecycle.LifecycleFactory;
import jakarta.faces.render.RenderKit;
import jakarta.faces.render.RenderKitFactory;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.application.ApplicationFactoryImpl;
import org.apache.myfaces.application.BackwardsCompatibleNavigationHandlerWrapper;
import org.apache.myfaces.cdi.util.BeanEntry;
import org.apache.myfaces.cdi.view.ViewScopeEventListener;
import org.apache.myfaces.component.search.SearchExpressionContextFactoryImpl;
import org.apache.myfaces.component.visit.VisitContextFactoryImpl;
import org.apache.myfaces.config.FacesConfigUnmarshaller;
import org.apache.myfaces.config.NamedEventManager;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.element.Behavior;
import org.apache.myfaces.config.element.ClientBehaviorRenderer;
import org.apache.myfaces.config.element.Component;
import org.apache.myfaces.config.element.ComponentTagDeclaration;
import org.apache.myfaces.config.element.ContractMapping;
import org.apache.myfaces.config.element.FaceletsProcessing;
import org.apache.myfaces.config.element.FaceletsTemplateMapping;
import org.apache.myfaces.config.element.FacesConfig;
import org.apache.myfaces.config.element.FacesConfigData;
import org.apache.myfaces.config.element.FacesFlowCall;
import org.apache.myfaces.config.element.FacesFlowDefinition;
import org.apache.myfaces.config.element.FacesFlowMethodCall;
import org.apache.myfaces.config.element.FacesFlowMethodParameter;
import org.apache.myfaces.config.element.FacesFlowParameter;
import org.apache.myfaces.config.element.FacesFlowReturn;
import org.apache.myfaces.config.element.FacesFlowSwitch;
import org.apache.myfaces.config.element.FacesFlowView;
import org.apache.myfaces.config.element.NamedEvent;
import org.apache.myfaces.config.element.NavigationCase;
import org.apache.myfaces.config.element.NavigationRule;
import org.apache.myfaces.config.element.Renderer;
import org.apache.myfaces.config.element.ResourceBundle;
import org.apache.myfaces.config.element.SystemEventListener;
import org.apache.myfaces.config.element.ViewPoolMapping;
import org.apache.myfaces.config.element.facelets.FaceletTagLibrary;
import org.apache.myfaces.config.impl.FacesConfigDispenserImpl;
import org.apache.myfaces.config.impl.FacesConfigUnmarshallerImpl;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.context.ExceptionHandlerFactoryImpl;
import org.apache.myfaces.context.ExternalContextFactoryImpl;
import org.apache.myfaces.context.FacesContextFactoryImpl;
import org.apache.myfaces.context.PartialViewContextFactoryImpl;
import org.apache.myfaces.context.servlet.ServletFlashFactoryImpl;
import org.apache.myfaces.el.TracingELResolverPhaseListener;
import org.apache.myfaces.flow.FlowCallNodeImpl;
import org.apache.myfaces.flow.FlowHandlerFactoryImpl;
import org.apache.myfaces.flow.FlowImpl;
import org.apache.myfaces.flow.Freezable;
import org.apache.myfaces.flow.MethodCallNodeImpl;
import org.apache.myfaces.flow.ParameterImpl;
import org.apache.myfaces.flow.ReturnNodeImpl;
import org.apache.myfaces.flow.SwitchCaseImpl;
import org.apache.myfaces.flow.SwitchNodeImpl;
import org.apache.myfaces.flow.ViewNodeImpl;
import org.apache.myfaces.lifecycle.LifecycleFactoryImpl;
import org.apache.myfaces.lifecycle.clientwindow.ClientWindowFactoryImpl;
import org.apache.myfaces.renderkit.LazyRenderKit;
import org.apache.myfaces.renderkit.RenderKitFactoryImpl;
import org.apache.myfaces.renderkit.html.HtmlRenderKitImpl;
import org.apache.myfaces.resource.ResourceLoaderUtils;
import org.apache.myfaces.spi.FacesConfigurationMerger;
import org.apache.myfaces.spi.FacesConfigurationMergerFactory;
import org.apache.myfaces.spi.FacesFlowProvider;
import org.apache.myfaces.spi.FacesFlowProviderFactory;
import org.apache.myfaces.spi.InjectionProvider;
import org.apache.myfaces.spi.InjectionProviderException;
import org.apache.myfaces.spi.InjectionProviderFactory;
import org.apache.myfaces.spi.ResourceLibraryContractsProvider;
import org.apache.myfaces.spi.ResourceLibraryContractsProviderFactory;
import org.apache.myfaces.spi.SerialFactory;
import org.apache.myfaces.spi.impl.DefaultSerialFactory;
import org.apache.myfaces.util.ExternalSpecifications;
import org.apache.myfaces.util.LocaleUtils;
import org.apache.myfaces.util.NavigationUtils;
import org.apache.myfaces.util.Purgeable;
import org.apache.myfaces.util.WebConfigParamUtils;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.util.lang.StringUtils;
import org.apache.myfaces.view.ViewDeclarationLanguageFactoryImpl;
import org.apache.myfaces.view.facelets.el.ELText;
import org.apache.myfaces.view.facelets.impl.FaceletCacheFactoryImpl;
import org.apache.myfaces.view.facelets.tag.faces.TagHandlerDelegateFactoryImpl;
import org.apache.myfaces.view.facelets.tag.ui.DebugPhaseListener;

public class FacesConfigurator {
    private final Class<?>[] NO_PARAMETER_TYPES = new Class[0];
    private final Object[] NO_PARAMETERS = new Object[0];
    private static final Logger log = Logger.getLogger(FacesConfigurator.class.getName());
    private static final String DEFAULT_RENDER_KIT_CLASS = HtmlRenderKitImpl.class.getName();
    private static final String DEFAULT_APPLICATION_FACTORY = ApplicationFactoryImpl.class.getName();
    private static final String DEFAULT_EXTERNAL_CONTEXT_FACTORY = ExternalContextFactoryImpl.class.getName();
    private static final String DEFAULT_FACES_CONTEXT_FACTORY = FacesContextFactoryImpl.class.getName();
    private static final String DEFAULT_LIFECYCLE_FACTORY = LifecycleFactoryImpl.class.getName();
    private static final String DEFAULT_RENDER_KIT_FACTORY = RenderKitFactoryImpl.class.getName();
    private static final String DEFAULT_PARTIAL_VIEW_CONTEXT_FACTORY = PartialViewContextFactoryImpl.class.getName();
    private static final String DEFAULT_VISIT_CONTEXT_FACTORY = VisitContextFactoryImpl.class.getName();
    private static final String DEFAULT_VIEW_DECLARATION_LANGUAGE_FACTORY = ViewDeclarationLanguageFactoryImpl.class.getName();
    private static final String DEFAULT_EXCEPTION_HANDLER_FACTORY = ExceptionHandlerFactoryImpl.class.getName();
    private static final String DEFAULT_TAG_HANDLER_DELEGATE_FACTORY = TagHandlerDelegateFactoryImpl.class.getName();
    private static final String DEFAULT_FACELET_CACHE_FACTORY = FaceletCacheFactoryImpl.class.getName();
    private static final String DEFAULT_FLASH_FACTORY = ServletFlashFactoryImpl.class.getName();
    private static final String DEFAULT_CLIENT_WINDOW_FACTORY = ClientWindowFactoryImpl.class.getName();
    private static final String DEFAULT_FLOW_FACTORY = FlowHandlerFactoryImpl.class.getName();
    private static final String DEFAULT_SEARCH_EXPRESSION_CONTEXT_FACTORY = SearchExpressionContextFactoryImpl.class.getName();
    private static final String DEFAULT_FACES_CONFIG = "/WEB-INF/faces-config.xml";
    public static final String ENABLE_DEFAULT_WINDOW_MODE = "org.apache.myfaces.ENABLE_DEFAULT_WINDOW_MODE";
    private final ExternalContext _externalContext;
    private FacesContext _facesContext;
    private FacesConfigUnmarshaller<? extends FacesConfig> _unmarshaller;
    private FacesConfigData _dispenser;
    private RuntimeConfig _runtimeConfig;
    private MyfacesConfig _myfacesConfig;
    private Application _application;
    private InjectionProvider _injectionProvider;
    private static long lastUpdate;

    public FacesConfigurator(ExternalContext externalContext) {
        if (externalContext == null) {
            throw new IllegalArgumentException("external context must not be null");
        }
        this._externalContext = externalContext;
        if (this._externalContext.getApplicationMap().get("org.apache.myfaces.spi.BEAN_ENTRY_STORAGE") == null) {
            this._externalContext.getApplicationMap().put("org.apache.myfaces.spi.BEAN_ENTRY_STORAGE", new CopyOnWriteArrayList());
        }
        this._myfacesConfig = MyfacesConfig.getCurrentInstance(this._externalContext);
        this._runtimeConfig = RuntimeConfig.getCurrentInstance(this._externalContext);
    }

    public void setUnmarshaller(FacesConfigUnmarshaller<? extends FacesConfig> unmarshaller) {
        this._unmarshaller = unmarshaller;
    }

    protected FacesConfigUnmarshaller<? extends FacesConfig> getUnmarshaller() {
        if (this._unmarshaller == null) {
            this._unmarshaller = new FacesConfigUnmarshallerImpl(this._externalContext);
        }
        return this._unmarshaller;
    }

    public void setDispenser(FacesConfigData dispenser) {
        this._dispenser = dispenser;
    }

    protected FacesConfigData getDispenser() {
        if (this._dispenser == null) {
            this._dispenser = new FacesConfigDispenserImpl();
        }
        return this._dispenser;
    }

    private long getResourceLastModified(String resource) {
        try {
            URL url = this._externalContext.getResource(resource);
            if (url != null) {
                return ResourceLoaderUtils.getResourceLastModified(url);
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Could not read lastModified " + resource, e);
        }
        return 0L;
    }

    private long getLastModifiedTime() {
        Set directoryPaths;
        long lastModified = 0L;
        long resModified = this.getResourceLastModified(DEFAULT_FACES_CONFIG);
        if (resModified > lastModified) {
            lastModified = resModified;
        }
        List<String> configFilesList = this.getConfigFilesList();
        int size = configFilesList.size();
        for (int i = 0; i < size; ++i) {
            String systemId = configFilesList.get(i);
            resModified = this.getResourceLastModified(systemId);
            if (resModified <= lastModified) continue;
            lastModified = resModified;
        }
        String faceletsFiles = WebConfigParamUtils.getStringInitParameter(this._externalContext, "jakarta.faces.FACELETS_LIBRARIES");
        if (faceletsFiles != null) {
            for (String systemId : StringUtils.trim(faceletsFiles.split(";"))) {
                resModified = this.getResourceLastModified(systemId);
                if (resModified <= lastModified) continue;
                lastModified = resModified;
            }
        }
        if ((directoryPaths = this._externalContext.getResourcePaths("/")) != null) {
            List<String> contextSpecifiedList = configFilesList;
            for (String dirPath : directoryPaths) {
                String flowName;
                String filePath;
                if (dirPath.equals("/WEB-INF/")) {
                    Set webDirectoryPaths = this._externalContext.getResourcePaths(dirPath);
                    for (String webDirPath : webDirectoryPaths) {
                        String flowName2;
                        String filePath2;
                        if (!webDirPath.endsWith("/") || webDirPath.equals("/WEB-INF/classes/") || contextSpecifiedList.contains(filePath2 = webDirPath + (flowName2 = webDirPath.substring(9, webDirPath.length() - 1)) + "-flow.xml") || (resModified = this.getResourceLastModified(filePath2)) <= lastModified) continue;
                        lastModified = resModified;
                    }
                    continue;
                }
                if (dirPath.startsWith("/META-INF") || !dirPath.endsWith("/") || contextSpecifiedList.contains(filePath = dirPath + (flowName = dirPath.substring(1, dirPath.length() - 1)) + "-flow.xml") || (resModified = this.getResourceLastModified(filePath)) <= lastModified) continue;
                lastModified = resModified;
            }
        }
        return lastModified;
    }

    public void update() {
        long refreshPeriod = MyfacesConfig.getCurrentInstance(this._externalContext).getConfigRefreshPeriod() * 1000L;
        if (refreshPeriod > 0L) {
            long ttl = lastUpdate + refreshPeriod;
            if (System.currentTimeMillis() > ttl && this.getLastModifiedTime() > ttl) {
                try {
                    this.purgeConfiguration();
                    this.configure();
                    FacesContext facesContext = this.getFacesContext();
                    Application application = facesContext.getApplication();
                    application.publishEvent(facesContext, PostConstructApplicationEvent.class, Application.class, (Object)application);
                }
                catch (Exception e) {
                    log.severe("Error during configuration clean-up" + e.getMessage());
                    lastUpdate = System.currentTimeMillis();
                }
            }
        }
    }

    private void purgeConfiguration() {
        ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"jakarta.faces.application.ApplicationFactory");
        this.purge(applicationFactory);
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"jakarta.faces.render.RenderKitFactory");
        this.purge(renderKitFactory);
        RuntimeConfig.getCurrentInstance(this._externalContext).purge();
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"jakarta.faces.lifecycle.LifecycleFactory");
        this.purge(lifecycleFactory);
        FacesContext facesContext = this.getFacesContext();
        this.purge(facesContext);
        this._externalContext.getApplicationMap().remove("org.apache.myfaces.lifecycle.first.request.processed");
    }

    <T> void purge(T instance) {
        while (instance != null) {
            if (instance instanceof Purgeable) {
                ((Purgeable)instance).purge();
            }
            if (instance instanceof FacesWrapper) {
                instance = ((FacesWrapper)instance).getWrapped();
                continue;
            }
            return;
        }
    }

    public void configure() throws FacesException {
        FacesConfigurationMerger facesConfigurationMerger = FacesConfigurationMergerFactory.getFacesConfigurationMergerFactory(this._externalContext).getFacesConfigurationMerger(this._externalContext);
        this.setDispenser(facesConfigurationMerger.getFacesConfigData(this._externalContext));
        this.configureFactories();
        this.configureApplication();
        this.configureRenderKits();
        this.configureRuntimeConfig();
        this.configureLifecycle();
        this.handleSerialFactory();
        this.configureFlowHandler();
        this.configureProtectedViews();
        lastUpdate = System.currentTimeMillis();
    }

    private List<String> getConfigFilesList() {
        String configFiles = this._externalContext.getInitParameter("jakarta.faces.CONFIG_FILES");
        ArrayList<String> configFilesList = new ArrayList<String>();
        if (configFiles != null) {
            StringTokenizer st = new StringTokenizer(configFiles, ",", false);
            while (st.hasMoreTokens()) {
                String systemId = st.nextToken().trim();
                if (DEFAULT_FACES_CONFIG.equals(systemId)) {
                    if (!log.isLoggable(Level.WARNING)) continue;
                    log.warning("/WEB-INF/faces-config.xml has been specified in the jakarta.faces.CONFIG_FILES context parameter of the deployment descriptor. This will automatically be removed, if we wouldn't do this, it would be loaded twice.  See Faces spec 1.1, 10.3.2");
                    continue;
                }
                configFilesList.add(systemId);
            }
        }
        return configFilesList;
    }

    private void configureFactories() {
        FacesConfigData dispenser = this.getDispenser();
        this.setFactories("jakarta.faces.application.ApplicationFactory", dispenser.getApplicationFactoryIterator(), DEFAULT_APPLICATION_FACTORY);
        this.setFactories("jakarta.faces.context.ExceptionHandlerFactory", dispenser.getExceptionHandlerFactoryIterator(), DEFAULT_EXCEPTION_HANDLER_FACTORY);
        this.setFactories("jakarta.faces.context.ExternalContextFactory", dispenser.getExternalContextFactoryIterator(), DEFAULT_EXTERNAL_CONTEXT_FACTORY);
        this.setFactories("jakarta.faces.context.FacesContextFactory", dispenser.getFacesContextFactoryIterator(), DEFAULT_FACES_CONTEXT_FACTORY);
        this.setFactories("jakarta.faces.lifecycle.LifecycleFactory", dispenser.getLifecycleFactoryIterator(), DEFAULT_LIFECYCLE_FACTORY);
        this.setFactories("jakarta.faces.render.RenderKitFactory", dispenser.getRenderKitFactoryIterator(), DEFAULT_RENDER_KIT_FACTORY);
        this.setFactories("jakarta.faces.view.facelets.TagHandlerDelegateFactory", dispenser.getTagHandlerDelegateFactoryIterator(), DEFAULT_TAG_HANDLER_DELEGATE_FACTORY);
        this.setFactories("jakarta.faces.context.PartialViewContextFactory", dispenser.getPartialViewContextFactoryIterator(), DEFAULT_PARTIAL_VIEW_CONTEXT_FACTORY);
        this.setFactories("jakarta.faces.component.visit.VisitContextFactory", dispenser.getVisitContextFactoryIterator(), DEFAULT_VISIT_CONTEXT_FACTORY);
        this.setFactories("jakarta.faces.view.ViewDeclarationLanguageFactory", dispenser.getViewDeclarationLanguageFactoryIterator(), DEFAULT_VIEW_DECLARATION_LANGUAGE_FACTORY);
        this.setFactories("jakarta.faces.view.facelets.FaceletCacheFactory", dispenser.getFaceletCacheFactoryIterator(), DEFAULT_FACELET_CACHE_FACTORY);
        this.setFactories("jakarta.faces.context.FlashFactory", dispenser.getFlashFactoryIterator(), DEFAULT_FLASH_FACTORY);
        this.setFactories("jakarta.faces.lifecycle.ClientWindowFactory", dispenser.getClientWindowFactoryIterator(), DEFAULT_CLIENT_WINDOW_FACTORY);
        this.setFactories("jakarta.faces.flow.FlowHandlerFactory", dispenser.getFlowHandlerFactoryIterator(), DEFAULT_FLOW_FACTORY);
        this.setFactories("jakarta.faces.component.search.SearchExpressionContextFactory", dispenser.getSearchExpressionContextFactoryIterator(), DEFAULT_SEARCH_EXPRESSION_CONTEXT_FACTORY);
    }

    private void setFactories(String factoryName, Collection<String> factories, String defaultFactory) {
        FactoryFinder.setFactory((String)factoryName, (String)defaultFactory);
        for (String factory : factories) {
            if (factory.equals(defaultFactory)) continue;
            FactoryFinder.setFactory((String)factoryName, (String)factory);
        }
    }

    private void configureApplication() {
        Application application = ((ApplicationFactory)FactoryFinder.getFactory((String)"jakarta.faces.application.ApplicationFactory")).getApplication();
        FacesConfigData dispenser = this.getDispenser();
        ActionListener actionListener = ClassUtils.buildApplicationObject(ActionListener.class, dispenser.getActionListenerIterator(), null);
        this._callInjectAndPostConstruct(actionListener);
        application.setActionListener(actionListener);
        if (dispenser.getDefaultLocale() != null) {
            application.setDefaultLocale(LocaleUtils.toLocale(dispenser.getDefaultLocale()));
        }
        if (dispenser.getDefaultRenderKitId() != null) {
            application.setDefaultRenderKitId(dispenser.getDefaultRenderKitId());
        }
        if (dispenser.getMessageBundle() != null) {
            application.setMessageBundle(dispenser.getMessageBundle());
        }
        NavigationHandler navigationHandler = ClassUtils.buildApplicationObject(NavigationHandler.class, ConfigurableNavigationHandler.class, null, dispenser.getNavigationHandlerIterator(), application.getNavigationHandler());
        this._callInjectAndPostConstruct(navigationHandler);
        navigationHandler = ClassUtils.wrapBackwardCompatible(NavigationHandler.class, ConfigurableNavigationHandler.class, BackwardsCompatibleNavigationHandlerWrapper.class, application.getNavigationHandler(), navigationHandler);
        application.setNavigationHandler(navigationHandler);
        StateManager stateManager = ClassUtils.buildApplicationObject(StateManager.class, dispenser.getStateManagerIterator(), application.getStateManager());
        this._callInjectAndPostConstruct(stateManager);
        application.setStateManager(stateManager);
        ResourceHandler resourceHandler = ClassUtils.buildApplicationObject(ResourceHandler.class, dispenser.getResourceHandlerIterator(), application.getResourceHandler());
        this._callInjectAndPostConstruct(resourceHandler);
        application.setResourceHandler(resourceHandler);
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (String string : dispenser.getSupportedLocalesIterator()) {
            locales.add(LocaleUtils.toLocale(string));
        }
        application.setSupportedLocales(locales);
        application.setViewHandler(ClassUtils.buildApplicationObject(ViewHandler.class, dispenser.getViewHandlerIterator(), application.getViewHandler()));
        application.setSearchExpressionHandler(ClassUtils.buildApplicationObject(SearchExpressionHandler.class, dispenser.getSearchExpressionHandlerIterator(), application.getSearchExpressionHandler()));
        for (SystemEventListener systemEventListener : dispenser.getSystemEventListeners()) {
            try {
                Class clazz = ClassUtils.classForName(systemEventListener.getSystemEventClass() != null ? systemEventListener.getSystemEventClass() : SystemEvent.class.getName());
                jakarta.faces.event.SystemEventListener listener = (jakarta.faces.event.SystemEventListener)ClassUtils.newInstance((String)systemEventListener.getSystemEventListenerClass());
                this._callInjectAndPostConstruct(listener);
                if (systemEventListener.getSourceClass() != null && systemEventListener.getSourceClass().length() > 0) {
                    application.subscribeToEvent(clazz, ClassUtils.classForName(systemEventListener.getSourceClass()), listener);
                    continue;
                }
                application.subscribeToEvent(clazz, listener);
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.log(Level.SEVERE, "System event listener could not be initialized, reason:", classNotFoundException);
            }
        }
        ViewScopeEventListener viewScopeEventListener = new ViewScopeEventListener();
        application.subscribeToEvent(PostConstructViewMapEvent.class, UIViewRoot.class, (jakarta.faces.event.SystemEventListener)viewScopeEventListener);
        application.subscribeToEvent(PreDestroyViewMapEvent.class, UIViewRoot.class, (jakarta.faces.event.SystemEventListener)viewScopeEventListener);
        for (Map.Entry<String, Component> entry : dispenser.getComponentsByType().entrySet()) {
            application.addComponent(entry.getKey(), entry.getValue().getComponentClass());
        }
        for (Map.Entry<String, String> entry : dispenser.getConverterClassesById().entrySet()) {
            application.addConverter(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : dispenser.getConverterClassesByClass().entrySet()) {
            try {
                application.addConverter(ClassUtils.classForName(entry.getKey()), entry.getValue());
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Converter could not be added. Reason:", ex);
            }
        }
        for (Map.Entry<String, String> entry : dispenser.getValidatorClassesById().entrySet()) {
            application.addValidator(entry.getKey(), entry.getValue());
        }
        String string = this._externalContext.getInitParameter("jakarta.faces.validator.DISABLE_DEFAULT_BEAN_VALIDATOR");
        boolean bl = string != null && string.equalsIgnoreCase("true");
        boolean beanValidatorInstalledProgrammatically = false;
        if (!bl && ExternalSpecifications.isBeanValidationAvailable()) {
            application.addDefaultValidatorId("jakarta.faces.Bean");
            beanValidatorInstalledProgrammatically = true;
        }
        for (String validatorId : dispenser.getDefaultValidatorIds()) {
            application.addDefaultValidatorId(validatorId);
        }
        if (!beanValidatorInstalledProgrammatically && application.getDefaultValidatorInfo().containsKey("jakarta.faces.Bean")) {
            if (!ExternalSpecifications.isBeanValidationAvailable()) {
                log.log(Level.WARNING, "The BeanValidator was installed as a default-validator from a faces-config file, but bean validation is not available on the classpath, thus it will not work!");
            } else if (bl) {
                log.log(Level.INFO, "The BeanValidator was disabled as a default-validator via the config parameter jakarta.faces.validator.DISABLE_DEFAULT_BEAN_VALIDATOR in web.xml, but a faces-config file added it, thus it actually was installed as a default-validator.");
            }
        }
        for (Behavior behavior : dispenser.getBehaviors()) {
            application.addBehavior(behavior.getBehaviorId(), behavior.getBehaviorClass());
        }
        FlowHandlerFactory flowHandlerFactory = (FlowHandlerFactory)FactoryFinder.getFactory((String)"jakarta.faces.flow.FlowHandlerFactory");
        FlowHandler flowHandler = flowHandlerFactory.createFlowHandler(this.getFacesContext());
        application.setFlowHandler(flowHandler);
        for (ContractMapping mapping : dispenser.getResourceLibraryContractMappings()) {
            List<String> urlMappingsList = mapping.getUrlPatternList();
            for (String urlPattern : urlMappingsList) {
                for (String contract : mapping.getContractList()) {
                    String[] contracts = StringUtils.trim(StringUtils.splitShortString(contract, ' '));
                    this._runtimeConfig.addContractMapping(urlPattern, contracts);
                }
            }
        }
        this.setApplication(application);
    }

    private void _callInjectAndPostConstruct(Object instance) {
        try {
            Object innerInstance;
            if (instance instanceof FacesWrapper && (innerInstance = ((FacesWrapper)instance).getWrapped()) != null) {
                this._callInjectAndPostConstruct(innerInstance);
            }
            List injectedBeanStorage = (List)this._externalContext.getApplicationMap().get("org.apache.myfaces.spi.BEAN_ENTRY_STORAGE");
            Object creationMetaData = this.getInjectionProvider().inject(instance);
            injectedBeanStorage.add(new BeanEntry(instance, creationMetaData));
            this.getInjectionProvider().postConstruct(instance, creationMetaData);
        }
        catch (InjectionProviderException ex) {
            log.log(Level.INFO, "Exception on Inject or PostConstruct", ex);
        }
    }

    private void configureRuntimeConfig() {
        ArrayList<String> knownNamespaces;
        FacesConfigData dispenser;
        RuntimeConfig runtimeConfig;
        block34: {
            block33: {
                Class clazz;
                runtimeConfig = RuntimeConfig.getCurrentInstance(this._externalContext);
                dispenser = this.getDispenser();
                knownNamespaces = new ArrayList<String>();
                for (ComponentTagDeclaration declaration : dispenser.getComponentTagDeclarations()) {
                    runtimeConfig.addComponentTagDeclaration(declaration);
                    if (declaration.getNamespace() == null) continue;
                    knownNamespaces.add(declaration.getNamespace());
                }
                for (NavigationRule rule : dispenser.getNavigationRules()) {
                    runtimeConfig.addNavigationRule(rule);
                }
                for (String converterClassName : dispenser.getConverterConfigurationByClassName()) {
                    runtimeConfig.addConverterConfiguration(converterClassName, this._dispenser.getConverterConfiguration(converterClassName));
                }
                for (ResourceBundle bundle : dispenser.getResourceBundles()) {
                    runtimeConfig.addResourceBundle(bundle);
                }
                for (String className : dispenser.getElResolvers()) {
                    ELResolver elResolver = (ELResolver)ClassUtils.newInstance((String)className, ELResolver.class);
                    this._callInjectAndPostConstruct(elResolver);
                    runtimeConfig.addFacesConfigElResolver(elResolver);
                }
                for (String className : dispenser.getSearchKeywordResolvers()) {
                    SearchKeywordResolver searchKeywordResolver = (SearchKeywordResolver)ClassUtils.newInstance((String)className, SearchKeywordResolver.class);
                    runtimeConfig.addApplicationSearchExpressionResolver(searchKeywordResolver);
                }
                runtimeConfig.setFacesVersion(dispenser.getFacesVersion());
                runtimeConfig.setNamedEventManager(new NamedEventManager());
                for (NamedEvent event : dispenser.getNamedEvents()) {
                    try {
                        clazz = ClassUtils.classForName(event.getEventClass());
                        runtimeConfig.getNamedEventManager().addNamedEvent(event.getShortName(), clazz);
                    }
                    catch (ClassNotFoundException e) {
                        log.log(Level.SEVERE, "Named event could not be initialized, reason:", e);
                    }
                }
                String elResolverComparatorClass = this._myfacesConfig.getElResolverComparator();
                if (elResolverComparatorClass != null && !elResolverComparatorClass.isEmpty()) {
                    try {
                        Class clazz2 = ClassUtils.classForName(elResolverComparatorClass);
                        Comparator comparator = (Comparator)ClassUtils.newInstance(clazz2);
                        runtimeConfig.setELResolverComparator(comparator);
                    }
                    catch (Exception e) {
                        if (log.isLoggable(Level.SEVERE)) {
                            log.log(Level.SEVERE, "Cannot instantiate EL Resolver Comparator " + elResolverComparatorClass + " . Check org.apache.myfaces.EL_RESOLVER_COMPARATOR web config param. Initialization continues with no comparator used.", e);
                        }
                    }
                } else {
                    runtimeConfig.setELResolverComparator(null);
                }
                String elResolverPredicateClass = this._myfacesConfig.getElResolverPredicate();
                if (elResolverPredicateClass != null && !elResolverPredicateClass.isEmpty()) {
                    try {
                        clazz = ClassUtils.classForName(elResolverPredicateClass);
                        Object elResolverPredicate = ClassUtils.newInstance(clazz);
                        if (elResolverPredicate instanceof Predicate) {
                            runtimeConfig.setELResolverPredicate((Predicate)elResolverPredicate);
                        } else if (log.isLoggable(Level.SEVERE)) {
                            log.log(Level.SEVERE, "EL Resolver Predicate " + elResolverPredicateClass + " must implement " + Predicate.class.getName() + " . Check org.apache.myfaces.EL_RESOLVER_PREDICATE web config param. Initialization continues with no predicate used.");
                        }
                        break block33;
                    }
                    catch (Exception e) {
                        if (log.isLoggable(Level.SEVERE)) {
                            log.log(Level.SEVERE, "Cannot instantiate EL Resolver Predicate " + elResolverPredicateClass + " . Check org.apache.myfaces.EL_RESOLVER_PREDICATE web config param. Initialization continues with no predicate used.", e);
                        }
                        break block33;
                    }
                }
                runtimeConfig.setELResolverPredicate(null);
            }
            for (FaceletsProcessing faceletsProcessing : dispenser.getFaceletsProcessing()) {
                runtimeConfig.addFaceletProcessingConfiguration(faceletsProcessing.getFileExtension(), faceletsProcessing);
            }
            ResourceLibraryContractsProvider rlcp = ResourceLibraryContractsProviderFactory.getFacesConfigResourceProviderFactory(this._externalContext).createResourceLibraryContractsProvider(this._externalContext);
            try {
                runtimeConfig.setExternalContextResourceLibraryContracts(rlcp.getExternalContextResourceLibraryContracts(this._externalContext));
                runtimeConfig.setClassLoaderResourceLibraryContracts(rlcp.getClassloaderResourceLibraryContracts(this._externalContext));
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.SEVERE)) break block34;
                log.log(Level.SEVERE, "An error was found when scanning for resource library contracts", e);
            }
        }
        if (log.isLoggable(Level.INFO)) {
            for (List<String> list : runtimeConfig.getContractMappings().values()) {
                for (String contract : list) {
                    if (runtimeConfig.getResourceLibraryContracts().contains(contract)) continue;
                    log.log(Level.INFO, "Resource Library Contract " + contract + " was not found while scanning for available contracts.");
                }
            }
        }
        if (runtimeConfig.getContractMappings().isEmpty()) {
            String[] contracts = runtimeConfig.getResourceLibraryContracts().toArray(new String[runtimeConfig.getResourceLibraryContracts().size()]);
            runtimeConfig.addContractMapping("*", contracts);
        }
        for (String resourceResolver : dispenser.getResourceResolvers()) {
            runtimeConfig.addResourceResolver(resourceResolver);
        }
        for (FaceletTagLibrary faceletTagLibrary : dispenser.getTagLibraries()) {
            runtimeConfig.addFaceletTagLibrary(faceletTagLibrary);
            if (faceletTagLibrary.getNamespace() == null) continue;
            knownNamespaces.add(faceletTagLibrary.getNamespace());
        }
        knownNamespaces.add("http://xmlns.jcp.org/jsf/core");
        knownNamespaces.add("http://java.sun.com/jsf/core");
        knownNamespaces.add("http://xmlns.jcp.org/jsf/html");
        knownNamespaces.add("http://java.sun.com/jsf/html");
        knownNamespaces.add("http://xmlns.jcp.org/jsf/facelets");
        knownNamespaces.add("http://java.sun.com/jsf/facelets");
        knownNamespaces.add("http://xmlns.jcp.org/jsp/jstl/core");
        knownNamespaces.add("http://java.sun.com/jsp/jstl/core");
        knownNamespaces.add("http://java.sun.com/jstl/core");
        knownNamespaces.add("http://xmlns.jcp.org/jsp/jstl/functions");
        knownNamespaces.add("http://java.sun.com/jsp/jstl/functions");
        knownNamespaces.add("http://xmlns.jcp.org/jsf/composite");
        knownNamespaces.add("http://java.sun.com/jsf/composite");
        knownNamespaces.add("http://xmlns.jcp.org/jsf");
        knownNamespaces.add("http://java.sun.com/jsf");
        knownNamespaces.add("http://xmlns.jcp.org/jsf/passthrough");
        knownNamespaces.add("http://java.sun.com/jsf/passthrough");
        HashMap<Integer, String> namespaceById = new HashMap<Integer, String>();
        HashMap<String, Integer> idByNamespace = new HashMap<String, Integer>();
        Collections.sort(knownNamespaces);
        for (int i = 0; i < knownNamespaces.size(); ++i) {
            namespaceById.put(i, (String)knownNamespaces.get(i));
            idByNamespace.put((String)knownNamespaces.get(i), i);
        }
        runtimeConfig.setNamespaceById(Collections.unmodifiableMap(namespaceById));
        runtimeConfig.setIdByNamespace(Collections.unmodifiableMap(idByNamespace));
        for (ViewPoolMapping viewPoolMapping : dispenser.getViewPoolMappings()) {
            runtimeConfig.addViewPoolMapping(viewPoolMapping);
        }
        for (FaceletsTemplateMapping faceletsTemplateMapping : dispenser.getFaceletsTemplateMappings()) {
            runtimeConfig.addFaceletsTemplateMapping(faceletsTemplateMapping);
        }
    }

    private void configureRenderKits() {
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"jakarta.faces.render.RenderKitFactory");
        FacesConfigData dispenser = this.getDispenser();
        for (String renderKitId : dispenser.getRenderKitIds()) {
            Collection<String> renderKitClass = dispenser.getRenderKitClasses(renderKitId);
            if (renderKitClass.isEmpty()) {
                renderKitClass = new ArrayList<String>(1);
                renderKitClass.add(DEFAULT_RENDER_KIT_CLASS);
            }
            RenderKit renderKit = ClassUtils.buildApplicationObject(RenderKit.class, renderKitClass, null);
            boolean lazyRenderKit = renderKit instanceof LazyRenderKit;
            for (Renderer element : dispenser.getRenderers(renderKitId)) {
                if (element.getRendererClass() != null) {
                    jakarta.faces.render.Renderer renderer;
                    if (lazyRenderKit) {
                        ((LazyRenderKit)renderKit).addRenderer(element.getComponentFamily(), element.getRendererType(), element.getRendererClass());
                        continue;
                    }
                    try {
                        renderer = (jakarta.faces.render.Renderer)ClassUtils.newInstance((String)element.getRendererClass());
                    }
                    catch (Throwable e) {
                        log.log(Level.SEVERE, "failed to configure class " + element.getRendererClass(), e);
                        continue;
                    }
                    if (renderer != null) {
                        renderKit.addRenderer(element.getComponentFamily(), element.getRendererType(), renderer);
                        continue;
                    }
                    log.log(Level.INFO, "Renderer instance cannot be created for " + element.getRendererClass() + ", ignoring..." + element.getRendererClass());
                    continue;
                }
                log.log(Level.INFO, "Renderer element with no rendererClass found, ignoring..." + element.getRendererClass());
            }
            Collection<ClientBehaviorRenderer> clientBehaviorRenderers = dispenser.getClientBehaviorRenderers(renderKitId);
            for (ClientBehaviorRenderer clientBehaviorRenderer : clientBehaviorRenderers) {
                try {
                    jakarta.faces.render.ClientBehaviorRenderer behaviorRenderer = (jakarta.faces.render.ClientBehaviorRenderer)ClassUtils.newInstance((String)clientBehaviorRenderer.getRendererClass());
                    renderKit.addClientBehaviorRenderer(clientBehaviorRenderer.getRendererType(), behaviorRenderer);
                }
                catch (Throwable e) {
                    if (!log.isLoggable(Level.SEVERE)) continue;
                    log.log(Level.SEVERE, "failed to configure client behavior renderer class " + clientBehaviorRenderer.getRendererClass(), e);
                }
            }
            renderKitFactory.addRenderKit(renderKitId, renderKit);
        }
    }

    private void configureLifecycle() {
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"jakarta.faces.lifecycle.LifecycleFactory");
        Iterator it = lifecycleFactory.getLifecycleIds();
        while (it.hasNext()) {
            Lifecycle lifecycle = lifecycleFactory.getLifecycle((String)it.next());
            for (String listenerClassName : this.getDispenser().getLifecyclePhaseListeners()) {
                try {
                    PhaseListener listener = (PhaseListener)ClassUtils.newInstance((String)listenerClassName, PhaseListener.class);
                    this._callInjectAndPostConstruct(listener);
                    lifecycle.addPhaseListener(listener);
                }
                catch (ClassCastException e) {
                    log.severe("Class " + listenerClassName + " does not implement PhaseListener");
                }
            }
            FacesContext facesContext = this.getFacesContext();
            if (facesContext.isProjectStage(ProjectStage.Development) && this._myfacesConfig.isDebugPhaseListenerEnabled()) {
                lifecycle.addPhaseListener((PhaseListener)new DebugPhaseListener());
            }
            if (!facesContext.isProjectStage(ProjectStage.Development) || !this._myfacesConfig.isElResolverTracing()) continue;
            lifecycle.addPhaseListener((PhaseListener)new TracingELResolverPhaseListener());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSerialFactory() {
        String serialProvider = this._externalContext.getInitParameter("org.apache.myfaces.SERIAL_FACTORY");
        SerialFactory serialFactory = null;
        if (serialProvider == null) {
            serialFactory = new DefaultSerialFactory();
        } else {
            try {
                serialFactory = (SerialFactory)ClassUtils.newInstance((String)serialProvider);
            }
            catch (ClassCastException e) {
                log.log(Level.SEVERE, "Make sure '" + serialProvider + "' implements the correct interface", e);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "", e);
            }
            finally {
                if (serialFactory == null) {
                    serialFactory = new DefaultSerialFactory();
                    log.severe("Using default serialization provider");
                }
            }
        }
        log.fine("Serialization provider : " + serialFactory.getClass());
        this._externalContext.getApplicationMap().put("org.apache.myfaces.SERIAL_FACTORY", serialFactory);
    }

    private void configureFlowHandler() {
        FacesContext facesContext = this.getFacesContext();
        Application application = this.getApplication();
        FacesConfigData dispenser = this.getDispenser();
        if (!dispenser.getFacesFlowDefinitions().isEmpty()) {
            FacesConfigurator.enableDefaultWindowMode(facesContext);
        }
        for (FacesFlowDefinition flowDefinition : dispenser.getFacesFlowDefinitions()) {
            Freezable node;
            FlowImpl flow = new FlowImpl();
            flow.setId(flowDefinition.getId());
            flow.setDefiningDocumentId(flowDefinition.getDefiningDocumentId());
            flow.setStartNodeId(flowDefinition.getStartNode());
            if (StringUtils.isNotEmpty(flowDefinition.getInitializer())) {
                flow.setInitializer(application.getExpressionFactory().createMethodExpression(facesContext.getELContext(), flowDefinition.getInitializer(), null, (Class[])this.NO_PARAMETER_TYPES));
            }
            if (StringUtils.isNotEmpty(flowDefinition.getFinalizer())) {
                flow.setFinalizer(application.getExpressionFactory().createMethodExpression(facesContext.getELContext(), flowDefinition.getFinalizer(), null, (Class[])this.NO_PARAMETER_TYPES));
            }
            for (FacesFlowCall call : flowDefinition.getFlowCallList()) {
                node = new FlowCallNodeImpl(call.getId());
                if (call.getFlowReference() != null) {
                    ((FlowCallNodeImpl)node).setCalledFlowId(call.getFlowReference().getFlowId());
                    ((FlowCallNodeImpl)node).setCalledFlowDocumentId(call.getFlowReference().getFlowDocumentId());
                }
                for (FacesFlowParameter facesFlowParameter : call.getOutboundParameterList()) {
                    ((FlowCallNodeImpl)node).putOutboundParameter(facesFlowParameter.getName(), new ParameterImpl(facesFlowParameter.getName(), application.getExpressionFactory().createValueExpression(facesContext.getELContext(), facesFlowParameter.getValue(), Object.class)));
                }
                flow.putFlowCall(((FlowCallNodeImpl)node).getId(), (FlowCallNode)node);
            }
            for (FacesFlowMethodCall methodCall : flowDefinition.getMethodCallList()) {
                node = new MethodCallNodeImpl(methodCall.getId());
                if (StringUtils.isNotEmpty(methodCall.getMethod())) {
                    ((MethodCallNodeImpl)node).setMethodExpression(application.getExpressionFactory().createMethodExpression(facesContext.getELContext(), methodCall.getMethod(), null, (Class[])this.NO_PARAMETER_TYPES));
                }
                if (StringUtils.isNotEmpty(methodCall.getDefaultOutcome())) {
                    ((MethodCallNodeImpl)node).setOutcome(application.getExpressionFactory().createValueExpression(facesContext.getELContext(), methodCall.getDefaultOutcome(), Object.class));
                }
                for (FacesFlowMethodParameter facesFlowMethodParameter : methodCall.getParameterList()) {
                    ((MethodCallNodeImpl)node).addParameter(new ParameterImpl(facesFlowMethodParameter.getClassName(), application.getExpressionFactory().createValueExpression(facesContext.getELContext(), facesFlowMethodParameter.getValue(), Object.class)));
                }
                flow.addMethodCall((MethodCallNode)node);
            }
            for (FacesFlowParameter parameter : flowDefinition.getInboundParameterList()) {
                flow.putInboundParameter(parameter.getName(), new ParameterImpl(parameter.getName(), application.getExpressionFactory().createValueExpression(facesContext.getELContext(), parameter.getValue(), Object.class)));
            }
            for (NavigationRule rule : flowDefinition.getNavigationRuleList()) {
                flow.addNavigationCases(rule.getFromViewId(), NavigationUtils.convertNavigationCasesToAPI(rule));
            }
            for (FacesFlowSwitch flowSwitch : flowDefinition.getSwitchList()) {
                node = new SwitchNodeImpl(flowSwitch.getId());
                if (flowSwitch.getDefaultOutcome() != null && StringUtils.isNotEmpty(flowSwitch.getDefaultOutcome().getFromOutcome())) {
                    if (ELText.isLiteral(flowSwitch.getDefaultOutcome().getFromOutcome())) {
                        ((SwitchNodeImpl)node).setDefaultOutcome(flowSwitch.getDefaultOutcome().getFromOutcome());
                    } else {
                        ((SwitchNodeImpl)node).setDefaultOutcome(application.getExpressionFactory().createValueExpression(facesContext.getELContext(), flowSwitch.getDefaultOutcome().getFromOutcome(), Object.class));
                    }
                }
                for (NavigationCase navigationCase : flowSwitch.getNavigationCaseList()) {
                    SwitchCaseImpl nodeCase = new SwitchCaseImpl();
                    nodeCase.setFromOutcome(navigationCase.getFromOutcome());
                    if (StringUtils.isNotEmpty(navigationCase.getIf())) {
                        nodeCase.setCondition(application.getExpressionFactory().createValueExpression(facesContext.getELContext(), navigationCase.getIf(), Object.class));
                    }
                    ((SwitchNodeImpl)node).addCase(nodeCase);
                }
                flow.putSwitch(((SwitchNodeImpl)node).getId(), (SwitchNode)node);
            }
            for (FacesFlowView view : flowDefinition.getViewList()) {
                node = new ViewNodeImpl(view.getId(), view.getVdlDocument());
                flow.addView((ViewNode)node);
            }
            for (FacesFlowReturn flowReturn : flowDefinition.getReturnList()) {
                node = new ReturnNodeImpl(flowReturn.getId());
                if (flowReturn.getNavigationCase() != null && StringUtils.isNotEmpty(flowReturn.getNavigationCase().getFromOutcome())) {
                    if (ELText.isLiteral(flowReturn.getNavigationCase().getFromOutcome())) {
                        ((ReturnNodeImpl)node).setFromOutcome(flowReturn.getNavigationCase().getFromOutcome());
                    } else {
                        ((ReturnNodeImpl)node).setFromOutcome(application.getExpressionFactory().createValueExpression(facesContext.getELContext(), flowReturn.getNavigationCase().getFromOutcome(), Object.class));
                    }
                }
                flow.putReturn(((ReturnNodeImpl)node).getId(), (ReturnNode)node);
            }
            flow.freeze();
            application.getFlowHandler().addFlow(facesContext, (Flow)flow);
        }
        FacesConfigurator.configureAnnotatedFlows(facesContext);
    }

    public static void configureAnnotatedFlows(FacesContext facesContext) {
        FacesFlowProviderFactory factory = FacesFlowProviderFactory.getFacesFlowProviderFactory(facesContext.getExternalContext());
        FacesFlowProvider provider = factory.getFacesFlowProvider(facesContext.getExternalContext());
        Iterator<Flow> it = provider.getAnnotatedFlows(facesContext);
        if (it == null) {
            return;
        }
        if (it.hasNext()) {
            FacesConfigurator.enableDefaultWindowMode(facesContext);
        }
        while (it.hasNext()) {
            Flow flow = it.next();
            if (flow instanceof FlowImpl) {
                ((FlowImpl)flow).freeze();
            }
            facesContext.getApplication().getFlowHandler().addFlow(facesContext, flow);
        }
    }

    public static void enableDefaultWindowMode(FacesContext facesContext) {
        String windowMode;
        if (!FacesConfigurator.isEnableDefaultWindowMode(facesContext.getExternalContext()) && (windowMode = WebConfigParamUtils.getStringInitParameter(facesContext.getExternalContext(), "jakarta.faces.CLIENT_WINDOW_MODE", null)) == null) {
            String defaultWindowMode = WebConfigParamUtils.getStringInitParameter(facesContext.getExternalContext(), "jakarta.faces.CLIENT_WINDOW_MODE", "url");
            log.info("The current configuration requires ClientWindow enabled, setting it to '" + defaultWindowMode + "'");
            facesContext.getExternalContext().getApplicationMap().put(ENABLE_DEFAULT_WINDOW_MODE, Boolean.TRUE);
        }
    }

    public static boolean isEnableDefaultWindowMode(ExternalContext externalContext) {
        return Boolean.TRUE.equals(externalContext.getApplicationMap().get(ENABLE_DEFAULT_WINDOW_MODE));
    }

    public static boolean isUrlWindowMode(ExternalContext externalContext) {
        return FacesConfigurator.isEnableDefaultWindowMode(externalContext) || "url".equals(externalContext.getInitParameter("jakarta.faces.CLIENT_WINDOW_MODE"));
    }

    public void configureProtectedViews() {
        Application application = this.getApplication();
        FacesConfigData dispenser = this.getDispenser();
        ViewHandler viewHandler = application.getViewHandler();
        for (String urlPattern : dispenser.getProtectedViewUrlPatterns()) {
            viewHandler.addProtectedView(urlPattern);
        }
    }

    protected InjectionProvider getInjectionProvider() {
        if (this._injectionProvider == null) {
            this._injectionProvider = InjectionProviderFactory.getInjectionProviderFactory(this._externalContext).getInjectionProvider(this._externalContext);
        }
        return this._injectionProvider;
    }

    protected FacesContext getFacesContext() {
        if (this._facesContext == null) {
            this._facesContext = FacesContext.getCurrentInstance();
        }
        return this._facesContext;
    }

    protected Application getApplication() {
        if (this._application == null) {
            return this.getFacesContext().getApplication();
        }
        return this._application;
    }

    protected void setApplication(Application application) {
        this._application = application;
    }
}

