/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.global;

import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.global.AbstractOpenSshHostKeysHandler;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.buffer.keys.BufferPublicKeyParser;
import org.apache.sshd.server.session.ServerSession;

public class OpenSshHostKeysHandler
extends AbstractOpenSshHostKeysHandler
implements SignatureFactoriesManager {
    public static final String REQUEST = "hostkeys-prove-00@openssh.com";
    public static final OpenSshHostKeysHandler INSTANCE = new OpenSshHostKeysHandler(){

        @Override
        public List<NamedFactory<Signature>> getSignatureFactories() {
            return null;
        }

        @Override
        public void setSignatureFactories(List<NamedFactory<Signature>> factories) {
            if (!GenericUtils.isEmpty(factories)) {
                throw new UnsupportedOperationException("Not allowed to change default instance signature factories");
            }
        }
    };
    private List<NamedFactory<Signature>> factories;

    public OpenSshHostKeysHandler() {
        super(REQUEST);
    }

    public OpenSshHostKeysHandler(BufferPublicKeyParser<? extends PublicKey> parser) {
        super(REQUEST, parser);
    }

    public List<NamedFactory<Signature>> getSignatureFactories() {
        return this.factories;
    }

    public void setSignatureFactories(List<NamedFactory<Signature>> factories) {
        this.factories = factories;
    }

    @Override
    protected RequestHandler.Result handleHostKeys(Session session, Collection<PublicKey> keys, boolean wantReply, Buffer buffer) throws Exception {
        ValidateUtils.checkTrue((boolean)wantReply, (String)"No reply required for host keys of %s", (Object)session);
        Collection factories = ValidateUtils.checkNotNullAndNotEmpty((Collection)SignatureFactoriesManager.resolveSignatureFactories((SignatureFactoriesManager)this, (SignatureFactoriesManager)session), (String)"No signature factories available for host keys of session=%s", (Object[])new Object[]{session});
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleHostKeys({})[want-reply={}] received {} keys - factories={}", new Object[]{session, wantReply, GenericUtils.size(keys), NamedResource.getNames((Collection)factories)});
        }
        buffer = session.createBuffer((byte)81);
        ByteArrayBuffer buf = new ByteArrayBuffer();
        byte[] sessionId = session.getSessionId();
        KeyPairProvider kpp = Objects.requireNonNull(((ServerSession)session).getKeyPairProvider(), "No server keys provider");
        Iterator<PublicKey> iterator = keys.iterator();
        while (iterator.hasNext()) {
            KeyPair kp;
            String keyType;
            String algo;
            PublicKey k;
            PublicKey signingKey = k = iterator.next();
            if (k instanceof OpenSshCertificate) {
                signingKey = ((OpenSshCertificate)k).getCertPubKey();
            }
            if ("ssh-rsa".equals(algo = (keyType = KeyUtils.getKeyType((Key)signingKey)))) {
                String negotiated = (String)session.getKexNegotiationResult().get(KexProposalOption.ALGORITHMS);
                String canonical = KeyUtils.getCanonicalKeyType((String)negotiated);
                algo = "ssh-rsa".equals(canonical) || "ssh-rsa-cert-v01@openssh.com".equals(canonical) ? KeyUtils.getSignatureAlgorithm((String)negotiated) : "rsa-sha2-512";
            }
            Signature verifier = (Signature)ValidateUtils.checkNotNull((Object)((Signature)NamedFactory.create((Collection)factories, (String)algo)), (String)"No signer could be located for key type=%s, algo=%s", (Object[])new Object[]{keyType, algo});
            try {
                kp = (KeyPair)ValidateUtils.checkNotNull((Object)kpp.loadKey((SessionContext)session, keyType), (String)"No key of type=%s available", (Object)keyType);
            }
            catch (Error e) {
                this.warn("handleHostKeys({}) failed ({}) to load key of type={}: {}", session, e.getClass().getSimpleName(), keyType, e.getMessage(), e);
                throw new RuntimeSshException((Throwable)e);
            }
            verifier.initSigner((SessionContext)session, kp.getPrivate());
            buf.clear();
            buf.putString(REQUEST);
            buf.putBytes(sessionId);
            buf.putPublicKey(k);
            byte[] data = buf.getCompactData();
            verifier.update((SessionContext)session, data);
            byte[] signature = verifier.sign((SessionContext)session);
            buffer.putBytes(signature);
        }
        session.writePacket(buffer);
        return RequestHandler.Result.Replied;
    }
}

