/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session.filter;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.proxy.ProxyData;
import org.apache.sshd.client.session.AbstractClientSession;
import org.apache.sshd.client.session.proxy.AbstractProxyConnector;
import org.apache.sshd.client.session.proxy.HttpProxyConnector;
import org.apache.sshd.client.session.proxy.Socks5ProxyConnector;
import org.apache.sshd.common.filter.InputHandler;
import org.apache.sshd.common.filter.IoFilter;
import org.apache.sshd.common.filter.OutputHandler;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.DefaultIoWriteFuture;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.io.functors.IOFunction;

public class ClientProxyFilter
extends IoFilter {
    private final AbstractClientSession session;
    private final AbstractProxyConnector connector;
    private final AtomicReference<InputHandler> input = new AtomicReference();
    private final AtomicReference<OutputHandler> output = new AtomicReference();
    private final Queue<Runnable> queue = new ConcurrentLinkedQueue<Runnable>();
    private final SshFutureListener<CloseFuture> closer;

    public ClientProxyFilter(AbstractClientSession session, ProxyData proxy, InetSocketAddress targetAddress) {
        this.session = Objects.requireNonNull(session);
        this.connector = proxy.getType() == Proxy.Type.SOCKS ? new Socks5ProxyConnector(proxy, targetAddress, (IOFunction<Buffer, IoWriteFuture>)((IOFunction)this::write), this::proxyAuth) : new HttpProxyConnector(proxy, targetAddress, (IOFunction<Buffer, IoWriteFuture>)((IOFunction)this::write), this::proxyAuth);
        this.closer = f -> this.connector.close();
        session.getIoSession().addCloseFutureListener(this.closer);
        this.input.set(new ProxyInputHandler());
        this.output.set(new ProxyOutputHandler());
    }

    @Override
    public InputHandler in() {
        return this.input.get();
    }

    @Override
    public OutputHandler out() {
        return this.output.get();
    }

    private IoWriteFuture write(Buffer message) throws IOException {
        return this.owner().send(-1, message);
    }

    private PasswordAuthentication proxyAuth(InetSocketAddress proxyAddress) {
        UserInteraction ui = this.session.getUserInteraction();
        if (ui == null) {
            return null;
        }
        return ui.getProxyCredentials(this.session, proxyAddress);
    }

    private class ProxyInputHandler
    implements InputHandler {
        ProxyInputHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void received(Readable message) throws Exception {
            if (ClientProxyFilter.this.input.get() == null || ClientProxyFilter.this.connector.isDone()) {
                ClientProxyFilter.this.owner().passOn(message);
            } else {
                Buffer buffer = ClientProxyFilter.this.connector.received(message);
                if (ClientProxyFilter.this.connector.isDone()) {
                    ClientProxyFilter.this.session.getIoSession().removeCloseFutureListener(ClientProxyFilter.this.closer);
                    ClientProxyFilter.this.connector.close();
                    if (buffer != null && buffer.available() > 0) {
                        buffer.compact();
                        ClientProxyFilter.this.owner().passOn((Readable)buffer);
                    }
                    ClientProxyFilter.this.input.set(null);
                    Queue queue = ClientProxyFilter.this.queue;
                    synchronized (queue) {
                        Runnable send;
                        ClientProxyFilter.this.output.set(null);
                        while ((send = (Runnable)ClientProxyFilter.this.queue.poll()) != null) {
                            send.run();
                        }
                    }
                }
            }
        }
    }

    private class ProxyOutputHandler
    implements OutputHandler {
        private AtomicBoolean first = new AtomicBoolean(true);

        ProxyOutputHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IoWriteFuture send(int cmd, Buffer message) throws IOException {
            if (this.first.compareAndSet(true, false)) {
                ClientProxyFilter.this.connector.start();
            }
            Queue queue = ClientProxyFilter.this.queue;
            synchronized (queue) {
                if (ClientProxyFilter.this.output.get() != null) {
                    DefaultIoWriteFuture result = new DefaultIoWriteFuture((Object)this, null);
                    ClientProxyFilter.this.queue.add(() -> {
                        try {
                            ClientProxyFilter.this.owner().send(cmd, message).addListener(w -> result.setValue((Object)(w.isWritten() ? Boolean.TRUE : w.getException())));
                        }
                        catch (IOException e) {
                            result.setValue((Object)e);
                        }
                    });
                    return result;
                }
            }
            return ClientProxyFilter.this.owner().send(cmd, message);
        }
    }
}

