/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.NavigableSet;
import java.util.Objects;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.PrivateKeyEntryResolver;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.output.SecureByteArrayOutputStream;

public interface PrivateKeyEntryDecoder
extends KeyEntryResolver,
PrivateKeyEntryResolver {
    @Override
    default public PrivateKey resolve(SessionContext session, String keyType, byte[] keyData) throws IOException, GeneralSecurityException {
        ValidateUtils.checkNotNullAndNotEmpty(keyType, "No key type provided");
        NavigableSet<String> supported = this.getSupportedKeyTypes();
        if (GenericUtils.size(supported) > 0 && supported.contains(keyType)) {
            return this.decodePrivateKey(session, FilePasswordProvider.EMPTY, keyData);
        }
        throw new InvalidKeySpecException("resolve(" + keyType + ") not in listed supported types: " + supported);
    }

    default public PrivateKey decodePrivateKey(SessionContext session, FilePasswordProvider passwordProvider, byte ... keyData) throws IOException, GeneralSecurityException {
        return this.decodePrivateKey(session, passwordProvider, keyData, 0, NumberUtils.length(keyData));
    }

    default public PrivateKey decodePrivateKey(SessionContext session, FilePasswordProvider passwordProvider, byte[] keyData, int offset, int length) throws IOException, GeneralSecurityException {
        if (length <= 0) {
            return null;
        }
        try (ByteArrayInputStream stream = new ByteArrayInputStream(keyData, offset, length);){
            PrivateKey privateKey = this.decodePrivateKey(session, passwordProvider, stream);
            return privateKey;
        }
    }

    default public PrivateKey decodePrivateKey(SessionContext session, FilePasswordProvider passwordProvider, InputStream keyData) throws IOException, GeneralSecurityException {
        String type = KeyEntryResolver.decodeString(keyData, 256);
        if (GenericUtils.isEmpty(type)) {
            throw new StreamCorruptedException("Missing key type string");
        }
        NavigableSet<String> supported = this.getSupportedKeyTypes();
        if (GenericUtils.isEmpty(supported) || !supported.contains(type)) {
            throw new InvalidKeySpecException("Reported key type (" + type + ") not in supported list: " + supported);
        }
        return this.decodePrivateKey(session, type, passwordProvider, keyData);
    }

    public PrivateKey decodePrivateKey(SessionContext var1, String var2, FilePasswordProvider var3, InputStream var4) throws IOException, GeneralSecurityException;

    default public String encodePrivateKey(SecureByteArrayOutputStream s, PrivateKey key, PublicKey pubKey) throws IOException {
        Objects.requireNonNull(key, "No private key provided");
        return null;
    }

    default public boolean isPublicKeyRecoverySupported() {
        return false;
    }

    default public PublicKey recoverPublicKey(PrivateKey prvKey) throws GeneralSecurityException {
        return null;
    }
}

