/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session.proxy;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class GssApiMechanisms {
    public static final String GSSAPI_HOST_PREFIX = "host@";
    public static final Oid KERBEROS_5 = GssApiMechanisms.createOid("1.2.840.113554.1.2.2");
    public static final Oid SPNEGO = GssApiMechanisms.createOid("1.3.6.1.5.5.2");
    private static final Object LOCK = new Object();
    private static Map<Oid, Boolean> supportedMechanisms;

    private GssApiMechanisms() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Oid> getSupportedMechanisms() {
        Object object = LOCK;
        synchronized (object) {
            if (supportedMechanisms == null) {
                GSSManager manager = GSSManager.getInstance();
                Oid[] mechs = manager.getMechs();
                LinkedHashMap<Oid, Boolean> mechanisms = new LinkedHashMap<Oid, Boolean>();
                if (mechs != null) {
                    for (Oid oid : mechs) {
                        mechanisms.put(oid, Boolean.FALSE);
                    }
                }
                supportedMechanisms = mechanisms;
            }
            return Collections.unmodifiableSet(supportedMechanisms.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void worked(Oid mechanism) {
        Object object = LOCK;
        synchronized (object) {
            supportedMechanisms.put(mechanism, Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void failed(Oid mechanism) {
        Object object = LOCK;
        synchronized (object) {
            Boolean worked = supportedMechanisms.get(mechanism);
            if (worked != null && !worked.booleanValue()) {
                supportedMechanisms.remove(mechanism);
            }
        }
    }

    public static InetAddress resolve(InetSocketAddress remote) {
        InetAddress address = remote.getAddress();
        if (address == null) {
            try {
                address = InetAddress.getByName(remote.getHostString());
            }
            catch (UnknownHostException e) {
                return null;
            }
        }
        return address;
    }

    public static String getCanonicalName(InetSocketAddress remote) {
        InetAddress address = GssApiMechanisms.resolve(remote);
        if (address == null) {
            return remote.getHostString();
        }
        return address.getCanonicalHostName();
    }

    public static GSSContext createContext(Oid mechanism, String fqdn) {
        GSSContext context = null;
        try {
            GSSManager manager = GSSManager.getInstance();
            context = manager.createContext(manager.createName(GSSAPI_HOST_PREFIX + fqdn, GSSName.NT_HOSTBASED_SERVICE), mechanism, null, 0);
        }
        catch (GSSException e) {
            GssApiMechanisms.closeContextSilently(context);
            GssApiMechanisms.failed(mechanism);
            return null;
        }
        GssApiMechanisms.worked(mechanism);
        return context;
    }

    public static void closeContextSilently(GSSContext context) {
        if (context != null) {
            try {
                context.dispose();
            }
            catch (GSSException gSSException) {
                // empty catch block
            }
        }
    }

    private static Oid createOid(String rep) {
        try {
            return new Oid(rep);
        }
        catch (GSSException e) {
            return null;
        }
    }
}

