/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.scope;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.aether.impl.scope.InternalScopeManager;
import org.eclipse.aether.scope.DependencyScope;
import org.eclipse.aether.util.graph.transformer.ConflictResolver;

public final class ManagedScopeSelector
extends ConflictResolver.ScopeSelector {
    private final DependencyScope systemScope;
    private final List<DependencyScope> dependencyScopesByWidthDescending;

    public ManagedScopeSelector(InternalScopeManager scopeManager) {
        Objects.requireNonNull(scopeManager, "scopeManager");
        this.systemScope = scopeManager.getSystemDependencyScope().orElse(null);
        this.dependencyScopesByWidthDescending = Collections.unmodifiableList(scopeManager.getDependencyScopeUniverse().stream().sorted(Comparator.comparing(scopeManager::getDependencyScopeWidth).reversed()).collect(Collectors.toList()));
    }

    public void selectScope(ConflictResolver.ConflictContext context) {
        String scope = context.getWinner().getDependency().getScope();
        if (this.systemScope == null || !this.systemScope.getId().equals(scope)) {
            scope = this.chooseEffectiveScope(context.getItems());
        }
        context.setScope(scope);
    }

    private String chooseEffectiveScope(Collection<ConflictResolver.ConflictItem> items) {
        HashSet<String> scopes = new HashSet<String>();
        for (ConflictResolver.ConflictItem item : items) {
            if (item.getDepth() <= 1) {
                return item.getDependency().getScope();
            }
            scopes.addAll(item.getScopes());
        }
        return this.chooseEffectiveScope((Set<String>)scopes);
    }

    public String chooseEffectiveScope(Set<String> scopes) {
        if (scopes.size() > 1 && this.systemScope != null) {
            scopes.remove(this.systemScope.getId());
        }
        String effectiveScope = "";
        if (scopes.size() == 1) {
            effectiveScope = scopes.iterator().next();
        } else {
            for (DependencyScope dependencyScope : this.dependencyScopesByWidthDescending) {
                if (!scopes.contains(dependencyScope.getId())) continue;
                effectiveScope = dependencyScope.getId();
                break;
            }
        }
        return effectiveScope;
    }
}

