/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.audit.log4j.audit;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.knox.gateway.audit.api.AuditContext;
import org.apache.knox.gateway.audit.api.AuditService;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.audit.log4j.audit.Log4jAuditContext;
import org.apache.knox.gateway.audit.log4j.audit.Log4jAuditor;
import org.apache.logging.log4j.ThreadContext;

public class Log4jAuditService
implements AuditService {
    public static final String MDC_AUDIT_CONTEXT_KEY = "audit_context";
    private Map<String, Auditor> auditors = new ConcurrentHashMap<String, Auditor>();

    @Override
    public AuditContext createContext() {
        Log4jAuditContext context = new Log4jAuditContext();
        this.attachContext(context);
        return context;
    }

    @Override
    public AuditContext getContext() {
        if (ThreadContext.get((String)MDC_AUDIT_CONTEXT_KEY) == null) {
            return null;
        }
        return new Log4jAuditContext(ThreadContext.get((String)"audit_context_username"), ThreadContext.get((String)"audit_context_proxyUsername"), ThreadContext.get((String)"audit_context_systemUsername"), ThreadContext.get((String)"audit_context_targetServiceName"), ThreadContext.get((String)"audit_context_remoteIp"), ThreadContext.get((String)"audit_context_remoteHostname"));
    }

    @Override
    public void attachContext(AuditContext context) {
        if (context != null) {
            ThreadContext.put((String)MDC_AUDIT_CONTEXT_KEY, (String)"true");
            ThreadContext.put((String)"audit_context_username", (String)context.getUsername());
            ThreadContext.put((String)"audit_context_proxyUsername", (String)context.getProxyUsername());
            ThreadContext.put((String)"audit_context_systemUsername", (String)context.getSystemUsername());
            ThreadContext.put((String)"audit_context_targetServiceName", (String)context.getTargetServiceName());
            ThreadContext.put((String)"audit_context_remoteIp", (String)context.getRemoteIp());
            ThreadContext.put((String)"audit_context_remoteHostname", (String)context.getRemoteHostname());
        }
    }

    @Override
    public AuditContext detachContext() {
        AuditContext context = this.getContext();
        ThreadContext.remove((String)MDC_AUDIT_CONTEXT_KEY);
        ThreadContext.remove((String)"audit_context_username");
        ThreadContext.remove((String)"audit_context_proxyUsername");
        ThreadContext.remove((String)"audit_context_systemUsername");
        ThreadContext.remove((String)"audit_context_targetServiceName");
        ThreadContext.remove((String)"audit_context_remoteIp");
        ThreadContext.remove((String)"audit_context_remoteHostname");
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(AuditContext context, Callable<T> callable) throws Exception {
        try {
            this.attachContext(context);
            T t = callable.call();
            return t;
        }
        finally {
            this.detachContext();
        }
    }

    @Override
    public synchronized Auditor getAuditor(String auditorName, String componentName, String serviceName) {
        String key = auditorName + componentName + serviceName;
        Auditor auditor = this.auditors.get(key);
        if (auditor == null) {
            auditor = new Log4jAuditor(auditorName, componentName, serviceName);
            this.auditors.put(key, auditor);
        }
        return auditor;
    }
}

