/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client.remote;

import java.lang.reflect.Type;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.remote.RemoteReturn;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.rest.client.remote.RemoteMethod;

public final class RemoteMethodReturn {
    private final Type returnType;
    private final RemoteReturn returnValue;
    private final ResponseBeanMeta meta;

    RemoteMethodReturn(MethodInfo m) {
        org.apache.juneau.http.remote.RemoteMethod rm;
        ClassInfo rt = m.getReturnType();
        RemoteMethod orm = m.getAnnotation(RemoteMethod.class);
        if (orm == null) {
            orm = m.getResolvedReturnType().getAnnotation(RemoteMethod.class);
        }
        if ((rm = m.getAnnotation(org.apache.juneau.http.remote.RemoteMethod.class)) == null) {
            rm = m.getResolvedReturnType().getAnnotation(org.apache.juneau.http.remote.RemoteMethod.class);
        }
        RemoteReturn rv = null;
        if (rt.is(Void.TYPE)) {
            rv = RemoteReturn.NONE;
        } else if (orm != null) {
            switch (orm.returns()) {
                case BEAN: {
                    rv = RemoteReturn.BEAN;
                    break;
                }
                case BODY: {
                    rv = RemoteReturn.BODY;
                    break;
                }
                case NONE: {
                    rv = RemoteReturn.NONE;
                    break;
                }
                case STATUS: {
                    rv = RemoteReturn.STATUS;
                }
            }
        } else {
            rv = rm != null ? rm.returns() : RemoteReturn.BODY;
        }
        if (rt.hasAnnotation(Response.class) && rt.isInterface()) {
            this.meta = ResponseBeanMeta.create(m, PropertyStore.DEFAULT);
            rv = RemoteReturn.BEAN;
        } else {
            this.meta = null;
        }
        this.returnType = m.getReturnType().innerType();
        this.returnValue = rv;
    }

    public ResponseBeanMeta getResponseBeanMeta() {
        return this.meta;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public RemoteReturn getReturnValue() {
        return this.returnValue;
    }
}

