/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.event;

import org.apache.wiki.event.WikiEvent;

public class WikiPageEvent
extends WikiEvent {
    private static final long serialVersionUID = 1L;
    public static final int PAGE_LOCK = 10;
    public static final int PAGE_UNLOCK = 11;
    public static final int PRE_TRANSLATE_BEGIN = 12;
    public static final int PRE_TRANSLATE = 13;
    public static final int PRE_TRANSLATE_END = 14;
    public static final int POST_TRANSLATE_BEGIN = 15;
    public static final int POST_TRANSLATE = 16;
    public static final int POST_TRANSLATE_END = 17;
    public static final int PRE_SAVE_BEGIN = 18;
    public static final int PRE_SAVE = 19;
    public static final int PRE_SAVE_END = 20;
    public static final int POST_SAVE_BEGIN = 21;
    public static final int POST_SAVE = 22;
    public static final int POST_SAVE_END = 23;
    public static final int PAGE_REQUESTED = 24;
    public static final int PAGE_DELIVERED = 25;
    public static final int PAGE_DELETE_REQUEST = 26;
    public static final int PAGE_DELETED = 27;
    public static final int PAGE_REINDEX = 28;
    private final String m_pagename;

    public WikiPageEvent(Object src, int type, String pagename) {
        super(src, type);
        this.m_pagename = pagename;
    }

    public String getPageName() {
        return this.m_pagename;
    }

    public static boolean isValidType(int type) {
        return type >= 10 && type <= 27;
    }

    @Override
    public String eventName() {
        switch (this.getType()) {
            case 10: {
                return "PAGE_LOCK";
            }
            case 11: {
                return "PAGE_UNLOCK";
            }
            case 12: {
                return "PRE_TRANSLATE_BEGIN";
            }
            case 13: {
                return "PRE_TRANSLATE";
            }
            case 14: {
                return "PRE_TRANSLATE_END";
            }
            case 15: {
                return "POST_TRANSLATE_BEGIN";
            }
            case 16: {
                return "POST_TRANSLATE";
            }
            case 17: {
                return "POST_TRANSLATE_END";
            }
            case 18: {
                return "PRE_SAVE_BEGIN";
            }
            case 19: {
                return "PRE_SAVE";
            }
            case 20: {
                return "PRE_SAVE_END";
            }
            case 21: {
                return "POST_SAVE_BEGIN";
            }
            case 22: {
                return "POST_SAVE";
            }
            case 23: {
                return "POST_SAVE_END";
            }
            case 24: {
                return "PAGE_REQUESTED";
            }
            case 25: {
                return "PAGE_DELIVERED";
            }
            case 26: {
                return "PAGE_DELETE_REQUEST";
            }
            case 27: {
                return "PAGE_DELETED";
            }
        }
        return super.eventName();
    }

    @Override
    public String getTypeDescription() {
        switch (this.getType()) {
            case 10: {
                return "page lock event";
            }
            case 11: {
                return "page unlock event";
            }
            case 12: {
                return "begin page pre-translate events";
            }
            case 13: {
                return "page pre-translate event";
            }
            case 14: {
                return "end of page pre-translate events";
            }
            case 15: {
                return "begin page post-translate events";
            }
            case 16: {
                return "page post-translate event";
            }
            case 17: {
                return "end of page post-translate events";
            }
            case 18: {
                return "begin page pre-save events";
            }
            case 19: {
                return "page pre-save event";
            }
            case 20: {
                return "end of page pre-save events";
            }
            case 21: {
                return "begin page post-save events";
            }
            case 22: {
                return "page post-save event";
            }
            case 23: {
                return "end of page post-save events";
            }
            case 24: {
                return "page requested event";
            }
            case 25: {
                return "page delivered event";
            }
            case 26: {
                return "page delete request event";
            }
            case 27: {
                return "page deleted event";
            }
        }
        return super.getTypeDescription();
    }
}

