/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

public class MimeUtil {
    public static String fold(String s, int usedCharacters, int maxCharacters) {
        int length = s.length();
        if (usedCharacters + length <= maxCharacters) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int lastLineBreak = -usedCharacters;
        int wspIdx = MimeUtil.indexOfWsp(s, 0);
        while (true) {
            if (wspIdx == length) {
                sb.append(s.substring(Math.max(0, lastLineBreak)));
                return sb.toString();
            }
            int nextWspIdx = MimeUtil.indexOfWsp(s, wspIdx + 1);
            if (nextWspIdx - lastLineBreak > maxCharacters) {
                sb.append(s, Math.max(0, lastLineBreak), wspIdx);
                sb.append("\r\n");
                lastLineBreak = wspIdx;
            }
            wspIdx = nextWspIdx;
        }
    }

    private static int indexOfWsp(String s, int fromIndex) {
        int len = s.length();
        for (int index = fromIndex; index < len; ++index) {
            char c = s.charAt(index);
            if (c != ' ' && c != '\t') continue;
            return index;
        }
        return len;
    }
}

