/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota.mailing.subscribers;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.quota.mailing.QuotaMailingListenerConfiguration;
import org.apache.james.mailbox.quota.model.HistoryEvolution;
import org.apache.james.mailbox.quota.model.QuotaThreshold;
import org.apache.james.mailbox.quota.model.QuotaThresholdChange;
import org.apache.james.util.SizeFormat;

public class QuotaThresholdNotice {
    private final Optional<QuotaThreshold> countThreshold;
    private final Optional<QuotaThreshold> sizeThreshold;
    private final Quota<QuotaSizeLimit, QuotaSizeUsage> sizeQuota;
    private final Quota<QuotaCountLimit, QuotaCountUsage> countQuota;
    private final QuotaMailingListenerConfiguration configuration;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    QuotaThresholdNotice(Optional<QuotaThreshold> countThreshold, Optional<QuotaThreshold> sizeThreshold, Quota<QuotaSizeLimit, QuotaSizeUsage> sizeQuota, Quota<QuotaCountLimit, QuotaCountUsage> countQuota, QuotaMailingListenerConfiguration configuration) {
        this.countThreshold = countThreshold;
        this.sizeThreshold = sizeThreshold;
        this.sizeQuota = sizeQuota;
        this.countQuota = countQuota;
        this.configuration = configuration;
    }

    public MimeMessageBuilder generateMimeMessage(FileSystem fileSystem) throws IOException {
        return MimeMessageBuilder.mimeMessageBuilder().setSubject(this.generateSubject(fileSystem)).setText(this.generateReport(fileSystem));
    }

    @VisibleForTesting
    String generateSubject(FileSystem fileSystem) throws IOException {
        return this.renderTemplate(fileSystem, this.configuration.getSubjectTemplate(this.mostSignificantThreshold()));
    }

    @VisibleForTesting
    String generateReport(FileSystem fileSystem) throws IOException {
        return this.renderTemplate(fileSystem, this.configuration.getBodyTemplate(this.mostSignificantThreshold()));
    }

    private QuotaThreshold mostSignificantThreshold() {
        return (QuotaThreshold)Stream.of(this.countThreshold, this.sizeThreshold).flatMap(Optional::stream).min(Comparator.reverseOrder()).get();
    }

    private String renderTemplate(FileSystem fileSystem, String template) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            String string;
            try (OutputStreamWriter writer = new OutputStreamWriter(byteArrayOutputStream);){
                DefaultMustacheFactory mf = new DefaultMustacheFactory();
                Mustache mustache = mf.compile((Reader)this.getPatternReader(fileSystem, template), "example");
                mustache.execute((Writer)writer, this.computeScopes());
                ((Writer)writer).flush();
                string = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
            }
            return string;
        }
    }

    private StringReader getPatternReader(FileSystem fileSystem, String path) throws IOException {
        try (InputStream patternStream = fileSystem.getResource(path);){
            StringReader stringReader;
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                IOUtils.copy((InputStream)patternStream, (OutputStream)byteArrayOutputStream);
                String pattern = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
                stringReader = new StringReader(pattern);
            }
            return stringReader;
        }
    }

    private HashMap<String, Object> computeScopes() {
        HashMap<String, Object> scopes = new HashMap<String, Object>();
        scopes.put("hasExceededSizeThreshold", this.sizeThreshold.isPresent());
        scopes.put("hasExceededCountThreshold", this.countThreshold.isPresent());
        this.sizeThreshold.ifPresent(value -> scopes.put("sizeThreshold", value.getQuotaOccupationRatioAsPercent()));
        this.countThreshold.ifPresent(value -> scopes.put("countThreshold", value.getQuotaOccupationRatioAsPercent()));
        scopes.put("usedSize", SizeFormat.format((long)((QuotaSizeUsage)this.sizeQuota.getUsed()).asLong()));
        scopes.put("hasSizeLimit", ((QuotaSizeLimit)this.sizeQuota.getLimit()).isLimited());
        if (((QuotaSizeLimit)this.sizeQuota.getLimit()).isLimited()) {
            scopes.put("limitSize", SizeFormat.format((long)((QuotaSizeLimit)this.sizeQuota.getLimit()).asLong()));
        }
        scopes.put("usedCount", ((QuotaCountUsage)this.countQuota.getUsed()).asLong());
        scopes.put("hasCountLimit", ((QuotaCountLimit)this.countQuota.getLimit()).isLimited());
        if (((QuotaCountLimit)this.countQuota.getLimit()).isLimited()) {
            scopes.put("limitCount", ((QuotaCountLimit)this.countQuota.getLimit()).asLong());
        }
        return scopes;
    }

    public final boolean equals(Object o) {
        if (o instanceof QuotaThresholdNotice) {
            QuotaThresholdNotice that = (QuotaThresholdNotice)o;
            return Objects.equals(this.countThreshold, that.countThreshold) && Objects.equals(this.sizeThreshold, that.sizeThreshold) && Objects.equals(this.sizeQuota, that.sizeQuota) && Objects.equals(this.countQuota, that.countQuota) && Objects.equals(this.configuration, that.configuration);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.countThreshold, this.sizeThreshold, this.sizeQuota, this.countQuota, this.configuration);
    }

    public static class Builder {
        private Optional<QuotaThreshold> countThreshold = Optional.empty();
        private Optional<QuotaThreshold> sizeThreshold = Optional.empty();
        private Quota<QuotaSizeLimit, QuotaSizeUsage> sizeQuota;
        private Quota<QuotaCountLimit, QuotaCountUsage> countQuota;
        private QuotaMailingListenerConfiguration configuration;

        public Builder sizeQuota(Quota<QuotaSizeLimit, QuotaSizeUsage> sizeQuota) {
            this.sizeQuota = sizeQuota;
            return this;
        }

        public Builder countQuota(Quota<QuotaCountLimit, QuotaCountUsage> countQuota) {
            this.countQuota = countQuota;
            return this;
        }

        public Builder countThreshold(HistoryEvolution countHistoryEvolution) {
            this.countThreshold = Optional.of(countHistoryEvolution).filter(this::needsNotification).flatMap(HistoryEvolution::getThresholdChange).map(QuotaThresholdChange::getQuotaThreshold);
            return this;
        }

        public Builder sizeThreshold(HistoryEvolution sizeHistoryEvolution) {
            this.sizeThreshold = Optional.of(sizeHistoryEvolution).filter(this::needsNotification).flatMap(HistoryEvolution::getThresholdChange).map(QuotaThresholdChange::getQuotaThreshold);
            return this;
        }

        public Builder withConfiguration(QuotaMailingListenerConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        boolean needsNotification(HistoryEvolution evolution) {
            return evolution.getThresholdHistoryChange() == HistoryEvolution.HistoryChangeType.HigherThresholdReached && evolution.currentThresholdNotRecentlyReached();
        }

        public Optional<QuotaThresholdNotice> build() {
            Preconditions.checkNotNull((Object)this.configuration);
            Preconditions.checkNotNull(this.sizeQuota);
            Preconditions.checkNotNull((Object)this.configuration);
            if (this.sizeThreshold.isPresent() || this.countThreshold.isPresent()) {
                return Optional.of(new QuotaThresholdNotice(this.countThreshold, this.sizeThreshold, this.sizeQuota, this.countQuota, this.configuration));
            }
            return Optional.empty();
        }
    }
}

