/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.mail.Mailbox;
import org.apache.james.jmap.mail.MailboxACL$;
import org.apache.james.jmap.mail.MailboxNamespace;
import org.apache.james.jmap.mail.MailboxRights;
import org.apache.james.jmap.mail.MailboxRights$;
import org.apache.james.jmap.mail.MailboxValidation;
import org.apache.james.jmap.mail.MailboxValidation$;
import org.apache.james.jmap.mail.NamespaceFactory;
import org.apache.james.jmap.mail.Quota;
import org.apache.james.jmap.mail.QuotaId;
import org.apache.james.jmap.mail.Quotas;
import org.apache.james.jmap.mail.Rfc4314Rights$;
import org.apache.james.jmap.mail.Right;
import org.apache.james.jmap.mail.Right$;
import org.apache.james.jmap.mail.Rights;
import org.apache.james.jmap.mail.Rights$;
import org.apache.james.jmap.mail.SortOrder;
import org.apache.james.jmap.mail.SortOrder$;
import org.apache.james.jmap.mail.Subscriptions;
import org.apache.james.jmap.mail.TotalEmails;
import org.apache.james.jmap.mail.TotalThreads;
import org.apache.james.jmap.mail.UnreadEmails;
import org.apache.james.jmap.mail.UnreadThreads;
import org.apache.james.jmap.utils.quotas.QuotaLoader;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;

@ScalaSignature(bytes="\u0006\u0005\u0005}f\u0001B\b\u0011\u0001mA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tS\u0001\u0011\t\u0011)A\u0005U!)a\u0006\u0001C\u0001_!)A\b\u0001C\u0005{!)\u0011\u000b\u0001C\u0005%\")\u0001\f\u0001C\u00053\")!\r\u0001C\u0005G\")\u0011\u000e\u0001C\u0005U\")a\u000e\u0001C\u0005_\"9\u00111\u0002\u0001\u0005\n\u00055\u0001bBA\u000e\u0001\u0011\u0005\u0011Q\u0004\u0005\b\u00037\u0001A\u0011AA=\u0011\u001d\tY\t\u0001C\u0005\u0003\u001bCq!a-\u0001\t\u0013\t)L\u0001\bNC&d'm\u001c=GC\u000e$xN]=\u000b\u0005E\u0011\u0012\u0001B7bS2T!a\u0005\u000b\u0002\t)l\u0017\r\u001d\u0006\u0003+Y\tQA[1nKNT!a\u0006\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0012aA8sO\u000e\u00011C\u0001\u0001\u001d!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0019\te.\u001f*fM\u0006qQ.Y5mE>DX*\u00198bO\u0016\u0014\bC\u0001\u0013(\u001b\u0005)#B\u0001\u0014\u0015\u0003\u001di\u0017-\u001b7c_bL!\u0001K\u0013\u0003\u001d5\u000b\u0017\u000e\u001c2pq6\u000bg.Y4fe\u0006\u0001b.Y7fgB\f7-\u001a$bGR|'/\u001f\t\u0003W1j\u0011\u0001E\u0005\u0003[A\u0011\u0001CT1nKN\u0004\u0018mY3GC\u000e$xN]=\u0002\rqJg.\u001b;?)\r\u0001\u0014G\r\t\u0003W\u0001AQAI\u0002A\u0002\rBQ!K\u0002A\u0002)B#a\u0001\u001b\u0011\u0005URT\"\u0001\u001c\u000b\u0005]B\u0014AB5oU\u0016\u001cGOC\u0001:\u0003\u0015Q\u0017M^1y\u0013\tYdG\u0001\u0004J]*,7\r^\u0001\bO\u0016$(k\u001c7f)\rqD\t\u0014\t\u0004;}\n\u0015B\u0001!\u001f\u0005\u0019y\u0005\u000f^5p]B\u0011AEQ\u0005\u0003\u0007\u0016\u0012AAU8mK\")Q\t\u0002a\u0001\r\u0006YQ.Y5mE>D\b+\u0019;i!\t9%*D\u0001I\u0015\tIU%A\u0003n_\u0012,G.\u0003\u0002L\u0011\nYQ*Y5mE>D\b+\u0019;i\u0011\u0015iE\u00011\u0001O\u00039i\u0017-\u001b7c_b\u001cVm]:j_:\u0004\"\u0001J(\n\u0005A+#AD'bS2\u0014w\u000e_*fgNLwN\\\u0001\rO\u0016$8k\u001c:u\u001fJ$WM\u001d\u000b\u0003'Z\u0003\"a\u000b+\n\u0005U\u0003\"!C*peR|%\u000fZ3s\u0011\u00159V\u00011\u0001?\u0003\u0011\u0011x\u000e\\3\u0002\u0013\u001d,GOU5hQR\u001cHC\u0001.^!\tY3,\u0003\u0002]!\t1!+[4iiNDQA\u0018\u0004A\u0002}\u000b\u0011C]3t_24X-T1jY\n|\u00070Q\"M!\t9\u0005-\u0003\u0002b\u0011\nQQ*Y5mE>D\u0018i\u0011'\u0002\u0019\u001d,GOT1nKN\u0004\u0018mY3\u0015\u0007\u0011<\u0007\u000e\u0005\u0002,K&\u0011a\r\u0005\u0002\u0011\u001b\u0006LGNY8y\u001d\u0006lWm\u001d9bG\u0016DQ!R\u0004A\u0002\u0019CQ!T\u0004A\u00029\u000bQbZ3u!\u0006\u0014XM\u001c;QCRDGcA6m[B\u0019Qd\u0010$\t\u000b\u0015C\u0001\u0019\u0001$\t\u000b5C\u0001\u0019\u0001(\u0002\u0017\u0005\u001cG.\u00128uef\\U-\u001f\u000b\u0004a\u0006%\u0001cA9\u0002\u00049\u0011!o \b\u0003gzt!\u0001^?\u000f\u0005UdhB\u0001<|\u001d\t9(0D\u0001y\u0015\tI($\u0001\u0004=e>|GOP\u0005\u00023%\u0011q\u0003G\u0005\u0003+YI!A\n\u000b\n\u0005%+\u0013bAA\u0001\u0011\u0006QQ*Y5mE>D\u0018i\u0011'\n\t\u0005\u0015\u0011q\u0001\u0002\t\u000b:$(/_&fs*\u0019\u0011\u0011\u0001%\t\u000b5K\u0001\u0019\u0001(\u0002\u0017\u001d,G/T=SS\u001eDGo\u001d\u000b\t\u0003\u001f\t)\"a\u0006\u0002\u001aA\u00191&!\u0005\n\u0007\u0005M\u0001CA\u0007NC&d'm\u001c=SS\u001eDGo\u001d\u0005\u0006\u000b*\u0001\rA\u0012\u0005\u0006=*\u0001\ra\u0018\u0005\u0006\u001b*\u0001\rAT\u0001\u0007GJ,\u0017\r^3\u0015\u0019\u0005}\u00111HA#\u0003\u000f\n\t&!\u001a\u0011\r\u0005\u0005\u0012\u0011GA\u001b\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012!\u00039vE2L7\u000f[3s\u0015\ry\u0012\u0011\u0006\u0006\u0005\u0003W\ti#\u0001\u0003d_J,'BAA\u0018\u0003\u001d\u0011X-Y2u_JLA!a\r\u0002$\t)1+T8o_B\u00191&a\u000e\n\u0007\u0005e\u0002CA\u0004NC&d'm\u001c=\t\u000f\u0005u2\u00021\u0001\u0002@\u0005yQ.Y5mE>DX*\u001a;b\t\u0006$\u0018\rE\u0002H\u0003\u0003J1!a\u0011I\u0005=i\u0015-\u001b7c_blU\r^1ECR\f\u0007\"B'\f\u0001\u0004q\u0005bBA%\u0017\u0001\u0007\u00111J\u0001\u000egV\u00147o\u0019:jaRLwN\\:\u0011\u0007-\ni%C\u0002\u0002PA\u0011QbU;cg\u000e\u0014\u0018\u000e\u001d;j_:\u001c\bbBA*\u0017\u0001\u0007\u0011QK\u0001\u0015C2dW*Y5mE>DXm]'fi\u0006$\u0017\r^1\u0011\u000f\u0005]\u0013q\f$\u0002@9!\u0011\u0011LA.!\t9h$C\u0002\u0002^y\ta\u0001\u0015:fI\u00164\u0017\u0002BA1\u0003G\u00121!T1q\u0015\r\tiF\b\u0005\b\u0003OZ\u0001\u0019AA5\u0003-\tXo\u001c;b\u0019>\fG-\u001a:\u0011\t\u0005-\u0014QO\u0007\u0003\u0003[RA!a\u001c\u0002r\u00051\u0011/^8uCNT1!a\u001d\u0013\u0003\u0015)H/\u001b7t\u0013\u0011\t9(!\u001c\u0003\u0017E+x\u000e^1M_\u0006$WM\u001d\u000b\u000b\u0003?\tY(!\"\u0002\b\u0006%\u0005bBA?\u0019\u0001\u0007\u0011qP\u0001\u0003S\u0012\u00042aRAA\u0013\r\t\u0019\t\u0013\u0002\n\u001b\u0006LGNY8y\u0013\u0012DQ!\u0014\u0007A\u00029Cq!a\u001a\r\u0001\u0004\tI\u0007C\u0004\u0002J1\u0001\r!a\u0013\u0002%%t7\u000f^1oG&\fG/Z'bS2\u0014w\u000e\u001f\u000b\u000f\u0003?\ty)!%\u0002\u0014\u0006U\u0015qTAY\u0011\u001d\ti(\u0004a\u0001\u0003\u007fBQ!T\u0007A\u00029Cq!a\u001a\u000e\u0001\u0004\tI\u0007C\u0004\u0002\u00186\u0001\r!!'\u0002\u001d5,7o]1hK6\u000bg.Y4feB\u0019A%a'\n\u0007\u0005uUE\u0001\bNKN\u001c\u0018mZ3NC:\fw-\u001a:\t\u000f\u0005\u0005V\u00021\u0001\u0002$\u0006\t2/\u00198ji&TX\rZ\"pk:$XM]:\u0011\t\u0005\u0015\u00161\u0016\b\u0004\u000f\u0006\u001d\u0016bAAU\u0011\u0006yQ*Y5mE>D8i\\;oi\u0016\u00148/\u0003\u0003\u0002.\u0006=&!C*b]&$\u0018N_3e\u0015\r\tI\u000b\u0013\u0005\b\u0003\u0013j\u0001\u0019AA&\u0003-9W\r\u001e)be\u0016tG/\u00133\u0015\r\u0005]\u00161XA_!\u0019\t\t#!\r\u0002:B!QdPA@\u0011\u001d\t9J\u0004a\u0001\u00033CQ!\u0014\bA\u00029\u0003")
public class MailboxFactory {
    private final MailboxManager mailboxManager;
    private final NamespaceFactory namespaceFactory;

    private Option<Role> getRole(MailboxPath mailboxPath, MailboxSession mailboxSession) {
        return OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(Role.from((String)mailboxPath.getName()).filter(x$1 -> mailboxPath.belongsTo(mailboxSession))));
    }

    private SortOrder getSortOrder(Option<Role> role2) {
        return (SortOrder)role2.map((Function1 & Serializable)role -> SortOrder$.MODULE$.getSortOrder((Role)role)).getOrElse((Function0 & Serializable)() -> SortOrder$.MODULE$.defaultSortOrder());
    }

    private Rights getRights(MailboxACL resolveMailboxACL) {
        return Rights$.MODULE$.fromACL(MailboxACL$.MODULE$.fromJava(resolveMailboxACL));
    }

    private MailboxNamespace getNamespace(MailboxPath mailboxPath, MailboxSession mailboxSession) {
        return this.namespaceFactory.from(mailboxPath, mailboxSession);
    }

    private Option<MailboxPath> getParentPath(MailboxPath mailboxPath, MailboxSession mailboxSession) {
        return ((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(mailboxPath.getHierarchyLevels(mailboxSession.getPathDelimiter())).asScala().reverse()).drop(1)).headOption();
    }

    private MailboxACL.EntryKey aclEntryKey(MailboxSession mailboxSession) {
        return MailboxACL.EntryKey.createUserEntryKey((Username)mailboxSession.getUser());
    }

    private MailboxRights getMyRights(MailboxPath mailboxPath, MailboxACL resolveMailboxACL, MailboxSession mailboxSession) {
        boolean bl = mailboxPath.belongsTo(mailboxSession);
        if (bl) {
            return MailboxRights$.MODULE$.FULL();
        }
        if (!bl) {
            Seq<Right> rights = Rfc4314Rights$.MODULE$.fromJava(resolveMailboxACL.getEntries().getOrDefault(this.aclEntryKey(mailboxSession), MailboxACL.NO_RIGHTS)).toRights();
            return new MailboxRights(rights.contains((Object)Right$.MODULE$.Read()), rights.contains((Object)Right$.MODULE$.Insert()), rights.contains((Object)Right$.MODULE$.DeleteMessages()), rights.contains((Object)Right$.MODULE$.Seen()), rights.contains((Object)Right$.MODULE$.Write()), false, false, false, false);
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    public SMono<Mailbox> create(MailboxMetaData mailboxMetaData, MailboxSession mailboxSession, Subscriptions subscriptions, Map<MailboxPath, MailboxMetaData> allMailboxesMetadata, QuotaLoader quotaLoader) {
        MailboxCounters.Sanitized sanitizedCounters = mailboxMetaData.getCounters().sanitize();
        Either<Exception, MailboxValidation> either = MailboxValidation$.MODULE$.validate(mailboxMetaData.getPath(), mailboxSession.getPathDelimiter(), sanitizedCounters.getUnseen(), sanitizedCounters.getUnseen(), sanitizedCounters.getCount(), sanitizedCounters.getCount());
        if (either instanceof Left) {
            Left left = (Left)either;
            Exception error = (Exception)left.value();
            return SMono$.MODULE$.error((Throwable)error);
        }
        if (either instanceof scala.util.Right) {
            scala.util.Right right = (scala.util.Right)either;
            MailboxValidation mailboxValidation = (MailboxValidation)right.value();
            return SMono$.MODULE$.fromPublisher(quotaLoader.getQuotas(mailboxMetaData.getPath())).map((Function1 & Serializable)quotas -> MailboxFactory.$anonfun$create$1(this, mailboxMetaData, mailboxSession, allMailboxesMetadata, subscriptions, mailboxValidation, ((Quotas)quotas).quotas()));
        }
        throw new MatchError(either);
    }

    public SMono<Mailbox> create(MailboxId id, MailboxSession mailboxSession, QuotaLoader quotaLoader, Subscriptions subscriptions) {
        return SMono$.MODULE$.apply(this.mailboxManager.getMailboxReactive(id, mailboxSession)).flatMap((Function1 & Serializable)messageManager -> SMono$.MODULE$.apply(messageManager.getMailboxCountersReactive(mailboxSession)).map((Function1 & Serializable)counters -> {
            MailboxCounters.Sanitized sanitizedCounters = counters.sanitize();
            return new Tuple2(counters, (Object)sanitizedCounters);
        }).flatMap((Function1 & Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 != null) {
                MailboxCounters.Sanitized sanitizedCounters = (MailboxCounters.Sanitized)tuple2._2();
                return this.instanciateMailbox(id, mailboxSession, quotaLoader, (MessageManager)messageManager, sanitizedCounters, subscriptions).map((Function1 & Serializable)mailbox -> mailbox);
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    private SMono<Mailbox> instanciateMailbox(MailboxId id, MailboxSession mailboxSession, QuotaLoader quotaLoader, MessageManager messageManager, MailboxCounters.Sanitized sanitizedCounters, Subscriptions subscriptions) {
        SMono sMono;
        block4: {
            try {
                Either<Exception, MailboxValidation> either = MailboxValidation$.MODULE$.validate(messageManager.getMailboxPath(), mailboxSession.getPathDelimiter(), sanitizedCounters.getUnseen(), sanitizedCounters.getUnseen(), sanitizedCounters.getCount(), sanitizedCounters.getCount());
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Exception error = (Exception)left.value();
                    sMono = SMono$.MODULE$.error((Throwable)error);
                    break block4;
                }
                if (either instanceof scala.util.Right) {
                    scala.util.Right right = (scala.util.Right)either;
                    MailboxValidation mailboxValidation = (MailboxValidation)right.value();
                    sMono = SMono$.MODULE$.zip((Function1 & Serializable)array -> {
                        Object object = array[1];
                        return new Tuple2((Object)((Option)array[0]), (Object)new Quotas(object == null ? null : ((Quotas)object).quotas()));
                    }, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SMono[]{this.getParentId(messageManager, mailboxSession), SMono$.MODULE$.fromPublisher(quotaLoader.getQuotas(messageManager.getMailboxPath()))})).map((Function1 & Serializable)tuple2 -> {
                        MailboxACL resolvedACL = messageManager.getResolvedAcl(mailboxSession);
                        Option<Role> role = this.getRole(messageManager.getMailboxPath(), mailboxSession);
                        SortOrder sortOrder = this.getSortOrder(role);
                        Rights rights = this.getRights(resolvedACL);
                        MailboxNamespace namespace = this.getNamespace(messageManager.getMailboxPath(), mailboxSession);
                        MailboxRights myRights = this.getMyRights(messageManager.getMailboxPath(), resolvedACL, mailboxSession);
                        boolean isSubscribed = subscriptions.isSubscribed(messageManager.getMailboxPath());
                        MailboxId x$1 = id;
                        String x$2 = mailboxValidation.mailboxName();
                        Option x$3 = (Option)tuple2._1();
                        Option<Role> x$4 = role;
                        SortOrder x$5 = sortOrder;
                        UnreadEmails x$6 = mailboxValidation.unreadEmails();
                        TotalEmails x$7 = mailboxValidation.totalEmails();
                        UnreadThreads x$8 = mailboxValidation.unreadThreads();
                        TotalThreads x$9 = mailboxValidation.totalThreads();
                        MailboxRights x$10 = myRights;
                        MailboxNamespace x$11 = namespace;
                        Rights x$12 = rights;
                        Map<QuotaId, Quota> x$13 = ((Quotas)tuple2._2()).quotas();
                        boolean x$14 = isSubscribed;
                        return new Mailbox(x$1, x$2, (Option<MailboxId>)x$3, x$4, x$5, x$7, x$6, x$9, x$8, x$10, x$14, x$11, x$12, x$13);
                    });
                    break block4;
                }
                throw new MatchError(either);
            }
            catch (Exception error) {
                sMono = SMono$.MODULE$.error((Throwable)error);
            }
        }
        return sMono;
    }

    private SMono<Option<MailboxId>> getParentId(MessageManager messageManager, MailboxSession mailboxSession) {
        return (SMono)this.getParentPath(messageManager.getMailboxPath(), mailboxSession).map((Function1 & Serializable)parentPath -> SMono$.MODULE$.apply($this.mailboxManager.getMailboxReactive(parentPath, mailboxSession)).map((Function1 & Serializable)x$4 -> x$4.getId()).map((Function1 & Serializable)x$5 -> new Some(x$5)).onErrorResume((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof MailboxNotFoundException) {
                return SMono$.MODULE$.just((Object)None$.MODULE$);
            }
            return SMono$.MODULE$.error(throwable);
        })).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.just((Object)None$.MODULE$));
    }

    public static final /* synthetic */ Mailbox $anonfun$create$1(MailboxFactory $this, MailboxMetaData mailboxMetaData$1, MailboxSession mailboxSession$2, Map allMailboxesMetadata$1, Subscriptions subscriptions$1, MailboxValidation mailboxValidation$1, Map quotas) {
        MailboxId id = mailboxMetaData$1.getId();
        Option<Role> role = $this.getRole(mailboxMetaData$1.getPath(), mailboxSession$2);
        SortOrder sortOrder = $this.getSortOrder(role);
        Rights rights = $this.getRights(mailboxMetaData$1.getResolvedAcls());
        MailboxNamespace namespace = $this.getNamespace(mailboxMetaData$1.getPath(), mailboxSession$2);
        Option<MailboxPath> parentPath = $this.getParentPath(mailboxMetaData$1.getPath(), mailboxSession$2);
        Option parentId = parentPath.flatMap((Function1 & Serializable)path -> allMailboxesMetadata$1.get(path)).map((Function1 & Serializable)x$2 -> x$2.getId());
        MailboxRights myRights = $this.getMyRights(mailboxMetaData$1.getPath(), mailboxMetaData$1.getResolvedAcls(), mailboxSession$2);
        boolean isSubscribed = subscriptions$1.isSubscribed(mailboxMetaData$1);
        MailboxId x$1 = id;
        String x$22 = mailboxValidation$1.mailboxName();
        Option x$3 = parentId;
        Option<Role> x$4 = role;
        SortOrder x$5 = sortOrder;
        UnreadEmails x$6 = mailboxValidation$1.unreadEmails();
        TotalEmails x$7 = mailboxValidation$1.totalEmails();
        UnreadThreads x$8 = mailboxValidation$1.unreadThreads();
        TotalThreads x$9 = mailboxValidation$1.totalThreads();
        MailboxRights x$10 = myRights;
        MailboxNamespace x$11 = namespace;
        Rights x$12 = rights;
        Map x$13 = quotas;
        boolean x$14 = isSubscribed;
        return new Mailbox(x$1, x$22, (Option<MailboxId>)x$3, x$4, x$5, x$7, x$6, x$9, x$8, x$10, x$14, x$11, x$12, (Map<QuotaId, Quota>)x$13);
    }

    @Inject
    public MailboxFactory(MailboxManager mailboxManager, NamespaceFactory namespaceFactory) {
        this.mailboxManager = mailboxManager;
        this.namespaceFactory = namespaceFactory;
    }
}

