/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.json;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.ConnectAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.json.JSONFormattedAccessLogFields;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONObject;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JSONConnectAccessLogMessage
extends JSONAccessLogMessage
implements ConnectAccessLogMessage {
    private static final long serialVersionUID = 2405380746589337636L;
    @Nullable
    private final Integer sourcePort;
    @Nullable
    private final Integer targetPort;
    @Nullable
    private final String clientConnectionPolicyName;
    @Nullable
    private final String protocolName;
    @Nullable
    private final String sourceAddress = this.getString(JSONFormattedAccessLogFields.CONNECT_FROM_ADDRESS);
    @Nullable
    private final String targetAddress;

    public JSONConnectAccessLogMessage(@NotNull JSONObject jsonObject) throws LogException {
        super(jsonObject);
        this.sourcePort = this.getIntegerNoThrow(JSONFormattedAccessLogFields.CONNECT_FROM_PORT);
        this.targetAddress = this.getString(JSONFormattedAccessLogFields.CONNECT_TO_ADDRESS);
        this.targetPort = this.getIntegerNoThrow(JSONFormattedAccessLogFields.CONNECT_TO_PORT);
        this.protocolName = this.getString(JSONFormattedAccessLogFields.PROTOCOL);
        this.clientConnectionPolicyName = this.getString(JSONFormattedAccessLogFields.CLIENT_CONNECTION_POLICY);
    }

    @Override
    @NotNull
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.CONNECT;
    }

    @Override
    @Nullable
    public String getSourceAddress() {
        return this.sourceAddress;
    }

    @Override
    @Nullable
    public Integer getSourcePort() {
        return this.sourcePort;
    }

    @Override
    @Nullable
    public String getTargetAddress() {
        return this.targetAddress;
    }

    @Override
    @Nullable
    public Integer getTargetPort() {
        return this.targetPort;
    }

    @Override
    @Nullable
    public String getProtocolName() {
        return this.protocolName;
    }

    @Override
    @Nullable
    public String getClientConnectionPolicy() {
        return this.clientConnectionPolicyName;
    }
}

