/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.mail.internet.AddressException;
import org.apache.james.core.MailAddress;
import org.apache.james.mime4j.dom.address.AddressList;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.dom.address.MailboxList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
public class Emailer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Emailer.class);
    private final Optional<String> name;
    private final Optional<String> email;

    public static List<Emailer> fromAddressList(AddressList list) {
        return (List)Optional.ofNullable(list).map(addresses -> (ImmutableList)addresses.flatten().stream().map(Emailer::fromMailbox).collect(ImmutableList.toImmutableList())).orElse(ImmutableList.of());
    }

    public static Optional<Emailer> firstFromMailboxList(MailboxList list) {
        return Optional.ofNullable(list).flatMap(mailboxes -> mailboxes.stream().map(Emailer::fromMailbox).findFirst());
    }

    private static Emailer fromMailbox(Mailbox mailbox) {
        return Emailer.builder().name(Emailer.getNameOrAddress(mailbox)).email(mailbox.getAddress()).allowInvalid().build();
    }

    private static String getNameOrAddress(Mailbox mailbox) {
        return Optional.ofNullable(mailbox.getName()).orElseGet(() -> ((Mailbox)mailbox).getAddress());
    }

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    Emailer(Optional<String> name, Optional<String> email) {
        this.name = name;
        this.email = email;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<String> getEmail() {
        return this.email;
    }

    @JsonIgnore
    public MailAddress toMailAddress() {
        Preconditions.checkArgument((boolean)this.email.isPresent(), (Object)"eMailer mail address should be present when sending a mail using JMAP");
        try {
            return new MailAddress(this.email.get());
        }
        catch (AddressException e) {
            LOGGER.error("Invalid mail address", this.email);
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof Emailer) {
            Emailer otherEMailer = (Emailer)o;
            return Objects.equals(this.name, otherEMailer.name) && Objects.equals(this.email, otherEMailer.email);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.email);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", this.name).add("email", this.email).toString();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private static final boolean DEFAULT_DISABLE = false;
        private Optional<Boolean> allowInvalid = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> email = Optional.empty();

        @JsonProperty(value="name")
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @JsonIgnore
        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonProperty(value="email")
        public Builder email(Optional<String> email) {
            this.email = email;
            return this;
        }

        @JsonIgnore
        public Builder email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        @JsonIgnore
        public Builder allowInvalid() {
            this.allowInvalid = Optional.of(true);
            return this;
        }

        public Emailer build() {
            if (this.allowInvalid.orElse(false).booleanValue()) {
                return this.buildRelaxed();
            }
            return this.buildStrict();
        }

        private Emailer buildStrict() {
            Preconditions.checkState((boolean)this.name.isPresent(), (Object)"'name' is mandatory");
            Preconditions.checkState((boolean)this.email.isPresent(), (Object)"'email' is mandatory");
            Preconditions.checkState((!this.name.get().isEmpty() ? 1 : 0) != 0, (Object)"'name' should not be empty");
            Preconditions.checkState((!this.email.get().isEmpty() ? 1 : 0) != 0, (Object)"'email' should not be empty");
            Preconditions.checkState((boolean)this.email.get().contains("@"), (Object)"'email' must contain '@' character");
            return new Emailer(this.name, this.email);
        }

        private Emailer buildRelaxed() {
            return new Emailer(this.replaceIfNeeded(this.name), this.replaceIfNeeded(this.email));
        }

        private Optional<String> replaceIfNeeded(Optional<String> value) {
            return value.filter(Predicate.not(Strings::isNullOrEmpty));
        }
    }
}

