/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.apache.james.jmap.draft.model.Number;

@JsonDeserialize(builder=Builder.class)
public class UploadResponse {
    private final Optional<String> accountId;
    private final String blobId;
    private final String type;
    private final Number size;
    private final Optional<ZonedDateTime> expires;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    UploadResponse(Optional<String> accountId, String blobId, String type, Number size, Optional<ZonedDateTime> expires) {
        this.accountId = accountId;
        this.blobId = blobId;
        this.type = type;
        this.size = size;
        this.expires = expires;
    }

    public Optional<String> getAccountId() {
        return this.accountId;
    }

    public String getBlobId() {
        return this.blobId;
    }

    public String getType() {
        return this.type;
    }

    public Number getSize() {
        return this.size;
    }

    public Optional<ZonedDateTime> getExpires() {
        return this.expires;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof UploadResponse) {
            UploadResponse other = (UploadResponse)obj;
            return Objects.equal(this.accountId, other.accountId) && Objects.equal((Object)this.blobId, (Object)other.blobId) && Objects.equal((Object)this.type, (Object)other.type) && Objects.equal((Object)this.size, (Object)other.size) && Objects.equal(this.expires, other.expires);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.accountId, this.blobId, this.type, this.size, this.expires});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountId", this.accountId).add("blobId", (Object)this.blobId).add("type", (Object)this.type).add("size", (Object)this.size).add("expires", this.expires).toString();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private String accountId;
        private String blobId;
        private String type;
        private Number size;
        private ZonedDateTime expires;

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder blobId(String blobId) {
            this.blobId = blobId;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder size(long size) {
            this.size = Number.BOUND_SANITIZING_FACTORY.from(size);
            return this;
        }

        public Builder expires(ZonedDateTime expires) {
            this.expires = expires;
            return this;
        }

        public UploadResponse build() {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.blobId) ? 1 : 0) != 0, (Object)"'blobId' is mandatory");
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.type) ? 1 : 0) != 0, (Object)"'type' is mandatory");
            Preconditions.checkState((this.size != null ? 1 : 0) != 0, (Object)"'size' is mandatory");
            return new UploadResponse(Optional.ofNullable(this.accountId), this.blobId, this.type, this.size, Optional.ofNullable(this.expires));
        }
    }
}

