/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class UnboundIDWorkQueueMonitorEntry
extends MonitorEntry {
    @NotNull
    static final String UNBOUNDID_WORK_QUEUE_MONITOR_OC = "ds-unboundid-work-queue-monitor-entry";
    @NotNull
    private static final String ATTR_AVERAGE_QUEUE_TIME_MILLIS = "average-operation-queue-time-millis";
    @NotNull
    private static final String ATTR_AVERAGE_PCT_BUSY = "average-worker-thread-percent-busy";
    @NotNull
    private static final String ATTR_AVERAGE_SIZE = "average-queue-size";
    @NotNull
    private static final String ATTR_CURRENT_PCT_BUSY = "current-worker-thread-percent-busy";
    @NotNull
    private static final String ATTR_CURRENT_SIZE = "current-queue-size";
    @NotNull
    private static final String ATTR_MAX_SIZE = "max-queue-size";
    @NotNull
    private static final String ATTR_MAX_PCT_BUSY = "max-worker-thread-percent-busy";
    @NotNull
    private static final String ATTR_NUM_BUSY_WORKER_THREADS = "num-busy-worker-threads";
    @NotNull
    private static final String ATTR_NUM_WORKER_THREADS = "num-worker-threads";
    @NotNull
    private static final String ATTR_RECENT_AVERAGE_SIZE = "recent-average-queue-size";
    @NotNull
    private static final String ATTR_RECENT_QUEUE_TIME_MILLIS = "recent-operation-queue-time-millis";
    @NotNull
    private static final String ATTR_RECENT_PCT_BUSY = "recent-worker-thread-percent-busy";
    @NotNull
    private static final String ATTR_REQUESTS_REJECTED = "rejected-count";
    @NotNull
    private static final String ATTR_REQUESTS_STOLEN = "stolen-count";
    @NotNull
    private static final String ATTR_CURRENT_ADMIN_QUEUE_SIZE = "current-administrative-session-queue-size";
    @NotNull
    private static final String ATTR_MAX_ADMIN_SESSION_QUEUE_SIZE = "max-administrative-session-queue-size";
    @NotNull
    private static final String ATTR_NUM_ADMIN_WORKER_THREADS = "num-administrative-session-worker-threads";
    @NotNull
    private static final String ATTR_NUM_BUSY_ADMIN_WORKER_THREADS = "num-busy-administrative-session-worker-threads";
    private static final long serialVersionUID = -304216058351812232L;
    @Nullable
    private final Long averageQueueTimeMillis;
    @Nullable
    private final Long averagePercentBusy;
    @Nullable
    private final Long averageSize = this.getLong("average-queue-size");
    @Nullable
    private final Long currentAdminSize;
    @Nullable
    private final Long currentSize = this.getLong("current-queue-size");
    @Nullable
    private final Long currentPercentBusy;
    @Nullable
    private final Long maxAdminSize;
    @Nullable
    private final Long maxPercentBusy;
    @Nullable
    private final Long maxSize;
    @Nullable
    private final Long numAdminWorkerThreads;
    @Nullable
    private final Long numBusyWorkerThreads;
    @Nullable
    private final Long numBusyAdminWorkerThreads;
    @Nullable
    private final Long numWorkerThreads;
    @Nullable
    private final Long recentAverageSize = this.getLong("recent-average-queue-size");
    @Nullable
    private final Long recentQueueTimeMillis;
    @Nullable
    private final Long recentPercentBusy;
    @Nullable
    private final Long requestsRejected;
    @Nullable
    private final Long requestsStolen;

    public UnboundIDWorkQueueMonitorEntry(@NotNull Entry entry) {
        super(entry);
        this.maxSize = this.getLong(ATTR_MAX_SIZE);
        this.requestsRejected = this.getLong(ATTR_REQUESTS_REJECTED);
        this.requestsStolen = this.getLong(ATTR_REQUESTS_STOLEN);
        this.numBusyWorkerThreads = this.getLong(ATTR_NUM_BUSY_WORKER_THREADS);
        this.numWorkerThreads = this.getLong(ATTR_NUM_WORKER_THREADS);
        this.currentPercentBusy = this.getLong(ATTR_CURRENT_PCT_BUSY);
        this.averagePercentBusy = this.getLong(ATTR_AVERAGE_PCT_BUSY);
        this.recentPercentBusy = this.getLong(ATTR_RECENT_PCT_BUSY);
        this.maxPercentBusy = this.getLong(ATTR_MAX_PCT_BUSY);
        this.averageQueueTimeMillis = this.getLong(ATTR_AVERAGE_QUEUE_TIME_MILLIS);
        this.recentQueueTimeMillis = this.getLong(ATTR_RECENT_QUEUE_TIME_MILLIS);
        this.currentAdminSize = this.getLong(ATTR_CURRENT_ADMIN_QUEUE_SIZE);
        this.maxAdminSize = this.getLong(ATTR_MAX_ADMIN_SESSION_QUEUE_SIZE);
        this.numAdminWorkerThreads = this.getLong(ATTR_NUM_ADMIN_WORKER_THREADS);
        this.numBusyAdminWorkerThreads = this.getLong(ATTR_NUM_BUSY_ADMIN_WORKER_THREADS);
    }

    @Nullable
    public Long getAverageSize() {
        return this.averageSize;
    }

    @Nullable
    public Long getRecentAverageSize() {
        return this.recentAverageSize;
    }

    @Nullable
    public Long getCurrentSize() {
        return this.currentSize;
    }

    @Nullable
    public Long getMaxSize() {
        return this.maxSize;
    }

    @Nullable
    public Long getRequestsRejectedDueToQueueFull() {
        return this.requestsRejected;
    }

    @Nullable
    public Long getRequestsStolen() {
        return this.requestsStolen;
    }

    @Nullable
    public Long getNumWorkerThreads() {
        return this.numWorkerThreads;
    }

    @Nullable
    public Long getNumBusyWorkerThreads() {
        return this.numBusyWorkerThreads;
    }

    @Nullable
    public Long getCurrentWorkerThreadPercentBusy() {
        return this.currentPercentBusy;
    }

    @Nullable
    public Long getAverageWorkerThreadPercentBusy() {
        return this.averagePercentBusy;
    }

    @Nullable
    public Long getRecentWorkerThreadPercentBusy() {
        return this.recentPercentBusy;
    }

    @Nullable
    public Long getMaxWorkerThreadPercentBusy() {
        return this.maxPercentBusy;
    }

    @Nullable
    public Long getAverageOperationQueueTimeMillis() {
        return this.averageQueueTimeMillis;
    }

    @Nullable
    public Long getRecentOperationQueueTimeMillis() {
        return this.recentQueueTimeMillis;
    }

    @Nullable
    public Long getCurrentAdministrativeSessionQueueSize() {
        return this.currentAdminSize;
    }

    @Nullable
    public Long getMaxAdministrativeSessionQueueSize() {
        return this.maxAdminSize;
    }

    @Nullable
    public Long getNumAdministrativeSessionWorkerThreads() {
        return this.numAdminWorkerThreads;
    }

    @Nullable
    public Long getNumBusyAdministrativeSessionWorkerThreads() {
        return this.numBusyAdminWorkerThreads;
    }

    @Override
    @NotNull
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_MONITOR_DISPNAME.get();
    }

    @Override
    @NotNull
    public String getMonitorDescription() {
        return MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_MONITOR_DESC.get();
    }

    @Override
    @NotNull
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(StaticUtils.computeMapCapacity(50));
        if (this.requestsRejected != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_REQUESTS_REJECTED, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_REQUESTS_REJECTED.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_REQUESTS_REJECTED.get(), this.requestsRejected);
        }
        if (this.requestsStolen != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_REQUESTS_STOLEN, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_REQUESTS_STOLEN.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_REQUESTS_STOLEN.get(), this.requestsStolen);
        }
        if (this.currentSize != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_CURRENT_SIZE, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_CURRENT_SIZE.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_CURRENT_SIZE.get(), this.currentSize);
        }
        if (this.recentAverageSize != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_RECENT_AVERAGE_SIZE, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_RECENT_AVERAGE_SIZE.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_RECENT_AVERAGE_SIZE.get(), this.recentAverageSize);
        }
        if (this.averageSize != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_AVERAGE_SIZE, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_AVERAGE_SIZE.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_AVERAGE_SIZE.get(), this.averageSize);
        }
        if (this.maxSize != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_MAX_SIZE, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_MAX_SIZE.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_MAX_SIZE.get(), this.maxSize);
        }
        if (this.numWorkerThreads != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_NUM_WORKER_THREADS, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_NUM_THREADS.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_NUM_THREADS.get(), this.numWorkerThreads);
        }
        if (this.numBusyWorkerThreads != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_NUM_BUSY_WORKER_THREADS, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_NUM_BUSY_THREADS.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_NUM_BUSY_THREADS.get(), this.numBusyWorkerThreads);
        }
        if (this.currentPercentBusy != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_CURRENT_PCT_BUSY, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_CURRENT_PCT_BUSY.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_CURRENT_PCT_BUSY.get(), this.currentPercentBusy);
        }
        if (this.averagePercentBusy != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_AVERAGE_PCT_BUSY, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_AVG_PCT_BUSY.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_AVG_PCT_BUSY.get(), this.averagePercentBusy);
        }
        if (this.recentPercentBusy != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_RECENT_PCT_BUSY, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_RECENT_PCT_BUSY.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_RECENT_PCT_BUSY.get(), this.recentPercentBusy);
        }
        if (this.maxPercentBusy != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_MAX_PCT_BUSY, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_MAX_PCT_BUSY.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_MAX_PCT_BUSY.get(), this.maxPercentBusy);
        }
        if (this.averageQueueTimeMillis != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_AVERAGE_QUEUE_TIME_MILLIS, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_AVG_QUEUE_TIME.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_AVG_QUEUE_TIME.get(), this.averageQueueTimeMillis);
        }
        if (this.recentQueueTimeMillis != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_RECENT_QUEUE_TIME_MILLIS, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_RECENT_QUEUE_TIME.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_RECENT_QUEUE_TIME.get(), this.recentQueueTimeMillis);
        }
        if (this.currentAdminSize != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_CURRENT_ADMIN_QUEUE_SIZE, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_CURRENT_ADMIN_QUEUE_SIZE.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_CURRENT_ADMIN_QUEUE_SIZE.get(), this.currentAdminSize);
        }
        if (this.maxAdminSize != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_MAX_ADMIN_SESSION_QUEUE_SIZE, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_MAX_ADMIN_QUEUE_SIZE.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_MAX_ADMIN_QUEUE_SIZE.get(), this.maxAdminSize);
        }
        if (this.numAdminWorkerThreads != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_NUM_ADMIN_WORKER_THREADS, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_NUM_ADMIN_THREADS.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_NUM_ADMIN_THREADS.get(), this.numAdminWorkerThreads);
        }
        if (this.numBusyAdminWorkerThreads != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_NUM_BUSY_ADMIN_WORKER_THREADS, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_NUM_BUSY_ADMIN_THREADS.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_NUM_BUSY_ADMIN_THREADS.get(), this.numBusyAdminWorkerThreads);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

