/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.function.Predicate;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.base.AbstractImapCommandParser;
import org.apache.james.imap.message.request.CreateRequest;
import org.apache.james.mailbox.MailboxSession;

public class CreateCommandParser
extends AbstractImapCommandParser {
    public CreateCommandParser(StatusResponseFactory statusResponseFactory) {
        super(ImapConstants.CREATE_COMMAND, statusResponseFactory);
    }

    @Override
    protected ImapMessage decode(ImapRequestLineReader request, Tag tag, ImapSession session) throws DecodingException {
        String mailboxName = request.mailbox();
        MailboxSession mailboxSession = session.getMailboxSession();
        if (mailboxSession != null && mailboxName.endsWith(Character.toString(mailboxSession.getPathDelimiter()))) {
            mailboxName = mailboxName.substring(0, mailboxName.length() - 1);
        }
        request.eol();
        this.assertMailboxNameJustContainDelimiter(mailboxName, mailboxSession.getPathDelimiter());
        return new CreateRequest(mailboxName, tag);
    }

    private void assertMailboxNameJustContainDelimiter(String mailboxName, char delimiter) throws DecodingException {
        Splitter.on((char)delimiter).splitToList((CharSequence)mailboxName).stream().filter(Predicate.not(Strings::isNullOrEmpty)).findAny().orElseThrow(() -> new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Invalid mailbox name"));
    }
}

