/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.frame;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.Partition;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.frame.Frame;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.frame.FrameInfo;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.utils.ColumnList;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.utils.Range;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.utils.RowComparator;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class RangeFrame
implements Frame {
    private final Partition partition;
    private final FrameInfo frameInfo;
    private boolean noOrderBy = false;
    private List<ColumnList> allSortedColumns;
    private ColumnList column;
    private TSDataType dataType;
    private int partitionSize;
    private RowComparator peerGroupComparator;
    private Range recentRange;

    public RangeFrame(Partition partition, FrameInfo frameInfo, List<ColumnList> sortedColumns, RowComparator comparator) {
        this.partition = partition;
        this.frameInfo = frameInfo;
        this.partitionSize = partition.getPositionCount();
        if (frameInfo.getSortChannel() == -1) {
            this.noOrderBy = true;
            return;
        }
        this.allSortedColumns = sortedColumns;
        this.column = sortedColumns.get(0);
        this.dataType = this.column.getDataType();
        this.peerGroupComparator = comparator;
        this.recentRange = new Range(0, 0);
    }

    @Override
    public Range getRange(int currentPosition, int currentGroup, int peerGroupStart, int peerGroupEnd) {
        int frameEnd;
        int frameStart;
        if (this.frameInfo.getStartType() == FrameInfo.FrameBoundType.UNBOUNDED_PRECEDING && this.frameInfo.getEndType() == FrameInfo.FrameBoundType.UNBOUNDED_FOLLOWING || this.noOrderBy) {
            return new Range(0, this.partitionSize - 1);
        }
        if (this.frameInfo.getStartType() == FrameInfo.FrameBoundType.CURRENT_ROW && this.frameInfo.getEndType() == FrameInfo.FrameBoundType.CURRENT_ROW || this.frameInfo.getStartType() == FrameInfo.FrameBoundType.CURRENT_ROW && this.frameInfo.getEndType() == FrameInfo.FrameBoundType.UNBOUNDED_FOLLOWING || this.frameInfo.getStartType() == FrameInfo.FrameBoundType.UNBOUNDED_PRECEDING && this.frameInfo.getEndType() == FrameInfo.FrameBoundType.CURRENT_ROW) {
            if (currentPosition == 0 || !this.peerGroupComparator.equalColumnLists(this.allSortedColumns, currentPosition - 1, currentPosition)) {
                int frameStart2 = this.frameInfo.getStartType() == FrameInfo.FrameBoundType.CURRENT_ROW ? peerGroupStart : 0;
                int frameEnd2 = this.frameInfo.getEndType() == FrameInfo.FrameBoundType.CURRENT_ROW ? peerGroupEnd - 1 : this.partitionSize - 1;
                this.recentRange = new Range(frameStart2, frameEnd2);
            }
            return this.recentRange;
        }
        if (this.column.isNull(currentPosition)) {
            this.recentRange = new Range(this.frameInfo.getStartType() == FrameInfo.FrameBoundType.UNBOUNDED_PRECEDING ? 0 : peerGroupStart, this.frameInfo.getEndType() == FrameInfo.FrameBoundType.UNBOUNDED_FOLLOWING ? this.partitionSize - 1 : peerGroupEnd - 1);
            return this.recentRange;
        }
        switch (this.frameInfo.getStartType()) {
            case UNBOUNDED_PRECEDING: {
                frameStart = 0;
                break;
            }
            case PRECEDING: {
                frameStart = this.getPrecedingOffset(currentPosition, peerGroupStart, peerGroupEnd, true);
                break;
            }
            case CURRENT_ROW: {
                frameStart = peerGroupStart;
                break;
            }
            case FOLLOWING: {
                frameStart = this.getFollowingOffset(currentPosition, peerGroupStart, peerGroupEnd, true);
                break;
            }
            default: {
                throw new SemanticException("UNBOUND PRECEDING is not allowed in frame start!");
            }
        }
        switch (this.frameInfo.getEndType()) {
            case PRECEDING: {
                frameEnd = this.getPrecedingOffset(currentPosition, peerGroupStart, peerGroupEnd, false);
                break;
            }
            case CURRENT_ROW: {
                frameEnd = peerGroupEnd - 1;
                break;
            }
            case FOLLOWING: {
                frameEnd = this.getFollowingOffset(currentPosition, peerGroupStart, peerGroupEnd, false);
                break;
            }
            case UNBOUNDED_FOLLOWING: {
                frameEnd = this.partitionSize - 1;
                break;
            }
            default: {
                throw new SemanticException("UNBOUND PRECEDING is not allowed in frame end!");
            }
        }
        if (frameEnd < frameStart || frameEnd < 0 || frameStart >= this.partitionSize) {
            this.recentRange = new Range(Math.min(this.partitionSize - 1, frameStart), Math.max(0, frameEnd));
            return new Range(-1, -1);
        }
        frameStart = Math.max(frameStart, 0);
        frameEnd = Math.min(frameEnd, this.partitionSize - 1);
        this.recentRange = new Range(frameStart, frameEnd);
        return this.recentRange;
    }

    private int getPrecedingOffset(int index, int peerGroupStart, int peerGroupEnd, boolean isStart) {
        int offset;
        if (isStart) {
            if (!this.dataType.isNumeric() && this.dataType != TSDataType.DATE && this.dataType != TSDataType.TIMESTAMP) {
                return peerGroupStart;
            }
            int recentStart = this.recentRange.getStart();
            if (this.frameInfo.getSortOrder().isNullsFirst() && this.column.isNull(recentStart)) {
                return index;
            }
            offset = this.frameInfo.getSortOrder().isAscending() ? this.getAscFrameStartPreceding(index, recentStart) : this.getDescFrameStartPreceding(index, recentStart);
        } else {
            int recentEnd;
            if (!this.dataType.isNumeric() && this.dataType != TSDataType.DATE && this.dataType != TSDataType.TIMESTAMP) {
                return peerGroupEnd;
            }
            if (this.frameInfo.getSortOrder().isNullsFirst()) {
                for (recentEnd = this.recentRange.getEnd(); recentEnd < this.partitionSize && this.column.isNull(recentEnd); ++recentEnd) {
                }
            }
            offset = this.frameInfo.getSortOrder().isAscending() ? this.getAscFrameEndPreceding(index, recentEnd) : this.getDescFrameEndPreceding(index, recentEnd);
        }
        return offset;
    }

    private int getFollowingOffset(int index, int peerGroupStart, int peerGroupEnd, boolean isStart) {
        int offset;
        if (isStart) {
            if (!this.dataType.isNumeric() && this.dataType != TSDataType.DATE && this.dataType != TSDataType.TIMESTAMP) {
                return peerGroupStart;
            }
            int recentStart = this.recentRange.getStart();
            if (recentStart == 0 && this.frameInfo.getSortOrder().isNullsFirst() && this.column.isNull(0)) {
                recentStart = index;
            }
            if (!this.frameInfo.getSortOrder().isNullsFirst()) {
                while (recentStart >= 0 && this.column.isNull(recentStart)) {
                    --recentStart;
                }
                if (recentStart < 0) {
                    return recentStart;
                }
            }
            offset = this.frameInfo.getSortOrder().isAscending() ? this.getAscFrameStartFollowing(index, recentStart) : this.getDescFrameStartFollowing(index, recentStart);
        } else {
            if (!this.dataType.isNumeric() && this.dataType != TSDataType.DATE && this.dataType != TSDataType.TIMESTAMP) {
                return peerGroupEnd;
            }
            int recentEnd = this.recentRange.getEnd();
            if (this.frameInfo.getSortOrder().isNullsFirst() && this.column.isNull(recentEnd)) {
                recentEnd = index;
            }
            offset = this.frameInfo.getSortOrder().isAscending() ? this.getAscFrameEndFollowing(index, recentEnd) : this.getDescFrameEndFollowing(index, recentEnd);
        }
        return offset;
    }

    private int getAscFrameStartFollowing(int currentIndex, int recentIndex) {
        while (recentIndex < this.partitionSize && !this.column.isNull(recentIndex)) {
            if (this.compareInAscFrameStartFollowing(currentIndex, recentIndex, this.frameInfo.getStartOffsetChannel())) {
                return recentIndex;
            }
            ++recentIndex;
        }
        return recentIndex;
    }

    private boolean compareInAscFrameStartFollowing(int currentIndex, int recentIndex, int channel) {
        Preconditions.checkArgument((!this.partition.isNull(channel, currentIndex) ? 1 : 0) != 0);
        switch (this.column.getDataType()) {
            case INT32: 
            case DATE: {
                int currentInt = this.column.getInt(currentIndex);
                int followInt = this.column.getInt(recentIndex);
                int deltaInt = this.partition.getInt(channel, currentIndex);
                return followInt >= currentInt + deltaInt;
            }
            case INT64: 
            case TIMESTAMP: {
                long currentLong = this.column.getLong(currentIndex);
                long followLong = this.column.getLong(recentIndex);
                long deltaLong = this.partition.getLong(channel, currentIndex);
                return followLong >= currentLong + deltaLong;
            }
            case FLOAT: {
                float currentFloat = this.column.getFloat(currentIndex);
                float followFloat = this.column.getFloat(recentIndex);
                float deltaFloat = this.partition.getFloat(channel, currentIndex);
                return followFloat >= currentFloat + deltaFloat;
            }
            case DOUBLE: {
                double currentDouble = this.column.getDouble(currentIndex);
                double followDouble = this.column.getDouble(recentIndex);
                double deltaDouble = this.partition.getDouble(channel, currentIndex);
                return followDouble >= currentDouble + deltaDouble;
            }
        }
        throw new UnSupportedDataTypeException("Unsupported data type: " + this.column.getDataType());
    }

    private int getAscFrameEndFollowing(int currentIndex, int recentIndex) {
        while (recentIndex < this.partitionSize && !this.column.isNull(recentIndex)) {
            if (this.compareInAscFrameEndFollowing(currentIndex, recentIndex, this.frameInfo.getEndOffsetChannel())) {
                return recentIndex - 1;
            }
            ++recentIndex;
        }
        return recentIndex - 1;
    }

    private boolean compareInAscFrameEndFollowing(int currentIndex, int recentIndex, int channel) {
        Preconditions.checkArgument((!this.partition.isNull(channel, currentIndex) ? 1 : 0) != 0);
        switch (this.column.getDataType()) {
            case INT32: 
            case DATE: {
                int currentInt = this.column.getInt(currentIndex);
                int followInt = this.column.getInt(recentIndex);
                int deltaInt = this.partition.getInt(channel, currentIndex);
                return followInt > currentInt + deltaInt;
            }
            case INT64: 
            case TIMESTAMP: {
                long currentLong = this.column.getLong(currentIndex);
                long followLong = this.column.getLong(recentIndex);
                long deltaLong = this.partition.getLong(channel, currentIndex);
                return followLong > currentLong + deltaLong;
            }
            case FLOAT: {
                float currentFloat = this.column.getFloat(currentIndex);
                float followFloat = this.column.getFloat(recentIndex);
                float deltaFloat = this.partition.getFloat(channel, currentIndex);
                return followFloat > currentFloat + deltaFloat;
            }
            case DOUBLE: {
                double currentDouble = this.column.getDouble(currentIndex);
                double followDouble = this.column.getDouble(recentIndex);
                double deltaDouble = this.partition.getDouble(channel, currentIndex);
                return followDouble > currentDouble + deltaDouble;
            }
        }
        throw new UnSupportedDataTypeException("Unsupported data type: " + this.column.getDataType());
    }

    private int getAscFrameStartPreceding(int currentIndex, int recentIndex) {
        while (recentIndex < currentIndex) {
            if (this.compareInAscFrameStartPreceding(currentIndex, recentIndex, this.frameInfo.getStartOffsetChannel())) {
                return recentIndex;
            }
            ++recentIndex;
        }
        return recentIndex;
    }

    private boolean compareInAscFrameStartPreceding(int currentIndex, int recentIndex, int channel) {
        Preconditions.checkArgument((!this.partition.isNull(channel, currentIndex) ? 1 : 0) != 0);
        switch (this.column.getDataType()) {
            case INT32: 
            case DATE: {
                int currentInt = this.column.getInt(currentIndex);
                int precedeInt = this.column.getInt(recentIndex);
                int deltaInt = this.partition.getInt(channel, currentIndex);
                return precedeInt >= currentInt - deltaInt;
            }
            case INT64: 
            case TIMESTAMP: {
                long currentLong = this.column.getLong(currentIndex);
                long precedeLong = this.column.getLong(recentIndex);
                long deltaLong = this.partition.getLong(channel, currentIndex);
                return precedeLong >= currentLong - deltaLong;
            }
            case FLOAT: {
                float currentFloat = this.column.getFloat(currentIndex);
                float precedeFollow = this.column.getFloat(recentIndex);
                float deltaFloat = this.partition.getFloat(channel, currentIndex);
                return precedeFollow >= currentFloat - deltaFloat;
            }
            case DOUBLE: {
                double currentDouble = this.column.getDouble(currentIndex);
                double precedeDouble = this.column.getDouble(recentIndex);
                double deltaDouble = this.partition.getDouble(channel, currentIndex);
                return precedeDouble >= currentDouble - deltaDouble;
            }
        }
        throw new UnSupportedDataTypeException("Unsupported data type: " + this.column.getDataType());
    }

    private int getAscFrameEndPreceding(int currentIndex, int recentIndex) {
        while (recentIndex < this.partitionSize) {
            if (this.compareInAscFrameEndPreceding(currentIndex, recentIndex, this.frameInfo.getEndOffsetChannel())) {
                return recentIndex - 1;
            }
            ++recentIndex;
        }
        return recentIndex - 1;
    }

    private boolean compareInAscFrameEndPreceding(int currentIndex, int recentIndex, int channel) {
        Preconditions.checkArgument((!this.partition.isNull(channel, currentIndex) ? 1 : 0) != 0);
        switch (this.column.getDataType()) {
            case INT32: 
            case DATE: {
                int currentInt = this.column.getInt(currentIndex);
                int precedeInt = this.column.getInt(recentIndex);
                int deltaInt = this.partition.getInt(channel, currentIndex);
                return precedeInt > currentInt - deltaInt;
            }
            case INT64: 
            case TIMESTAMP: {
                long currentLong = this.column.getLong(currentIndex);
                long precedeLong = this.column.getLong(recentIndex);
                long deltaLong = this.partition.getLong(channel, currentIndex);
                return precedeLong > currentLong - deltaLong;
            }
            case FLOAT: {
                float currentFloat = this.column.getFloat(currentIndex);
                float precedeFollow = this.column.getFloat(recentIndex);
                float deltaFloat = this.partition.getFloat(channel, currentIndex);
                return precedeFollow > currentFloat - deltaFloat;
            }
            case DOUBLE: {
                double currentDouble = this.column.getDouble(currentIndex);
                double precedeDouble = this.column.getDouble(recentIndex);
                double deltaDouble = this.partition.getDouble(channel, currentIndex);
                return precedeDouble > currentDouble - deltaDouble;
            }
        }
        throw new UnSupportedDataTypeException("Unsupported data type: " + this.column.getDataType());
    }

    private int getDescFrameStartFollowing(int currentIndex, int recentIndex) {
        while (recentIndex < this.partitionSize && !this.column.isNull(recentIndex)) {
            if (this.compareInDescFrameStartFollowing(currentIndex, recentIndex, this.frameInfo.getStartOffsetChannel())) {
                return recentIndex;
            }
            ++recentIndex;
        }
        return recentIndex;
    }

    private boolean compareInDescFrameStartFollowing(int currentIndex, int recentIndex, int channel) {
        Preconditions.checkArgument((!this.partition.isNull(channel, currentIndex) ? 1 : 0) != 0);
        switch (this.column.getDataType()) {
            case INT32: 
            case DATE: {
                int currentInt = this.column.getInt(currentIndex);
                int followInt = this.column.getInt(recentIndex);
                int deltaInt = this.partition.getInt(channel, currentIndex);
                return followInt <= currentInt - deltaInt;
            }
            case INT64: 
            case TIMESTAMP: {
                long currentLong = this.column.getLong(currentIndex);
                long followLong = this.column.getLong(recentIndex);
                long deltaLong = this.partition.getLong(channel, currentIndex);
                return followLong <= currentLong - deltaLong;
            }
            case FLOAT: {
                float currentFloat = this.column.getFloat(currentIndex);
                float followFloat = this.column.getFloat(recentIndex);
                float deltaFloat = this.partition.getFloat(channel, currentIndex);
                return followFloat <= currentFloat - deltaFloat;
            }
            case DOUBLE: {
                double currentDouble = this.column.getDouble(currentIndex);
                double followDouble = this.column.getDouble(recentIndex);
                double deltaDouble = this.partition.getDouble(channel, currentIndex);
                return followDouble <= currentDouble - deltaDouble;
            }
        }
        throw new UnSupportedDataTypeException("Unsupported data type: " + this.column.getDataType());
    }

    private int getDescFrameEndFollowing(int currentIndex, int recentIndex) {
        while (recentIndex < this.partitionSize && !this.column.isNull(recentIndex)) {
            if (this.compareInDescFrameEndFollowing(currentIndex, recentIndex, this.frameInfo.getEndOffsetChannel())) {
                return recentIndex - 1;
            }
            ++recentIndex;
        }
        return recentIndex - 1;
    }

    private boolean compareInDescFrameEndFollowing(int currentIndex, int recentIndex, int channel) {
        Preconditions.checkArgument((!this.partition.isNull(channel, currentIndex) ? 1 : 0) != 0);
        switch (this.column.getDataType()) {
            case INT32: 
            case DATE: {
                int currentInt = this.column.getInt(currentIndex);
                int followInt = this.column.getInt(recentIndex);
                int deltaInt = this.partition.getInt(channel, currentIndex);
                return followInt < currentInt - deltaInt;
            }
            case INT64: 
            case TIMESTAMP: {
                long currentLong = this.column.getLong(currentIndex);
                long followLong = this.column.getLong(recentIndex);
                long deltaLong = this.partition.getLong(channel, currentIndex);
                return followLong < currentLong - deltaLong;
            }
            case FLOAT: {
                float currentFloat = this.column.getFloat(currentIndex);
                float followFloat = this.column.getFloat(recentIndex);
                float deltaFloat = this.partition.getFloat(channel, currentIndex);
                return followFloat < currentFloat - deltaFloat;
            }
            case DOUBLE: {
                double currentDouble = this.column.getDouble(currentIndex);
                double followDouble = this.column.getDouble(recentIndex);
                double deltaDouble = this.partition.getDouble(channel, currentIndex);
                return followDouble < currentDouble - deltaDouble;
            }
        }
        throw new UnSupportedDataTypeException("Unsupported data type: " + this.column.getDataType());
    }

    private int getDescFrameStartPreceding(int currentIndex, int recentIndex) {
        while (recentIndex < currentIndex) {
            if (this.compareInDescFrameStartPreceding(currentIndex, recentIndex, this.frameInfo.getStartOffsetChannel())) {
                return recentIndex;
            }
            ++recentIndex;
        }
        return recentIndex;
    }

    private boolean compareInDescFrameStartPreceding(int currentIndex, int recentIndex, int channel) {
        Preconditions.checkArgument((!this.partition.isNull(channel, currentIndex) ? 1 : 0) != 0);
        switch (this.column.getDataType()) {
            case INT32: 
            case DATE: {
                int currentInt = this.column.getInt(currentIndex);
                int precedeInt = this.column.getInt(recentIndex);
                int deltaInt = this.partition.getInt(channel, currentIndex);
                return precedeInt <= currentInt + deltaInt;
            }
            case INT64: 
            case TIMESTAMP: {
                long currentLong = this.column.getLong(currentIndex);
                long precedeLong = this.column.getLong(recentIndex);
                long deltaLong = this.partition.getLong(channel, currentIndex);
                return precedeLong <= currentLong + deltaLong;
            }
            case FLOAT: {
                float currentFloat = this.column.getFloat(currentIndex);
                float precedeFollow = this.column.getFloat(recentIndex);
                float deltaFloat = this.partition.getFloat(channel, currentIndex);
                return precedeFollow <= currentFloat + deltaFloat;
            }
            case DOUBLE: {
                double currentDouble = this.column.getDouble(currentIndex);
                double precedeDouble = this.column.getDouble(recentIndex);
                double deltaDouble = this.partition.getDouble(channel, currentIndex);
                return precedeDouble <= currentDouble + deltaDouble;
            }
        }
        throw new UnSupportedDataTypeException("Unsupported data type: " + this.column.getDataType());
    }

    private int getDescFrameEndPreceding(int currentIndex, int recentIndex) {
        while (recentIndex < this.partitionSize) {
            if (this.compareInDescFrameEndPreceding(currentIndex, recentIndex, this.frameInfo.getEndOffsetChannel())) {
                return recentIndex - 1;
            }
            ++recentIndex;
        }
        return recentIndex - 1;
    }

    private boolean compareInDescFrameEndPreceding(int currentIndex, int recentIndex, int channel) {
        Preconditions.checkArgument((!this.partition.isNull(channel, currentIndex) ? 1 : 0) != 0);
        switch (this.column.getDataType()) {
            case INT32: 
            case DATE: {
                int currentInt = this.column.getInt(currentIndex);
                int precedeInt = this.column.getInt(recentIndex);
                int deltaInt = this.partition.getInt(channel, currentIndex);
                return precedeInt < currentInt + deltaInt;
            }
            case INT64: 
            case TIMESTAMP: {
                long currentLong = this.column.getLong(currentIndex);
                long precedeLong = this.column.getLong(recentIndex);
                long deltaLong = this.partition.getLong(channel, currentIndex);
                return precedeLong < currentLong + deltaLong;
            }
            case FLOAT: {
                float currentFloat = this.column.getFloat(currentIndex);
                float precedeFollow = this.column.getFloat(recentIndex);
                float deltaFloat = this.partition.getFloat(channel, currentIndex);
                return precedeFollow < currentFloat + deltaFloat;
            }
            case DOUBLE: {
                double currentDouble = this.column.getDouble(currentIndex);
                double precedeDouble = this.column.getDouble(recentIndex);
                double deltaDouble = this.partition.getDouble(channel, currentIndex);
                return precedeDouble < currentDouble + deltaDouble;
            }
        }
        throw new UnSupportedDataTypeException("Unsupported data type: " + this.column.getDataType());
    }
}

