/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.fill.linear;

import java.util.Optional;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.linear.LinearFill;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.column.FloatColumn;
import org.apache.tsfile.read.common.block.column.FloatColumnBuilder;

public class FloatLinearFill
extends LinearFill {
    private float previousValue;
    private float nextValue;
    private float nextValueInCurrentColumn;

    @Override
    void fillValue(Column column, int index, Object array) {
        ((float[])array)[index] = column.getFloat(index);
    }

    @Override
    void fillValue(Object array, int index, double factor) {
        ((float[])array)[index] = this.getFilledValue(factor);
    }

    @Override
    Object createValueArray(int size) {
        return new float[size];
    }

    @Override
    Column createNullValueColumn() {
        return FloatColumnBuilder.NULL_VALUE_BLOCK;
    }

    @Override
    Column createFilledValueColumn(double[] factors, Optional<boolean[]> valueIsNull) {
        int size = factors.length;
        float[] filledValue = new float[size];
        if (valueIsNull.isPresent()) {
            boolean[] isNull = valueIsNull.get();
            for (int i = 0; i < size; ++i) {
                if (isNull[i]) continue;
                filledValue[i] = this.getFilledValue(factors[i]);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                filledValue[i] = this.getFilledValue(factors[i]);
            }
        }
        return new FloatColumn(size, valueIsNull, filledValue);
    }

    @Override
    Column createFilledValueColumn(Object array, boolean[] isNull, boolean hasNullValue, int size) {
        if (hasNullValue) {
            return new FloatColumn(size, Optional.of(isNull), (float[])array);
        }
        return new FloatColumn(size, Optional.empty(), (float[])array);
    }

    @Override
    void updatePreviousValue(Column column, int index) {
        this.previousValue = column.getFloat(index);
    }

    @Override
    void updateNextValue(Column nextValueColumn, int index) {
        this.nextValue = nextValueColumn.getFloat(index);
    }

    @Override
    void updateNextValueInCurrentColumn(Column nextValueColumn, int index) {
        this.nextValueInCurrentColumn = nextValueColumn.getFloat(index);
    }

    @Override
    void updateNextValueInCurrentColumn() {
        this.nextValueInCurrentColumn = this.nextValue;
    }

    private float getFilledValue(double factor) {
        return (float)((double)this.previousValue + (double)(this.nextValueInCurrentColumn - this.previousValue) * factor);
    }
}

