/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.data;

import java.io.File;
import java.util.concurrent.LinkedBlockingQueue;

public class ImportDataScanTool {
    private static final LinkedBlockingQueue<String> dataQueue = new LinkedBlockingQueue();
    private static String sourceFullPath;

    public static void traverseAndCollectFiles() throws InterruptedException {
        ImportDataScanTool.traverseAndCollectFilesBySourceFullPath(new File(sourceFullPath));
    }

    private static void traverseAndCollectFilesBySourceFullPath(File file) throws InterruptedException {
        File[] files;
        if (file.isFile()) {
            ImportDataScanTool.putToQueue(file.getAbsolutePath());
        } else if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                ImportDataScanTool.traverseAndCollectFilesBySourceFullPath(f);
            }
        }
    }

    public static String pollFromQueue() {
        return dataQueue.poll();
    }

    public static void putToQueue(String filePath) throws InterruptedException {
        dataQueue.put(filePath);
    }

    public static void setSourceFullPath(String sourceFullPath) {
        ImportDataScanTool.sourceFullPath = sourceFullPath;
    }
}

