/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.twostage.exchange.payload;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.IoTDBSinkRequestVersion;
import org.apache.iotdb.db.pipe.processor.twostage.exchange.payload.RequestType;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class FetchCombineResultRequest
extends TPipeTransferReq {
    private String pipeName;
    private long creationTime;
    private List<String> combineIdList;

    private FetchCombineResultRequest() {
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public List<String> getCombineIdList() {
        return this.combineIdList;
    }

    public static FetchCombineResultRequest toTPipeTransferReq(String pipeName, long creationTime, List<String> combineIdList) throws IOException {
        return new FetchCombineResultRequest().convertToTPipeTransferReq(pipeName, creationTime, combineIdList);
    }

    public static FetchCombineResultRequest fromTPipeTransferReq(TPipeTransferReq transferReq) throws Exception {
        return new FetchCombineResultRequest().translateFromTPipeTransferReq(transferReq);
    }

    private FetchCombineResultRequest convertToTPipeTransferReq(String pipeName, long creationTime, List<String> combineIdList) throws IOException {
        this.pipeName = pipeName;
        this.creationTime = creationTime;
        this.combineIdList = combineIdList;
        this.version = IoTDBSinkRequestVersion.VERSION_2.getVersion();
        this.type = RequestType.FETCH_COMBINE_RESULT.getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            ReadWriteIOUtils.write((String)pipeName, (OutputStream)outputStream);
            ReadWriteIOUtils.write((long)creationTime, (OutputStream)outputStream);
            ReadWriteIOUtils.write((int)combineIdList.size(), (OutputStream)outputStream);
            for (String combineId : combineIdList) {
                ReadWriteIOUtils.write((String)combineId, (OutputStream)outputStream);
            }
            this.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return this;
    }

    private FetchCombineResultRequest translateFromTPipeTransferReq(TPipeTransferReq transferReq) {
        this.pipeName = ReadWriteIOUtils.readString((ByteBuffer)transferReq.body);
        this.creationTime = ReadWriteIOUtils.readLong((ByteBuffer)transferReq.body);
        this.combineIdList = new ArrayList<String>();
        int combineIdListSize = ReadWriteIOUtils.readInt((ByteBuffer)transferReq.body);
        for (int i = 0; i < combineIdListSize; ++i) {
            this.combineIdList.add(ReadWriteIOUtils.readString((ByteBuffer)transferReq.body));
        }
        this.version = transferReq.version;
        this.type = transferReq.type;
        return this;
    }

    public String toString() {
        return "FetchCombineResultRequest{pipeName='" + this.pipeName + '\'' + ", creationTime=" + this.creationTime + ", combineIdList=" + this.combineIdList + '}';
    }
}

